# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UserReference
    from . import WorkPlanReference

class AdminAgentWorkPlanBiddingPreference(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AdminAgentWorkPlanBiddingPreference - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'agent': 'UserReference',
            'submitted': 'bool',
            'assigned_work_plan': 'WorkPlanReference',
            'overridden_work_plan': 'WorkPlanReference',
            'override_reason': 'str',
            'priorities': 'list[int]'
        }

        self.attribute_map = {
            'agent': 'agent',
            'submitted': 'submitted',
            'assigned_work_plan': 'assignedWorkPlan',
            'overridden_work_plan': 'overriddenWorkPlan',
            'override_reason': 'overrideReason',
            'priorities': 'priorities'
        }

        self._agent = None
        self._submitted = None
        self._assigned_work_plan = None
        self._overridden_work_plan = None
        self._override_reason = None
        self._priorities = None

    @property
    def agent(self) -> 'UserReference':
        """
        Gets the agent of this AdminAgentWorkPlanBiddingPreference.
        The agent to whom this work plan bidding preference applies

        :return: The agent of this AdminAgentWorkPlanBiddingPreference.
        :rtype: UserReference
        """
        return self._agent

    @agent.setter
    def agent(self, agent: 'UserReference') -> None:
        """
        Sets the agent of this AdminAgentWorkPlanBiddingPreference.
        The agent to whom this work plan bidding preference applies

        :param agent: The agent of this AdminAgentWorkPlanBiddingPreference.
        :type: UserReference
        """
        

        self._agent = agent

    @property
    def submitted(self) -> bool:
        """
        Gets the submitted of this AdminAgentWorkPlanBiddingPreference.
        Whether the preference is submitted

        :return: The submitted of this AdminAgentWorkPlanBiddingPreference.
        :rtype: bool
        """
        return self._submitted

    @submitted.setter
    def submitted(self, submitted: bool) -> None:
        """
        Sets the submitted of this AdminAgentWorkPlanBiddingPreference.
        Whether the preference is submitted

        :param submitted: The submitted of this AdminAgentWorkPlanBiddingPreference.
        :type: bool
        """
        

        self._submitted = submitted

    @property
    def assigned_work_plan(self) -> 'WorkPlanReference':
        """
        Gets the assigned_work_plan of this AdminAgentWorkPlanBiddingPreference.
        The work plan assigned to the agent by the bid process

        :return: The assigned_work_plan of this AdminAgentWorkPlanBiddingPreference.
        :rtype: WorkPlanReference
        """
        return self._assigned_work_plan

    @assigned_work_plan.setter
    def assigned_work_plan(self, assigned_work_plan: 'WorkPlanReference') -> None:
        """
        Sets the assigned_work_plan of this AdminAgentWorkPlanBiddingPreference.
        The work plan assigned to the agent by the bid process

        :param assigned_work_plan: The assigned_work_plan of this AdminAgentWorkPlanBiddingPreference.
        :type: WorkPlanReference
        """
        

        self._assigned_work_plan = assigned_work_plan

    @property
    def overridden_work_plan(self) -> 'WorkPlanReference':
        """
        Gets the overridden_work_plan of this AdminAgentWorkPlanBiddingPreference.
        The work plan that overrides the assigned work plan for the agent

        :return: The overridden_work_plan of this AdminAgentWorkPlanBiddingPreference.
        :rtype: WorkPlanReference
        """
        return self._overridden_work_plan

    @overridden_work_plan.setter
    def overridden_work_plan(self, overridden_work_plan: 'WorkPlanReference') -> None:
        """
        Sets the overridden_work_plan of this AdminAgentWorkPlanBiddingPreference.
        The work plan that overrides the assigned work plan for the agent

        :param overridden_work_plan: The overridden_work_plan of this AdminAgentWorkPlanBiddingPreference.
        :type: WorkPlanReference
        """
        

        self._overridden_work_plan = overridden_work_plan

    @property
    def override_reason(self) -> str:
        """
        Gets the override_reason of this AdminAgentWorkPlanBiddingPreference.
        The reason why the assigned work plan has been overridden. This must be null without an override work plan

        :return: The override_reason of this AdminAgentWorkPlanBiddingPreference.
        :rtype: str
        """
        return self._override_reason

    @override_reason.setter
    def override_reason(self, override_reason: str) -> None:
        """
        Sets the override_reason of this AdminAgentWorkPlanBiddingPreference.
        The reason why the assigned work plan has been overridden. This must be null without an override work plan

        :param override_reason: The override_reason of this AdminAgentWorkPlanBiddingPreference.
        :type: str
        """
        if isinstance(override_reason, int):
            override_reason = str(override_reason)
        allowed_values = ["UnableToBid", "ChangeOfCircumstance", "NewHire", "EmployeeMove"]
        if override_reason.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for override_reason -> " + override_reason)
            self._override_reason = "outdated_sdk_version"
        else:
            self._override_reason = override_reason

    @property
    def priorities(self) -> List[int]:
        """
        Gets the priorities of this AdminAgentWorkPlanBiddingPreference.
        The agent priorities for the list of work plans. The index of the priorities should match with the list of work plans that belong to bid group. It contains null if priority is not set for the work plan

        :return: The priorities of this AdminAgentWorkPlanBiddingPreference.
        :rtype: list[int]
        """
        return self._priorities

    @priorities.setter
    def priorities(self, priorities: List[int]) -> None:
        """
        Sets the priorities of this AdminAgentWorkPlanBiddingPreference.
        The agent priorities for the list of work plans. The index of the priorities should match with the list of work plans that belong to bid group. It contains null if priority is not set for the work plan

        :param priorities: The priorities of this AdminAgentWorkPlanBiddingPreference.
        :type: list[int]
        """
        

        self._priorities = priorities

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

