# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class AdjustableLiveSpeakerDetection(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AdjustableLiveSpeakerDetection - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'mode': 'str',
            'preconnect_duration': 'str',
            'event_name': 'str',
            'is_person_likely': 'bool',
            'total_ringbacks': 'int',
            'line_connected': 'bool'
        }

        self.attribute_map = {
            'mode': 'mode',
            'preconnect_duration': 'preconnectDuration',
            'event_name': 'eventName',
            'is_person_likely': 'isPersonLikely',
            'total_ringbacks': 'totalRingbacks',
            'line_connected': 'lineConnected'
        }

        self._mode = None
        self._preconnect_duration = None
        self._event_name = None
        self._is_person_likely = None
        self._total_ringbacks = None
        self._line_connected = None

    @property
    def mode(self) -> str:
        """
        Gets the mode of this AdjustableLiveSpeakerDetection.
        Modes to tune between speed to live speaker detection vs accuracy.

        :return: The mode of this AdjustableLiveSpeakerDetection.
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode: str) -> None:
        """
        Sets the mode of this AdjustableLiveSpeakerDetection.
        Modes to tune between speed to live speaker detection vs accuracy.

        :param mode: The mode of this AdjustableLiveSpeakerDetection.
        :type: str
        """
        if isinstance(mode, int):
            mode = str(mode)
        allowed_values = ["unknown", "disabled", "low", "medium", "high"]
        if mode.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for mode -> " + mode)
            self._mode = "outdated_sdk_version"
        else:
            self._mode = mode

    @property
    def preconnect_duration(self) -> str:
        """
        Gets the preconnect_duration of this AdjustableLiveSpeakerDetection.
        ISO 8601 formatted relative duration (e.g., PT30.8427419S for 30.8 seconds), calculated on line connect.

        :return: The preconnect_duration of this AdjustableLiveSpeakerDetection.
        :rtype: str
        """
        return self._preconnect_duration

    @preconnect_duration.setter
    def preconnect_duration(self, preconnect_duration: str) -> None:
        """
        Sets the preconnect_duration of this AdjustableLiveSpeakerDetection.
        ISO 8601 formatted relative duration (e.g., PT30.8427419S for 30.8 seconds), calculated on line connect.

        :param preconnect_duration: The preconnect_duration of this AdjustableLiveSpeakerDetection.
        :type: str
        """
        

        self._preconnect_duration = preconnect_duration

    @property
    def event_name(self) -> str:
        """
        Gets the event_name of this AdjustableLiveSpeakerDetection.
        The name of the event that triggered the ALSD evaluation (e.g., line.connect, speech.generic).

        :return: The event_name of this AdjustableLiveSpeakerDetection.
        :rtype: str
        """
        return self._event_name

    @event_name.setter
    def event_name(self, event_name: str) -> None:
        """
        Sets the event_name of this AdjustableLiveSpeakerDetection.
        The name of the event that triggered the ALSD evaluation (e.g., line.connect, speech.generic).

        :param event_name: The event_name of this AdjustableLiveSpeakerDetection.
        :type: str
        """
        

        self._event_name = event_name

    @property
    def is_person_likely(self) -> bool:
        """
        Gets the is_person_likely of this AdjustableLiveSpeakerDetection.
        The output of the ALSD detector, evaluating whether there is likely a person on the call based on the above inputs, and if so, a person is detected early (person disposition name and speech.person analyzer result) and the associated action taken (e.g., speech.person postconnect entry in the disposition table has the action to transfer to a queue).

        :return: The is_person_likely of this AdjustableLiveSpeakerDetection.
        :rtype: bool
        """
        return self._is_person_likely

    @is_person_likely.setter
    def is_person_likely(self, is_person_likely: bool) -> None:
        """
        Sets the is_person_likely of this AdjustableLiveSpeakerDetection.
        The output of the ALSD detector, evaluating whether there is likely a person on the call based on the above inputs, and if so, a person is detected early (person disposition name and speech.person analyzer result) and the associated action taken (e.g., speech.person postconnect entry in the disposition table has the action to transfer to a queue).

        :param is_person_likely: The is_person_likely of this AdjustableLiveSpeakerDetection.
        :type: bool
        """
        

        self._is_person_likely = is_person_likely

    @property
    def total_ringbacks(self) -> int:
        """
        Gets the total_ringbacks of this AdjustableLiveSpeakerDetection.
        Number of tone.ring.* analyzer events detected during the call (expected mostly during pre-connect but the last ringback tone detection could potentially complete after line connect, which will increment totalRingbacks still).

        :return: The total_ringbacks of this AdjustableLiveSpeakerDetection.
        :rtype: int
        """
        return self._total_ringbacks

    @total_ringbacks.setter
    def total_ringbacks(self, total_ringbacks: int) -> None:
        """
        Sets the total_ringbacks of this AdjustableLiveSpeakerDetection.
        Number of tone.ring.* analyzer events detected during the call (expected mostly during pre-connect but the last ringback tone detection could potentially complete after line connect, which will increment totalRingbacks still).

        :param total_ringbacks: The total_ringbacks of this AdjustableLiveSpeakerDetection.
        :type: int
        """
        

        self._total_ringbacks = total_ringbacks

    @property
    def line_connected(self) -> bool:
        """
        Gets the line_connected of this AdjustableLiveSpeakerDetection.
        Protocol line connect received (answered by a person, machine, busy, fax).

        :return: The line_connected of this AdjustableLiveSpeakerDetection.
        :rtype: bool
        """
        return self._line_connected

    @line_connected.setter
    def line_connected(self, line_connected: bool) -> None:
        """
        Sets the line_connected of this AdjustableLiveSpeakerDetection.
        Protocol line connect received (answered by a person, machine, busy, fax).

        :param line_connected: The line_connected of this AdjustableLiveSpeakerDetection.
        :type: bool
        """
        

        self._line_connected = line_connected

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

