# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ActivityCodeReference
    from . import ActivityPlanServiceGoalImpactOverrides
    from . import FixedAvailability
    from . import GroupSettings
    from . import ManagementUnitReference
    from . import RecurrenceSettings
    from . import SchedulingPeriod
    from . import UserReference
    from . import UserSearchRule

class ActivityPlanResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ActivityPlanResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'management_units': 'list[ManagementUnitReference]',
            'description': 'str',
            'activity_code': 'ActivityCodeReference',
            'type': 'str',
            'initial_schedule_period': 'SchedulingPeriod',
            'length_minutes': 'int',
            'group_settings': 'GroupSettings',
            'recurrence_settings': 'RecurrenceSettings',
            'attendees_search_rule': 'UserSearchRule',
            'facilitated': 'bool',
            'facilitators_search_rule': 'UserSearchRule',
            'transition_time_minutes': 'int',
            'service_goal_impact_overrides': 'ActivityPlanServiceGoalImpactOverrides',
            'optimization_objective': 'str',
            'fixed_availability': 'list[FixedAvailability]',
            'state': 'str',
            'counts_as_paid_time': 'bool',
            'created_date': 'datetime',
            'created_by': 'UserReference',
            'modified_date': 'datetime',
            'modified_by': 'UserReference',
            'last_run_date': 'datetime',
            'last_run_by': 'UserReference',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'management_units': 'managementUnits',
            'description': 'description',
            'activity_code': 'activityCode',
            'type': 'type',
            'initial_schedule_period': 'initialSchedulePeriod',
            'length_minutes': 'lengthMinutes',
            'group_settings': 'groupSettings',
            'recurrence_settings': 'recurrenceSettings',
            'attendees_search_rule': 'attendeesSearchRule',
            'facilitated': 'facilitated',
            'facilitators_search_rule': 'facilitatorsSearchRule',
            'transition_time_minutes': 'transitionTimeMinutes',
            'service_goal_impact_overrides': 'serviceGoalImpactOverrides',
            'optimization_objective': 'optimizationObjective',
            'fixed_availability': 'fixedAvailability',
            'state': 'state',
            'counts_as_paid_time': 'countsAsPaidTime',
            'created_date': 'createdDate',
            'created_by': 'createdBy',
            'modified_date': 'modifiedDate',
            'modified_by': 'modifiedBy',
            'last_run_date': 'lastRunDate',
            'last_run_by': 'lastRunBy',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._management_units = None
        self._description = None
        self._activity_code = None
        self._type = None
        self._initial_schedule_period = None
        self._length_minutes = None
        self._group_settings = None
        self._recurrence_settings = None
        self._attendees_search_rule = None
        self._facilitated = None
        self._facilitators_search_rule = None
        self._transition_time_minutes = None
        self._service_goal_impact_overrides = None
        self._optimization_objective = None
        self._fixed_availability = None
        self._state = None
        self._counts_as_paid_time = None
        self._created_date = None
        self._created_by = None
        self._modified_date = None
        self._modified_by = None
        self._last_run_date = None
        self._last_run_by = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ActivityPlanResponse.
        The globally unique identifier for the object.

        :return: The id of this ActivityPlanResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ActivityPlanResponse.
        The globally unique identifier for the object.

        :param id: The id of this ActivityPlanResponse.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this ActivityPlanResponse.
        The name of the activity plan

        :return: The name of this ActivityPlanResponse.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ActivityPlanResponse.
        The name of the activity plan

        :param name: The name of this ActivityPlanResponse.
        :type: str
        """
        

        self._name = name

    @property
    def management_units(self) -> List['ManagementUnitReference']:
        """
        Gets the management_units of this ActivityPlanResponse.
        The management units to which this activity plan applies. Empty list or null means this activity plan applies to the entire business unit

        :return: The management_units of this ActivityPlanResponse.
        :rtype: list[ManagementUnitReference]
        """
        return self._management_units

    @management_units.setter
    def management_units(self, management_units: List['ManagementUnitReference']) -> None:
        """
        Sets the management_units of this ActivityPlanResponse.
        The management units to which this activity plan applies. Empty list or null means this activity plan applies to the entire business unit

        :param management_units: The management_units of this ActivityPlanResponse.
        :type: list[ManagementUnitReference]
        """
        

        self._management_units = management_units

    @property
    def description(self) -> str:
        """
        Gets the description of this ActivityPlanResponse.
        The description of this activity plan

        :return: The description of this ActivityPlanResponse.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this ActivityPlanResponse.
        The description of this activity plan

        :param description: The description of this ActivityPlanResponse.
        :type: str
        """
        

        self._description = description

    @property
    def activity_code(self) -> 'ActivityCodeReference':
        """
        Gets the activity_code of this ActivityPlanResponse.
        The activity code associated with this activity plan. It is recommended to load and cache the entire list of activity codes rather than look up individual codes

        :return: The activity_code of this ActivityPlanResponse.
        :rtype: ActivityCodeReference
        """
        return self._activity_code

    @activity_code.setter
    def activity_code(self, activity_code: 'ActivityCodeReference') -> None:
        """
        Sets the activity_code of this ActivityPlanResponse.
        The activity code associated with this activity plan. It is recommended to load and cache the entire list of activity codes rather than look up individual codes

        :param activity_code: The activity_code of this ActivityPlanResponse.
        :type: ActivityCodeReference
        """
        

        self._activity_code = activity_code

    @property
    def type(self) -> str:
        """
        Gets the type of this ActivityPlanResponse.
        The type of the activity plan

        :return: The type of this ActivityPlanResponse.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this ActivityPlanResponse.
        The type of the activity plan

        :param type: The type of this ActivityPlanResponse.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Individual", "Group"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def initial_schedule_period(self) -> 'SchedulingPeriod':
        """
        Gets the initial_schedule_period of this ActivityPlanResponse.
        The initial schedule period of the activity plan

        :return: The initial_schedule_period of this ActivityPlanResponse.
        :rtype: SchedulingPeriod
        """
        return self._initial_schedule_period

    @initial_schedule_period.setter
    def initial_schedule_period(self, initial_schedule_period: 'SchedulingPeriod') -> None:
        """
        Sets the initial_schedule_period of this ActivityPlanResponse.
        The initial schedule period of the activity plan

        :param initial_schedule_period: The initial_schedule_period of this ActivityPlanResponse.
        :type: SchedulingPeriod
        """
        

        self._initial_schedule_period = initial_schedule_period

    @property
    def length_minutes(self) -> int:
        """
        Gets the length_minutes of this ActivityPlanResponse.
        The length of the activity in minutes

        :return: The length_minutes of this ActivityPlanResponse.
        :rtype: int
        """
        return self._length_minutes

    @length_minutes.setter
    def length_minutes(self, length_minutes: int) -> None:
        """
        Sets the length_minutes of this ActivityPlanResponse.
        The length of the activity in minutes

        :param length_minutes: The length_minutes of this ActivityPlanResponse.
        :type: int
        """
        

        self._length_minutes = length_minutes

    @property
    def group_settings(self) -> 'GroupSettings':
        """
        Gets the group_settings of this ActivityPlanResponse.
        Group settings for this activity plan

        :return: The group_settings of this ActivityPlanResponse.
        :rtype: GroupSettings
        """
        return self._group_settings

    @group_settings.setter
    def group_settings(self, group_settings: 'GroupSettings') -> None:
        """
        Sets the group_settings of this ActivityPlanResponse.
        Group settings for this activity plan

        :param group_settings: The group_settings of this ActivityPlanResponse.
        :type: GroupSettings
        """
        

        self._group_settings = group_settings

    @property
    def recurrence_settings(self) -> 'RecurrenceSettings':
        """
        Gets the recurrence_settings of this ActivityPlanResponse.
        Recurrence settings for this activity plan

        :return: The recurrence_settings of this ActivityPlanResponse.
        :rtype: RecurrenceSettings
        """
        return self._recurrence_settings

    @recurrence_settings.setter
    def recurrence_settings(self, recurrence_settings: 'RecurrenceSettings') -> None:
        """
        Sets the recurrence_settings of this ActivityPlanResponse.
        Recurrence settings for this activity plan

        :param recurrence_settings: The recurrence_settings of this ActivityPlanResponse.
        :type: RecurrenceSettings
        """
        

        self._recurrence_settings = recurrence_settings

    @property
    def attendees_search_rule(self) -> 'UserSearchRule':
        """
        Gets the attendees_search_rule of this ActivityPlanResponse.
        Attendee search rule for this activity plan

        :return: The attendees_search_rule of this ActivityPlanResponse.
        :rtype: UserSearchRule
        """
        return self._attendees_search_rule

    @attendees_search_rule.setter
    def attendees_search_rule(self, attendees_search_rule: 'UserSearchRule') -> None:
        """
        Sets the attendees_search_rule of this ActivityPlanResponse.
        Attendee search rule for this activity plan

        :param attendees_search_rule: The attendees_search_rule of this ActivityPlanResponse.
        :type: UserSearchRule
        """
        

        self._attendees_search_rule = attendees_search_rule

    @property
    def facilitated(self) -> bool:
        """
        Gets the facilitated of this ActivityPlanResponse.
        Whether the sessions created by this activity plan should be facilitated

        :return: The facilitated of this ActivityPlanResponse.
        :rtype: bool
        """
        return self._facilitated

    @facilitated.setter
    def facilitated(self, facilitated: bool) -> None:
        """
        Sets the facilitated of this ActivityPlanResponse.
        Whether the sessions created by this activity plan should be facilitated

        :param facilitated: The facilitated of this ActivityPlanResponse.
        :type: bool
        """
        

        self._facilitated = facilitated

    @property
    def facilitators_search_rule(self) -> 'UserSearchRule':
        """
        Gets the facilitators_search_rule of this ActivityPlanResponse.
        Facilitator search rule for this activity plan

        :return: The facilitators_search_rule of this ActivityPlanResponse.
        :rtype: UserSearchRule
        """
        return self._facilitators_search_rule

    @facilitators_search_rule.setter
    def facilitators_search_rule(self, facilitators_search_rule: 'UserSearchRule') -> None:
        """
        Sets the facilitators_search_rule of this ActivityPlanResponse.
        Facilitator search rule for this activity plan

        :param facilitators_search_rule: The facilitators_search_rule of this ActivityPlanResponse.
        :type: UserSearchRule
        """
        

        self._facilitators_search_rule = facilitators_search_rule

    @property
    def transition_time_minutes(self) -> int:
        """
        Gets the transition_time_minutes of this ActivityPlanResponse.
        Transition time in minutes between facilitated sessions

        :return: The transition_time_minutes of this ActivityPlanResponse.
        :rtype: int
        """
        return self._transition_time_minutes

    @transition_time_minutes.setter
    def transition_time_minutes(self, transition_time_minutes: int) -> None:
        """
        Sets the transition_time_minutes of this ActivityPlanResponse.
        Transition time in minutes between facilitated sessions

        :param transition_time_minutes: The transition_time_minutes of this ActivityPlanResponse.
        :type: int
        """
        

        self._transition_time_minutes = transition_time_minutes

    @property
    def service_goal_impact_overrides(self) -> 'ActivityPlanServiceGoalImpactOverrides':
        """
        Gets the service_goal_impact_overrides of this ActivityPlanResponse.
        Allowable service goal impact override settings for this activity plan

        :return: The service_goal_impact_overrides of this ActivityPlanResponse.
        :rtype: ActivityPlanServiceGoalImpactOverrides
        """
        return self._service_goal_impact_overrides

    @service_goal_impact_overrides.setter
    def service_goal_impact_overrides(self, service_goal_impact_overrides: 'ActivityPlanServiceGoalImpactOverrides') -> None:
        """
        Sets the service_goal_impact_overrides of this ActivityPlanResponse.
        Allowable service goal impact override settings for this activity plan

        :param service_goal_impact_overrides: The service_goal_impact_overrides of this ActivityPlanResponse.
        :type: ActivityPlanServiceGoalImpactOverrides
        """
        

        self._service_goal_impact_overrides = service_goal_impact_overrides

    @property
    def optimization_objective(self) -> str:
        """
        Gets the optimization_objective of this ActivityPlanResponse.
        The optimization objective of this activity plan

        :return: The optimization_objective of this ActivityPlanResponse.
        :rtype: str
        """
        return self._optimization_objective

    @optimization_objective.setter
    def optimization_objective(self, optimization_objective: str) -> None:
        """
        Sets the optimization_objective of this ActivityPlanResponse.
        The optimization objective of this activity plan

        :param optimization_objective: The optimization_objective of this ActivityPlanResponse.
        :type: str
        """
        if isinstance(optimization_objective, int):
            optimization_objective = str(optimization_objective)
        allowed_values = ["FavorServiceGoals", "FavorSchedulingAll"]
        if optimization_objective.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for optimization_objective -> " + optimization_objective)
            self._optimization_objective = "outdated_sdk_version"
        else:
            self._optimization_objective = optimization_objective

    @property
    def fixed_availability(self) -> List['FixedAvailability']:
        """
        Gets the fixed_availability of this ActivityPlanResponse.
        Fixed availability configuration for this activity plan

        :return: The fixed_availability of this ActivityPlanResponse.
        :rtype: list[FixedAvailability]
        """
        return self._fixed_availability

    @fixed_availability.setter
    def fixed_availability(self, fixed_availability: List['FixedAvailability']) -> None:
        """
        Sets the fixed_availability of this ActivityPlanResponse.
        Fixed availability configuration for this activity plan

        :param fixed_availability: The fixed_availability of this ActivityPlanResponse.
        :type: list[FixedAvailability]
        """
        

        self._fixed_availability = fixed_availability

    @property
    def state(self) -> str:
        """
        Gets the state of this ActivityPlanResponse.
        The state of this activity plan

        :return: The state of this ActivityPlanResponse.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this ActivityPlanResponse.
        The state of this activity plan

        :param state: The state of this ActivityPlanResponse.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Active", "Inactive"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def counts_as_paid_time(self) -> bool:
        """
        Gets the counts_as_paid_time of this ActivityPlanResponse.
        Whether the activity should count as paid time

        :return: The counts_as_paid_time of this ActivityPlanResponse.
        :rtype: bool
        """
        return self._counts_as_paid_time

    @counts_as_paid_time.setter
    def counts_as_paid_time(self, counts_as_paid_time: bool) -> None:
        """
        Sets the counts_as_paid_time of this ActivityPlanResponse.
        Whether the activity should count as paid time

        :param counts_as_paid_time: The counts_as_paid_time of this ActivityPlanResponse.
        :type: bool
        """
        

        self._counts_as_paid_time = counts_as_paid_time

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this ActivityPlanResponse.
        The date the activity plan was created, in ISO-8601 format

        :return: The created_date of this ActivityPlanResponse.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this ActivityPlanResponse.
        The date the activity plan was created, in ISO-8601 format

        :param created_date: The created_date of this ActivityPlanResponse.
        :type: datetime
        """
        

        self._created_date = created_date

    @property
    def created_by(self) -> 'UserReference':
        """
        Gets the created_by of this ActivityPlanResponse.
        The user who created this activity plan

        :return: The created_by of this ActivityPlanResponse.
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'UserReference') -> None:
        """
        Sets the created_by of this ActivityPlanResponse.
        The user who created this activity plan

        :param created_by: The created_by of this ActivityPlanResponse.
        :type: UserReference
        """
        

        self._created_by = created_by

    @property
    def modified_date(self) -> datetime:
        """
        Gets the modified_date of this ActivityPlanResponse.
        The date the activity plan was modified, in ISO-8601 format

        :return: The modified_date of this ActivityPlanResponse.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date: datetime) -> None:
        """
        Sets the modified_date of this ActivityPlanResponse.
        The date the activity plan was modified, in ISO-8601 format

        :param modified_date: The modified_date of this ActivityPlanResponse.
        :type: datetime
        """
        

        self._modified_date = modified_date

    @property
    def modified_by(self) -> 'UserReference':
        """
        Gets the modified_by of this ActivityPlanResponse.
        The last user to modify this activity plan. The id may be 'System' if it was an automated process

        :return: The modified_by of this ActivityPlanResponse.
        :rtype: UserReference
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'UserReference') -> None:
        """
        Sets the modified_by of this ActivityPlanResponse.
        The last user to modify this activity plan. The id may be 'System' if it was an automated process

        :param modified_by: The modified_by of this ActivityPlanResponse.
        :type: UserReference
        """
        

        self._modified_by = modified_by

    @property
    def last_run_date(self) -> datetime:
        """
        Gets the last_run_date of this ActivityPlanResponse.
        The date the activity plan was last run, in ISO-8601 format

        :return: The last_run_date of this ActivityPlanResponse.
        :rtype: datetime
        """
        return self._last_run_date

    @last_run_date.setter
    def last_run_date(self, last_run_date: datetime) -> None:
        """
        Sets the last_run_date of this ActivityPlanResponse.
        The date the activity plan was last run, in ISO-8601 format

        :param last_run_date: The last_run_date of this ActivityPlanResponse.
        :type: datetime
        """
        

        self._last_run_date = last_run_date

    @property
    def last_run_by(self) -> 'UserReference':
        """
        Gets the last_run_by of this ActivityPlanResponse.
        The last user to run this activity plan

        :return: The last_run_by of this ActivityPlanResponse.
        :rtype: UserReference
        """
        return self._last_run_by

    @last_run_by.setter
    def last_run_by(self, last_run_by: 'UserReference') -> None:
        """
        Sets the last_run_by of this ActivityPlanResponse.
        The last user to run this activity plan

        :param last_run_by: The last_run_by of this ActivityPlanResponse.
        :type: UserReference
        """
        

        self._last_run_by = last_run_by

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ActivityPlanResponse.
        The URI for this object

        :return: The self_uri of this ActivityPlanResponse.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ActivityPlanResponse.
        The URI for this object

        :param self_uri: The self_uri of this ActivityPlanResponse.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

