# coding: utf-8

"""
TaskManagementApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import BulkJob
from ..models import BulkJobAddRequest
from ..models import BulkJobAddResponse
from ..models import BulkJobTerminateRequest
from ..models import BulkJobTerminateResultsResponse
from ..models import BulkJobUpdate
from ..models import BulkJobsListing
from ..models import Coretype
from ..models import DataSchema
from ..models import DataSchemaListing
from ..models import ErrorBody
from ..models import SchemaQuantityLimits
from ..models import Workbin
from ..models import WorkbinChangeListing
from ..models import WorkbinCreate
from ..models import WorkbinQueryEntityListing
from ..models import WorkbinQueryRequest
from ..models import WorkbinUpdate
from ..models import WorkbinVersion
from ..models import WorkbinVersionListing
from ..models import Workitem
from ..models import WorkitemChangeListing
from ..models import WorkitemCreate
from ..models import WorkitemDateBasedRule
from ..models import WorkitemDateBasedRuleCreate
from ..models import WorkitemDateBasedRuleListing
from ..models import WorkitemDateBasedRuleUpdate
from ..models import WorkitemManualAssign
from ..models import WorkitemOnAttributeChangeRule
from ..models import WorkitemOnAttributeChangeRuleCreate
from ..models import WorkitemOnAttributeChangeRuleListing
from ..models import WorkitemOnAttributeChangeRuleUpdate
from ..models import WorkitemOnCreateRule
from ..models import WorkitemOnCreateRuleCreate
from ..models import WorkitemOnCreateRuleListing
from ..models import WorkitemOnCreateRuleUpdate
from ..models import WorkitemPagedEntityListing
from ..models import WorkitemPostQueryEntityListing
from ..models import WorkitemQueryJobCreate
from ..models import WorkitemQueryJobResponse
from ..models import WorkitemQueryPostRequest
from ..models import WorkitemStatus
from ..models import WorkitemStatusCreate
from ..models import WorkitemStatusListing
from ..models import WorkitemStatusUpdate
from ..models import WorkitemTerminate
from ..models import WorkitemUpdate
from ..models import WorkitemVersion
from ..models import WorkitemVersionListing
from ..models import WorkitemWrapup
from ..models import WorkitemWrapupEntityListing
from ..models import WorkitemWrapupUpdate
from ..models import Worktype
from ..models import WorktypeChangeListing
from ..models import WorktypeCreate
from ..models import WorktypeQueryEntityListing
from ..models import WorktypeQueryRequest
from ..models import WorktypeUpdate
from ..models import WorktypeVersion
from ..models import WorktypeVersionListing

class TaskManagementApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_taskmanagement_workbin(self, workbin_id: str, **kwargs) -> None:
        """
        Delete a workbin
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_taskmanagement_workbin(workbin_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbin_id: Workbin ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workbin_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_taskmanagement_workbin" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workbin_id' is set
        if ('workbin_id' not in params) or (params['workbin_id'] is None):
            raise ValueError("Missing the required parameter `workbin_id` when calling `delete_taskmanagement_workbin`")


        resource_path = '/api/v2/taskmanagement/workbins/{workbinId}'.replace('{format}', 'json')
        path_params = {}
        if 'workbin_id' in params:
            path_params['workbinId'] = params['workbin_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_taskmanagement_workitem(self, workitem_id: str, **kwargs) -> None:
        """
        Delete a workitem
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_taskmanagement_workitem(workitem_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: Workitem ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_taskmanagement_workitem" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `delete_taskmanagement_workitem`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_taskmanagement_workitems_bulk_add_job(self, bulk_job_id: str, **kwargs) -> None:
        """
        Delete a bulk add job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_taskmanagement_workitems_bulk_add_job(bulk_job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bulk_job_id: Bulk job id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_taskmanagement_workitems_bulk_add_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'bulk_job_id' is set
        if ('bulk_job_id' not in params) or (params['bulk_job_id'] is None):
            raise ValueError("Missing the required parameter `bulk_job_id` when calling `delete_taskmanagement_workitems_bulk_add_job`")


        resource_path = '/api/v2/taskmanagement/workitems/bulk/add/jobs/{bulkJobId}'.replace('{format}', 'json')
        path_params = {}
        if 'bulk_job_id' in params:
            path_params['bulkJobId'] = params['bulk_job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_taskmanagement_workitems_bulk_terminate_job(self, bulk_job_id: str, **kwargs) -> None:
        """
        Delete a Bulk job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_taskmanagement_workitems_bulk_terminate_job(bulk_job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bulk_job_id: Bulk job id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_taskmanagement_workitems_bulk_terminate_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'bulk_job_id' is set
        if ('bulk_job_id' not in params) or (params['bulk_job_id'] is None):
            raise ValueError("Missing the required parameter `bulk_job_id` when calling `delete_taskmanagement_workitems_bulk_terminate_job`")


        resource_path = '/api/v2/taskmanagement/workitems/bulk/terminate/jobs/{bulkJobId}'.replace('{format}', 'json')
        path_params = {}
        if 'bulk_job_id' in params:
            path_params['bulkJobId'] = params['bulk_job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_taskmanagement_workitems_schema(self, schema_id: str, **kwargs) -> None:
        """
        Delete a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_taskmanagement_workitems_schema(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_taskmanagement_workitems_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `delete_taskmanagement_workitems_schema`")


        resource_path = '/api/v2/taskmanagement/workitems/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_taskmanagement_worktype(self, worktype_id: str, **kwargs) -> None:
        """
        Delete a worktype
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_taskmanagement_worktype(worktype_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_taskmanagement_worktype" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `delete_taskmanagement_worktype`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_taskmanagement_worktype_flows_datebased_rule(self, worktype_id: str, rule_id: str, **kwargs) -> None:
        """
        Delete a date based rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_taskmanagement_worktype_flows_datebased_rule(worktype_id, rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str rule_id: ruleId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_taskmanagement_worktype_flows_datebased_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `delete_taskmanagement_worktype_flows_datebased_rule`")
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `delete_taskmanagement_worktype_flows_datebased_rule`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/datebased/rules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_taskmanagement_worktype_flows_onattributechange_rule(self, worktype_id: str, rule_id: str, **kwargs) -> None:
        """
        Delete a rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_taskmanagement_worktype_flows_onattributechange_rule(worktype_id, rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str rule_id: ruleId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_taskmanagement_worktype_flows_onattributechange_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `delete_taskmanagement_worktype_flows_onattributechange_rule`")
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `delete_taskmanagement_worktype_flows_onattributechange_rule`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/onattributechange/rules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_taskmanagement_worktype_flows_oncreate_rule(self, worktype_id: str, rule_id: str, **kwargs) -> None:
        """
        Delete a rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_taskmanagement_worktype_flows_oncreate_rule(worktype_id, rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str rule_id: ruleId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_taskmanagement_worktype_flows_oncreate_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `delete_taskmanagement_worktype_flows_oncreate_rule`")
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `delete_taskmanagement_worktype_flows_oncreate_rule`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/oncreate/rules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_taskmanagement_worktype_status(self, worktype_id: str, status_id: str, **kwargs) -> None:
        """
        Delete a status
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_taskmanagement_worktype_status(worktype_id, status_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str status_id: Status id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'status_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_taskmanagement_worktype_status" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `delete_taskmanagement_worktype_status`")
        # verify the required parameter 'status_id' is set
        if ('status_id' not in params) or (params['status_id'] is None):
            raise ValueError("Missing the required parameter `status_id` when calling `delete_taskmanagement_worktype_status`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/statuses/{statusId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']
        if 'status_id' in params:
            path_params['statusId'] = params['status_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workbin(self, workbin_id: str, **kwargs) -> 'Workbin':
        """
        Get a workbin
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workbin(workbin_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbin_id: Workbin ID (required)
        :return: Workbin
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workbin_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workbin" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workbin_id' is set
        if ('workbin_id' not in params) or (params['workbin_id'] is None):
            raise ValueError("Missing the required parameter `workbin_id` when calling `get_taskmanagement_workbin`")


        resource_path = '/api/v2/taskmanagement/workbins/{workbinId}'.replace('{format}', 'json')
        path_params = {}
        if 'workbin_id' in params:
            path_params['workbinId'] = params['workbin_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workbin',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workbin_history(self, workbin_id: str, **kwargs) -> 'WorkbinChangeListing':
        """
        Get a listing of a workbin's attribute change history
        
	    get_taskmanagement_workbin_history is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workbin_history(workbin_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbin_id: Workbin ID (required)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param int page_size: Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 200.
        :param str sort_order: Ascending or descending sort order
        :return: WorkbinChangeListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workbin_id', 'after', 'page_size', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workbin_history" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workbin_id' is set
        if ('workbin_id' not in params) or (params['workbin_id'] is None):
            raise ValueError("Missing the required parameter `workbin_id` when calling `get_taskmanagement_workbin_history`")


        resource_path = '/api/v2/taskmanagement/workbins/{workbinId}/history'.replace('{format}', 'json')
        path_params = {}
        if 'workbin_id' in params:
            path_params['workbinId'] = params['workbin_id']

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkbinChangeListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workbin_version(self, workbin_id: str, entity_version: int, **kwargs) -> 'WorkbinVersion':
        """
        Get a version of a workbin
        
	    get_taskmanagement_workbin_version is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workbin_version(workbin_id, entity_version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbin_id: Workbin ID (required)
        :param int entity_version: Workbin version (required)
        :return: WorkbinVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workbin_id', 'entity_version']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workbin_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workbin_id' is set
        if ('workbin_id' not in params) or (params['workbin_id'] is None):
            raise ValueError("Missing the required parameter `workbin_id` when calling `get_taskmanagement_workbin_version`")
        # verify the required parameter 'entity_version' is set
        if ('entity_version' not in params) or (params['entity_version'] is None):
            raise ValueError("Missing the required parameter `entity_version` when calling `get_taskmanagement_workbin_version`")


        resource_path = '/api/v2/taskmanagement/workbins/{workbinId}/versions/{entityVersion}'.replace('{format}', 'json')
        path_params = {}
        if 'workbin_id' in params:
            path_params['workbinId'] = params['workbin_id']
        if 'entity_version' in params:
            path_params['entityVersion'] = params['entity_version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkbinVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workbin_versions(self, workbin_id: str, **kwargs) -> 'WorkbinVersionListing':
        """
        Get all versions of a workbin
        
	    get_taskmanagement_workbin_versions is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workbin_versions(workbin_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbin_id: Workbin ID (required)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param int page_size: Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 200.
        :param str sort_order: Ascending or descending sort order
        :return: WorkbinVersionListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workbin_id', 'after', 'page_size', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workbin_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workbin_id' is set
        if ('workbin_id' not in params) or (params['workbin_id'] is None):
            raise ValueError("Missing the required parameter `workbin_id` when calling `get_taskmanagement_workbin_versions`")


        resource_path = '/api/v2/taskmanagement/workbins/{workbinId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'workbin_id' in params:
            path_params['workbinId'] = params['workbin_id']

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkbinVersionListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitem(self, workitem_id: str, **kwargs) -> 'Workitem':
        """
        Get a workitem
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitem(workitem_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: Workitem ID (required)
        :param str expands: Which fields to expand. Comma separated if more than one.
        :return: Workitem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id', 'expands']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitem" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `get_taskmanagement_workitem`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']

        query_params = {}
        if 'expands' in params:
            query_params['expands'] = params['expands']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workitem',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitem_history(self, workitem_id: str, **kwargs) -> 'WorkitemChangeListing':
        """
        Get a listing of a workitem's attribute change history
        
	    get_taskmanagement_workitem_history is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitem_history(workitem_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: Workitem ID (required)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param int page_size: Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 200.
        :param str sort_order: Ascending or descending sort order
        :return: WorkitemChangeListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id', 'after', 'page_size', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitem_history" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `get_taskmanagement_workitem_history`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}/history'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemChangeListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitem_user_wrapups(self, workitem_id: str, user_id: str, **kwargs) -> 'WorkitemWrapup':
        """
        Get all wrapup codes added for the given user for a workitem.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitem_user_wrapups(workitem_id, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: The ID of the Workitem. (required)
        :param str user_id: The ID of the user (required)
        :param str expands: Which fields, if any, to expand.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param int page_size: Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 50.
        :param str sort_order: Ascending or descending sort order
        :return: WorkitemWrapup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id', 'user_id', 'expands', 'after', 'page_size', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitem_user_wrapups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `get_taskmanagement_workitem_user_wrapups`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_taskmanagement_workitem_user_wrapups`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}/users/{userId}/wrapups'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'expands' in params:
            query_params['expands'] = params['expands']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemWrapup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitem_version(self, workitem_id: str, entity_version: int, **kwargs) -> 'WorkitemVersion':
        """
        Get a version of a workitem
        
	    get_taskmanagement_workitem_version is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitem_version(workitem_id, entity_version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: Workitem ID (required)
        :param int entity_version: Workitem version (required)
        :return: WorkitemVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id', 'entity_version']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitem_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `get_taskmanagement_workitem_version`")
        # verify the required parameter 'entity_version' is set
        if ('entity_version' not in params) or (params['entity_version'] is None):
            raise ValueError("Missing the required parameter `entity_version` when calling `get_taskmanagement_workitem_version`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}/versions/{entityVersion}'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']
        if 'entity_version' in params:
            path_params['entityVersion'] = params['entity_version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitem_versions(self, workitem_id: str, **kwargs) -> 'WorkitemVersionListing':
        """
        Get all versions of a workitem
        
	    get_taskmanagement_workitem_versions is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitem_versions(workitem_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: Workitem ID (required)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param int page_size: Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 200.
        :param str sort_order: Ascending or descending sort order
        :return: WorkitemVersionListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id', 'after', 'page_size', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitem_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `get_taskmanagement_workitem_versions`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemVersionListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitem_wrapups(self, workitem_id: str, **kwargs) -> 'WorkitemWrapupEntityListing':
        """
        Get all wrapup codes added for all users for a workitem.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitem_wrapups(workitem_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: The ID of the Workitem. (required)
        :param str expands: Which fields, if any, to expand.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param int page_size: Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 50.
        :param str sort_order: Ascending or descending sort order
        :return: WorkitemWrapupEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id', 'expands', 'after', 'page_size', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitem_wrapups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `get_taskmanagement_workitem_wrapups`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}/wrapups'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']

        query_params = {}
        if 'expands' in params:
            query_params['expands'] = params['expands']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemWrapupEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_bulk_add_job(self, bulk_job_id: str, **kwargs) -> 'BulkJob':
        """
        Get the bulk add job associated with the job id.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_bulk_add_job(bulk_job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bulk_job_id: Bulk job id (required)
        :return: BulkJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_bulk_add_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'bulk_job_id' is set
        if ('bulk_job_id' not in params) or (params['bulk_job_id'] is None):
            raise ValueError("Missing the required parameter `bulk_job_id` when calling `get_taskmanagement_workitems_bulk_add_job`")


        resource_path = '/api/v2/taskmanagement/workitems/bulk/add/jobs/{bulkJobId}'.replace('{format}', 'json')
        path_params = {}
        if 'bulk_job_id' in params:
            path_params['bulkJobId'] = params['bulk_job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_bulk_add_job_results(self, bulk_job_id: str, **kwargs) -> 'BulkJobAddResponse':
        """
        Get bulk add job results.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_bulk_add_job_results(bulk_job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bulk_job_id: Bulk job id (required)
        :return: BulkJobAddResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_bulk_add_job_results" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'bulk_job_id' is set
        if ('bulk_job_id' not in params) or (params['bulk_job_id'] is None):
            raise ValueError("Missing the required parameter `bulk_job_id` when calling `get_taskmanagement_workitems_bulk_add_job_results`")


        resource_path = '/api/v2/taskmanagement/workitems/bulk/add/jobs/{bulkJobId}/results'.replace('{format}', 'json')
        path_params = {}
        if 'bulk_job_id' in params:
            path_params['bulkJobId'] = params['bulk_job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkJobAddResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_bulk_jobs_users_me(self, **kwargs) -> 'BulkJobsListing':
        """
        Get bulk jobs created by the currently logged in user.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_bulk_jobs_users_me(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param int page_size: Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 200.
        :param str sort_order: Ascending or descending sort order
        :param str action: The bulk job action.
        :return: BulkJobsListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['after', 'page_size', 'sort_order', 'action']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_bulk_jobs_users_me" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/taskmanagement/workitems/bulk/jobs/users/me'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'action' in params:
            query_params['action'] = params['action']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkJobsListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_bulk_terminate_job(self, bulk_job_id: str, **kwargs) -> 'BulkJob':
        """
        Get the bulk job associated with the job id.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_bulk_terminate_job(bulk_job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bulk_job_id: Bulk job id (required)
        :return: BulkJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_bulk_terminate_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'bulk_job_id' is set
        if ('bulk_job_id' not in params) or (params['bulk_job_id'] is None):
            raise ValueError("Missing the required parameter `bulk_job_id` when calling `get_taskmanagement_workitems_bulk_terminate_job`")


        resource_path = '/api/v2/taskmanagement/workitems/bulk/terminate/jobs/{bulkJobId}'.replace('{format}', 'json')
        path_params = {}
        if 'bulk_job_id' in params:
            path_params['bulkJobId'] = params['bulk_job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_bulk_terminate_job_results(self, bulk_job_id: str, **kwargs) -> 'BulkJobTerminateResultsResponse':
        """
        Get bulk terminate job results.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_bulk_terminate_job_results(bulk_job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bulk_job_id: Bulk job id (required)
        :return: BulkJobTerminateResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_bulk_terminate_job_results" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'bulk_job_id' is set
        if ('bulk_job_id' not in params) or (params['bulk_job_id'] is None):
            raise ValueError("Missing the required parameter `bulk_job_id` when calling `get_taskmanagement_workitems_bulk_terminate_job_results`")


        resource_path = '/api/v2/taskmanagement/workitems/bulk/terminate/jobs/{bulkJobId}/results'.replace('{format}', 'json')
        path_params = {}
        if 'bulk_job_id' in params:
            path_params['bulkJobId'] = params['bulk_job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkJobTerminateResultsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_query_job(self, job_id: str, **kwargs) -> 'WorkitemQueryJobResponse':
        """
        Get the workitem query job associated with the job id.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_query_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: jobId (required)
        :return: WorkitemQueryJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_query_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_taskmanagement_workitems_query_job`")


        resource_path = '/api/v2/taskmanagement/workitems/query/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemQueryJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_query_job_results(self, job_id: str, **kwargs) -> 'WorkitemPagedEntityListing':
        """
        Get results from for workitem query job 
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_query_job_results(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: jobId (required)
        :return: WorkitemPagedEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_query_job_results" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_taskmanagement_workitems_query_job_results`")


        resource_path = '/api/v2/taskmanagement/workitems/query/jobs/{jobId}/results'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemPagedEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_schema(self, schema_id: str, **kwargs) -> 'DataSchema':
        """
        Get a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_schema(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_taskmanagement_workitems_schema`")


        resource_path = '/api/v2/taskmanagement/workitems/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_schema_version(self, schema_id: str, version_id: str, **kwargs) -> 'DataSchema':
        """
        Get a specific version of a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_schema_version(schema_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :param str version_id: Schema version (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id', 'version_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_schema_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_taskmanagement_workitems_schema_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_taskmanagement_workitems_schema_version`")


        resource_path = '/api/v2/taskmanagement/workitems/schemas/{schemaId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_schema_versions(self, schema_id: str, **kwargs) -> 'DataSchema':
        """
        Get all versions of a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_schema_versions(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_schema_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_taskmanagement_workitems_schema_versions`")


        resource_path = '/api/v2/taskmanagement/workitems/schemas/{schemaId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_schemas(self, **kwargs) -> 'DataSchemaListing':
        """
        Get a list of schemas.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_schemas(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DataSchemaListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_schemas" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/taskmanagement/workitems/schemas'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchemaListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_schemas_coretype(self, core_type_name: str, **kwargs) -> 'Coretype':
        """
        Get the core types from which all schemas are built.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_schemas_coretype(core_type_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str core_type_name: Name of the core type (required)
        :return: Coretype
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['core_type_name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_schemas_coretype" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'core_type_name' is set
        if ('core_type_name' not in params) or (params['core_type_name'] is None):
            raise ValueError("Missing the required parameter `core_type_name` when calling `get_taskmanagement_workitems_schemas_coretype`")


        resource_path = '/api/v2/taskmanagement/workitems/schemas/coretypes/{coreTypeName}'.replace('{format}', 'json')
        path_params = {}
        if 'core_type_name' in params:
            path_params['coreTypeName'] = params['core_type_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Coretype',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_schemas_coretypes(self, **kwargs) -> 'Coretype':
        """
        Get the core types from which all schemas are built.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_schemas_coretypes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: Coretype
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_schemas_coretypes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/taskmanagement/workitems/schemas/coretypes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Coretype',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_workitems_schemas_limits(self, **kwargs) -> 'SchemaQuantityLimits':
        """
        Get quantitative limits on schemas
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_workitems_schemas_limits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SchemaQuantityLimits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_workitems_schemas_limits" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/taskmanagement/workitems/schemas/limits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SchemaQuantityLimits',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_worktype(self, worktype_id: str, **kwargs) -> 'Worktype':
        """
        Get a worktype
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_worktype(worktype_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param list[str] expands: Which fields, if any, to expand.
        :return: Worktype
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'expands']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_worktype" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `get_taskmanagement_worktype`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']

        query_params = {}
        if 'expands' in params:
            query_params['expands'] = params['expands']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Worktype',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_worktype_flows_datebased_rule(self, worktype_id: str, rule_id: str, **kwargs) -> 'WorkitemDateBasedRule':
        """
        Get a date based rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_worktype_flows_datebased_rule(worktype_id, rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str rule_id: ruleId (required)
        :return: WorkitemDateBasedRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_worktype_flows_datebased_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `get_taskmanagement_worktype_flows_datebased_rule`")
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `get_taskmanagement_worktype_flows_datebased_rule`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/datebased/rules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemDateBasedRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_worktype_flows_datebased_rules(self, worktype_id: str, **kwargs) -> 'WorkitemDateBasedRuleListing':
        """
        Get all date based rules for a worktype
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_worktype_flows_datebased_rules(worktype_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param int page_size: Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 200.
        :return: WorkitemDateBasedRuleListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'after', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_worktype_flows_datebased_rules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `get_taskmanagement_worktype_flows_datebased_rules`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/datebased/rules'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemDateBasedRuleListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_worktype_flows_onattributechange_rule(self, worktype_id: str, rule_id: str, **kwargs) -> 'WorkitemOnAttributeChangeRule':
        """
        Get an attribute change rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_worktype_flows_onattributechange_rule(worktype_id, rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str rule_id: ruleId (required)
        :return: WorkitemOnAttributeChangeRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_worktype_flows_onattributechange_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `get_taskmanagement_worktype_flows_onattributechange_rule`")
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `get_taskmanagement_worktype_flows_onattributechange_rule`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/onattributechange/rules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemOnAttributeChangeRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_worktype_flows_onattributechange_rules(self, worktype_id: str, **kwargs) -> 'WorkitemOnAttributeChangeRuleListing':
        """
        Get all attribute-change rules for a worktype
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_worktype_flows_onattributechange_rules(worktype_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param int page_size: Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 200.
        :return: WorkitemOnAttributeChangeRuleListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'after', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_worktype_flows_onattributechange_rules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `get_taskmanagement_worktype_flows_onattributechange_rules`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/onattributechange/rules'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemOnAttributeChangeRuleListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_worktype_flows_oncreate_rule(self, worktype_id: str, rule_id: str, **kwargs) -> 'WorkitemOnCreateRule':
        """
        Get an on-create rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_worktype_flows_oncreate_rule(worktype_id, rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str rule_id: ruleId (required)
        :return: WorkitemOnCreateRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_worktype_flows_oncreate_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `get_taskmanagement_worktype_flows_oncreate_rule`")
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `get_taskmanagement_worktype_flows_oncreate_rule`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/oncreate/rules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemOnCreateRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_worktype_flows_oncreate_rules(self, worktype_id: str, **kwargs) -> 'WorkitemOnCreateRuleListing':
        """
        Get all on-create rules for a worktype
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_worktype_flows_oncreate_rules(worktype_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param int page_size: Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 200.
        :return: WorkitemOnCreateRuleListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'after', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_worktype_flows_oncreate_rules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `get_taskmanagement_worktype_flows_oncreate_rules`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/oncreate/rules'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemOnCreateRuleListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_worktype_history(self, worktype_id: str, **kwargs) -> 'WorktypeChangeListing':
        """
        Get a listing of a worktype's attribute change history
        
	    get_taskmanagement_worktype_history is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_worktype_history(worktype_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param int page_size: Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 200.
        :param str sort_order: Ascending or descending sort order
        :param list[str] fields: Comma-separated list of fields. The response will contain only versions created as a result of changes to these fields.
        :return: WorktypeChangeListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'after', 'page_size', 'sort_order', 'fields']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_worktype_history" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `get_taskmanagement_worktype_history`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/history'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'fields' in params:
            query_params['fields'] = params['fields']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorktypeChangeListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_worktype_status(self, worktype_id: str, status_id: str, **kwargs) -> 'WorkitemStatus':
        """
        Get a status
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_worktype_status(worktype_id, status_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str status_id: Status id (required)
        :return: WorkitemStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'status_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_worktype_status" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `get_taskmanagement_worktype_status`")
        # verify the required parameter 'status_id' is set
        if ('status_id' not in params) or (params['status_id'] is None):
            raise ValueError("Missing the required parameter `status_id` when calling `get_taskmanagement_worktype_status`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/statuses/{statusId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']
        if 'status_id' in params:
            path_params['statusId'] = params['status_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_worktype_statuses(self, worktype_id: str, **kwargs) -> 'WorkitemStatusListing':
        """
        Get list of statuses for this worktype.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_worktype_statuses(worktype_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :return: WorkitemStatusListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_worktype_statuses" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `get_taskmanagement_worktype_statuses`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/statuses'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemStatusListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_worktype_version(self, worktype_id: str, entity_version: int, **kwargs) -> 'WorktypeVersion':
        """
        Get a version of a worktype
        
	    get_taskmanagement_worktype_version is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_worktype_version(worktype_id, entity_version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param int entity_version: Worktype version (required)
        :return: WorktypeVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'entity_version']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_worktype_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `get_taskmanagement_worktype_version`")
        # verify the required parameter 'entity_version' is set
        if ('entity_version' not in params) or (params['entity_version'] is None):
            raise ValueError("Missing the required parameter `entity_version` when calling `get_taskmanagement_worktype_version`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/versions/{entityVersion}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']
        if 'entity_version' in params:
            path_params['entityVersion'] = params['entity_version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorktypeVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_taskmanagement_worktype_versions(self, worktype_id: str, **kwargs) -> 'WorktypeVersionListing':
        """
        Get all versions of a worktype
        
	    get_taskmanagement_worktype_versions is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_taskmanagement_worktype_versions(worktype_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param int page_size: Limit the number of entities to return. It is not guaranteed that the requested number of entities will be filled in a single request. If an `after` key is returned as part of the response it is possible that more entities that match the filter criteria exist. Maximum of 200.
        :param str sort_order: Ascending or descending sort order
        :return: WorktypeVersionListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'after', 'page_size', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_taskmanagement_worktype_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `get_taskmanagement_worktype_versions`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorktypeVersionListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_taskmanagement_workbin(self, workbin_id: str, body: 'WorkbinUpdate', **kwargs) -> 'Workbin':
        """
        Update the attributes of a workbin
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_taskmanagement_workbin(workbin_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workbin_id: Workbin ID (required)
        :param WorkbinUpdate body: Json with attributes and their new values: {\"description\":\"new description\", \"name\":\"new name\"}. (required)
        :return: Workbin
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workbin_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_taskmanagement_workbin" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workbin_id' is set
        if ('workbin_id' not in params) or (params['workbin_id'] is None):
            raise ValueError("Missing the required parameter `workbin_id` when calling `patch_taskmanagement_workbin`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_taskmanagement_workbin`")


        resource_path = '/api/v2/taskmanagement/workbins/{workbinId}'.replace('{format}', 'json')
        path_params = {}
        if 'workbin_id' in params:
            path_params['workbinId'] = params['workbin_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workbin',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_taskmanagement_workitem(self, workitem_id: str, body: 'WorkitemUpdate', **kwargs) -> 'Workitem':
        """
        Update the attributes of a workitem
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_taskmanagement_workitem(workitem_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: Workitem ID (required)
        :param WorkitemUpdate body: Workitem (required)
        :return: Workitem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_taskmanagement_workitem" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `patch_taskmanagement_workitem`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_taskmanagement_workitem`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workitem',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_taskmanagement_workitem_assignment(self, workitem_id: str, body: 'WorkitemManualAssign', **kwargs) -> None:
        """
        Attempts to manually assign a specified workitem to a specified user.  Ignores bullseye ring, PAR score, skills, and languages.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_taskmanagement_workitem_assignment(workitem_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: Workitem ID (required)
        :param WorkitemManualAssign body: Targeted user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_taskmanagement_workitem_assignment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `patch_taskmanagement_workitem_assignment`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_taskmanagement_workitem_assignment`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}/assignment'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_taskmanagement_workitem_user_wrapups(self, workitem_id: str, user_id: str, body: 'WorkitemWrapupUpdate', **kwargs) -> 'WorkitemWrapup':
        """
        Add/Remove a wrapup code for a given user in a workitem.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_taskmanagement_workitem_user_wrapups(workitem_id, user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: The ID of the Workitem. (required)
        :param str user_id: The ID of the user (required)
        :param WorkitemWrapupUpdate body: Request body to add/remove a wrapup code for a workitem (required)
        :return: WorkitemWrapup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id', 'user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_taskmanagement_workitem_user_wrapups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `patch_taskmanagement_workitem_user_wrapups`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `patch_taskmanagement_workitem_user_wrapups`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_taskmanagement_workitem_user_wrapups`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}/users/{userId}/wrapups'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemWrapup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_taskmanagement_workitem_users_me_wrapups(self, workitem_id: str, body: 'WorkitemWrapupUpdate', **kwargs) -> 'WorkitemWrapup':
        """
        Add/Remove a wrapup code for the current user in a workitem.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_taskmanagement_workitem_users_me_wrapups(workitem_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: The ID of the Workitem. (required)
        :param WorkitemWrapupUpdate body: Request body to add/remove the wrapup code for workitem (required)
        :return: WorkitemWrapup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_taskmanagement_workitem_users_me_wrapups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `patch_taskmanagement_workitem_users_me_wrapups`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_taskmanagement_workitem_users_me_wrapups`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}/users/me/wrapups'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemWrapup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_taskmanagement_workitems_bulk_add_job(self, bulk_job_id: str, body: 'BulkJobUpdate', **kwargs) -> 'BulkJob':
        """
        Update workitem bulk add job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_taskmanagement_workitems_bulk_add_job(bulk_job_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bulk_job_id: Bulk job id (required)
        :param BulkJobUpdate body: Bulk add job update request (required)
        :return: BulkJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_job_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_taskmanagement_workitems_bulk_add_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'bulk_job_id' is set
        if ('bulk_job_id' not in params) or (params['bulk_job_id'] is None):
            raise ValueError("Missing the required parameter `bulk_job_id` when calling `patch_taskmanagement_workitems_bulk_add_job`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_taskmanagement_workitems_bulk_add_job`")


        resource_path = '/api/v2/taskmanagement/workitems/bulk/add/jobs/{bulkJobId}'.replace('{format}', 'json')
        path_params = {}
        if 'bulk_job_id' in params:
            path_params['bulkJobId'] = params['bulk_job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_taskmanagement_workitems_bulk_terminate_job(self, bulk_job_id: str, body: 'BulkJobUpdate', **kwargs) -> 'BulkJob':
        """
        Update workitem bulk terminate job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_taskmanagement_workitems_bulk_terminate_job(bulk_job_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str bulk_job_id: Bulk job id (required)
        :param BulkJobUpdate body: Bulk job update request (required)
        :return: BulkJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bulk_job_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_taskmanagement_workitems_bulk_terminate_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'bulk_job_id' is set
        if ('bulk_job_id' not in params) or (params['bulk_job_id'] is None):
            raise ValueError("Missing the required parameter `bulk_job_id` when calling `patch_taskmanagement_workitems_bulk_terminate_job`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_taskmanagement_workitems_bulk_terminate_job`")


        resource_path = '/api/v2/taskmanagement/workitems/bulk/terminate/jobs/{bulkJobId}'.replace('{format}', 'json')
        path_params = {}
        if 'bulk_job_id' in params:
            path_params['bulkJobId'] = params['bulk_job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_taskmanagement_worktype(self, worktype_id: str, body: 'WorktypeUpdate', **kwargs) -> 'Worktype':
        """
        Update the attributes of a worktype
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_taskmanagement_worktype(worktype_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param WorktypeUpdate body: Worktype (required)
        :return: Worktype
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_taskmanagement_worktype" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `patch_taskmanagement_worktype`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_taskmanagement_worktype`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Worktype',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_taskmanagement_worktype_flows_datebased_rule(self, worktype_id: str, rule_id: str, body: 'WorkitemDateBasedRuleUpdate', **kwargs) -> 'WorkitemDateBasedRule':
        """
        Update the attributes of a date based rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_taskmanagement_worktype_flows_datebased_rule(worktype_id, rule_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str rule_id: ruleId (required)
        :param WorkitemDateBasedRuleUpdate body: Rule (required)
        :return: WorkitemDateBasedRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'rule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_taskmanagement_worktype_flows_datebased_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `patch_taskmanagement_worktype_flows_datebased_rule`")
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `patch_taskmanagement_worktype_flows_datebased_rule`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_taskmanagement_worktype_flows_datebased_rule`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/datebased/rules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemDateBasedRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_taskmanagement_worktype_flows_onattributechange_rule(self, worktype_id: str, rule_id: str, body: 'WorkitemOnAttributeChangeRuleUpdate', **kwargs) -> 'WorkitemOnAttributeChangeRule':
        """
        Update the attributes of a rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_taskmanagement_worktype_flows_onattributechange_rule(worktype_id, rule_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str rule_id: ruleId (required)
        :param WorkitemOnAttributeChangeRuleUpdate body: Rule (required)
        :return: WorkitemOnAttributeChangeRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'rule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_taskmanagement_worktype_flows_onattributechange_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `patch_taskmanagement_worktype_flows_onattributechange_rule`")
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `patch_taskmanagement_worktype_flows_onattributechange_rule`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_taskmanagement_worktype_flows_onattributechange_rule`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/onattributechange/rules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemOnAttributeChangeRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_taskmanagement_worktype_flows_oncreate_rule(self, worktype_id: str, rule_id: str, body: 'WorkitemOnCreateRuleUpdate', **kwargs) -> 'WorkitemOnCreateRule':
        """
        Update the attributes of a rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_taskmanagement_worktype_flows_oncreate_rule(worktype_id, rule_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str rule_id: ruleId (required)
        :param WorkitemOnCreateRuleUpdate body: Rule (required)
        :return: WorkitemOnCreateRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'rule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_taskmanagement_worktype_flows_oncreate_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `patch_taskmanagement_worktype_flows_oncreate_rule`")
        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `patch_taskmanagement_worktype_flows_oncreate_rule`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_taskmanagement_worktype_flows_oncreate_rule`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/oncreate/rules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemOnCreateRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_taskmanagement_worktype_status(self, worktype_id: str, status_id: str, body: 'WorkitemStatusUpdate', **kwargs) -> 'WorkitemStatus':
        """
        Update the attributes of a status
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_taskmanagement_worktype_status(worktype_id, status_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param str status_id: Status id (required)
        :param WorkitemStatusUpdate body: Status (required)
        :return: WorkitemStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'status_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_taskmanagement_worktype_status" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `patch_taskmanagement_worktype_status`")
        # verify the required parameter 'status_id' is set
        if ('status_id' not in params) or (params['status_id'] is None):
            raise ValueError("Missing the required parameter `status_id` when calling `patch_taskmanagement_worktype_status`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_taskmanagement_worktype_status`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/statuses/{statusId}'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']
        if 'status_id' in params:
            path_params['statusId'] = params['status_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_workbins(self, body: 'WorkbinCreate', **kwargs) -> 'Workbin':
        """
        Create a workbin
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_workbins(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorkbinCreate body: Workbin (required)
        :return: Workbin
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_workbins" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_workbins`")


        resource_path = '/api/v2/taskmanagement/workbins'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workbin',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_workbins_query(self, body: 'WorkbinQueryRequest', **kwargs) -> 'WorkbinQueryEntityListing':
        """
        Query for workbins
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_workbins_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorkbinQueryRequest body: QueryPostRequest (required)
        :return: WorkbinQueryEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_workbins_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_workbins_query`")


        resource_path = '/api/v2/taskmanagement/workbins/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkbinQueryEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_workitem_acd_cancel(self, workitem_id: str, **kwargs) -> 'Workitem':
        """
        Cancel the assignment process for a workitem that is currently queued for assignment through ACD.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_workitem_acd_cancel(workitem_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: Workitem ID (required)
        :return: Workitem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_workitem_acd_cancel" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `post_taskmanagement_workitem_acd_cancel`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}/acd/cancel'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workitem',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_workitem_disconnect(self, workitem_id: str, **kwargs) -> 'Workitem':
        """
        Disconnect the assignee of the workitem
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_workitem_disconnect(workitem_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: Workitem ID (required)
        :return: Workitem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_workitem_disconnect" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `post_taskmanagement_workitem_disconnect`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}/disconnect'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workitem',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_workitem_terminate(self, workitem_id: str, **kwargs) -> 'Workitem':
        """
        Terminate a workitem
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_workitem_terminate(workitem_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workitem_id: Workitem ID (required)
        :param WorkitemTerminate body: Terminated request
        :return: Workitem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workitem_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_workitem_terminate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workitem_id' is set
        if ('workitem_id' not in params) or (params['workitem_id'] is None):
            raise ValueError("Missing the required parameter `workitem_id` when calling `post_taskmanagement_workitem_terminate`")


        resource_path = '/api/v2/taskmanagement/workitems/{workitemId}/terminate'.replace('{format}', 'json')
        path_params = {}
        if 'workitem_id' in params:
            path_params['workitemId'] = params['workitem_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workitem',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_workitems(self, body: 'WorkitemCreate', **kwargs) -> 'Workitem':
        """
        Create a workitem
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_workitems(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorkitemCreate body: Workitem (required)
        :return: Workitem
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_workitems" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_workitems`")


        resource_path = '/api/v2/taskmanagement/workitems'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workitem',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_workitems_bulk_add_jobs(self, body: 'BulkJobAddRequest', **kwargs) -> 'BulkJob':
        """
        Create a workitem bulk add job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_workitems_bulk_add_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkJobAddRequest body: Bulk job definition. (required)
        :return: BulkJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_workitems_bulk_add_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_workitems_bulk_add_jobs`")


        resource_path = '/api/v2/taskmanagement/workitems/bulk/add/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_workitems_bulk_terminate_jobs(self, body: 'BulkJobTerminateRequest', **kwargs) -> 'BulkJob':
        """
        Create a workitem bulk terminate job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_workitems_bulk_terminate_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkJobTerminateRequest body: Bulk job definition. (required)
        :return: BulkJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_workitems_bulk_terminate_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_workitems_bulk_terminate_jobs`")


        resource_path = '/api/v2/taskmanagement/workitems/bulk/terminate/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_workitems_query(self, body: 'WorkitemQueryPostRequest', **kwargs) -> 'WorkitemPostQueryEntityListing':
        """
        Query for workitems
        This query requires at least one EQ filter on the workbinId, assigneeId or typeId attributes.
	    post_taskmanagement_workitems_query is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_workitems_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorkitemQueryPostRequest body: WorkitemQueryPostRequest (required)
        :return: WorkitemPostQueryEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_workitems_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_workitems_query`")


        resource_path = '/api/v2/taskmanagement/workitems/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemPostQueryEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_workitems_query_jobs(self, body: 'WorkitemQueryJobCreate', **kwargs) -> 'WorkitemQueryJobResponse':
        """
        Create a workitem query job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_workitems_query_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorkitemQueryJobCreate body: WorkitemQueryJobCreate (required)
        :return: WorkitemQueryJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_workitems_query_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_workitems_query_jobs`")


        resource_path = '/api/v2/taskmanagement/workitems/query/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemQueryJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_workitems_schemas(self, body: 'DataSchema', **kwargs) -> 'DataSchema':
        """
        Create a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_workitems_schemas(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DataSchema body: Schema (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_workitems_schemas" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_workitems_schemas`")


        resource_path = '/api/v2/taskmanagement/workitems/schemas'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_worktype_flows_datebased_rules(self, worktype_id: str, body: 'WorkitemDateBasedRuleCreate', **kwargs) -> 'WorkitemDateBasedRule':
        """
        Add a date based rule to a worktype
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_worktype_flows_datebased_rules(worktype_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param WorkitemDateBasedRuleCreate body: Rule (required)
        :return: WorkitemDateBasedRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_worktype_flows_datebased_rules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `post_taskmanagement_worktype_flows_datebased_rules`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_worktype_flows_datebased_rules`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/datebased/rules'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemDateBasedRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_worktype_flows_onattributechange_rules(self, worktype_id: str, body: 'WorkitemOnAttributeChangeRuleCreate', **kwargs) -> 'WorkitemOnAttributeChangeRule':
        """
        Add an attribute-change rule to a worktype
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_worktype_flows_onattributechange_rules(worktype_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param WorkitemOnAttributeChangeRuleCreate body: Rule (required)
        :return: WorkitemOnAttributeChangeRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_worktype_flows_onattributechange_rules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `post_taskmanagement_worktype_flows_onattributechange_rules`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_worktype_flows_onattributechange_rules`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/onattributechange/rules'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemOnAttributeChangeRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_worktype_flows_oncreate_rules(self, worktype_id: str, body: 'WorkitemOnCreateRuleCreate', **kwargs) -> 'WorkitemOnCreateRule':
        """
        Add an on-create rule to a worktype
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_worktype_flows_oncreate_rules(worktype_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param WorkitemOnCreateRuleCreate body: Rule (required)
        :return: WorkitemOnCreateRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_worktype_flows_oncreate_rules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `post_taskmanagement_worktype_flows_oncreate_rules`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_worktype_flows_oncreate_rules`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/flows/oncreate/rules'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemOnCreateRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_worktype_statuses(self, worktype_id: str, body: 'WorkitemStatusCreate', **kwargs) -> 'WorkitemStatus':
        """
        Add a status to a worktype
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_worktype_statuses(worktype_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str worktype_id: Worktype id (required)
        :param WorkitemStatusCreate body: Status (required)
        :return: WorkitemStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['worktype_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_worktype_statuses" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'worktype_id' is set
        if ('worktype_id' not in params) or (params['worktype_id'] is None):
            raise ValueError("Missing the required parameter `worktype_id` when calling `post_taskmanagement_worktype_statuses`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_worktype_statuses`")


        resource_path = '/api/v2/taskmanagement/worktypes/{worktypeId}/statuses'.replace('{format}', 'json')
        path_params = {}
        if 'worktype_id' in params:
            path_params['worktypeId'] = params['worktype_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkitemStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_worktypes(self, body: 'WorktypeCreate', **kwargs) -> 'Worktype':
        """
        Create a worktype
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_worktypes(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorktypeCreate body: Worktype (required)
        :return: Worktype
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_worktypes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_worktypes`")


        resource_path = '/api/v2/taskmanagement/worktypes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Worktype',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_taskmanagement_worktypes_query(self, body: 'WorktypeQueryRequest', **kwargs) -> 'WorktypeQueryEntityListing':
        """
        Query for worktypes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_taskmanagement_worktypes_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorktypeQueryRequest body: QueryPostRequest (required)
        :return: WorktypeQueryEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_taskmanagement_worktypes_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_taskmanagement_worktypes_query`")


        resource_path = '/api/v2/taskmanagement/worktypes/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorktypeQueryEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_taskmanagement_workitems_schema(self, schema_id: str, body: 'DataSchema', **kwargs) -> 'DataSchema':
        """
        Update a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_taskmanagement_workitems_schema(schema_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :param DataSchema body: Data Schema (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_taskmanagement_workitems_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `put_taskmanagement_workitems_schema`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_taskmanagement_workitems_schema`")


        resource_path = '/api/v2/taskmanagement/workitems/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
