# coding: utf-8

"""
ProcessAutomationApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import CreateTriggerRequest
from ..models import ErrorBody
from ..models import TestModeEventResults
from ..models import TestModeResults
from ..models import TopicCursorEntityListing
from ..models import Trigger
from ..models import TriggerEntityListing
from ..models import UpdateTriggerRequest

class ProcessAutomationApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_processautomation_trigger(self, trigger_id: str, **kwargs) -> None:
        """
        Delete a Trigger
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_processautomation_trigger(trigger_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trigger_id: triggerId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trigger_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_processautomation_trigger" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trigger_id' is set
        if ('trigger_id' not in params) or (params['trigger_id'] is None):
            raise ValueError("Missing the required parameter `trigger_id` when calling `delete_processautomation_trigger`")


        resource_path = '/api/v2/processautomation/triggers/{triggerId}'.replace('{format}', 'json')
        path_params = {}
        if 'trigger_id' in params:
            path_params['triggerId'] = params['trigger_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_processautomation_trigger(self, trigger_id: str, **kwargs) -> 'Trigger':
        """
        Retrieve a single Trigger matching id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_processautomation_trigger(trigger_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trigger_id: triggerId (required)
        :return: Trigger
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trigger_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_processautomation_trigger" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trigger_id' is set
        if ('trigger_id' not in params) or (params['trigger_id'] is None):
            raise ValueError("Missing the required parameter `trigger_id` when calling `get_processautomation_trigger`")


        resource_path = '/api/v2/processautomation/triggers/{triggerId}'.replace('{format}', 'json')
        path_params = {}
        if 'trigger_id' in params:
            path_params['triggerId'] = params['trigger_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Trigger',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_processautomation_triggers(self, **kwargs) -> 'TriggerEntityListing':
        """
        Retrieves all triggers, optionally filtered by query parameters.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_processautomation_triggers(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str before: The cursor that points to the start of the set of entities that has been returned.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str page_size: Number of entities to return. Maximum of 200.
        :param str topic_name: Topic name(s). Separated by commas
        :param bool enabled: Boolean indicating desired enabled state of triggers
        :param bool has_delay_by: Boolean to filter based on delayBySeconds being set in triggers. Default returns all, true returns only those with delayBySeconds set, false returns those without delayBySeconds set.
        :return: TriggerEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['before', 'after', 'page_size', 'topic_name', 'enabled', 'has_delay_by']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_processautomation_triggers" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/processautomation/triggers'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'topic_name' in params:
            query_params['topicName'] = params['topic_name']
        if 'enabled' in params:
            query_params['enabled'] = params['enabled']
        if 'has_delay_by' in params:
            query_params['hasDelayBy'] = params['has_delay_by']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TriggerEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_processautomation_triggers_topics(self, **kwargs) -> 'TopicCursorEntityListing':
        """
        Get topics available for organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_processautomation_triggers_topics(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str before: The cursor that points to the start of the set of entities that has been returned.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str page_size: Number of entities to return. Maximum of 200.
        :return: TopicCursorEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['before', 'after', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_processautomation_triggers_topics" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/processautomation/triggers/topics'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TopicCursorEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_processautomation_trigger_test(self, trigger_id: str, **kwargs) -> 'TestModeResults':
        """
        Test the matching of a Trigger based on provided event body
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_processautomation_trigger_test(trigger_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trigger_id: triggerId (required)
        :param str body: eventBody
        :return: TestModeResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trigger_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_processautomation_trigger_test" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trigger_id' is set
        if ('trigger_id' not in params) or (params['trigger_id'] is None):
            raise ValueError("Missing the required parameter `trigger_id` when calling `post_processautomation_trigger_test`")


        resource_path = '/api/v2/processautomation/triggers/{triggerId}/test'.replace('{format}', 'json')
        path_params = {}
        if 'trigger_id' in params:
            path_params['triggerId'] = params['trigger_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TestModeResults',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_processautomation_triggers(self, body: 'CreateTriggerRequest', **kwargs) -> 'Trigger':
        """
        Create a Trigger
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_processautomation_triggers(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateTriggerRequest body: Input used to create a Trigger. (required)
        :return: Trigger
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_processautomation_triggers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_processautomation_triggers`")


        resource_path = '/api/v2/processautomation/triggers'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Trigger',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_processautomation_triggers_topic_test(self, topic_name: str, **kwargs) -> 'TestModeEventResults':
        """
        Test the matching of all organization Triggers on given topic using provided event body
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_processautomation_triggers_topic_test(topic_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str topic_name: topicName (required)
        :param str body: eventBody
        :return: TestModeEventResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['topic_name', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_processautomation_triggers_topic_test" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'topic_name' is set
        if ('topic_name' not in params) or (params['topic_name'] is None):
            raise ValueError("Missing the required parameter `topic_name` when calling `post_processautomation_triggers_topic_test`")


        resource_path = '/api/v2/processautomation/triggers/topics/{topicName}/test'.replace('{format}', 'json')
        path_params = {}
        if 'topic_name' in params:
            path_params['topicName'] = params['topic_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TestModeEventResults',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_processautomation_trigger(self, trigger_id: str, body: 'UpdateTriggerRequest', **kwargs) -> 'Trigger':
        """
        Update a Trigger
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_processautomation_trigger(trigger_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str trigger_id: triggerId (required)
        :param UpdateTriggerRequest body: Input to update Trigger. (topicName cannot be updated, a new trigger must be created to use a new topicName) (required)
        :return: Trigger
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['trigger_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_processautomation_trigger" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'trigger_id' is set
        if ('trigger_id' not in params) or (params['trigger_id'] is None):
            raise ValueError("Missing the required parameter `trigger_id` when calling `put_processautomation_trigger`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_processautomation_trigger`")


        resource_path = '/api/v2/processautomation/triggers/{triggerId}'.replace('{format}', 'json')
        path_params = {}
        if 'trigger_id' in params:
            path_params['triggerId'] = params['trigger_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Trigger',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
