# coding: utf-8

"""
JourneyApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import ActionEventRequest
from ..models import ActionMap
from ..models import ActionMapEstimateRequest
from ..models import ActionMapEstimateResult
from ..models import ActionMapListing
from ..models import ActionTarget
from ..models import ActionTargetListing
from ..models import ActionTemplate
from ..models import ActionTemplateListing
from ..models import AppEventRequest
from ..models import AppEventResponse
from ..models import AsyncQueryResponse
from ..models import AsyncQueryStatus
from ..models import DataRange
from ..models import DeploymentPing
from ..models import EntityListing
from ..models import ErrorBody
from ..models import EstimateJobAsyncResponse
from ..models import EventListing
from ..models import FlowPaths
from ..models import FlowPathsQuery
from ..models import JourneyAggregateQueryResponse
from ..models import JourneyAggregationQuery
from ..models import JourneyAsyncAggregateQueryResponse
from ..models import JourneyAsyncAggregationQuery
from ..models import JourneyEventDefinition
from ..models import JourneyEventDefinitionListing
from ..models import JourneySegment
from ..models import JourneySegmentRequest
from ..models import JourneyView
from ..models import JourneyViewChart
from ..models import JourneyViewChartResult
from ..models import JourneyViewJob
from ..models import JourneyViewJobListing
from ..models import JourneyViewListing
from ..models import JourneyViewResult
from ..models import JourneyViewSchedule
from ..models import JourneyViewScheduleListing
from ..models import Label
from ..models import Outcome
from ..models import OutcomeAttributionAsyncResponse
from ..models import OutcomeAttributionJobStateResponse
from ..models import OutcomeAttributionListing
from ..models import OutcomeAttributionResponseListing
from ..models import OutcomeListing
from ..models import OutcomePredictor
from ..models import OutcomePredictorListing
from ..models import OutcomePredictorRequest
from ..models import OutcomeRequest
from ..models import OutcomeScoresResult
from ..models import PatchActionMap
from ..models import PatchActionTarget
from ..models import PatchActionTemplate
from ..models import PatchOutcome
from ..models import PatchSegment
from ..models import SegmentListing
from ..models import Session
from ..models import SessionListing
from ..models import WebEventRequest
from ..models import WebEventResponse

class JourneyApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_journey_actionmap(self, action_map_id: str, **kwargs) -> None:
        """
        Delete single action map.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_journey_actionmap(action_map_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_map_id: ID of the action map. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_map_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_journey_actionmap" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_map_id' is set
        if ('action_map_id' not in params) or (params['action_map_id'] is None):
            raise ValueError("Missing the required parameter `action_map_id` when calling `delete_journey_actionmap`")


        resource_path = '/api/v2/journey/actionmaps/{actionMapId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_map_id' in params:
            path_params['actionMapId'] = params['action_map_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_journey_actiontemplate(self, action_template_id: str, **kwargs) -> None:
        """
        Delete a single action template.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_journey_actiontemplate(action_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_template_id: ID of the action template. (required)
        :param bool hard_delete: Determines whether Action Template should be soft-deleted (have it's state set to deleted) or hard-deleted (permanently removed). Set to false (soft-delete) by default.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_template_id', 'hard_delete']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_journey_actiontemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_template_id' is set
        if ('action_template_id' not in params) or (params['action_template_id'] is None):
            raise ValueError("Missing the required parameter `action_template_id` when calling `delete_journey_actiontemplate`")


        resource_path = '/api/v2/journey/actiontemplates/{actionTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_template_id' in params:
            path_params['actionTemplateId'] = params['action_template_id']

        query_params = {}
        if 'hard_delete' in params:
            query_params['hardDelete'] = params['hard_delete']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_journey_outcome(self, outcome_id: str, **kwargs) -> None:
        """
        Delete an outcome.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_journey_outcome(outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str outcome_id: ID of the outcome. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['outcome_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_journey_outcome" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'outcome_id' is set
        if ('outcome_id' not in params) or (params['outcome_id'] is None):
            raise ValueError("Missing the required parameter `outcome_id` when calling `delete_journey_outcome`")


        resource_path = '/api/v2/journey/outcomes/{outcomeId}'.replace('{format}', 'json')
        path_params = {}
        if 'outcome_id' in params:
            path_params['outcomeId'] = params['outcome_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_journey_outcomes_predictor(self, predictor_id: str, **kwargs) -> None:
        """
        Delete an outcome predictor.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_journey_outcomes_predictor(predictor_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str predictor_id: ID of predictor (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['predictor_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_journey_outcomes_predictor" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'predictor_id' is set
        if ('predictor_id' not in params) or (params['predictor_id'] is None):
            raise ValueError("Missing the required parameter `predictor_id` when calling `delete_journey_outcomes_predictor`")


        resource_path = '/api/v2/journey/outcomes/predictors/{predictorId}'.replace('{format}', 'json')
        path_params = {}
        if 'predictor_id' in params:
            path_params['predictorId'] = params['predictor_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_journey_segment(self, segment_id: str, **kwargs) -> None:
        """
        Delete a segment.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_journey_segment(segment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str segment_id: ID of the segment. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['segment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_journey_segment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'segment_id' is set
        if ('segment_id' not in params) or (params['segment_id'] is None):
            raise ValueError("Missing the required parameter `segment_id` when calling `delete_journey_segment`")


        resource_path = '/api/v2/journey/segments/{segmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'segment_id' in params:
            path_params['segmentId'] = params['segment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_journey_view(self, view_id: str, **kwargs) -> None:
        """
        Delete a Journey View by ID
        deletes all versions

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_journey_view(view_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: viewId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_journey_view" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `delete_journey_view`")


        resource_path = '/api/v2/journey/views/{viewId}'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_journey_view_schedules(self, view_id: str, **kwargs) -> 'JourneyViewSchedule':
        """
        Delete the Schedule of a JourneyView
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_journey_view_schedules(view_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: Journey View Id (required)
        :return: JourneyViewSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_journey_view_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `delete_journey_view_schedules`")


        resource_path = '/api/v2/journey/views/{viewId}/schedules'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_analytics_journeys_aggregates_job(self, job_id: str, **kwargs) -> 'AsyncQueryStatus':
        """
        Get status for async query for journey aggregates
        
	    get_analytics_journeys_aggregates_job is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_analytics_journeys_aggregates_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: jobId (required)
        :return: AsyncQueryStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analytics_journeys_aggregates_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_analytics_journeys_aggregates_job`")


        resource_path = '/api/v2/analytics/journeys/aggregates/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AsyncQueryStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_analytics_journeys_aggregates_job_results(self, job_id: str, **kwargs) -> 'JourneyAsyncAggregateQueryResponse':
        """
        Fetch a page of results for an async aggregates query
        
	    get_analytics_journeys_aggregates_job_results is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_analytics_journeys_aggregates_job_results(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: jobId (required)
        :param str cursor: Cursor token to retrieve next page
        :return: JourneyAsyncAggregateQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'cursor']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_analytics_journeys_aggregates_job_results" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_analytics_journeys_aggregates_job_results`")


        resource_path = '/api/v2/analytics/journeys/aggregates/jobs/{jobId}/results'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyAsyncAggregateQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contact_journey_sessions(self, contact_id: str, **kwargs) -> 'SessionListing':
        """
        Retrieve all sessions for a given external contact.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contact_journey_sessions(contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact ID (required)
        :param str page_size: Number of entities to return. Maximum of 200.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param bool include_merged: Indicates whether to return sessions from all external contacts in the merge-set of the given one.
        :return: SessionListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'page_size', 'after', 'include_merged']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contact_journey_sessions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `get_externalcontacts_contact_journey_sessions`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/journey/sessions'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'include_merged' in params:
            query_params['includeMerged'] = params['include_merged']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SessionListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actionmap(self, action_map_id: str, **kwargs) -> 'ActionMap':
        """
        Retrieve a single action map.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actionmap(action_map_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_map_id: ID of the action map. (required)
        :return: ActionMap
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_map_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actionmap" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_map_id' is set
        if ('action_map_id' not in params) or (params['action_map_id'] is None):
            raise ValueError("Missing the required parameter `action_map_id` when calling `get_journey_actionmap`")


        resource_path = '/api/v2/journey/actionmaps/{actionMapId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_map_id' in params:
            path_params['actionMapId'] = params['action_map_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionMap',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actionmaps(self, **kwargs) -> 'ActionMapListing':
        """
        Retrieve all action maps.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actionmaps(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Field(s) to sort by. Prefix with '-' for descending (e.g. sortBy=displayName,-createdDate).
        :param str filter_field: Field to filter by (e.g. filterField=weight or filterField=action.actionTemplate.id). Requires 'filterField' to also be set.
        :param str filter_value: Value to filter by. Requires 'filterValue' to also be set.
        :param list[str] action_map_ids: IDs of action maps to return. Use of this parameter is not compatible with pagination, filtering, sorting or querying. A maximum of 100 action maps are allowed per request.
        :param list[str] query_fields: Action Map field(s) to query on. Requires 'queryValue' to also be set.
        :param str query_value: Value to query on. Requires 'queryFields' to also be set.
        :return: ActionMapListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'filter_field', 'filter_value', 'action_map_ids', 'query_fields', 'query_value']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actionmaps" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/actionmaps'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'filter_field' in params:
            query_params['filterField'] = params['filter_field']
        if 'filter_value' in params:
            query_params['filterValue'] = params['filter_value']
        if 'action_map_ids' in params:
            query_params['actionMapIds'] = params['action_map_ids']
        if 'query_fields' in params:
            query_params['queryFields'] = params['query_fields']
        if 'query_value' in params:
            query_params['queryValue'] = params['query_value']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionMapListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actionmaps_estimates_job(self, job_id: str, **kwargs) -> str:
        """
        Get status of job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actionmaps_estimates_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: ID of the job. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actionmaps_estimates_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_journey_actionmaps_estimates_job`")


        resource_path = '/api/v2/journey/actionmaps/estimates/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actionmaps_estimates_job_results(self, job_id: str, **kwargs) -> 'ActionMapEstimateResult':
        """
        Get estimates from completed job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actionmaps_estimates_job_results(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: ID of the job. (required)
        :return: ActionMapEstimateResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actionmaps_estimates_job_results" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_journey_actionmaps_estimates_job_results`")


        resource_path = '/api/v2/journey/actionmaps/estimates/jobs/{jobId}/results'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionMapEstimateResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actiontarget(self, action_target_id: str, **kwargs) -> 'ActionTarget':
        """
        Retrieve a single action target.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actiontarget(action_target_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_target_id: ID of the action target. (required)
        :return: ActionTarget
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_target_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actiontarget" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_target_id' is set
        if ('action_target_id' not in params) or (params['action_target_id'] is None):
            raise ValueError("Missing the required parameter `action_target_id` when calling `get_journey_actiontarget`")


        resource_path = '/api/v2/journey/actiontargets/{actionTargetId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_target_id' in params:
            path_params['actionTargetId'] = params['action_target_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTarget',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actiontargets(self, **kwargs) -> 'ActionTargetListing':
        """
        Retrieve all action targets.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actiontargets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: ActionTargetListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actiontargets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/actiontargets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTargetListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actiontemplate(self, action_template_id: str, **kwargs) -> 'ActionTemplate':
        """
        Retrieve a single action template.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actiontemplate(action_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_template_id: ID of the action template. (required)
        :return: ActionTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_template_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actiontemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_template_id' is set
        if ('action_template_id' not in params) or (params['action_template_id'] is None):
            raise ValueError("Missing the required parameter `action_template_id` when calling `get_journey_actiontemplate`")


        resource_path = '/api/v2/journey/actiontemplates/{actionTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_template_id' in params:
            path_params['actionTemplateId'] = params['action_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_actiontemplates(self, **kwargs) -> 'ActionTemplateListing':
        """
        Retrieve all action templates.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_actiontemplates(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Field(s) to sort by. Prefix with '-' for descending (e.g. sortBy=name,-createdDate).
        :param str media_type: Media type
        :param str state: Action template state.
        :param list[str] query_fields: ActionTemplate field(s) to query on. Requires 'queryValue' to also be set.
        :param str query_value: Value to query on. Requires 'queryFields' to also be set.
        :return: ActionTemplateListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'media_type', 'state', 'query_fields', 'query_value']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_actiontemplates" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/actiontemplates'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'media_type' in params:
            query_params['mediaType'] = params['media_type']
        if 'state' in params:
            query_params['state'] = params['state']
        if 'query_fields' in params:
            query_params['queryFields'] = params['query_fields']
        if 'query_value' in params:
            query_params['queryValue'] = params['query_value']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTemplateListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_deployment_customer_ping(self, deployment_id: str, customer_cookie_id: str, **kwargs) -> 'DeploymentPing':
        """
        Send a ping.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_deployment_customer_ping(deployment_id, customer_cookie_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str deployment_id: The ID of the deployment sending the ping. (required)
        :param str customer_cookie_id: ID of the customer associated with the ping. (required)
        :param str dl: Document Location: 1) Web Page URL if overridden or URL fragment identifier (window.location.hash). OR  2) Application screen name that the ping request was sent from in the app. e.g. 'home' or 'help. Pings without this parameter will not return actions.
        :param str dt: Document Title.  A human readable name for the page or screen
        :param str app_namespace: Namespace of the application (e.g. com.genesys.bancodinero). Used for domain filtering in application sessions
        :param str session_id: UUID of the customer session. Use the same Session Id for all pings, AppEvents and ActionEvents in the session
        :param int since_last_beacon_milliseconds: How long (milliseconds) since the last app event or beacon was sent. The response may return a pollInternvalMilliseconds to reduce the frequency of pings.
        :return: DeploymentPing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['deployment_id', 'customer_cookie_id', 'dl', 'dt', 'app_namespace', 'session_id', 'since_last_beacon_milliseconds']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_deployment_customer_ping" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'deployment_id' is set
        if ('deployment_id' not in params) or (params['deployment_id'] is None):
            raise ValueError("Missing the required parameter `deployment_id` when calling `get_journey_deployment_customer_ping`")
        # verify the required parameter 'customer_cookie_id' is set
        if ('customer_cookie_id' not in params) or (params['customer_cookie_id'] is None):
            raise ValueError("Missing the required parameter `customer_cookie_id` when calling `get_journey_deployment_customer_ping`")


        resource_path = '/api/v2/journey/deployments/{deploymentId}/customers/{customerCookieId}/ping'.replace('{format}', 'json')
        path_params = {}
        if 'deployment_id' in params:
            path_params['deploymentId'] = params['deployment_id']
        if 'customer_cookie_id' in params:
            path_params['customerCookieId'] = params['customer_cookie_id']

        query_params = {}
        if 'dl' in params:
            query_params['dl'] = params['dl']
        if 'dt' in params:
            query_params['dt'] = params['dt']
        if 'app_namespace' in params:
            query_params['appNamespace'] = params['app_namespace']
        if 'session_id' in params:
            query_params['sessionId'] = params['session_id']
        if 'since_last_beacon_milliseconds' in params:
            query_params['sinceLastBeaconMilliseconds'] = params['since_last_beacon_milliseconds']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DeploymentPing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_outcome(self, outcome_id: str, **kwargs) -> 'Outcome':
        """
        Retrieve a single outcome.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_outcome(outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str outcome_id: ID of the outcome. (required)
        :return: Outcome
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['outcome_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_outcome" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'outcome_id' is set
        if ('outcome_id' not in params) or (params['outcome_id'] is None):
            raise ValueError("Missing the required parameter `outcome_id` when calling `get_journey_outcome`")


        resource_path = '/api/v2/journey/outcomes/{outcomeId}'.replace('{format}', 'json')
        path_params = {}
        if 'outcome_id' in params:
            path_params['outcomeId'] = params['outcome_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Outcome',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_outcomes(self, **kwargs) -> 'OutcomeListing':
        """
        Retrieve all outcomes.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_outcomes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Field(s) to sort by. The response can be sorted by any first level property on the Outcome response. Prefix with '-' for descending (e.g. sortBy=displayName,-createdDate).
        :param list[str] outcome_ids: IDs of outcomes to return. Use of this parameter is not compatible with pagination, sorting or querying. A maximum of 20 outcomes are allowed per request.
        :param list[str] query_fields: Outcome field(s) to query on. Requires 'queryValue' to also be set.
        :param str query_value: Value to query on. Requires 'queryFields' to also be set.
        :return: OutcomeListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'outcome_ids', 'query_fields', 'query_value']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_outcomes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/outcomes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'outcome_ids' in params:
            query_params['outcomeIds'] = params['outcome_ids']
        if 'query_fields' in params:
            query_params['queryFields'] = params['query_fields']
        if 'query_value' in params:
            query_params['queryValue'] = params['query_value']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_outcomes_attributions_job(self, job_id: str, **kwargs) -> 'OutcomeAttributionJobStateResponse':
        """
        Get job status.
        
	    get_journey_outcomes_attributions_job is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_outcomes_attributions_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: ID of the job. (required)
        :return: OutcomeAttributionJobStateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_outcomes_attributions_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_journey_outcomes_attributions_job`")


        resource_path = '/api/v2/journey/outcomes/attributions/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeAttributionJobStateResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_outcomes_attributions_job_results(self, job_id: str, **kwargs) -> 'OutcomeAttributionResponseListing':
        """
        Get outcome attribution entities from completed job.
        
	    get_journey_outcomes_attributions_job_results is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_outcomes_attributions_job_results(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: ID of the job. (required)
        :return: OutcomeAttributionResponseListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_outcomes_attributions_job_results" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_journey_outcomes_attributions_job_results`")


        resource_path = '/api/v2/journey/outcomes/attributions/jobs/{jobId}/results'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeAttributionResponseListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_outcomes_predictor(self, predictor_id: str, **kwargs) -> 'OutcomePredictor':
        """
        Retrieve a single outcome predictor.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_outcomes_predictor(predictor_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str predictor_id: ID of predictor (required)
        :return: OutcomePredictor
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['predictor_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_outcomes_predictor" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'predictor_id' is set
        if ('predictor_id' not in params) or (params['predictor_id'] is None):
            raise ValueError("Missing the required parameter `predictor_id` when calling `get_journey_outcomes_predictor`")


        resource_path = '/api/v2/journey/outcomes/predictors/{predictorId}'.replace('{format}', 'json')
        path_params = {}
        if 'predictor_id' in params:
            path_params['predictorId'] = params['predictor_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomePredictor',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_outcomes_predictors(self, **kwargs) -> 'OutcomePredictorListing':
        """
        Retrieve all outcome predictors.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_outcomes_predictors(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: OutcomePredictorListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_outcomes_predictors" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/outcomes/predictors'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomePredictorListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_segment(self, segment_id: str, **kwargs) -> 'JourneySegment':
        """
        Retrieve a single segment.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_segment(segment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str segment_id: ID of the segment. (required)
        :return: JourneySegment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['segment_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_segment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'segment_id' is set
        if ('segment_id' not in params) or (params['segment_id'] is None):
            raise ValueError("Missing the required parameter `segment_id` when calling `get_journey_segment`")


        resource_path = '/api/v2/journey/segments/{segmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'segment_id' in params:
            path_params['segmentId'] = params['segment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneySegment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_segments(self, **kwargs) -> 'SegmentListing':
        """
        Retrieve all segments.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_segments(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sort_by: Field(s) to sort by. The response can be sorted by any first level property on the Outcome response. Prefix with '-' for descending (e.g. sortBy=displayName,-createdDate).
        :param int page_size: Page size
        :param int page_number: Page number
        :param bool is_active: Determines whether or not to show only active segments.
        :param list[str] segment_ids: IDs of segments to return. Use of this parameter is not compatible with pagination, sorting or querying. A maximum of 100 segments are allowed per request.
        :param list[str] query_fields: Segment field(s) to query on. Requires 'queryValue' to also be set.
        :param str query_value: Value to query on. Requires 'queryFields' to also be set.
        :return: SegmentListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sort_by', 'page_size', 'page_number', 'is_active', 'segment_ids', 'query_fields', 'query_value']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_segments" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/segments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'is_active' in params:
            query_params['isActive'] = params['is_active']
        if 'segment_ids' in params:
            query_params['segmentIds'] = params['segment_ids']
        if 'query_fields' in params:
            query_params['queryFields'] = params['query_fields']
        if 'query_value' in params:
            query_params['queryValue'] = params['query_value']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SegmentListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_session(self, session_id: str, **kwargs) -> 'Session':
        """
        Retrieve a single session.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_session(session_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str session_id: ID of the session. (required)
        :return: Session
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['session_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_session" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'session_id' is set
        if ('session_id' not in params) or (params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `get_journey_session`")


        resource_path = '/api/v2/journey/sessions/{sessionId}'.replace('{format}', 'json')
        path_params = {}
        if 'session_id' in params:
            path_params['sessionId'] = params['session_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Session',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_session_events(self, session_id: str, **kwargs) -> 'EventListing':
        """
        Retrieve all events for a given session.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_session_events(session_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str session_id: System-generated UUID that represents the session the event is a part of. (required)
        :param str page_size: Number of entities to return. Maximum of 200.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str event_type: A comma separated list of journey event types to include in the results.
        :return: EventListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['session_id', 'page_size', 'after', 'event_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_session_events" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'session_id' is set
        if ('session_id' not in params) or (params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `get_journey_session_events`")


        resource_path = '/api/v2/journey/sessions/{sessionId}/events'.replace('{format}', 'json')
        path_params = {}
        if 'session_id' in params:
            path_params['sessionId'] = params['session_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'event_type' in params:
            query_params['eventType'] = params['event_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EventListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_session_outcomescores(self, session_id: str, **kwargs) -> 'OutcomeScoresResult':
        """
        Retrieve latest outcome score associated with a session for all outcomes.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_session_outcomescores(session_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str session_id: ID of the session. (required)
        :return: OutcomeScoresResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['session_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_session_outcomescores" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'session_id' is set
        if ('session_id' not in params) or (params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `get_journey_session_outcomescores`")


        resource_path = '/api/v2/journey/sessions/{sessionId}/outcomescores'.replace('{format}', 'json')
        path_params = {}
        if 'session_id' in params:
            path_params['sessionId'] = params['session_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeScoresResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_view(self, view_id: str, **kwargs) -> 'JourneyView':
        """
        Get a Journey View by ID
        returns the latest version

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_view(view_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: viewId (required)
        :return: JourneyView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_view" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_journey_view`")


        resource_path = '/api/v2/journey/views/{viewId}'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyView',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_view_schedules(self, view_id: str, **kwargs) -> 'JourneyViewSchedule':
        """
        Get the Schedule for a JourneyView
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_view_schedules(view_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: Journey View Id (required)
        :return: JourneyViewSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_view_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_journey_view_schedules`")


        resource_path = '/api/v2/journey/views/{viewId}/schedules'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_view_version(self, view_id: str, version_id: str, **kwargs) -> 'JourneyView':
        """
        Get a Journey View by ID and version
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_view_version(view_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: viewId (required)
        :param str version_id: versionId (required)
        :return: JourneyView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'version_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_view_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_journey_view_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_journey_view_version`")


        resource_path = '/api/v2/journey/views/{viewId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyView',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_view_version_chart(self, view_id: str, journey_view_version: str, chart_id: str, **kwargs) -> 'JourneyViewChart':
        """
        Get a Chart by ID
        returns the latest version

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_view_version_chart(view_id, journey_view_version, chart_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: viewId (required)
        :param str journey_view_version: Journey View Version (required)
        :param str chart_id: chartId (required)
        :return: JourneyViewChart
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'journey_view_version', 'chart_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_view_version_chart" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_journey_view_version_chart`")
        # verify the required parameter 'journey_view_version' is set
        if ('journey_view_version' not in params) or (params['journey_view_version'] is None):
            raise ValueError("Missing the required parameter `journey_view_version` when calling `get_journey_view_version_chart`")
        # verify the required parameter 'chart_id' is set
        if ('chart_id' not in params) or (params['chart_id'] is None):
            raise ValueError("Missing the required parameter `chart_id` when calling `get_journey_view_version_chart`")


        resource_path = '/api/v2/journey/views/{viewId}/versions/{journeyViewVersion}/charts/{chartId}'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']
        if 'journey_view_version' in params:
            path_params['journeyViewVersion'] = params['journey_view_version']
        if 'chart_id' in params:
            path_params['chartId'] = params['chart_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewChart',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_view_version_chart_version(self, view_id: str, journey_view_version: str, chart_id: str, chart_version: str, **kwargs) -> 'JourneyViewChart':
        """
        Get a Chart by ID and version
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_view_version_chart_version(view_id, journey_view_version, chart_id, chart_version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: viewId (required)
        :param str journey_view_version: Journey View Version (required)
        :param str chart_id: chartId (required)
        :param str chart_version: chartVersion (required)
        :return: JourneyViewChart
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'journey_view_version', 'chart_id', 'chart_version']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_view_version_chart_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_journey_view_version_chart_version`")
        # verify the required parameter 'journey_view_version' is set
        if ('journey_view_version' not in params) or (params['journey_view_version'] is None):
            raise ValueError("Missing the required parameter `journey_view_version` when calling `get_journey_view_version_chart_version`")
        # verify the required parameter 'chart_id' is set
        if ('chart_id' not in params) or (params['chart_id'] is None):
            raise ValueError("Missing the required parameter `chart_id` when calling `get_journey_view_version_chart_version`")
        # verify the required parameter 'chart_version' is set
        if ('chart_version' not in params) or (params['chart_version'] is None):
            raise ValueError("Missing the required parameter `chart_version` when calling `get_journey_view_version_chart_version`")


        resource_path = '/api/v2/journey/views/{viewId}/versions/{journeyViewVersion}/charts/{chartId}/versions/{chartVersion}'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']
        if 'journey_view_version' in params:
            path_params['journeyViewVersion'] = params['journey_view_version']
        if 'chart_id' in params:
            path_params['chartId'] = params['chart_id']
        if 'chart_version' in params:
            path_params['chartVersion'] = params['chart_version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewChart',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_view_version_job(self, view_id: str, journey_version_id: str, job_id: str, **kwargs) -> 'JourneyViewJob':
        """
        Get the job for a journey view version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_view_version_job(view_id, journey_version_id, job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: Journey View Id (required)
        :param str journey_version_id: Journey View Version (required)
        :param str job_id: JobId (required)
        :return: JourneyViewJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'journey_version_id', 'job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_view_version_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_journey_view_version_job`")
        # verify the required parameter 'journey_version_id' is set
        if ('journey_version_id' not in params) or (params['journey_version_id'] is None):
            raise ValueError("Missing the required parameter `journey_version_id` when calling `get_journey_view_version_job`")
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_journey_view_version_job`")


        resource_path = '/api/v2/journey/views/{viewId}/versions/{journeyVersionId}/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']
        if 'journey_version_id' in params:
            path_params['journeyVersionId'] = params['journey_version_id']
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_view_version_job_results(self, view_id: str, journey_view_version: str, job_id: str, **kwargs) -> 'JourneyViewResult':
        """
        Get the result of a job for a journey view version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_view_version_job_results(view_id, journey_view_version, job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: JourneyViewResult id (required)
        :param str journey_view_version: Journey View Version (required)
        :param str job_id: Id of the executing job (required)
        :return: JourneyViewResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'journey_view_version', 'job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_view_version_job_results" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_journey_view_version_job_results`")
        # verify the required parameter 'journey_view_version' is set
        if ('journey_view_version' not in params) or (params['journey_view_version'] is None):
            raise ValueError("Missing the required parameter `journey_view_version` when calling `get_journey_view_version_job_results`")
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_journey_view_version_job_results`")


        resource_path = '/api/v2/journey/views/{viewId}/versions/{journeyViewVersion}/jobs/{jobId}/results'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']
        if 'journey_view_version' in params:
            path_params['journeyViewVersion'] = params['journey_view_version']
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_view_version_job_results_chart(self, view_id: str, journey_version_id: str, job_id: str, chart_id: str, **kwargs) -> 'JourneyViewChartResult':
        """
        Get the chart result associated with a journey view job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_view_version_job_results_chart(view_id, journey_version_id, job_id, chart_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: Journey View Id (required)
        :param str journey_version_id: Journey View Version (required)
        :param str job_id: JobId (required)
        :param str chart_id: ChartId (required)
        :return: JourneyViewChartResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'journey_version_id', 'job_id', 'chart_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_view_version_job_results_chart" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_journey_view_version_job_results_chart`")
        # verify the required parameter 'journey_version_id' is set
        if ('journey_version_id' not in params) or (params['journey_version_id'] is None):
            raise ValueError("Missing the required parameter `journey_version_id` when calling `get_journey_view_version_job_results_chart`")
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_journey_view_version_job_results_chart`")
        # verify the required parameter 'chart_id' is set
        if ('chart_id' not in params) or (params['chart_id'] is None):
            raise ValueError("Missing the required parameter `chart_id` when calling `get_journey_view_version_job_results_chart`")


        resource_path = '/api/v2/journey/views/{viewId}/versions/{journeyVersionId}/jobs/{jobId}/results/charts/{chartId}'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']
        if 'journey_version_id' in params:
            path_params['journeyVersionId'] = params['journey_version_id']
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']
        if 'chart_id' in params:
            path_params['chartId'] = params['chart_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewChartResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_view_version_jobs_latest(self, view_id: str, journey_version_id: str, **kwargs) -> 'JourneyViewJob':
        """
        Get the latest job of a journey view version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_view_version_jobs_latest(view_id, journey_version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: Journey View Id (required)
        :param str journey_version_id: Journey View Version (required)
        :return: JourneyViewJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'journey_version_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_view_version_jobs_latest" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `get_journey_view_version_jobs_latest`")
        # verify the required parameter 'journey_version_id' is set
        if ('journey_version_id' not in params) or (params['journey_version_id'] is None):
            raise ValueError("Missing the required parameter `journey_version_id` when calling `get_journey_view_version_jobs_latest`")


        resource_path = '/api/v2/journey/views/{viewId}/versions/{journeyVersionId}/jobs/latest'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']
        if 'journey_version_id' in params:
            path_params['journeyVersionId'] = params['journey_version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_views(self, **kwargs) -> 'JourneyViewListing':
        """
        Get a list of Journey Views
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_views(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str name_or_created_by: Journey View Name or Created By
        :param str expand: Parameter to request additional data to return in Journey payload
        :param str id: Parameter to request a list of Journey Views by id, separated by commas. Limit of 100 items.
        :return: JourneyViewListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'name_or_created_by', 'expand', 'id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_views" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/views'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'name_or_created_by' in params:
            query_params['nameOrCreatedBy'] = params['name_or_created_by']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_views_data_details(self, **kwargs) -> 'DataRange':
        """
        Get details about the data available for journey queries including oldest and newest event dates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_views_data_details(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DataRange
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_views_data_details" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/views/data/details'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataRange',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_views_eventdefinition(self, event_definition_id: str, **kwargs) -> 'JourneyEventDefinition':
        """
        Get an Event Definition
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_views_eventdefinition(event_definition_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str event_definition_id: Event Definition ID (required)
        :return: JourneyEventDefinition
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_definition_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_views_eventdefinition" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'event_definition_id' is set
        if ('event_definition_id' not in params) or (params['event_definition_id'] is None):
            raise ValueError("Missing the required parameter `event_definition_id` when calling `get_journey_views_eventdefinition`")


        resource_path = '/api/v2/journey/views/eventdefinitions/{eventDefinitionId}'.replace('{format}', 'json')
        path_params = {}
        if 'event_definition_id' in params:
            path_params['eventDefinitionId'] = params['event_definition_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyEventDefinition',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_views_eventdefinitions(self, **kwargs) -> 'JourneyEventDefinitionListing':
        """
        Get a list of Event Definitions
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_views_eventdefinitions(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: JourneyEventDefinitionListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_views_eventdefinitions" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/views/eventdefinitions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyEventDefinitionListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_views_jobs(self, **kwargs) -> 'JourneyViewJobListing':
        """
        Get the jobs for an organization.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_views_jobs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: The number of the page to return
        :param int page_size: Max number of entities to return
        :param str interval: An absolute timeframe for filtering the jobs, expressed as an ISO 8601 interval.
        :param str statuses: Job statuses to filter for
        :return: JourneyViewJobListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'interval', 'statuses']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_views_jobs" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/views/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'interval' in params:
            query_params['interval'] = params['interval']
        if 'statuses' in params:
            query_params['statuses'] = params['statuses']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewJobListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_journey_views_schedules(self, **kwargs) -> 'JourneyViewScheduleListing':
        """
        Get the journey schedules for an organization.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_journey_views_schedules(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: The number of the page to return
        :param int page_size: Max number of entities to return
        :return: JourneyViewScheduleListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_journey_views_schedules" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/views/schedules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewScheduleListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_journey_actionmap(self, action_map_id: str, **kwargs) -> 'ActionMap':
        """
        Update single action map.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_journey_actionmap(action_map_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_map_id: ID of the action map. (required)
        :param PatchActionMap body: 
        :return: ActionMap
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_map_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_journey_actionmap" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_map_id' is set
        if ('action_map_id' not in params) or (params['action_map_id'] is None):
            raise ValueError("Missing the required parameter `action_map_id` when calling `patch_journey_actionmap`")


        resource_path = '/api/v2/journey/actionmaps/{actionMapId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_map_id' in params:
            path_params['actionMapId'] = params['action_map_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionMap',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_journey_actiontarget(self, action_target_id: str, **kwargs) -> 'ActionTarget':
        """
        Update a single action target.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_journey_actiontarget(action_target_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_target_id: ID of the action target. (required)
        :param PatchActionTarget body: 
        :return: ActionTarget
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_target_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_journey_actiontarget" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_target_id' is set
        if ('action_target_id' not in params) or (params['action_target_id'] is None):
            raise ValueError("Missing the required parameter `action_target_id` when calling `patch_journey_actiontarget`")


        resource_path = '/api/v2/journey/actiontargets/{actionTargetId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_target_id' in params:
            path_params['actionTargetId'] = params['action_target_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTarget',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_journey_actiontemplate(self, action_template_id: str, **kwargs) -> 'ActionTemplate':
        """
        Update a single action template.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_journey_actiontemplate(action_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str action_template_id: ID of the action template. (required)
        :param PatchActionTemplate body: 
        :return: ActionTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action_template_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_journey_actiontemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'action_template_id' is set
        if ('action_template_id' not in params) or (params['action_template_id'] is None):
            raise ValueError("Missing the required parameter `action_template_id` when calling `patch_journey_actiontemplate`")


        resource_path = '/api/v2/journey/actiontemplates/{actionTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'action_template_id' in params:
            path_params['actionTemplateId'] = params['action_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_journey_outcome(self, outcome_id: str, **kwargs) -> 'Outcome':
        """
        Update an outcome.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_journey_outcome(outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str outcome_id: ID of the outcome. (required)
        :param PatchOutcome body: 
        :return: Outcome
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['outcome_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_journey_outcome" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'outcome_id' is set
        if ('outcome_id' not in params) or (params['outcome_id'] is None):
            raise ValueError("Missing the required parameter `outcome_id` when calling `patch_journey_outcome`")


        resource_path = '/api/v2/journey/outcomes/{outcomeId}'.replace('{format}', 'json')
        path_params = {}
        if 'outcome_id' in params:
            path_params['outcomeId'] = params['outcome_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Outcome',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_journey_segment(self, segment_id: str, **kwargs) -> 'JourneySegment':
        """
        Update a segment.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_journey_segment(segment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str segment_id: ID of the segment. (required)
        :param PatchSegment body: 
        :return: JourneySegment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['segment_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_journey_segment" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'segment_id' is set
        if ('segment_id' not in params) or (params['segment_id'] is None):
            raise ValueError("Missing the required parameter `segment_id` when calling `patch_journey_segment`")


        resource_path = '/api/v2/journey/segments/{segmentId}'.replace('{format}', 'json')
        path_params = {}
        if 'segment_id' in params:
            path_params['segmentId'] = params['segment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneySegment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_journey_view_version_job(self, view_id: str, journey_version_id: str, job_id: str, body: 'JourneyViewJob', **kwargs) -> 'JourneyViewJob':
        """
        Update the job for a journey view version. Only the status can be changed and only to Cancelled
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_journey_view_version_job(view_id, journey_version_id, job_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: Journey View Id (required)
        :param str journey_version_id: Journey View Version (required)
        :param str job_id: JobId (required)
        :param JourneyViewJob body: journeyViewJob (required)
        :return: JourneyViewJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'journey_version_id', 'job_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_journey_view_version_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `patch_journey_view_version_job`")
        # verify the required parameter 'journey_version_id' is set
        if ('journey_version_id' not in params) or (params['journey_version_id'] is None):
            raise ValueError("Missing the required parameter `journey_version_id` when calling `patch_journey_view_version_job`")
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `patch_journey_view_version_job`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_journey_view_version_job`")


        resource_path = '/api/v2/journey/views/{viewId}/versions/{journeyVersionId}/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']
        if 'journey_version_id' in params:
            path_params['journeyVersionId'] = params['journey_version_id']
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_analytics_journeys_aggregates_jobs(self, body: 'JourneyAsyncAggregationQuery', **kwargs) -> 'AsyncQueryResponse':
        """
        Query for journey aggregates asynchronously
        
	    post_analytics_journeys_aggregates_jobs is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_analytics_journeys_aggregates_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param JourneyAsyncAggregationQuery body: query (required)
        :return: AsyncQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_analytics_journeys_aggregates_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_analytics_journeys_aggregates_jobs`")


        resource_path = '/api/v2/analytics/journeys/aggregates/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AsyncQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_analytics_journeys_aggregates_query(self, body: 'JourneyAggregationQuery', **kwargs) -> 'JourneyAggregateQueryResponse':
        """
        Query for journey aggregates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_analytics_journeys_aggregates_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param JourneyAggregationQuery body: query (required)
        :return: JourneyAggregateQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_analytics_journeys_aggregates_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_analytics_journeys_aggregates_query`")


        resource_path = '/api/v2/analytics/journeys/aggregates/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyAggregateQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_actionmaps(self, **kwargs) -> 'ActionMap':
        """
        Create an action map.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_actionmaps(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ActionMap body: 
        :return: ActionMap
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_actionmaps" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/actionmaps'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionMap',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_actionmaps_estimates_jobs(self, body: 'ActionMapEstimateRequest', **kwargs) -> 'EstimateJobAsyncResponse':
        """
        Query for estimates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_actionmaps_estimates_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ActionMapEstimateRequest body: audience estimator request (required)
        :return: EstimateJobAsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_actionmaps_estimates_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_journey_actionmaps_estimates_jobs`")


        resource_path = '/api/v2/journey/actionmaps/estimates/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EstimateJobAsyncResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_actiontemplates(self, **kwargs) -> 'ActionTemplate':
        """
        Create a single action template.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_actiontemplates(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ActionTemplate body: 
        :return: ActionTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_actiontemplates" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/actiontemplates'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ActionTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_deployment_actionevent(self, deployment_id: str, body: 'ActionEventRequest', **kwargs) -> None:
        """
        Sends an action event, which is used for changing the state of actions that have been offered to the user.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_deployment_actionevent(deployment_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str deployment_id: The ID of the deployment sending the beacon. (required)
        :param ActionEventRequest body:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['deployment_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_deployment_actionevent" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'deployment_id' is set
        if ('deployment_id' not in params) or (params['deployment_id'] is None):
            raise ValueError("Missing the required parameter `deployment_id` when calling `post_journey_deployment_actionevent`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_journey_deployment_actionevent`")


        resource_path = '/api/v2/journey/deployments/{deploymentId}/actionevent'.replace('{format}', 'json')
        path_params = {}
        if 'deployment_id' in params:
            path_params['deploymentId'] = params['deployment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_deployment_appevents(self, deployment_id: str, **kwargs) -> 'AppEventResponse':
        """
        Send a journey app event, used for tracking customer activity on an application.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_deployment_appevents(deployment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str deployment_id: The ID of the deployment sending the app event. (required)
        :param AppEventRequest body: 
        :return: AppEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['deployment_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_deployment_appevents" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'deployment_id' is set
        if ('deployment_id' not in params) or (params['deployment_id'] is None):
            raise ValueError("Missing the required parameter `deployment_id` when calling `post_journey_deployment_appevents`")


        resource_path = '/api/v2/journey/deployments/{deploymentId}/appevents'.replace('{format}', 'json')
        path_params = {}
        if 'deployment_id' in params:
            path_params['deploymentId'] = params['deployment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AppEventResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_deployment_webevents(self, deployment_id: str, **kwargs) -> 'WebEventResponse':
        """
        Send a journey web event, used for tracking customer activity on a website.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_deployment_webevents(deployment_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str deployment_id: The ID of the deployment sending the web event. (required)
        :param WebEventRequest body: 
        :return: WebEventResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['deployment_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_deployment_webevents" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'deployment_id' is set
        if ('deployment_id' not in params) or (params['deployment_id'] is None):
            raise ValueError("Missing the required parameter `deployment_id` when calling `post_journey_deployment_webevents`")


        resource_path = '/api/v2/journey/deployments/{deploymentId}/webevents'.replace('{format}', 'json')
        path_params = {}
        if 'deployment_id' in params:
            path_params['deploymentId'] = params['deployment_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = []

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WebEventResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_flows_paths_query(self, **kwargs) -> 'FlowPaths':
        """
        Query for flow paths.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_flows_paths_query(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FlowPathsQuery body: 
        :return: FlowPaths
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_flows_paths_query" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/flows/paths/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowPaths',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_outcomes(self, **kwargs) -> 'Outcome':
        """
        Create an outcome.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_outcomes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param OutcomeRequest body: 
        :return: Outcome
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_outcomes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/outcomes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Outcome',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_outcomes_attributions_jobs(self, **kwargs) -> 'OutcomeAttributionAsyncResponse':
        """
        Create Outcome Attributions
        
	    post_journey_outcomes_attributions_jobs is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_outcomes_attributions_jobs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param OutcomeAttributionListing body: outcome attribution request
        :return: OutcomeAttributionAsyncResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_outcomes_attributions_jobs" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/outcomes/attributions/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomeAttributionAsyncResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_outcomes_predictors(self, **kwargs) -> 'OutcomePredictor':
        """
        Create an outcome predictor.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_outcomes_predictors(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param OutcomePredictorRequest body: 
        :return: OutcomePredictor
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_outcomes_predictors" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/outcomes/predictors'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutcomePredictor',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_segments(self, **kwargs) -> 'JourneySegment':
        """
        Create a segment.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_segments(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param JourneySegmentRequest body: 
        :return: JourneySegment
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_segments" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/segments'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneySegment',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_view_schedules(self, view_id: str, body: 'JourneyViewSchedule', **kwargs) -> 'JourneyViewSchedule':
        """
        Add a new Schedule to a JourneyView
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_view_schedules(view_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: Journey View Id (required)
        :param JourneyViewSchedule body: journeyViewSchedule (required)
        :return: JourneyViewSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_view_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `post_journey_view_schedules`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_journey_view_schedules`")


        resource_path = '/api/v2/journey/views/{viewId}/schedules'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_view_version_jobs(self, view_id: str, journey_version_id: str, **kwargs) -> 'JourneyViewJob':
        """
        Submit a job request for a journey view version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_view_version_jobs(view_id, journey_version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: Journey View Id (required)
        :param str journey_version_id: Journey View Version (required)
        :return: JourneyViewJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'journey_version_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_view_version_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `post_journey_view_version_jobs`")
        # verify the required parameter 'journey_version_id' is set
        if ('journey_version_id' not in params) or (params['journey_version_id'] is None):
            raise ValueError("Missing the required parameter `journey_version_id` when calling `post_journey_view_version_jobs`")


        resource_path = '/api/v2/journey/views/{viewId}/versions/{journeyVersionId}/jobs'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']
        if 'journey_version_id' in params:
            path_params['journeyVersionId'] = params['journey_version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_view_versions(self, view_id: str, body: 'JourneyView', **kwargs) -> 'JourneyView':
        """
        Update a Journey View by ID
        creates a new version

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_view_versions(view_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: viewId (required)
        :param JourneyView body: JourneyView (required)
        :return: JourneyView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_view_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `post_journey_view_versions`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_journey_view_versions`")


        resource_path = '/api/v2/journey/views/{viewId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyView',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_views(self, body: 'JourneyView', **kwargs) -> 'JourneyView':
        """
        Create a new Journey View
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_views(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param JourneyView body: JourneyView (required)
        :return: JourneyView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_views" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_journey_views`")


        resource_path = '/api/v2/journey/views'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyView',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_journey_views_encodings_validate(self, **kwargs) -> 'EntityListing':
        """
        Validate whether an encoding exist for a label/value combination.
        True indicates a valid encoding

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_journey_views_encodings_validate(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[Label] body: 
        :return: EntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_journey_views_encodings_validate" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/journey/views/encodings/validate'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_journey_view_schedules(self, view_id: str, body: 'JourneyViewSchedule', **kwargs) -> 'JourneyViewSchedule':
        """
        Update the Schedule for a JourneyView
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_journey_view_schedules(view_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: Journey View Id (required)
        :param JourneyViewSchedule body: journeyViewSchedule (required)
        :return: JourneyViewSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_journey_view_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `put_journey_view_schedules`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_journey_view_schedules`")


        resource_path = '/api/v2/journey/views/{viewId}/schedules'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyViewSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_journey_view_version(self, view_id: str, version_id: str, body: 'JourneyView', **kwargs) -> 'JourneyView':
        """
        Update a Journey View by ID and version
        does not create a new version

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_journey_view_version(view_id, version_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str view_id: viewId (required)
        :param str version_id: versionId (required)
        :param JourneyView body: JourneyView (required)
        :return: JourneyView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['view_id', 'version_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_journey_view_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'view_id' is set
        if ('view_id' not in params) or (params['view_id'] is None):
            raise ValueError("Missing the required parameter `view_id` when calling `put_journey_view_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `put_journey_view_version`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_journey_view_version`")


        resource_path = '/api/v2/journey/views/{viewId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'view_id' in params:
            path_params['viewId'] = params['view_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JourneyView',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
