# coding: utf-8

"""
GeneralDataProtectionRegulationApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import ErrorBody
from ..models import GDPRRequest
from ..models import GDPRRequestEntityListing
from ..models import GDPRSubjectEntityListing

class GeneralDataProtectionRegulationApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_gdpr_request(self, request_id: str, **kwargs) -> 'GDPRRequest':
        """
        Get an existing GDPR request
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gdpr_request(request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str request_id: Request id (required)
        :return: GDPRRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gdpr_request" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'request_id' is set
        if ('request_id' not in params) or (params['request_id'] is None):
            raise ValueError("Missing the required parameter `request_id` when calling `get_gdpr_request`")


        resource_path = '/api/v2/gdpr/requests/{requestId}'.replace('{format}', 'json')
        path_params = {}
        if 'request_id' in params:
            path_params['requestId'] = params['request_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GDPRRequest',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gdpr_requests(self, **kwargs) -> 'GDPRRequestEntityListing':
        """
        Get all GDPR requests
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gdpr_requests(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: GDPRRequestEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gdpr_requests" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/gdpr/requests'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GDPRRequestEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_gdpr_subjects(self, search_type: str, search_value: str, **kwargs) -> 'GDPRSubjectEntityListing':
        """
        Get GDPR subjects
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_gdpr_subjects(search_type, search_value, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str search_type: Search Type (required)
        :param str search_value: Search Value (required)
        :return: GDPRSubjectEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['search_type', 'search_value']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gdpr_subjects" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'search_type' is set
        if ('search_type' not in params) or (params['search_type'] is None):
            raise ValueError("Missing the required parameter `search_type` when calling `get_gdpr_subjects`")
        # verify the required parameter 'search_value' is set
        if ('search_value' not in params) or (params['search_value'] is None):
            raise ValueError("Missing the required parameter `search_value` when calling `get_gdpr_subjects`")


        resource_path = '/api/v2/gdpr/subjects'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'search_type' in params:
            query_params['searchType'] = params['search_type']
        if 'search_value' in params:
            query_params['searchValue'] = params['search_value']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GDPRSubjectEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_gdpr_requests(self, body: 'GDPRRequest', **kwargs) -> 'GDPRRequest':
        """
        Submit a new GDPR request
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_gdpr_requests(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param GDPRRequest body: GDPR request (required)
        :param bool delete_confirmed: Confirm delete
        :return: GDPRRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'delete_confirmed']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_gdpr_requests" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_gdpr_requests`")


        resource_path = '/api/v2/gdpr/requests'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'delete_confirmed' in params:
            query_params['deleteConfirmed'] = params['delete_confirmed']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GDPRRequest',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
