# coding: utf-8

"""
ExternalContactsApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import BulkContactsEnrichRequest
from ..models import BulkContactsEnrichResponse
from ..models import BulkContactsRequest
from ..models import BulkContactsResponse
from ..models import BulkDeleteResponse
from ..models import BulkFetchContactsResponse
from ..models import BulkFetchNotesResponse
from ..models import BulkFetchOrganizationsResponse
from ..models import BulkFetchRelationshipsResponse
from ..models import BulkIdsRequest
from ..models import BulkNotesRequest
from ..models import BulkNotesResponse
from ..models import BulkOrganizationsEnrichRequest
from ..models import BulkOrganizationsEnrichResponse
from ..models import BulkOrganizationsRequest
from ..models import BulkOrganizationsResponse
from ..models import BulkRelationshipsRequest
from ..models import BulkRelationshipsResponse
from ..models import ContactEnrichRequest
from ..models import ContactIdentifier
from ..models import ContactIdentifierListing
from ..models import ContactImportJobEntityListing
from ..models import ContactImportJobRequest
from ..models import ContactImportJobResponse
from ..models import ContactImportJobStatusUpdateRequest
from ..models import ContactImportJobStatusUpdateResponse
from ..models import ContactImportSettings
from ..models import ContactImportSettingsEntityListing
from ..models import ContactListing
from ..models import ContactsExport
from ..models import ConversationAssociation
from ..models import Coretype
from ..models import CsvJobRequest
from ..models import CsvJobResponse
from ..models import CsvSettings
from ..models import CsvUploadDetailsResponse
from ..models import CsvUploadPreviewResponse
from ..models import CsvUploadRequest
from ..models import CsvUploadResponse
from ..models import CursorContactListing
from ..models import CursorExternalSourceListing
from ..models import CursorNoteListing
from ..models import CursorOrganizationListing
from ..models import CursorRelationshipListing
from ..models import DataSchema
from ..models import DataSchemaListing
from ..models import ErrorBody
from ..models import ErrorInfo
from ..models import ExportListing
from ..models import ExternalContact
from ..models import ExternalOrganization
from ..models import ExternalOrganizationEnrichRequest
from ..models import ExternalOrganizationIdentifier
from ..models import ExternalOrganizationIdentifierClaimRequest
from ..models import ExternalOrganizationIdentifierListing
from ..models import ExternalOrganizationListing
from ..models import ExternalOrganizationTrustorLink
from ..models import ExternalSource
from ..models import IdentifierClaimRequest
from ..models import Listing
from ..models import MergeContactsRequest
from ..models import MergeRequest
from ..models import Note
from ..models import NoteListing
from ..models import Relationship
from ..models import RelationshipListing
from ..models import ReverseWhitepagesLookupResult
from ..models import SchemaQuantityLimits
from ..models import SessionListing

class ExternalContactsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_externalcontacts_contact(self, contact_id: str, **kwargs) -> object:
        """
        Delete an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_contact(contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact ID (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_contact" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `delete_externalcontacts_contact`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_contact_note(self, contact_id: str, note_id: str, **kwargs) -> object:
        """
        Delete a note for an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_contact_note(contact_id, note_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact Id (required)
        :param str note_id: Note Id (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'note_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_contact_note" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `delete_externalcontacts_contact_note`")
        # verify the required parameter 'note_id' is set
        if ('note_id' not in params) or (params['note_id'] is None):
            raise ValueError("Missing the required parameter `note_id` when calling `delete_externalcontacts_contact_note`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/notes/{noteId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']
        if 'note_id' in params:
            path_params['noteId'] = params['note_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_contacts_schema(self, schema_id: str, **kwargs) -> None:
        """
        Delete a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_contacts_schema(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_contacts_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `delete_externalcontacts_contacts_schema`")


        resource_path = '/api/v2/externalcontacts/contacts/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_externalsource(self, external_source_id: str, **kwargs) -> object:
        """
        Delete an External Source. WARNING: Any records that reference this External Source will not be automatically cleaned up. Those records will still be editable, but their External IDs may not be fully viewable.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_externalsource(external_source_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_source_id: External Source ID (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_source_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_externalsource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_source_id' is set
        if ('external_source_id' not in params) or (params['external_source_id'] is None):
            raise ValueError("Missing the required parameter `external_source_id` when calling `delete_externalcontacts_externalsource`")


        resource_path = '/api/v2/externalcontacts/externalsources/{externalSourceId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_source_id' in params:
            path_params['externalSourceId'] = params['external_source_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_import_csv_setting(self, settings_id: str, **kwargs) -> None:
        """
        Delete settings for CSV import
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_import_csv_setting(settings_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str settings_id: Settings id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_import_csv_setting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'settings_id' is set
        if ('settings_id' not in params) or (params['settings_id'] is None):
            raise ValueError("Missing the required parameter `settings_id` when calling `delete_externalcontacts_import_csv_setting`")


        resource_path = '/api/v2/externalcontacts/import/csv/settings/{settingsId}'.replace('{format}', 'json')
        path_params = {}
        if 'settings_id' in params:
            path_params['settingsId'] = params['settings_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_import_setting(self, settings_id: str, **kwargs) -> None:
        """
        Delete Settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_import_setting(settings_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str settings_id: Settings id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_import_setting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'settings_id' is set
        if ('settings_id' not in params) or (params['settings_id'] is None):
            raise ValueError("Missing the required parameter `settings_id` when calling `delete_externalcontacts_import_setting`")


        resource_path = '/api/v2/externalcontacts/import/settings/{settingsId}'.replace('{format}', 'json')
        path_params = {}
        if 'settings_id' in params:
            path_params['settingsId'] = params['settings_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_organization(self, external_organization_id: str, **kwargs) -> object:
        """
        Delete an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_organization(external_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_organization" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `delete_externalcontacts_organization`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_organization_note(self, external_organization_id: str, note_id: str, **kwargs) -> object:
        """
        Delete a note for an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_organization_note(external_organization_id, note_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization Id (required)
        :param str note_id: Note Id (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'note_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_organization_note" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `delete_externalcontacts_organization_note`")
        # verify the required parameter 'note_id' is set
        if ('note_id' not in params) or (params['note_id'] is None):
            raise ValueError("Missing the required parameter `note_id` when calling `delete_externalcontacts_organization_note`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/notes/{noteId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']
        if 'note_id' in params:
            path_params['noteId'] = params['note_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_organization_trustor(self, external_organization_id: str, **kwargs) -> None:
        """
        Unlink the Trustor for this External Organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_organization_trustor(external_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_organization_trustor" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `delete_externalcontacts_organization_trustor`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/trustor'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_externalcontacts_relationship(self, relationship_id: str, **kwargs) -> object:
        """
        Delete a relationship
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_externalcontacts_relationship(relationship_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str relationship_id: Relationship Id (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['relationship_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_externalcontacts_relationship" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'relationship_id' is set
        if ('relationship_id' not in params) or (params['relationship_id'] is None):
            raise ValueError("Missing the required parameter `relationship_id` when calling `delete_externalcontacts_relationship`")


        resource_path = '/api/v2/externalcontacts/relationships/{relationshipId}'.replace('{format}', 'json')
        path_params = {}
        if 'relationship_id' in params:
            path_params['relationshipId'] = params['relationship_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contact(self, contact_id: str, **kwargs) -> 'ExternalContact':
        """
        Fetch an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contact(contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact ID (required)
        :param list[str] expand: which fields, if any, to expand
        :return: ExternalContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contact" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `get_externalcontacts_contact`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contact_identifiers(self, contact_id: str, **kwargs) -> 'ContactIdentifierListing':
        """
        List the identifiers for a contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contact_identifiers(contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact ID (required)
        :return: ContactIdentifierListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contact_identifiers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `get_externalcontacts_contact_identifiers`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/identifiers'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactIdentifierListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contact_journey_sessions(self, contact_id: str, **kwargs) -> 'SessionListing':
        """
        Retrieve all sessions for a given external contact.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contact_journey_sessions(contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact ID (required)
        :param str page_size: Number of entities to return. Maximum of 200.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param bool include_merged: Indicates whether to return sessions from all external contacts in the merge-set of the given one.
        :return: SessionListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'page_size', 'after', 'include_merged']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contact_journey_sessions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `get_externalcontacts_contact_journey_sessions`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/journey/sessions'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'include_merged' in params:
            query_params['includeMerged'] = params['include_merged']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SessionListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contact_note(self, contact_id: str, note_id: str, **kwargs) -> 'Note':
        """
        Fetch a note for an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contact_note(contact_id, note_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact Id (required)
        :param str note_id: Note Id (required)
        :param list[str] expand: which fields, if any, to expand
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'note_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contact_note" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `get_externalcontacts_contact_note`")
        # verify the required parameter 'note_id' is set
        if ('note_id' not in params) or (params['note_id'] is None):
            raise ValueError("Missing the required parameter `note_id` when calling `get_externalcontacts_contact_note`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/notes/{noteId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']
        if 'note_id' in params:
            path_params['noteId'] = params['note_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Note',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contact_notes(self, contact_id: str, **kwargs) -> 'NoteListing':
        """
        List notes for an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contact_notes(contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact Id (required)
        :param int page_size: Page size (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param int page_number: Page number (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param str sort_order: The Note field to sort by. Any of: [createDate]. Direction: [asc, desc].  e.g. \"createDate:asc\", \"createDate:desc\"
        :param list[str] expand: which fields, if any, to expand
        :return: NoteListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'page_size', 'page_number', 'sort_order', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contact_notes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `get_externalcontacts_contact_notes`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/notes'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NoteListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contact_unresolved(self, contact_id: str, **kwargs) -> 'ExternalContact':
        """
        Fetch an unresolved external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contact_unresolved(contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact ID (required)
        :param list[str] expand: which fields, if any, to expand
        :return: ExternalContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contact_unresolved" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `get_externalcontacts_contact_unresolved`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/unresolved'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts(self, **kwargs) -> 'ContactListing':
        """
        Search for external contacts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param int page_number: Page number (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param str q: User supplied search keywords (no special syntax is currently supported)
        :param str sort_order: The External Contact field to sort by. Any of: [firstName, lastName, middleName, title]. Direction: [asc, desc]. e.g. \"firstName:asc\", \"title:desc\"
        :param list[str] expand: which fields, if any, to expand
        :param list[str] division_ids: which divisions to search, up to 50
        :return: ContactListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'q', 'sort_order', 'expand', 'division_ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/contacts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'q' in params:
            query_params['q'] = params['q']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'division_ids' in params:
            query_params['divisionIds'] = params['division_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts_export(self, export_id: str, **kwargs) -> 'ContactsExport':
        """
        Get export for exportId
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts_export(export_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str export_id: Export id (required)
        :return: ContactsExport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['export_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts_export" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'export_id' is set
        if ('export_id' not in params) or (params['export_id'] is None):
            raise ValueError("Missing the required parameter `export_id` when calling `get_externalcontacts_contacts_export`")


        resource_path = '/api/v2/externalcontacts/contacts/exports/{exportId}'.replace('{format}', 'json')
        path_params = {}
        if 'export_id' in params:
            path_params['exportId'] = params['export_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactsExport',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts_exports(self, **kwargs) -> 'ExportListing':
        """
        List exports for organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts_exports(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] division_ids: Division IDs of entities
        :param str after: The cursor that points to the end of the set of entities
        :param int page_size: Number of entities to return
        :return: ExportListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['division_ids', 'after', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts_exports" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/contacts/exports'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'division_ids' in params:
            query_params['divisionIds'] = params['division_ids']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExportListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts_schema(self, schema_id: str, **kwargs) -> 'DataSchema':
        """
        Get a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts_schema(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_externalcontacts_contacts_schema`")


        resource_path = '/api/v2/externalcontacts/contacts/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts_schema_version(self, schema_id: str, version_id: str, **kwargs) -> 'DataSchema':
        """
        Get a specific version of a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts_schema_version(schema_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :param str version_id: Schema version (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id', 'version_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts_schema_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_externalcontacts_contacts_schema_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_externalcontacts_contacts_schema_version`")


        resource_path = '/api/v2/externalcontacts/contacts/schemas/{schemaId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts_schema_versions(self, schema_id: str, **kwargs) -> 'DataSchema':
        """
        Get all versions of an external contact's schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts_schema_versions(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts_schema_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_externalcontacts_contacts_schema_versions`")


        resource_path = '/api/v2/externalcontacts/contacts/schemas/{schemaId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts_schemas(self, **kwargs) -> 'DataSchemaListing':
        """
        Get a list of schemas.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts_schemas(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DataSchemaListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts_schemas" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/contacts/schemas'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchemaListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts_schemas_coretype(self, core_type_name: str, **kwargs) -> 'Coretype':
        """
        Get the core types from which all schemas are built.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts_schemas_coretype(core_type_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str core_type_name: Name of the core type (required)
        :return: Coretype
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['core_type_name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts_schemas_coretype" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'core_type_name' is set
        if ('core_type_name' not in params) or (params['core_type_name'] is None):
            raise ValueError("Missing the required parameter `core_type_name` when calling `get_externalcontacts_contacts_schemas_coretype`")


        resource_path = '/api/v2/externalcontacts/contacts/schemas/coretypes/{coreTypeName}'.replace('{format}', 'json')
        path_params = {}
        if 'core_type_name' in params:
            path_params['coreTypeName'] = params['core_type_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Coretype',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts_schemas_coretypes(self, **kwargs) -> 'Coretype':
        """
        Get the core types from which all schemas are built.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts_schemas_coretypes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: Coretype
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts_schemas_coretypes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/contacts/schemas/coretypes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Coretype',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_contacts_schemas_limits(self, **kwargs) -> 'SchemaQuantityLimits':
        """
        Get quantitative limits on schemas
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_contacts_schemas_limits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SchemaQuantityLimits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_contacts_schemas_limits" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/contacts/schemas/limits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SchemaQuantityLimits',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_externalsource(self, external_source_id: str, **kwargs) -> 'ExternalSource':
        """
        Fetch an External Source
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_externalsource(external_source_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_source_id: External Source ID (required)
        :return: ExternalSource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_source_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_externalsource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_source_id' is set
        if ('external_source_id' not in params) or (params['external_source_id'] is None):
            raise ValueError("Missing the required parameter `external_source_id` when calling `get_externalcontacts_externalsource`")


        resource_path = '/api/v2/externalcontacts/externalsources/{externalSourceId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_source_id' in params:
            path_params['externalSourceId'] = params['external_source_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalSource',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_externalsources(self, **kwargs) -> 'CursorExternalSourceListing':
        """
        Fetch a list of External Sources
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_externalsources(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str cursor: Indicates where to resume query results (not required for first page), each page returns a new cursor with a 24h TTL
        :param int limit: The number of ExternalSources per page; must be between 10 and 200, default is 100
        :param str name: Filter by external source name. Filtering is prefix filtering and not an exact match
        :param bool active: Filter by active status of external source
        :return: CursorExternalSourceListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['cursor', 'limit', 'name', 'active']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_externalsources" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/externalsources'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'active' in params:
            query_params['active'] = params['active']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CursorExternalSourceListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_import_csv_setting(self, settings_id: str, **kwargs) -> 'CsvSettings':
        """
        Get settings for CSV import
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_import_csv_setting(settings_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str settings_id: Settings id (required)
        :return: CsvSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_import_csv_setting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'settings_id' is set
        if ('settings_id' not in params) or (params['settings_id'] is None):
            raise ValueError("Missing the required parameter `settings_id` when calling `get_externalcontacts_import_csv_setting`")


        resource_path = '/api/v2/externalcontacts/import/csv/settings/{settingsId}'.replace('{format}', 'json')
        path_params = {}
        if 'settings_id' in params:
            path_params['settingsId'] = params['settings_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CsvSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_import_csv_settings(self, **kwargs) -> 'Listing':
        """
        Retrieve all settings for organization filtered by externalSettingsId if provided
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_import_csv_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str page_size: Number of entities to return. Maximum of 200.
        :param str external_settings_id: External Settings Id to filter the list.
        :return: Listing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['after', 'page_size', 'external_settings_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_import_csv_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/import/csv/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'external_settings_id' in params:
            query_params['externalSettingsId'] = params['external_settings_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Listing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_import_csv_upload_details(self, upload_id: str, **kwargs) -> 'CsvUploadDetailsResponse':
        """
        Get details for CSV upload
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_import_csv_upload_details(upload_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str upload_id: Upload id (required)
        :return: CsvUploadDetailsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['upload_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_import_csv_upload_details" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'upload_id' is set
        if ('upload_id' not in params) or (params['upload_id'] is None):
            raise ValueError("Missing the required parameter `upload_id` when calling `get_externalcontacts_import_csv_upload_details`")


        resource_path = '/api/v2/externalcontacts/import/csv/uploads/{uploadId}/details'.replace('{format}', 'json')
        path_params = {}
        if 'upload_id' in params:
            path_params['uploadId'] = params['upload_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CsvUploadDetailsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_import_csv_upload_preview(self, upload_id: str, **kwargs) -> 'CsvUploadPreviewResponse':
        """
        Get preview for CSV upload
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_import_csv_upload_preview(upload_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str upload_id: Upload id (required)
        :return: CsvUploadPreviewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['upload_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_import_csv_upload_preview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'upload_id' is set
        if ('upload_id' not in params) or (params['upload_id'] is None):
            raise ValueError("Missing the required parameter `upload_id` when calling `get_externalcontacts_import_csv_upload_preview`")


        resource_path = '/api/v2/externalcontacts/import/csv/uploads/{uploadId}/preview'.replace('{format}', 'json')
        path_params = {}
        if 'upload_id' in params:
            path_params['uploadId'] = params['upload_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CsvUploadPreviewResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_import_job(self, job_id: str, **kwargs) -> 'ContactImportJobResponse':
        """
        Get job based on id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_import_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: Job id (required)
        :param list[str] expand: which fields, if any, to expand
        :return: ContactImportJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_import_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_externalcontacts_import_job`")


        resource_path = '/api/v2/externalcontacts/import/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactImportJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_import_jobs(self, **kwargs) -> 'ContactImportJobEntityListing':
        """
        List jobs for organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_import_jobs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] expand: which fields, if any, to expand
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str page_size: Number of entities to return. Maximum of 100.
        :param str sort_order: Direction of sorting.
        :param str job_status: Search term to filter by jobStatus
        :return: ContactImportJobEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['expand', 'after', 'page_size', 'sort_order', 'job_status']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_import_jobs" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/import/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'job_status' in params:
            query_params['jobStatus'] = params['job_status']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactImportJobEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_import_setting(self, settings_id: str, **kwargs) -> 'ContactImportSettings':
        """
        Get setting based on id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_import_setting(settings_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str settings_id: Settings id (required)
        :return: ContactImportSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_import_setting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'settings_id' is set
        if ('settings_id' not in params) or (params['settings_id'] is None):
            raise ValueError("Missing the required parameter `settings_id` when calling `get_externalcontacts_import_setting`")


        resource_path = '/api/v2/externalcontacts/import/settings/{settingsId}'.replace('{format}', 'json')
        path_params = {}
        if 'settings_id' in params:
            path_params['settingsId'] = params['settings_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactImportSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_import_settings(self, **kwargs) -> 'ContactImportSettingsEntityListing':
        """
        List settings for organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_import_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str page_size: Number of entities to return. Maximum of 100.
        :param str sort_order: Direction of sorting.
        :param str name: Search term to filter by settings name
        :return: ContactImportSettingsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['after', 'page_size', 'sort_order', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_import_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/import/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactImportSettingsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organization(self, external_organization_id: str, **kwargs) -> 'ExternalOrganization':
        """
        Fetch an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organization(external_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :param list[str] expand: which fields, if any, to expand
        :param bool include_trustors: (true or false) whether or not to include trustor information embedded in the externalOrganization
        :return: ExternalOrganization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'expand', 'include_trustors']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organization" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `get_externalcontacts_organization`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'include_trustors' in params:
            query_params['includeTrustors'] = params['include_trustors']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organization_contacts(self, external_organization_id: str, **kwargs) -> 'ContactListing':
        """
        Search for external contacts in an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organization_contacts(external_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :param int page_size: Page size (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param int page_number: Page number (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param str q: User supplied search keywords (no special syntax is currently supported)
        :param str sort_order: The External Contact field to sort by. Any of: [firstName, lastName, middleName, title]. Direction: [asc, desc]. e.g. \"firstName:asc\", \"title:desc\"
        :param list[str] expand: which fields, if any, to expand
        :return: ContactListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'page_size', 'page_number', 'q', 'sort_order', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organization_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `get_externalcontacts_organization_contacts`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/contacts'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'q' in params:
            query_params['q'] = params['q']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organization_identifiers(self, external_organization_id: str, **kwargs) -> 'ExternalOrganizationIdentifierListing':
        """
        List the identifiers for an external organization
        
	    get_externalcontacts_organization_identifiers is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organization_identifiers(external_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :return: ExternalOrganizationIdentifierListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organization_identifiers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `get_externalcontacts_organization_identifiers`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/identifiers'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganizationIdentifierListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organization_note(self, external_organization_id: str, note_id: str, **kwargs) -> 'Note':
        """
        Fetch a note for an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organization_note(external_organization_id, note_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization Id (required)
        :param str note_id: Note Id (required)
        :param list[str] expand: which fields, if any, to expand
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'note_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organization_note" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `get_externalcontacts_organization_note`")
        # verify the required parameter 'note_id' is set
        if ('note_id' not in params) or (params['note_id'] is None):
            raise ValueError("Missing the required parameter `note_id` when calling `get_externalcontacts_organization_note`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/notes/{noteId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']
        if 'note_id' in params:
            path_params['noteId'] = params['note_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Note',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organization_notes(self, external_organization_id: str, **kwargs) -> 'NoteListing':
        """
        List notes for an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organization_notes(external_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization Id (required)
        :param int page_size: Page size (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param int page_number: Page number (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param str sort_order: The Note field to sort by. Any of: [createDate]. Direction: [asc, desc]. e.g. \"createDate:asc\", \"createDate:desc\"
        :param list[str] expand: which fields, if any, to expand
        :return: NoteListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'page_size', 'page_number', 'sort_order', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organization_notes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `get_externalcontacts_organization_notes`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/notes'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='NoteListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organization_relationships(self, external_organization_id: str, **kwargs) -> 'RelationshipListing':
        """
        Fetch a relationship for an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organization_relationships(external_organization_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :param int page_size: Page size (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param int page_number: Page number (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param list[str] expand: which fields, if any, to expand
        :param str sort_order: The Relationship field to sort by. Any of: [createDate, relationship]. Direction: [asc, desc]. e.g. \"createDate:asc\", \"relationship:desc\"
        :return: RelationshipListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'page_size', 'page_number', 'expand', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organization_relationships" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `get_externalcontacts_organization_relationships`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/relationships'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RelationshipListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organizations(self, **kwargs) -> 'ExternalOrganizationListing':
        """
        Search for external organizations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organizations(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param int page_number: Page number (limited to fetching first 1,000 records; pageNumber * pageSize must be <= 1,000)
        :param str q: Search query
        :param list[str] trustor_id: Search for external organizations by trustorIds (limit 25). If supplied, the 'q' parameters is ignored. Items are returned in the order requested
        :param str sort_order: The Organization field to sort by. Any of: [companyType, industry, name]. Direction: [asc, desc]. e.g. \"companyType:asc\", \"industry:desc\"
        :param list[str] expand: which fields, if any, to expand
        :param bool include_trustors: (true or false) whether or not to include trustor information embedded in the externalOrganization
        :param list[str] division_ids: which divisions to search, up to 50
        :return: ExternalOrganizationListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'q', 'trustor_id', 'sort_order', 'expand', 'include_trustors', 'division_ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organizations" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/organizations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'q' in params:
            query_params['q'] = params['q']
        if 'trustor_id' in params:
            query_params['trustorId'] = params['trustor_id']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'include_trustors' in params:
            query_params['includeTrustors'] = params['include_trustors']
        if 'division_ids' in params:
            query_params['divisionIds'] = params['division_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganizationListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organizations_schema(self, schema_id: str, **kwargs) -> 'DataSchema':
        """
        Get a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organizations_schema(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organizations_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_externalcontacts_organizations_schema`")


        resource_path = '/api/v2/externalcontacts/organizations/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organizations_schema_version(self, schema_id: str, version_id: str, **kwargs) -> 'DataSchema':
        """
        Get a specific version of a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organizations_schema_version(schema_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :param str version_id: Schema version (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id', 'version_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organizations_schema_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_externalcontacts_organizations_schema_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_externalcontacts_organizations_schema_version`")


        resource_path = '/api/v2/externalcontacts/organizations/schemas/{schemaId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organizations_schema_versions(self, schema_id: str, **kwargs) -> 'DataSchema':
        """
        Get all versions of an external organization's schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organizations_schema_versions(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organizations_schema_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_externalcontacts_organizations_schema_versions`")


        resource_path = '/api/v2/externalcontacts/organizations/schemas/{schemaId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organizations_schemas(self, **kwargs) -> 'DataSchemaListing':
        """
        Get a list of schemas.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organizations_schemas(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DataSchemaListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organizations_schemas" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/organizations/schemas'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchemaListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organizations_schemas_coretype(self, core_type_name: str, **kwargs) -> 'Coretype':
        """
        Get the core types from which all schemas are built.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organizations_schemas_coretype(core_type_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str core_type_name: Name of the core type (required)
        :return: Coretype
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['core_type_name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organizations_schemas_coretype" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'core_type_name' is set
        if ('core_type_name' not in params) or (params['core_type_name'] is None):
            raise ValueError("Missing the required parameter `core_type_name` when calling `get_externalcontacts_organizations_schemas_coretype`")


        resource_path = '/api/v2/externalcontacts/organizations/schemas/coretypes/{coreTypeName}'.replace('{format}', 'json')
        path_params = {}
        if 'core_type_name' in params:
            path_params['coreTypeName'] = params['core_type_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Coretype',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organizations_schemas_coretypes(self, **kwargs) -> 'Coretype':
        """
        Get the core types from which all schemas are built.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organizations_schemas_coretypes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: Coretype
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organizations_schemas_coretypes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/organizations/schemas/coretypes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Coretype',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_organizations_schemas_limits(self, **kwargs) -> 'SchemaQuantityLimits':
        """
        Get quantitative limits on schemas
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_organizations_schemas_limits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SchemaQuantityLimits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_organizations_schemas_limits" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/organizations/schemas/limits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SchemaQuantityLimits',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_relationship(self, relationship_id: str, **kwargs) -> 'Relationship':
        """
        Fetch a relationship
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_relationship(relationship_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str relationship_id: Relationship Id (required)
        :param list[str] expand: which fields, if any, to expand
        :return: Relationship
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['relationship_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_relationship" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'relationship_id' is set
        if ('relationship_id' not in params) or (params['relationship_id'] is None):
            raise ValueError("Missing the required parameter `relationship_id` when calling `get_externalcontacts_relationship`")


        resource_path = '/api/v2/externalcontacts/relationships/{relationshipId}'.replace('{format}', 'json')
        path_params = {}
        if 'relationship_id' in params:
            path_params['relationshipId'] = params['relationship_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Relationship',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_reversewhitepageslookup(self, lookup_val: str, **kwargs) -> 'ReverseWhitepagesLookupResult':
        """
        Look up contacts and externalOrganizations based on an attribute. Maximum of 25 values returned.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_reversewhitepageslookup(lookup_val, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str lookup_val: User supplied value to lookup contacts/externalOrganizations (supports email addresses, e164 phone numbers, Twitter screen names) (required)
        :param list[str] expand: which field, if any, to expand
        :param str division_id: Specifies which division to lookup contacts/externalOrganizations in, for the given lookup value
        :return: ReverseWhitepagesLookupResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['lookup_val', 'expand', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_reversewhitepageslookup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'lookup_val' is set
        if ('lookup_val' not in params) or (params['lookup_val'] is None):
            raise ValueError("Missing the required parameter `lookup_val` when calling `get_externalcontacts_reversewhitepageslookup`")


        resource_path = '/api/v2/externalcontacts/reversewhitepageslookup'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'lookup_val' in params:
            query_params['lookupVal'] = params['lookup_val']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ReverseWhitepagesLookupResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_scan_contacts(self, **kwargs) -> 'CursorContactListing':
        """
        Scan for external contacts using paging
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_scan_contacts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of contacts per page; must be between 10 and 200, default is 100
        :param str cursor: Indicates where to resume query results (not required for first page), each page returns a new cursor with a 24h TTL
        :param str division_id: The division to scan over
        :return: CursorContactListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_scan_contacts" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/scan/contacts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CursorContactListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_scan_contacts_divisionviews_all(self, **kwargs) -> 'CursorContactListing':
        """
        Scan for external contacts using paging
        
	    get_externalcontacts_scan_contacts_divisionviews_all is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_scan_contacts_divisionviews_all(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of contacts per page; must be between 10 and 200, default is 100
        :param str cursor: Indicates where to resume query results (not required for first page), each page returns a new cursor with a 24h TTL
        :return: CursorContactListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_scan_contacts_divisionviews_all" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/scan/contacts/divisionviews/all'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CursorContactListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_scan_notes(self, **kwargs) -> 'CursorNoteListing':
        """
        Scan for notes using paging
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_scan_notes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of notes per page; must be between 10 and 200, default is 100
        :param str cursor: Indicates where to resume query results (not required for first page), each page returns a new cursor with a 24h TTL
        :param str division_id: The division to scan over
        :return: CursorNoteListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_scan_notes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/scan/notes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CursorNoteListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_scan_notes_divisionviews_all(self, **kwargs) -> 'CursorNoteListing':
        """
        Scan for notes using paging
        
	    get_externalcontacts_scan_notes_divisionviews_all is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_scan_notes_divisionviews_all(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of notes per page; must be between 10 and 200, default is 100
        :param str cursor: Indicates where to resume query results (not required for first page), each page returns a new cursor with a 24h TTL
        :return: CursorNoteListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_scan_notes_divisionviews_all" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/scan/notes/divisionviews/all'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CursorNoteListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_scan_organizations(self, **kwargs) -> 'CursorOrganizationListing':
        """
        Scan for external organizations using paging
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_scan_organizations(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of organizations per page; must be between 10 and 200, default is 100
        :param str cursor: Indicates where to resume query results (not required for first page), each page returns a new cursor with a 24h TTL
        :param str division_id: The division to scan over
        :return: CursorOrganizationListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_scan_organizations" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/scan/organizations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CursorOrganizationListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_scan_organizations_divisionviews_all(self, **kwargs) -> 'CursorOrganizationListing':
        """
        Scan for external organizations using paging
        
	    get_externalcontacts_scan_organizations_divisionviews_all is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_scan_organizations_divisionviews_all(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of organizations per page; must be between 10 and 200, default is 100
        :param str cursor: Indicates where to resume query results (not required for first page), each page returns a new cursor with a 24h TTL
        :return: CursorOrganizationListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_scan_organizations_divisionviews_all" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/scan/organizations/divisionviews/all'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CursorOrganizationListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_scan_relationships(self, **kwargs) -> 'CursorRelationshipListing':
        """
        Scan for relationships
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_scan_relationships(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of relationships per page; must be between 10 and 200, default is 100
        :param str cursor: Indicates where to resume query results (not required for first page), each page returns a new cursor with a 24h TTL
        :param str division_id: The division to scan over
        :return: CursorRelationshipListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_scan_relationships" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/scan/relationships'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CursorRelationshipListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_externalcontacts_scan_relationships_divisionviews_all(self, **kwargs) -> 'CursorRelationshipListing':
        """
        Scan for relationships
        
	    get_externalcontacts_scan_relationships_divisionviews_all is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_externalcontacts_scan_relationships_divisionviews_all(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int limit: The number of relationships per page; must be between 10 and 200, default is 100
        :param str cursor: Indicates where to resume query results (not required for first page), each page returns a new cursor with a 24h TTL
        :return: CursorRelationshipListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['limit', 'cursor']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_externalcontacts_scan_relationships_divisionviews_all" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/externalcontacts/scan/relationships/divisionviews/all'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CursorRelationshipListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_externalcontacts_contact_identifiers(self, contact_id: str, body: 'IdentifierClaimRequest', **kwargs) -> 'ContactIdentifier':
        """
        Claim or release identifiers for a contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_externalcontacts_contact_identifiers(contact_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact ID (required)
        :param IdentifierClaimRequest body: ClaimRequest (required)
        :return: ContactIdentifier
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_externalcontacts_contact_identifiers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `patch_externalcontacts_contact_identifiers`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_externalcontacts_contact_identifiers`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/identifiers'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactIdentifier',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_externalcontacts_organization_identifiers(self, external_organization_id: str, body: 'ExternalOrganizationIdentifierClaimRequest', **kwargs) -> 'ExternalOrganizationIdentifier':
        """
        Claim or release identifiers for an external organization
        
	    patch_externalcontacts_organization_identifiers is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_externalcontacts_organization_identifiers(external_organization_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :param ExternalOrganizationIdentifierClaimRequest body: ClaimRequest (required)
        :return: ExternalOrganizationIdentifier
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_externalcontacts_organization_identifiers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `patch_externalcontacts_organization_identifiers`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_externalcontacts_organization_identifiers`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/identifiers'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganizationIdentifier',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_contacts(self, body: 'BulkIdsRequest', **kwargs) -> 'BulkFetchContactsResponse':
        """
        Bulk fetch contacts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_contacts(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Contact ids (required)
        :return: BulkFetchContactsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_contacts`")


        resource_path = '/api/v2/externalcontacts/bulk/contacts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkFetchContactsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_contacts_add(self, body: 'BulkContactsRequest', **kwargs) -> 'BulkContactsResponse':
        """
        Bulk add contacts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_contacts_add(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkContactsRequest body: Contacts (required)
        :return: BulkContactsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_contacts_add" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_contacts_add`")


        resource_path = '/api/v2/externalcontacts/bulk/contacts/add'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkContactsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_contacts_divisionviews(self, body: 'BulkIdsRequest', **kwargs) -> 'BulkFetchContactsResponse':
        """
        Bulk fetch contacts across divisions
        
	    post_externalcontacts_bulk_contacts_divisionviews is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_contacts_divisionviews(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Contact ids (required)
        :return: BulkFetchContactsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_contacts_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_contacts_divisionviews`")


        resource_path = '/api/v2/externalcontacts/bulk/contacts/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkFetchContactsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_contacts_enrich(self, body: 'BulkContactsEnrichRequest', **kwargs) -> 'BulkContactsEnrichResponse':
        """
        Bulk Enrich Contacts - Run up to 10 Enrich operations per request
        See the API endpoint /externalcontacts/contacts/enrich for docs on individual Enrich operations.
	    post_externalcontacts_bulk_contacts_enrich is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_contacts_enrich(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkContactsEnrichRequest body: Contact Enrich Requests (required)
        :param bool dry_run: If true, the request will not make any modifications, but will show you what the end result *would* be.
        :return: BulkContactsEnrichResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dry_run']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_contacts_enrich" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_contacts_enrich`")


        resource_path = '/api/v2/externalcontacts/bulk/contacts/enrich'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'dry_run' in params:
            query_params['dryRun'] = params['dry_run']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkContactsEnrichResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_contacts_remove(self, body: 'BulkIdsRequest', **kwargs) -> 'BulkDeleteResponse':
        """
        Bulk remove contacts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_contacts_remove(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Contact ids (required)
        :return: BulkDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_contacts_remove" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_contacts_remove`")


        resource_path = '/api/v2/externalcontacts/bulk/contacts/remove'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkDeleteResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_contacts_unresolved(self, body: 'BulkIdsRequest', **kwargs) -> 'BulkFetchContactsResponse':
        """
        Bulk fetch unresolved ancestor contacts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_contacts_unresolved(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Contact ids (required)
        :return: BulkFetchContactsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_contacts_unresolved" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_contacts_unresolved`")


        resource_path = '/api/v2/externalcontacts/bulk/contacts/unresolved'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkFetchContactsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_contacts_update(self, body: 'BulkContactsRequest', **kwargs) -> 'BulkContactsResponse':
        """
        Bulk update contacts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_contacts_update(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkContactsRequest body: Contacts (required)
        :return: BulkContactsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_contacts_update" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_contacts_update`")


        resource_path = '/api/v2/externalcontacts/bulk/contacts/update'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkContactsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_notes(self, body: 'BulkIdsRequest', **kwargs) -> 'BulkFetchNotesResponse':
        """
        Bulk fetch notes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_notes(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Note ids (required)
        :return: BulkFetchNotesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_notes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_notes`")


        resource_path = '/api/v2/externalcontacts/bulk/notes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkFetchNotesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_notes_add(self, body: 'BulkNotesRequest', **kwargs) -> 'BulkNotesResponse':
        """
        Bulk add notes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_notes_add(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkNotesRequest body: Notes (required)
        :return: BulkNotesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_notes_add" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_notes_add`")


        resource_path = '/api/v2/externalcontacts/bulk/notes/add'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkNotesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_notes_remove(self, body: 'BulkIdsRequest', **kwargs) -> 'BulkDeleteResponse':
        """
        Bulk remove notes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_notes_remove(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Note ids (required)
        :return: BulkDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_notes_remove" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_notes_remove`")


        resource_path = '/api/v2/externalcontacts/bulk/notes/remove'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkDeleteResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_notes_update(self, body: 'BulkNotesRequest', **kwargs) -> 'BulkNotesResponse':
        """
        Bulk update notes
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_notes_update(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkNotesRequest body: Notes (required)
        :return: BulkNotesResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_notes_update" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_notes_update`")


        resource_path = '/api/v2/externalcontacts/bulk/notes/update'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkNotesResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_organizations(self, body: 'BulkIdsRequest', **kwargs) -> 'BulkFetchOrganizationsResponse':
        """
        Bulk fetch organizations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_organizations(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Organizations ids (required)
        :return: BulkFetchOrganizationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_organizations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_organizations`")


        resource_path = '/api/v2/externalcontacts/bulk/organizations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkFetchOrganizationsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_organizations_add(self, body: 'BulkOrganizationsRequest', **kwargs) -> 'BulkOrganizationsResponse':
        """
        Bulk add organizations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_organizations_add(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkOrganizationsRequest body: Organizations (required)
        :return: BulkOrganizationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_organizations_add" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_organizations_add`")


        resource_path = '/api/v2/externalcontacts/bulk/organizations/add'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkOrganizationsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_organizations_divisionviews(self, body: 'BulkIdsRequest', **kwargs) -> 'BulkFetchOrganizationsResponse':
        """
        Bulk fetch organizations across divisions
        
	    post_externalcontacts_bulk_organizations_divisionviews is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_organizations_divisionviews(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Organizations ids (required)
        :return: BulkFetchOrganizationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_organizations_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_organizations_divisionviews`")


        resource_path = '/api/v2/externalcontacts/bulk/organizations/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkFetchOrganizationsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_organizations_enrich(self, body: 'BulkOrganizationsEnrichRequest', **kwargs) -> 'BulkOrganizationsEnrichResponse':
        """
        Bulk enrich external organizations - Run up to 10 Enrich operations per request
        See the API endpoint /externalcontacts/organizations/enrich for docs on individual Enrich operations.
	    post_externalcontacts_bulk_organizations_enrich is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_organizations_enrich(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkOrganizationsEnrichRequest body: External Organization Enrich Requests (required)
        :param bool dry_run: If true, the request will not make any modifications, but will show you what the end result *would* be.
        :return: BulkOrganizationsEnrichResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dry_run']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_organizations_enrich" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_organizations_enrich`")


        resource_path = '/api/v2/externalcontacts/bulk/organizations/enrich'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'dry_run' in params:
            query_params['dryRun'] = params['dry_run']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkOrganizationsEnrichResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_organizations_remove(self, body: 'BulkIdsRequest', **kwargs) -> 'BulkDeleteResponse':
        """
        Bulk remove organizations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_organizations_remove(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Organization ids (required)
        :return: BulkDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_organizations_remove" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_organizations_remove`")


        resource_path = '/api/v2/externalcontacts/bulk/organizations/remove'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkDeleteResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_organizations_update(self, body: 'BulkOrganizationsRequest', **kwargs) -> 'BulkOrganizationsResponse':
        """
        Bulk update organizations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_organizations_update(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkOrganizationsRequest body: Organizations (required)
        :return: BulkOrganizationsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_organizations_update" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_organizations_update`")


        resource_path = '/api/v2/externalcontacts/bulk/organizations/update'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkOrganizationsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_relationships(self, body: 'BulkIdsRequest', **kwargs) -> 'BulkFetchRelationshipsResponse':
        """
        Bulk fetch relationships
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_relationships(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Relationships ids (required)
        :return: BulkFetchRelationshipsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_relationships" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_relationships`")


        resource_path = '/api/v2/externalcontacts/bulk/relationships'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkFetchRelationshipsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_relationships_add(self, body: 'BulkRelationshipsRequest', **kwargs) -> 'BulkRelationshipsResponse':
        """
        Bulk add relationships
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_relationships_add(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkRelationshipsRequest body: Relationships (required)
        :return: BulkRelationshipsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_relationships_add" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_relationships_add`")


        resource_path = '/api/v2/externalcontacts/bulk/relationships/add'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkRelationshipsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_relationships_remove(self, body: 'BulkIdsRequest', **kwargs) -> 'BulkDeleteResponse':
        """
        Bulk remove relationships
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_relationships_remove(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkIdsRequest body: Relationships ids (required)
        :return: BulkDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_relationships_remove" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_relationships_remove`")


        resource_path = '/api/v2/externalcontacts/bulk/relationships/remove'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkDeleteResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_bulk_relationships_update(self, body: 'BulkRelationshipsRequest', **kwargs) -> 'BulkRelationshipsResponse':
        """
        Bulk update relationships
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_bulk_relationships_update(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param BulkRelationshipsRequest body: Relationships (required)
        :return: BulkRelationshipsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_bulk_relationships_update" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_bulk_relationships_update`")


        resource_path = '/api/v2/externalcontacts/bulk/relationships/update'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkRelationshipsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_contact_notes(self, contact_id: str, body: 'Note', **kwargs) -> 'Note':
        """
        Create a note for an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_contact_notes(contact_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact Id (required)
        :param Note body: ExternalContact (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_contact_notes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `post_externalcontacts_contact_notes`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_contact_notes`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/notes'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Note',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_contact_promotion(self, contact_id: str, **kwargs) -> 'ExternalContact':
        """
        Promote an observed contact (ephemeral or identified) to a curated contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_contact_promotion(contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact ID (required)
        :return: ExternalContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_contact_promotion" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `post_externalcontacts_contact_promotion`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/promotion'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_contacts(self, body: 'ExternalContact', **kwargs) -> 'ExternalContact':
        """
        Create an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_contacts(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExternalContact body: ExternalContact (required)
        :return: ExternalContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_contacts`")


        resource_path = '/api/v2/externalcontacts/contacts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_contacts_enrich(self, body: 'ContactEnrichRequest', **kwargs) -> 'ExternalContact':
        """
        Modify or create an External Contact, with powerful behaviors for finding and combining data with pre-existing Contacts.
        You may also submit multiple Enrich operations in one request via the Bulk Enrich API at /externalcontacts/bulk/contacts. A 201 response status indicates that a new Contact was created, whereas a 200 status indicates that a Contact was updated or a merge occurred.
	    post_externalcontacts_contacts_enrich is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_contacts_enrich(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactEnrichRequest body: ContactEnrichRequest (required)
        :param bool dry_run: If true, the request will not make any modifications, but will show you what the end result *would* be.
        :return: ExternalContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dry_run']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_contacts_enrich" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_contacts_enrich`")


        resource_path = '/api/v2/externalcontacts/contacts/enrich'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'dry_run' in params:
            query_params['dryRun'] = params['dry_run']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_contacts_exports(self, body: 'ContactsExport', **kwargs) -> 'ContactsExport':
        """
        Create bulk export
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_contacts_exports(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactsExport body: Export (required)
        :return: ContactsExport
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_contacts_exports" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_contacts_exports`")


        resource_path = '/api/v2/externalcontacts/contacts/exports'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactsExport',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_contacts_merge(self, body: 'MergeContactsRequest', **kwargs) -> 'ExternalContact':
        """
        Merge up to 25 contacts into a new contact record
        Merge operation may fail if the resulting mergeset exceeds our default limit of 52. The valueOverride field lets you override any of the Contact fields post-merge. If any Contact field is left null in `valueOverride`, it will be taken from the most recently-modified contact in the merge set. Exception for *phone/*email fields: Conflicting data will be moved to any other available phone/email fields in the merged contact.
	    post_externalcontacts_contacts_merge is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_contacts_merge(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MergeContactsRequest body: MergeRequest (required)
        :return: ExternalContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_contacts_merge" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_contacts_merge`")


        resource_path = '/api/v2/externalcontacts/contacts/merge'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_contacts_schemas(self, body: 'DataSchema', **kwargs) -> 'DataSchema':
        """
        Create a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_contacts_schemas(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DataSchema body: Schema (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_contacts_schemas" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_contacts_schemas`")


        resource_path = '/api/v2/externalcontacts/contacts/schemas'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_externalsources(self, body: 'ExternalSource', **kwargs) -> 'ExternalSource':
        """
        Create an External Source
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_externalsources(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExternalSource body: External Source (required)
        :return: ExternalSource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_externalsources" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_externalsources`")


        resource_path = '/api/v2/externalcontacts/externalsources'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalSource',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    @deprecated("post_externalcontacts_identifierlookup is deprecated")
    def post_externalcontacts_identifierlookup(self, identifier: 'ContactIdentifier', **kwargs) -> 'ExternalContact':
        """
        Fetch a contact using an identifier type and value.
        NOTE: Deprecated. Please use /api/v2/externalcontacts/identifierlookup/contacts as an alternative endpoint instead. Phone number identifier values must be provided with the country code and a leading '+' symbol. Example: \"+1 704 298 4733\"

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_identifierlookup(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactIdentifier identifier:  (required)
        :param list[str] expand: which field, if any, to expand
        :return: ExternalContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_identifierlookup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `post_externalcontacts_identifierlookup`")


        resource_path = '/api/v2/externalcontacts/identifierlookup'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'identifier' in params:
            body_params = params['identifier']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_identifierlookup_contacts(self, identifier: 'ContactIdentifier', **kwargs) -> 'ExternalContact':
        """
        Fetch a contact using an identifier type and value.
        Phone number identifier values must be provided with the country code and a leading '+' symbol. Example: \"+1 704 298 4733\"
	    post_externalcontacts_identifierlookup_contacts is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_identifierlookup_contacts(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactIdentifier identifier:  (required)
        :param list[str] expand: which field, if any, to expand
        :return: ExternalContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_identifierlookup_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `post_externalcontacts_identifierlookup_contacts`")


        resource_path = '/api/v2/externalcontacts/identifierlookup/contacts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'identifier' in params:
            body_params = params['identifier']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_identifierlookup_organizations(self, identifier: 'ExternalOrganizationIdentifier', **kwargs) -> 'ExternalOrganization':
        """
        Fetch an external organization using an identifier type and value.
        This endpoint will only accept ExternalId type identifiers.
	    post_externalcontacts_identifierlookup_organizations is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_identifierlookup_organizations(identifier, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExternalOrganizationIdentifier identifier:  (required)
        :param list[str] expand: which field, if any, to expand
        :return: ExternalOrganization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_identifierlookup_organizations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'identifier' is set
        if ('identifier' not in params) or (params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `post_externalcontacts_identifierlookup_organizations`")


        resource_path = '/api/v2/externalcontacts/identifierlookup/organizations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'identifier' in params:
            body_params = params['identifier']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_import_csv_jobs(self, body: 'CsvJobRequest', **kwargs) -> 'CsvJobResponse':
        """
        Create CSV import job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_import_csv_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CsvJobRequest body: ImportRequest (required)
        :return: CsvJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_import_csv_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_import_csv_jobs`")


        resource_path = '/api/v2/externalcontacts/import/csv/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CsvJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_import_csv_settings(self, body: 'CsvSettings', **kwargs) -> 'CsvSettings':
        """
        Create settings for CSV import
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_import_csv_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CsvSettings body: Settings (required)
        :return: CsvSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_import_csv_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_import_csv_settings`")


        resource_path = '/api/v2/externalcontacts/import/csv/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CsvSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_import_csv_uploads(self, body: 'CsvUploadRequest', **kwargs) -> 'CsvUploadResponse':
        """
        Get url for CSV upload
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_import_csv_uploads(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CsvUploadRequest body: UploadRequest (required)
        :return: CsvUploadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_import_csv_uploads" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_import_csv_uploads`")


        resource_path = '/api/v2/externalcontacts/import/csv/uploads'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CsvUploadResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_import_jobs(self, body: 'ContactImportJobRequest', **kwargs) -> 'ContactImportJobResponse':
        """
        Create a new job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_import_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactImportJobRequest body: Job (required)
        :return: ContactImportJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_import_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_import_jobs`")


        resource_path = '/api/v2/externalcontacts/import/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactImportJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_import_settings(self, body: 'ContactImportSettings', **kwargs) -> 'ContactImportSettings':
        """
        Create a new settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_import_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactImportSettings body: Setting (required)
        :return: ContactImportSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_import_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_import_settings`")


        resource_path = '/api/v2/externalcontacts/import/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactImportSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    @deprecated("post_externalcontacts_merge_contacts is deprecated")
    def post_externalcontacts_merge_contacts(self, body: 'MergeRequest', **kwargs) -> 'ExternalContact':
        """
        Merge two contacts into a new contact record
        Two curated contacts cannot be merged. Refer to the Contact Merging article on the Developer Center for details. Deprecated: This API has been superseded by a new merge API. You are encouraged to instead use /api/v2/externalcontacts/contacts/merge, which supports merging up to 25 Contacts of any type, and overriding specific fields in the resulting Contact.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_merge_contacts(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MergeRequest body: MergeRequest (required)
        :return: ExternalContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_merge_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_merge_contacts`")


        resource_path = '/api/v2/externalcontacts/merge/contacts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_organization_notes(self, external_organization_id: str, body: 'Note', **kwargs) -> 'Note':
        """
        Create a note for an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_organization_notes(external_organization_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization Id (required)
        :param Note body: ExternalContact (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_organization_notes" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `post_externalcontacts_organization_notes`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_organization_notes`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/notes'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Note',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_organizations(self, body: 'ExternalOrganization', **kwargs) -> 'ExternalOrganization':
        """
        Create an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_organizations(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExternalOrganization body: ExternalOrganization (required)
        :return: ExternalOrganization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_organizations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_organizations`")


        resource_path = '/api/v2/externalcontacts/organizations'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_organizations_enrich(self, body: 'ExternalOrganizationEnrichRequest', **kwargs) -> 'ExternalOrganization':
        """
        Modify or create an External Org, with powerful behaviors for finding and combining data with pre-existing External Orgs.
        You may also submit multiple Enrich operations in one request via the Bulk Enrich API at /externalcontacts/bulk/organizations. A 201 response status indicates that a new External Organization was created, whereas a 200 status indicates that an External Organization was updated
	    post_externalcontacts_organizations_enrich is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_organizations_enrich(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExternalOrganizationEnrichRequest body: ExternalOrgEnrichRequest (required)
        :param bool dry_run: If true, the request will not make any modifications, but will show you what the end result *would* be.
        :return: ExternalOrganization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'dry_run']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_organizations_enrich" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_organizations_enrich`")


        resource_path = '/api/v2/externalcontacts/organizations/enrich'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'dry_run' in params:
            query_params['dryRun'] = params['dry_run']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_organizations_schemas(self, body: 'DataSchema', **kwargs) -> 'DataSchema':
        """
        Create a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_organizations_schemas(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DataSchema body: Schema (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_organizations_schemas" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_organizations_schemas`")


        resource_path = '/api/v2/externalcontacts/organizations/schemas'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_externalcontacts_relationships(self, body: 'Relationship', **kwargs) -> 'Relationship':
        """
        Create a relationship
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_externalcontacts_relationships(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Relationship body: Relationship (required)
        :return: Relationship
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_externalcontacts_relationships" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_externalcontacts_relationships`")


        resource_path = '/api/v2/externalcontacts/relationships'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Relationship',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_contact(self, contact_id: str, body: 'ExternalContact', **kwargs) -> 'ExternalContact':
        """
        Update an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_contact(contact_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact ID (required)
        :param ExternalContact body: ExternalContact (required)
        :return: ExternalContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_contact" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `put_externalcontacts_contact`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_contact`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_contact_note(self, contact_id: str, note_id: str, body: 'Note', **kwargs) -> 'Note':
        """
        Update a note for an external contact
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_contact_note(contact_id, note_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_id: ExternalContact Id (required)
        :param str note_id: Note Id (required)
        :param Note body: Note (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_id', 'note_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_contact_note" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `put_externalcontacts_contact_note`")
        # verify the required parameter 'note_id' is set
        if ('note_id' not in params) or (params['note_id'] is None):
            raise ValueError("Missing the required parameter `note_id` when calling `put_externalcontacts_contact_note`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_contact_note`")


        resource_path = '/api/v2/externalcontacts/contacts/{contactId}/notes/{noteId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']
        if 'note_id' in params:
            path_params['noteId'] = params['note_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Note',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_contacts_schema(self, schema_id: str, body: 'DataSchema', **kwargs) -> 'DataSchema':
        """
        Update a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_contacts_schema(schema_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :param DataSchema body: Data Schema (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_contacts_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `put_externalcontacts_contacts_schema`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_contacts_schema`")


        resource_path = '/api/v2/externalcontacts/contacts/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_conversation(self, conversation_id: str, body: 'ConversationAssociation', **kwargs) -> None:
        """
        Associate/disassociate an external contact with a conversation
        To associate, supply a value for the externalContactId.  To disassociate, do not include the property at all.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_conversation(conversation_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param ConversationAssociation body: ConversationAssociation (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_conversation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `put_externalcontacts_conversation`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_conversation`")


        resource_path = '/api/v2/externalcontacts/conversations/{conversationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_externalsource(self, external_source_id: str, body: 'ExternalSource', **kwargs) -> 'ExternalSource':
        """
        Update an External Source
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_externalsource(external_source_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_source_id: External Source ID (required)
        :param ExternalSource body: External Source (required)
        :return: ExternalSource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_source_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_externalsource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_source_id' is set
        if ('external_source_id' not in params) or (params['external_source_id'] is None):
            raise ValueError("Missing the required parameter `external_source_id` when calling `put_externalcontacts_externalsource`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_externalsource`")


        resource_path = '/api/v2/externalcontacts/externalsources/{externalSourceId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_source_id' in params:
            path_params['externalSourceId'] = params['external_source_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalSource',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_import_csv_setting(self, settings_id: str, body: 'CsvSettings', **kwargs) -> 'CsvSettings':
        """
        Update settings for CSV import
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_import_csv_setting(settings_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str settings_id: Settings id (required)
        :param CsvSettings body: Settings (required)
        :return: CsvSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_import_csv_setting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'settings_id' is set
        if ('settings_id' not in params) or (params['settings_id'] is None):
            raise ValueError("Missing the required parameter `settings_id` when calling `put_externalcontacts_import_csv_setting`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_import_csv_setting`")


        resource_path = '/api/v2/externalcontacts/import/csv/settings/{settingsId}'.replace('{format}', 'json')
        path_params = {}
        if 'settings_id' in params:
            path_params['settingsId'] = params['settings_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CsvSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_import_job(self, job_id: str, body: 'ContactImportJobStatusUpdateRequest', **kwargs) -> 'ContactImportJobStatusUpdateResponse':
        """
        Update Job's workflow status
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_import_job(job_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: Job id (required)
        :param ContactImportJobStatusUpdateRequest body: Status of the Job's workflow (required)
        :return: ContactImportJobStatusUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_import_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `put_externalcontacts_import_job`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_import_job`")


        resource_path = '/api/v2/externalcontacts/import/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactImportJobStatusUpdateResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_import_setting(self, settings_id: str, body: 'ContactImportSettings', **kwargs) -> 'ContactImportSettings':
        """
        Update settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_import_setting(settings_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str settings_id: Settings id (required)
        :param ContactImportSettings body: Setting (required)
        :return: ContactImportSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['settings_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_import_setting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'settings_id' is set
        if ('settings_id' not in params) or (params['settings_id'] is None):
            raise ValueError("Missing the required parameter `settings_id` when calling `put_externalcontacts_import_setting`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_import_setting`")


        resource_path = '/api/v2/externalcontacts/import/settings/{settingsId}'.replace('{format}', 'json')
        path_params = {}
        if 'settings_id' in params:
            path_params['settingsId'] = params['settings_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactImportSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_organization(self, external_organization_id: str, body: 'ExternalOrganization', **kwargs) -> 'ExternalOrganization':
        """
        Update an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_organization(external_organization_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :param ExternalOrganization body: ExternalOrganization (required)
        :return: ExternalOrganization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_organization" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `put_externalcontacts_organization`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_organization`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_organization_note(self, external_organization_id: str, note_id: str, body: 'Note', **kwargs) -> 'Note':
        """
        Update a note for an external organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_organization_note(external_organization_id, note_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization Id (required)
        :param str note_id: Note Id (required)
        :param Note body: Note (required)
        :return: Note
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'note_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_organization_note" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `put_externalcontacts_organization_note`")
        # verify the required parameter 'note_id' is set
        if ('note_id' not in params) or (params['note_id'] is None):
            raise ValueError("Missing the required parameter `note_id` when calling `put_externalcontacts_organization_note`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_organization_note`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/notes/{noteId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']
        if 'note_id' in params:
            path_params['noteId'] = params['note_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Note',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_organization_trustor_trustor_id(self, external_organization_id: str, trustor_id: str, **kwargs) -> 'ExternalOrganizationTrustorLink':
        """
        Links a Trustor with an External Organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_organization_trustor_trustor_id(external_organization_id, trustor_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str external_organization_id: External Organization ID (required)
        :param str trustor_id: Trustor ID (required)
        :return: ExternalOrganizationTrustorLink
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['external_organization_id', 'trustor_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_organization_trustor_trustor_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'external_organization_id' is set
        if ('external_organization_id' not in params) or (params['external_organization_id'] is None):
            raise ValueError("Missing the required parameter `external_organization_id` when calling `put_externalcontacts_organization_trustor_trustor_id`")
        # verify the required parameter 'trustor_id' is set
        if ('trustor_id' not in params) or (params['trustor_id'] is None):
            raise ValueError("Missing the required parameter `trustor_id` when calling `put_externalcontacts_organization_trustor_trustor_id`")


        resource_path = '/api/v2/externalcontacts/organizations/{externalOrganizationId}/trustor/{trustorId}'.replace('{format}', 'json')
        path_params = {}
        if 'external_organization_id' in params:
            path_params['externalOrganizationId'] = params['external_organization_id']
        if 'trustor_id' in params:
            path_params['trustorId'] = params['trustor_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExternalOrganizationTrustorLink',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_organizations_schema(self, schema_id: str, body: 'DataSchema', **kwargs) -> 'DataSchema':
        """
        Update a schema
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_organizations_schema(schema_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :param DataSchema body: Data Schema (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_organizations_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `put_externalcontacts_organizations_schema`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_organizations_schema`")


        resource_path = '/api/v2/externalcontacts/organizations/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_externalcontacts_relationship(self, relationship_id: str, body: 'Relationship', **kwargs) -> 'Relationship':
        """
        Update a relationship
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_externalcontacts_relationship(relationship_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str relationship_id: Relationship Id (required)
        :param Relationship body: Relationship (required)
        :return: Relationship
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['relationship_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_externalcontacts_relationship" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'relationship_id' is set
        if ('relationship_id' not in params) or (params['relationship_id'] is None):
            raise ValueError("Missing the required parameter `relationship_id` when calling `put_externalcontacts_relationship`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_externalcontacts_relationship`")


        resource_path = '/api/v2/externalcontacts/relationships/{relationshipId}'.replace('{format}', 'json')
        path_params = {}
        if 'relationship_id' in params:
            path_params['relationshipId'] = params['relationship_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Relationship',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
