# coding: utf-8

"""
DataPrivacyApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import ErrorBody
from ..models import ErrorInfo
from ..models import MaskingRule
from ..models import MaskingRuleListing
from ..models import MaskingRuleValidateRequest
from ..models import MaskingRuleValidateResponse

class DataPrivacyApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_dataprivacy_maskingrule(self, rule_id: str, **kwargs) -> None:
        """
        Delete a masking rule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_dataprivacy_maskingrule(rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_id: ruleId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_dataprivacy_maskingrule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `delete_dataprivacy_maskingrule`")


        resource_path = '/api/v2/dataprivacy/maskingrules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_dataprivacy_maskingrule(self, rule_id: str, **kwargs) -> 'MaskingRule':
        """
        Fetch details about a masking rule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_dataprivacy_maskingrule(rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_id: ruleId (required)
        :return: MaskingRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataprivacy_maskingrule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `get_dataprivacy_maskingrule`")


        resource_path = '/api/v2/dataprivacy/maskingrules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MaskingRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_dataprivacy_maskingrules(self, **kwargs) -> 'MaskingRuleListing':
        """
        Retrieve the list of masking rules.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_dataprivacy_maskingrules(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: MaskingRuleListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dataprivacy_maskingrules" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/dataprivacy/maskingrules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MaskingRuleListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_dataprivacy_maskingrule(self, rule_id: str, **kwargs) -> 'MaskingRule':
        """
        Update information about a masking rule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_dataprivacy_maskingrule(rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_id: ruleId (required)
        :param MaskingRule body: 
        :return: MaskingRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_dataprivacy_maskingrule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `patch_dataprivacy_maskingrule`")


        resource_path = '/api/v2/dataprivacy/maskingrules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MaskingRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_dataprivacy_maskingrules(self, body: 'MaskingRule', **kwargs) -> 'MaskingRule':
        """
        Create a new masking rule resource.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_dataprivacy_maskingrules(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MaskingRule body: Details for creating masking rule resource (required)
        :return: MaskingRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_dataprivacy_maskingrules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_dataprivacy_maskingrules`")


        resource_path = '/api/v2/dataprivacy/maskingrules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MaskingRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_dataprivacy_maskingrules_validate(self, body: 'MaskingRuleValidateRequest', **kwargs) -> 'MaskingRuleValidateResponse':
        """
        Validate masking before creating.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_dataprivacy_maskingrules_validate(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MaskingRuleValidateRequest body: Text to be masked (required)
        :return: MaskingRuleValidateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_dataprivacy_maskingrules_validate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_dataprivacy_maskingrules_validate`")


        resource_path = '/api/v2/dataprivacy/maskingrules/validate'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MaskingRuleValidateResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
