# coding: utf-8

"""
ContentManagementApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import CommandStatus
from ..models import CommandStatusEntityListing
from ..models import CreateShareRequest
from ..models import CreateShareResponse
from ..models import Document
from ..models import DocumentEntityListing
from ..models import DocumentUpdate
from ..models import DocumentUpload
from ..models import DownloadResponse
from ..models import ErrorBody
from ..models import QueryRequest
from ..models import QueryResults
from ..models import ReplaceRequest
from ..models import ReplaceResponse
from ..models import SecurityProfile
from ..models import SecurityProfileEntityListing
from ..models import Share
from ..models import ShareEntityListing
from ..models import SharedResponse
from ..models import TagQueryRequest
from ..models import TagValue
from ..models import TagValueEntityListing
from ..models import Usage
from ..models import Workspace
from ..models import WorkspaceCreate
from ..models import WorkspaceEntityListing
from ..models import WorkspaceMember
from ..models import WorkspaceMemberEntityListing

class ContentManagementApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_contentmanagement_document(self, document_id: str, **kwargs) -> None:
        """
        Delete a document.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_contentmanagement_document(document_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param bool override: Override any lock on the document
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'override']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_contentmanagement_document" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `delete_contentmanagement_document`")


        resource_path = '/api/v2/contentmanagement/documents/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']

        query_params = {}
        if 'override' in params:
            query_params['override'] = params['override']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_contentmanagement_share(self, share_id: str, **kwargs) -> None:
        """
        Deletes an existing share.
        This revokes sharing rights specified in the share record

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_contentmanagement_share(share_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str share_id: Share ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['share_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_contentmanagement_share" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'share_id' is set
        if ('share_id' not in params) or (params['share_id'] is None):
            raise ValueError("Missing the required parameter `share_id` when calling `delete_contentmanagement_share`")


        resource_path = '/api/v2/contentmanagement/shares/{shareId}'.replace('{format}', 'json')
        path_params = {}
        if 'share_id' in params:
            path_params['shareId'] = params['share_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_contentmanagement_status_status_id(self, status_id: str, **kwargs) -> None:
        """
        Cancel the command for this status
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_contentmanagement_status_status_id(status_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str status_id: Status ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_contentmanagement_status_status_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'status_id' is set
        if ('status_id' not in params) or (params['status_id'] is None):
            raise ValueError("Missing the required parameter `status_id` when calling `delete_contentmanagement_status_status_id`")


        resource_path = '/api/v2/contentmanagement/status/{statusId}'.replace('{format}', 'json')
        path_params = {}
        if 'status_id' in params:
            path_params['statusId'] = params['status_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_contentmanagement_workspace(self, workspace_id: str, **kwargs) -> None:
        """
        Delete a workspace
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_contentmanagement_workspace(workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str move_children_to_workspace_id: New location for objects in deleted workspace.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'move_children_to_workspace_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_contentmanagement_workspace" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `delete_contentmanagement_workspace`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'move_children_to_workspace_id' in params:
            query_params['moveChildrenToWorkspaceId'] = params['move_children_to_workspace_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_contentmanagement_workspace_member(self, workspace_id: str, member_id: str, **kwargs) -> None:
        """
        Delete a member from a workspace
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_contentmanagement_workspace_member(workspace_id, member_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str member_id: Member ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'member_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_contentmanagement_workspace_member" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `delete_contentmanagement_workspace_member`")
        # verify the required parameter 'member_id' is set
        if ('member_id' not in params) or (params['member_id'] is None):
            raise ValueError("Missing the required parameter `member_id` when calling `delete_contentmanagement_workspace_member`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']
        if 'member_id' in params:
            path_params['memberId'] = params['member_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_contentmanagement_workspace_tagvalue(self, workspace_id: str, tag_id: str, **kwargs) -> None:
        """
        Delete workspace tag
        Delete a tag from a workspace. Will remove this tag from all documents.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_contentmanagement_workspace_tagvalue(workspace_id, tag_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str tag_id: Tag ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'tag_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_contentmanagement_workspace_tagvalue" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `delete_contentmanagement_workspace_tagvalue`")
        # verify the required parameter 'tag_id' is set
        if ('tag_id' not in params) or (params['tag_id'] is None):
            raise ValueError("Missing the required parameter `tag_id` when calling `delete_contentmanagement_workspace_tagvalue`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_document(self, document_id: str, **kwargs) -> 'Document':
        """
        Get a document.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_document(document_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param list[str] expand: Which fields, if any, to expand.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_document" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_contentmanagement_document`")


        resource_path = '/api/v2/contentmanagement/documents/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Document',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_document_content(self, document_id: str, **kwargs) -> 'DownloadResponse':
        """
        Download a document.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_document_content(document_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param str disposition: Request how the content will be downloaded: a file attachment or inline. Default is attachment.
        :param str content_type: The requested format for the specified document. If supported, the document will be returned in that format. Example contentType=audio/wav
        :return: DownloadResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'disposition', 'content_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_document_content" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `get_contentmanagement_document_content`")


        resource_path = '/api/v2/contentmanagement/documents/{documentId}/content'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']

        query_params = {}
        if 'disposition' in params:
            query_params['disposition'] = params['disposition']
        if 'content_type' in params:
            query_params['contentType'] = params['content_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DownloadResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    @deprecated("get_contentmanagement_documents is deprecated")
    def get_contentmanagement_documents(self, workspace_id: str, **kwargs) -> 'DocumentEntityListing':
        """
        Get a list of documents.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_documents(workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str name: Name
        :param list[str] expand: Which fields, if any, to expand.
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: name or dateCreated
        :param str sort_order: ascending or descending
        :return: DocumentEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'name', 'expand', 'page_size', 'page_number', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_documents" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_contentmanagement_documents`")


        resource_path = '/api/v2/contentmanagement/documents'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'workspace_id' in params:
            query_params['workspaceId'] = params['workspace_id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DocumentEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_query(self, query_phrase: str, **kwargs) -> 'QueryResults':
        """
        Query content
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_query(query_phrase, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str query_phrase: Phrase tokens are ANDed together over all searchable fields (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: name or dateCreated
        :param str sort_order: ascending or descending
        :param list[str] expand: Which fields, if any, to expand.
        :return: QueryResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query_phrase', 'page_size', 'page_number', 'sort_by', 'sort_order', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'query_phrase' is set
        if ('query_phrase' not in params) or (params['query_phrase'] is None):
            raise ValueError("Missing the required parameter `query_phrase` when calling `get_contentmanagement_query`")


        resource_path = '/api/v2/contentmanagement/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'query_phrase' in params:
            query_params['queryPhrase'] = params['query_phrase']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueryResults',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_securityprofile(self, security_profile_id: str, **kwargs) -> 'SecurityProfile':
        """
        Get a Security Profile
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_securityprofile(security_profile_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str security_profile_id: Security Profile Id (required)
        :return: SecurityProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['security_profile_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_securityprofile" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'security_profile_id' is set
        if ('security_profile_id' not in params) or (params['security_profile_id'] is None):
            raise ValueError("Missing the required parameter `security_profile_id` when calling `get_contentmanagement_securityprofile`")


        resource_path = '/api/v2/contentmanagement/securityprofiles/{securityProfileId}'.replace('{format}', 'json')
        path_params = {}
        if 'security_profile_id' in params:
            path_params['securityProfileId'] = params['security_profile_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SecurityProfile',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_securityprofiles(self, **kwargs) -> 'SecurityProfileEntityListing':
        """
        Get a List of Security Profiles
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_securityprofiles(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SecurityProfileEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_securityprofiles" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/contentmanagement/securityprofiles'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SecurityProfileEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_share(self, share_id: str, **kwargs) -> 'Share':
        """
        Retrieve details about an existing share.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_share(share_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str share_id: Share ID (required)
        :param list[str] expand: Which fields, if any, to expand.
        :return: Share
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['share_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_share" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'share_id' is set
        if ('share_id' not in params) or (params['share_id'] is None):
            raise ValueError("Missing the required parameter `share_id` when calling `get_contentmanagement_share`")


        resource_path = '/api/v2/contentmanagement/shares/{shareId}'.replace('{format}', 'json')
        path_params = {}
        if 'share_id' in params:
            path_params['shareId'] = params['share_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Share',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_shared_shared_id(self, shared_id: str, **kwargs) -> 'SharedResponse':
        """
        Get shared documents. Securely download a shared document.
        This method requires the download sharing URI obtained in the get document response (downloadSharingUri). Documents may be shared between users in the same workspace. Documents may also be shared between any user by creating a content management share.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_shared_shared_id(shared_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str shared_id: Shared ID (required)
        :param str disposition: Request how the share content will be downloaded: attached as a file or inline. Default is attachment.
        :param str content_type: The requested format for the specified document. If supported, the document will be returned in that format. Example contentType=audio/wav
        :param str expand: Expand some document fields
        :return: SharedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['shared_id', 'disposition', 'content_type', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_shared_shared_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'shared_id' is set
        if ('shared_id' not in params) or (params['shared_id'] is None):
            raise ValueError("Missing the required parameter `shared_id` when calling `get_contentmanagement_shared_shared_id`")


        resource_path = '/api/v2/contentmanagement/shared/{sharedId}'.replace('{format}', 'json')
        path_params = {}
        if 'shared_id' in params:
            path_params['sharedId'] = params['shared_id']

        query_params = {}
        if 'disposition' in params:
            query_params['disposition'] = params['disposition']
        if 'content_type' in params:
            query_params['contentType'] = params['content_type']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SharedResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_shares(self, **kwargs) -> 'ShareEntityListing':
        """
        Gets a list of shares.  You must specify at least one filter (e.g. entityId).
        Failing to specify a filter will return 400.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_shares(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str entity_id: Filters the shares returned to only the entity specified by the value of this parameter.
        :param list[str] expand: Which fields, if any, to expand.
        :param int page_size: Page size
        :param int page_number: Page number
        :return: ShareEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entity_id', 'expand', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_shares" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/contentmanagement/shares'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'entity_id' in params:
            query_params['entityId'] = params['entity_id']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ShareEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_status(self, **kwargs) -> 'CommandStatusEntityListing':
        """
        Get a list of statuses for pending operations
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_status(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: CommandStatusEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_status" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/contentmanagement/status'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CommandStatusEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_status_status_id(self, status_id: str, **kwargs) -> 'CommandStatus':
        """
        Get a status.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_status_status_id(status_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str status_id: Status ID (required)
        :return: CommandStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['status_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_status_status_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'status_id' is set
        if ('status_id' not in params) or (params['status_id'] is None):
            raise ValueError("Missing the required parameter `status_id` when calling `get_contentmanagement_status_status_id`")


        resource_path = '/api/v2/contentmanagement/status/{statusId}'.replace('{format}', 'json')
        path_params = {}
        if 'status_id' in params:
            path_params['statusId'] = params['status_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CommandStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_usage(self, **kwargs) -> 'Usage':
        """
        Get usage details.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_usage(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: Usage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_usage" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/contentmanagement/usage'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Usage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_workspace(self, workspace_id: str, **kwargs) -> 'Workspace':
        """
        Get a workspace.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_workspace(workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param list[str] expand: Which fields, if any, to expand.
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_workspace" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_contentmanagement_workspace`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workspace',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_workspace_documents(self, workspace_id: str, **kwargs) -> 'DocumentEntityListing':
        """
        Get a list of documents.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_workspace_documents(workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param list[str] expand: Which fields, if any, to expand.
        :param int page_size: Page size
        :param int page_number: Page number
        :param str sort_by: name or dateCreated
        :param str sort_order: ascending or descending
        :return: DocumentEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'expand', 'page_size', 'page_number', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_workspace_documents" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_contentmanagement_workspace_documents`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/documents'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DocumentEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_workspace_member(self, workspace_id: str, member_id: str, **kwargs) -> 'WorkspaceMember':
        """
        Get a workspace member
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_workspace_member(workspace_id, member_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str member_id: Member ID (required)
        :param list[str] expand: Which fields, if any, to expand.
        :return: WorkspaceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'member_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_workspace_member" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_contentmanagement_workspace_member`")
        # verify the required parameter 'member_id' is set
        if ('member_id' not in params) or (params['member_id'] is None):
            raise ValueError("Missing the required parameter `member_id` when calling `get_contentmanagement_workspace_member`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']
        if 'member_id' in params:
            path_params['memberId'] = params['member_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkspaceMember',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_workspace_members(self, workspace_id: str, **kwargs) -> 'WorkspaceMemberEntityListing':
        """
        Get a list workspace members
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_workspace_members(workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :param list[str] expand: Which fields, if any, to expand.
        :return: WorkspaceMemberEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'page_size', 'page_number', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_workspace_members" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_contentmanagement_workspace_members`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/members'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkspaceMemberEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_workspace_tagvalue(self, workspace_id: str, tag_id: str, **kwargs) -> 'TagValue':
        """
        Get a workspace tag
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_workspace_tagvalue(workspace_id, tag_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str tag_id: Tag ID (required)
        :param list[str] expand: Which fields, if any, to expand.
        :return: TagValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'tag_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_workspace_tagvalue" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_contentmanagement_workspace_tagvalue`")
        # verify the required parameter 'tag_id' is set
        if ('tag_id' not in params) or (params['tag_id'] is None):
            raise ValueError("Missing the required parameter `tag_id` when calling `get_contentmanagement_workspace_tagvalue`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TagValue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_workspace_tagvalues(self, workspace_id: str, **kwargs) -> 'TagValueEntityListing':
        """
        Get a list of workspace tags
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_workspace_tagvalues(workspace_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str value: filter the list of tags returned
        :param int page_size: Page size
        :param int page_number: Page number
        :param list[str] expand: Which fields, if any, to expand.
        :return: TagValueEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'value', 'page_size', 'page_number', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_workspace_tagvalues" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `get_contentmanagement_workspace_tagvalues`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'value' in params:
            query_params['value'] = params['value']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TagValueEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_contentmanagement_workspaces(self, **kwargs) -> 'WorkspaceEntityListing':
        """
        Get a list of workspaces.
        Specifying 'content' access will return all workspaces the user has document access to, while 'admin' access will return all group workspaces the user has administrative rights to.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_contentmanagement_workspaces(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param list[str] access: Requested access level.
        :param list[str] expand: Which fields, if any, to expand.
        :return: WorkspaceEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'access', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contentmanagement_workspaces" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/contentmanagement/workspaces'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'access' in params:
            query_params['access'] = params['access']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkspaceEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_contentmanagement_document(self, document_id: str, body: 'DocumentUpdate', **kwargs) -> 'Document':
        """
        Update a document.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_contentmanagement_document(document_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param DocumentUpdate body: Document (required)
        :param str expand: Expand some document fields
        :param bool override: Override any lock on the document
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'body', 'expand', 'override']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_contentmanagement_document" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `post_contentmanagement_document`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_contentmanagement_document`")


        resource_path = '/api/v2/contentmanagement/documents/{documentId}'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'override' in params:
            query_params['override'] = params['override']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Document',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_contentmanagement_document_content(self, document_id: str, body: 'ReplaceRequest', **kwargs) -> 'ReplaceResponse':
        """
        Replace the contents of a document.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_contentmanagement_document_content(document_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str document_id: Document ID (required)
        :param ReplaceRequest body: Replace Request (required)
        :param bool override: Override any lock on the document
        :return: ReplaceResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['document_id', 'body', 'override']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_contentmanagement_document_content" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'document_id' is set
        if ('document_id' not in params) or (params['document_id'] is None):
            raise ValueError("Missing the required parameter `document_id` when calling `post_contentmanagement_document_content`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_contentmanagement_document_content`")


        resource_path = '/api/v2/contentmanagement/documents/{documentId}/content'.replace('{format}', 'json')
        path_params = {}
        if 'document_id' in params:
            path_params['documentId'] = params['document_id']

        query_params = {}
        if 'override' in params:
            query_params['override'] = params['override']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ReplaceResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_contentmanagement_documents(self, body: 'DocumentUpload', **kwargs) -> 'Document':
        """
        Add a document.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_contentmanagement_documents(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DocumentUpload body: Document (required)
        :param str copy_source: Copy a document within a workspace or to a new workspace. Provide a document ID as the copy source.
        :param str move_source: Move a document to a new workspace. Provide a document ID as the move source.
        :param bool override: Override any lock on the source document
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'copy_source', 'move_source', 'override']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_contentmanagement_documents" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_contentmanagement_documents`")


        resource_path = '/api/v2/contentmanagement/documents'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'copy_source' in params:
            query_params['copySource'] = params['copy_source']
        if 'move_source' in params:
            query_params['moveSource'] = params['move_source']
        if 'override' in params:
            query_params['override'] = params['override']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Document',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_contentmanagement_query(self, body: 'QueryRequest', **kwargs) -> 'QueryResults':
        """
        Query content
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_contentmanagement_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param QueryRequest body: Allows for a filtered query returning facet information (required)
        :param str expand: Expand some document fields
        :return: QueryResults
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_contentmanagement_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_contentmanagement_query`")


        resource_path = '/api/v2/contentmanagement/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='QueryResults',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_contentmanagement_shares(self, body: 'CreateShareRequest', **kwargs) -> 'CreateShareResponse':
        """
        Creates a new share or updates an existing share if the entity has already been shared
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_contentmanagement_shares(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateShareRequest body: CreateShareRequest - entity id and type and a single member or list of members are required (required)
        :return: CreateShareResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_contentmanagement_shares" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_contentmanagement_shares`")


        resource_path = '/api/v2/contentmanagement/shares'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CreateShareResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_contentmanagement_workspace_tagvalues(self, workspace_id: str, body: 'TagValue', **kwargs) -> 'TagValue':
        """
        Create a workspace tag
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_contentmanagement_workspace_tagvalues(workspace_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param TagValue body: tag (required)
        :return: TagValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_contentmanagement_workspace_tagvalues" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `post_contentmanagement_workspace_tagvalues`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_contentmanagement_workspace_tagvalues`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TagValue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_contentmanagement_workspace_tagvalues_query(self, workspace_id: str, body: 'TagQueryRequest', **kwargs) -> 'TagValueEntityListing':
        """
        Perform a prefix query on tags in the workspace
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_contentmanagement_workspace_tagvalues_query(workspace_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param TagQueryRequest body: query (required)
        :param list[str] expand: Which fields, if any, to expand.
        :return: TagValueEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_contentmanagement_workspace_tagvalues_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `post_contentmanagement_workspace_tagvalues_query`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_contentmanagement_workspace_tagvalues_query`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/query'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TagValueEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_contentmanagement_workspaces(self, body: 'WorkspaceCreate', **kwargs) -> 'Workspace':
        """
        Create a group workspace
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_contentmanagement_workspaces(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WorkspaceCreate body: Workspace (required)
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_contentmanagement_workspaces" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_contentmanagement_workspaces`")


        resource_path = '/api/v2/contentmanagement/workspaces'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workspace',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_contentmanagement_workspace(self, workspace_id: str, body: 'Workspace', **kwargs) -> 'Workspace':
        """
        Update a workspace
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_contentmanagement_workspace(workspace_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param Workspace body: Workspace (required)
        :return: Workspace
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_contentmanagement_workspace" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `put_contentmanagement_workspace`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_contentmanagement_workspace`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Workspace',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_contentmanagement_workspace_member(self, workspace_id: str, member_id: str, body: 'WorkspaceMember', **kwargs) -> 'WorkspaceMember':
        """
        Add a member to a workspace
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_contentmanagement_workspace_member(workspace_id, member_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str member_id: Member ID (required)
        :param WorkspaceMember body: Workspace Member (required)
        :return: WorkspaceMember
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'member_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_contentmanagement_workspace_member" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `put_contentmanagement_workspace_member`")
        # verify the required parameter 'member_id' is set
        if ('member_id' not in params) or (params['member_id'] is None):
            raise ValueError("Missing the required parameter `member_id` when calling `put_contentmanagement_workspace_member`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_contentmanagement_workspace_member`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/members/{memberId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']
        if 'member_id' in params:
            path_params['memberId'] = params['member_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WorkspaceMember',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_contentmanagement_workspace_tagvalue(self, workspace_id: str, tag_id: str, body: 'TagValue', **kwargs) -> 'TagValue':
        """
        Update a workspace tag. Will update all documents with the new tag value.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_contentmanagement_workspace_tagvalue(workspace_id, tag_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str workspace_id: Workspace ID (required)
        :param str tag_id: Tag ID (required)
        :param TagValue body: Workspace (required)
        :return: TagValue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workspace_id', 'tag_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_contentmanagement_workspace_tagvalue" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'workspace_id' is set
        if ('workspace_id' not in params) or (params['workspace_id'] is None):
            raise ValueError("Missing the required parameter `workspace_id` when calling `put_contentmanagement_workspace_tagvalue`")
        # verify the required parameter 'tag_id' is set
        if ('tag_id' not in params) or (params['tag_id'] is None):
            raise ValueError("Missing the required parameter `tag_id` when calling `put_contentmanagement_workspace_tagvalue`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_contentmanagement_workspace_tagvalue`")


        resource_path = '/api/v2/contentmanagement/workspaces/{workspaceId}/tagvalues/{tagId}'.replace('{format}', 'json')
        path_params = {}
        if 'workspace_id' in params:
            path_params['workspaceId'] = params['workspace_id']
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TagValue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
