# coding: utf-8

"""
ArchitectApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import ArchitectExportJobStateResponse
from ..models import ArchitectJobStateResponse
from ..models import ConsumedResourcesEntityListing
from ..models import ConsumingResourcesEntityListing
from ..models import CriteriaQuery
from ..models import DataTable
from ..models import DataTableExportJob
from ..models import DataTableImportEntityListing
from ..models import DataTableImportJob
from ..models import DataTableRowEntityListing
from ..models import DataTablesDomainEntityListing
from ..models import DependencyObject
from ..models import DependencyObjectEntityListing
from ..models import DependencyStatus
from ..models import DependencyType
from ..models import DependencyTypeEntityListing
from ..models import EmergencyGroup
from ..models import EmergencyGroupDivisionViewEntityListing
from ..models import EmergencyGroupListing
from ..models import ErrorBody
from ..models import ExecutionDataFlowSettingsResponse
from ..models import ExecutionDataRequest
from ..models import ExecutionDataSettingsRequest
from ..models import Flow
from ..models import FlowDivisionViewEntityListing
from ..models import FlowEntityListing
from ..models import FlowExecutionLaunchRequest
from ..models import FlowExecutionLaunchResponse
from ..models import FlowHealth
from ..models import FlowHealthIntent
from ..models import FlowHealthUtterance
from ..models import FlowLogLevelCharacteristicsDefinitions
from ..models import FlowLogLevelRequest
from ..models import FlowMilestone
from ..models import FlowMilestoneDivisionViewEntityListing
from ..models import FlowMilestoneListing
from ..models import FlowOutcome
from ..models import FlowOutcomeDivisionViewEntityListing
from ..models import FlowOutcomeListing
from ..models import FlowResultEntityListing
from ..models import FlowRuntimeExecution
from ..models import FlowSettingsResponse
from ..models import FlowSettingsResponseEntityListing
from ..models import FlowVersion
from ..models import FlowVersionEntityListing
from ..models import FlowsQueryCriteriaResponse
from ..models import GetFlowExecutionDataJobResult
from ..models import Grammar
from ..models import GrammarFileUploadRequest
from ..models import GrammarLanguage
from ..models import GrammarLanguageUpdate
from ..models import GrammarListing
from ..models import HistoryListing
from ..models import IVR
from ..models import IVRDivisionViewEntityListing
from ..models import IVREntityListing
from ..models import IdentityResolutionConfig
from ..models import Operation
from ..models import Prompt
from ..models import PromptAsset
from ..models import PromptAssetCreate
from ..models import PromptAssetEntityListing
from ..models import PromptAssetUpload
from ..models import PromptEntityListing
from ..models import RegisterArchitectExportJob
from ..models import RegisterArchitectExportJobResponse
from ..models import RegisterArchitectJobResponse
from ..models import Schedule
from ..models import ScheduleDivisionViewEntityListing
from ..models import ScheduleEntityListing
from ..models import ScheduleGroup
from ..models import ScheduleGroupDivisionViewEntityListing
from ..models import ScheduleGroupEntityListing
from ..models import SystemPrompt
from ..models import SystemPromptAsset
from ..models import SystemPromptAssetEntityListing
from ..models import SystemPromptEntityListing
from ..models import UploadUrlResponse

class ArchitectApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_architect_emergencygroup(self, emergency_group_id: str, **kwargs) -> None:
        """
        Deletes a emergency group by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_emergencygroup(emergency_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str emergency_group_id: Emergency group ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['emergency_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_emergencygroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'emergency_group_id' is set
        if ('emergency_group_id' not in params) or (params['emergency_group_id'] is None):
            raise ValueError("Missing the required parameter `emergency_group_id` when calling `delete_architect_emergencygroup`")


        resource_path = '/api/v2/architect/emergencygroups/{emergencyGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'emergency_group_id' in params:
            path_params['emergencyGroupId'] = params['emergency_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_grammar(self, grammar_id: str, **kwargs) -> object:
        """
        Delete a grammar.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_grammar(grammar_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str grammar_id: grammar ID (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grammar_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_grammar" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'grammar_id' is set
        if ('grammar_id' not in params) or (params['grammar_id'] is None):
            raise ValueError("Missing the required parameter `grammar_id` when calling `delete_architect_grammar`")


        resource_path = '/api/v2/architect/grammars/{grammarId}'.replace('{format}', 'json')
        path_params = {}
        if 'grammar_id' in params:
            path_params['grammarId'] = params['grammar_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_grammar_language(self, grammar_id: str, language_code: str, **kwargs) -> None:
        """
        Delete specified grammar language
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_grammar_language(grammar_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str grammar_id: Grammar ID (required)
        :param str language_code: Language (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grammar_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_grammar_language" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'grammar_id' is set
        if ('grammar_id' not in params) or (params['grammar_id'] is None):
            raise ValueError("Missing the required parameter `grammar_id` when calling `delete_architect_grammar_language`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_architect_grammar_language`")


        resource_path = '/api/v2/architect/grammars/{grammarId}/languages/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'grammar_id' in params:
            path_params['grammarId'] = params['grammar_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_grammar_language_files_dtmf(self, grammar_id: str, language_code: str, **kwargs) -> None:
        """
        Clear the DTMF mode file for the grammar language if there is one
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_grammar_language_files_dtmf(grammar_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str grammar_id: Grammar ID (required)
        :param str language_code: Language (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grammar_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_grammar_language_files_dtmf" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'grammar_id' is set
        if ('grammar_id' not in params) or (params['grammar_id'] is None):
            raise ValueError("Missing the required parameter `grammar_id` when calling `delete_architect_grammar_language_files_dtmf`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_architect_grammar_language_files_dtmf`")


        resource_path = '/api/v2/architect/grammars/{grammarId}/languages/{languageCode}/files/dtmf'.replace('{format}', 'json')
        path_params = {}
        if 'grammar_id' in params:
            path_params['grammarId'] = params['grammar_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_grammar_language_files_voice(self, grammar_id: str, language_code: str, **kwargs) -> None:
        """
        Clear the voice mode file for the grammar language if there is one
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_grammar_language_files_voice(grammar_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str grammar_id: Grammar ID (required)
        :param str language_code: Language (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grammar_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_grammar_language_files_voice" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'grammar_id' is set
        if ('grammar_id' not in params) or (params['grammar_id'] is None):
            raise ValueError("Missing the required parameter `grammar_id` when calling `delete_architect_grammar_language_files_voice`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_architect_grammar_language_files_voice`")


        resource_path = '/api/v2/architect/grammars/{grammarId}/languages/{languageCode}/files/voice'.replace('{format}', 'json')
        path_params = {}
        if 'grammar_id' in params:
            path_params['grammarId'] = params['grammar_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_ivr(self, ivr_id: str, **kwargs) -> None:
        """
        Delete an IVR Config.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_ivr(ivr_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str ivr_id: IVR id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ivr_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_ivr" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'ivr_id' is set
        if ('ivr_id' not in params) or (params['ivr_id'] is None):
            raise ValueError("Missing the required parameter `ivr_id` when calling `delete_architect_ivr`")


        resource_path = '/api/v2/architect/ivrs/{ivrId}'.replace('{format}', 'json')
        path_params = {}
        if 'ivr_id' in params:
            path_params['ivrId'] = params['ivr_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_prompt(self, prompt_id: str, **kwargs) -> None:
        """
        Delete specified user prompt
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_prompt(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param bool all_resources: Whether or not to delete all the prompt resources
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'all_resources']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_prompt" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `delete_architect_prompt`")


        resource_path = '/api/v2/architect/prompts/{promptId}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}
        if 'all_resources' in params:
            query_params['allResources'] = params['all_resources']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_prompt_resource(self, prompt_id: str, language_code: str, **kwargs) -> None:
        """
        Delete specified user prompt resource
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_prompt_resource(prompt_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_prompt_resource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `delete_architect_prompt_resource`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_architect_prompt_resource`")


        resource_path = '/api/v2/architect/prompts/{promptId}/resources/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_prompt_resource_audio(self, prompt_id: str, language_code: str, **kwargs) -> None:
        """
        Delete specified user prompt resource audio
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_prompt_resource_audio(prompt_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_prompt_resource_audio" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `delete_architect_prompt_resource_audio`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_architect_prompt_resource_audio`")


        resource_path = '/api/v2/architect/prompts/{promptId}/resources/{languageCode}/audio'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_prompts(self, id: List['str'], **kwargs) -> 'Operation':
        """
        Batch-delete a list of prompts
        Multiple IDs can be specified, in which case all specified prompts will be deleted.  Asynchronous.  Notification topic: v2.architect.prompts.{promptId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_prompts(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] id: List of Prompt IDs (required)
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_prompts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_architect_prompts`")


        resource_path = '/api/v2/architect/prompts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_schedule(self, schedule_id: str, **kwargs) -> None:
        """
        Delete a schedule by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_schedule(schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schedule_id: Schedule ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `delete_architect_schedule`")


        resource_path = '/api/v2/architect/schedules/{scheduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_schedulegroup(self, schedule_group_id: str, **kwargs) -> None:
        """
        Deletes a schedule group by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_schedulegroup(schedule_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schedule_group_id: Schedule group ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_schedulegroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schedule_group_id' is set
        if ('schedule_group_id' not in params) or (params['schedule_group_id'] is None):
            raise ValueError("Missing the required parameter `schedule_group_id` when calling `delete_architect_schedulegroup`")


        resource_path = '/api/v2/architect/schedulegroups/{scheduleGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'schedule_group_id' in params:
            path_params['scheduleGroupId'] = params['schedule_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_systemprompt_resource(self, prompt_id: str, language_code: str, **kwargs) -> None:
        """
        Delete a system prompt resource override.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_systemprompt_resource(prompt_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_systemprompt_resource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `delete_architect_systemprompt_resource`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_architect_systemprompt_resource`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_flow(self, flow_id: str, **kwargs) -> None:
        """
        Delete flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flow(flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flow" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `delete_flow`")


        resource_path = '/api/v2/flows/{flowId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_flow_instances_settings_loglevels(self, flow_id: str, **kwargs) -> None:
        """
        Deletes a log level for a flow by flow id.
        Deletes the associated log level for a flow by flow id

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flow_instances_settings_loglevels(flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: The flow id to delete the loglevel for (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flow_instances_settings_loglevels" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `delete_flow_instances_settings_loglevels`")


        resource_path = '/api/v2/flows/{flowId}/instances/settings/loglevels'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_flows(self, id: List['str'], **kwargs) -> 'Operation':
        """
        Batch-delete a list of flows
        Multiple IDs can be specified, in which case all specified flows will be deleted.  Asynchronous.  Notification topic: v2.flows.{flowId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flows(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] id: List of Flow IDs (required)
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flows" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_flows`")


        resource_path = '/api/v2/flows'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_flows_datatable(self, datatable_id: str, **kwargs) -> None:
        """
        deletes a specific datatable by id
        Deletes an entire datatable (including the schema and data) with a given datatableId

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flows_datatable(datatable_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param bool force: force delete, even if in use
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'force']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flows_datatable" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `delete_flows_datatable`")


        resource_path = '/api/v2/flows/datatables/{datatableId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}
        if 'force' in params:
            query_params['force'] = params['force']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_flows_datatable_row(self, datatable_id: str, row_id: str, **kwargs) -> None:
        """
        Delete a row entry
        Deletes a row with a given rowId (the value of the key field).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flows_datatable_row(datatable_id, row_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str row_id: the key for the row (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'row_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flows_datatable_row" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `delete_flows_datatable_row`")
        # verify the required parameter 'row_id' is set
        if ('row_id' not in params) or (params['row_id'] is None):
            raise ValueError("Missing the required parameter `row_id` when calling `delete_flows_datatable_row`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/rows/{rowId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']
        if 'row_id' in params:
            path_params['rowId'] = params['row_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_flows_instances_settings_loglevels_default(self, **kwargs) -> None:
        """
        Resets the org log level to default, base
        Resets the org log level to default, base

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flows_instances_settings_loglevels_default(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flows_instances_settings_loglevels_default" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/instances/settings/loglevels/default'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_flows_milestone(self, milestone_id: str, **kwargs) -> object:
        """
        Delete a flow milestone.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flows_milestone(milestone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str milestone_id: flow milestone ID (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['milestone_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flows_milestone" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'milestone_id' is set
        if ('milestone_id' not in params) or (params['milestone_id'] is None):
            raise ValueError("Missing the required parameter `milestone_id` when calling `delete_flows_milestone`")


        resource_path = '/api/v2/flows/milestones/{milestoneId}'.replace('{format}', 'json')
        path_params = {}
        if 'milestone_id' in params:
            path_params['milestoneId'] = params['milestone_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking(self, name: str, **kwargs) -> 'DependencyObjectEntityListing':
        """
        Get Dependency Tracking objects that have a given display name
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Object name to search for (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param list[str] object_type: Object type(s) to search for
        :param bool consumed_resources: Include resources each result item consumes
        :param bool consuming_resources: Include resources that consume each result item
        :param list[str] consumed_resource_type: Types of consumed resources to return, if consumed resources are requested
        :param list[str] consuming_resource_type: Types of consuming resources to return, if consuming resources are requested
        :return: DependencyObjectEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'page_size', 'object_type', 'consumed_resources', 'consuming_resources', 'consumed_resource_type', 'consuming_resource_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_architect_dependencytracking`")


        resource_path = '/api/v2/architect/dependencytracking'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'object_type' in params:
            query_params['objectType'] = params['object_type']
        if 'consumed_resources' in params:
            query_params['consumedResources'] = params['consumed_resources']
        if 'consuming_resources' in params:
            query_params['consumingResources'] = params['consuming_resources']
        if 'consumed_resource_type' in params:
            query_params['consumedResourceType'] = params['consumed_resource_type']
        if 'consuming_resource_type' in params:
            query_params['consumingResourceType'] = params['consuming_resource_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyObjectEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_build(self, **kwargs) -> 'DependencyStatus':
        """
        Get Dependency Tracking build status for an organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_build(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DependencyStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_build" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/dependencytracking/build'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_consumedresources(self, id: str, version: str, object_type: str, **kwargs) -> 'ConsumedResourcesEntityListing':
        """
        Get resources that are consumed by a given Dependency Tracking object
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_consumedresources(id, version, object_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Consuming object ID (required)
        :param str version: Consuming object version (required)
        :param str object_type: Consuming object type.  Only versioned types are allowed here. (required)
        :param list[str] resource_type: Types of consumed resources to show
        :param int page_number: Page number
        :param int page_size: Page size
        :return: ConsumedResourcesEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'version', 'object_type', 'resource_type', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_consumedresources" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_architect_dependencytracking_consumedresources`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_architect_dependencytracking_consumedresources`")
        # verify the required parameter 'object_type' is set
        if ('object_type' not in params) or (params['object_type'] is None):
            raise ValueError("Missing the required parameter `object_type` when calling `get_architect_dependencytracking_consumedresources`")


        resource_path = '/api/v2/architect/dependencytracking/consumedresources'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']
        if 'version' in params:
            query_params['version'] = params['version']
        if 'object_type' in params:
            query_params['objectType'] = params['object_type']
        if 'resource_type' in params:
            query_params['resourceType'] = params['resource_type']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ConsumedResourcesEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_consumingresources(self, id: str, object_type: str, **kwargs) -> 'ConsumingResourcesEntityListing':
        """
        Get resources that consume a given Dependency Tracking object
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_consumingresources(id, object_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Consumed object ID (required)
        :param str object_type: Consumed object type (required)
        :param list[str] resource_type: Types of consuming resources to show.  Only versioned types are allowed here.
        :param str version: Object version
        :param int page_number: Page number
        :param int page_size: Page size
        :param str flow_filter: Show only checkedIn or published flows
        :return: ConsumingResourcesEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'object_type', 'resource_type', 'version', 'page_number', 'page_size', 'flow_filter']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_consumingresources" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_architect_dependencytracking_consumingresources`")
        # verify the required parameter 'object_type' is set
        if ('object_type' not in params) or (params['object_type'] is None):
            raise ValueError("Missing the required parameter `object_type` when calling `get_architect_dependencytracking_consumingresources`")


        resource_path = '/api/v2/architect/dependencytracking/consumingresources'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']
        if 'object_type' in params:
            query_params['objectType'] = params['object_type']
        if 'resource_type' in params:
            query_params['resourceType'] = params['resource_type']
        if 'version' in params:
            query_params['version'] = params['version']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'flow_filter' in params:
            query_params['flowFilter'] = params['flow_filter']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ConsumingResourcesEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_deletedresourceconsumers(self, **kwargs) -> 'DependencyObjectEntityListing':
        """
        Get Dependency Tracking objects that consume deleted resources
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_deletedresourceconsumers(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Name to search for
        :param list[str] object_type: Object type(s) to search for
        :param str flow_filter: Show only checkedIn or published flows
        :param bool consumed_resources: Return consumed resources?
        :param list[str] consumed_resource_type: Resource type(s) to return
        :param int page_number: Page number
        :param int page_size: Page size
        :return: DependencyObjectEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'object_type', 'flow_filter', 'consumed_resources', 'consumed_resource_type', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_deletedresourceconsumers" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/dependencytracking/deletedresourceconsumers'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'name' in params:
            query_params['name'] = params['name']
        if 'object_type' in params:
            query_params['objectType'] = params['object_type']
        if 'flow_filter' in params:
            query_params['flowFilter'] = params['flow_filter']
        if 'consumed_resources' in params:
            query_params['consumedResources'] = params['consumed_resources']
        if 'consumed_resource_type' in params:
            query_params['consumedResourceType'] = params['consumed_resource_type']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyObjectEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_object(self, id: str, **kwargs) -> 'DependencyObject':
        """
        Get a Dependency Tracking object
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_object(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Object ID (required)
        :param str version: Object version
        :param str object_type: Object type
        :param bool consumed_resources: Include resources this item consumes
        :param bool consuming_resources: Include resources that consume this item
        :param list[str] consumed_resource_type: Types of consumed resources to return, if consumed resources are requested
        :param list[str] consuming_resource_type: Types of consuming resources to return, if consuming resources are requested
        :param bool consumed_resource_request: Indicate that this is going to look up a consumed resource object
        :return: DependencyObject
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'version', 'object_type', 'consumed_resources', 'consuming_resources', 'consumed_resource_type', 'consuming_resource_type', 'consumed_resource_request']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_object" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_architect_dependencytracking_object`")


        resource_path = '/api/v2/architect/dependencytracking/object'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']
        if 'version' in params:
            query_params['version'] = params['version']
        if 'object_type' in params:
            query_params['objectType'] = params['object_type']
        if 'consumed_resources' in params:
            query_params['consumedResources'] = params['consumed_resources']
        if 'consuming_resources' in params:
            query_params['consumingResources'] = params['consuming_resources']
        if 'consumed_resource_type' in params:
            query_params['consumedResourceType'] = params['consumed_resource_type']
        if 'consuming_resource_type' in params:
            query_params['consumingResourceType'] = params['consuming_resource_type']
        if 'consumed_resource_request' in params:
            query_params['consumedResourceRequest'] = params['consumed_resource_request']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyObject',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_type(self, type_id: str, **kwargs) -> 'DependencyType':
        """
        Get a Dependency Tracking type.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_type(type_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str type_id: Type ID (required)
        :return: DependencyType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_type" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'type_id' is set
        if ('type_id' not in params) or (params['type_id'] is None):
            raise ValueError("Missing the required parameter `type_id` when calling `get_architect_dependencytracking_type`")


        resource_path = '/api/v2/architect/dependencytracking/types/{typeId}'.replace('{format}', 'json')
        path_params = {}
        if 'type_id' in params:
            path_params['typeId'] = params['type_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyType',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_types(self, **kwargs) -> 'DependencyTypeEntityListing':
        """
        Get Dependency Tracking types.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_types(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: DependencyTypeEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_types" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/dependencytracking/types'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyTypeEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_updatedresourceconsumers(self, **kwargs) -> 'DependencyObjectEntityListing':
        """
        Get Dependency Tracking objects that depend on updated resources
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_updatedresourceconsumers(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Name to search for
        :param list[str] object_type: Object type(s) to search for
        :param bool consumed_resources: Return consumed resources?
        :param list[str] consumed_resource_type: Resource type(s) to return
        :param int page_number: Page number
        :param int page_size: Page size
        :return: DependencyObjectEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'object_type', 'consumed_resources', 'consumed_resource_type', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_updatedresourceconsumers" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/dependencytracking/updatedresourceconsumers'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'name' in params:
            query_params['name'] = params['name']
        if 'object_type' in params:
            query_params['objectType'] = params['object_type']
        if 'consumed_resources' in params:
            query_params['consumedResources'] = params['consumed_resources']
        if 'consumed_resource_type' in params:
            query_params['consumedResourceType'] = params['consumed_resource_type']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyObjectEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_emergencygroup(self, emergency_group_id: str, **kwargs) -> 'EmergencyGroup':
        """
        Gets a emergency group by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_emergencygroup(emergency_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str emergency_group_id: Emergency group ID (required)
        :return: EmergencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['emergency_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_emergencygroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'emergency_group_id' is set
        if ('emergency_group_id' not in params) or (params['emergency_group_id'] is None):
            raise ValueError("Missing the required parameter `emergency_group_id` when calling `get_architect_emergencygroup`")


        resource_path = '/api/v2/architect/emergencygroups/{emergencyGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'emergency_group_id' in params:
            path_params['emergencyGroupId'] = params['emergency_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmergencyGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_emergencygroups(self, **kwargs) -> 'EmergencyGroupListing':
        """
        Get a list of emergency groups.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_emergencygroups(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str name: Name of the Emergency Group to filter by.
        :return: EmergencyGroupListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_emergencygroups" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/emergencygroups'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmergencyGroupListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_emergencygroups_divisionviews(self, **kwargs) -> 'EmergencyGroupDivisionViewEntityListing':
        """
        Get a pageable list of basic emergency group objects filterable by query parameters.
        This returns emergency groups consisting of name and division. If one or more IDs are specified, the search will fetch flow outcomes that match the given ID(s) and not use any additional supplied query parameters in the search.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_emergencygroups_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID of the Emergency Groups to filter by.
        :param str name: Name of the Emergency Group to filter by.
        :param list[str] division_id: List of divisionIds on which to filter.
        :return: EmergencyGroupDivisionViewEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_emergencygroups_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/emergencygroups/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmergencyGroupDivisionViewEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_grammar(self, grammar_id: str, **kwargs) -> 'Grammar':
        """
        Get a grammar
        Returns a specified grammar

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_grammar(grammar_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str grammar_id: grammar ID (required)
        :param bool include_file_urls: Include grammar language file URLs
        :return: Grammar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grammar_id', 'include_file_urls']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_grammar" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'grammar_id' is set
        if ('grammar_id' not in params) or (params['grammar_id'] is None):
            raise ValueError("Missing the required parameter `grammar_id` when calling `get_architect_grammar`")


        resource_path = '/api/v2/architect/grammars/{grammarId}'.replace('{format}', 'json')
        path_params = {}
        if 'grammar_id' in params:
            path_params['grammarId'] = params['grammar_id']

        query_params = {}
        if 'include_file_urls' in params:
            query_params['includeFileUrls'] = params['include_file_urls']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Grammar',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_grammar_language(self, grammar_id: str, language_code: str, **kwargs) -> 'GrammarLanguage':
        """
        Get a grammar language.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_grammar_language(grammar_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str grammar_id: Grammar ID (required)
        :param str language_code: Language (required)
        :return: GrammarLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grammar_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_grammar_language" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'grammar_id' is set
        if ('grammar_id' not in params) or (params['grammar_id'] is None):
            raise ValueError("Missing the required parameter `grammar_id` when calling `get_architect_grammar_language`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_architect_grammar_language`")


        resource_path = '/api/v2/architect/grammars/{grammarId}/languages/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'grammar_id' in params:
            path_params['grammarId'] = params['grammar_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GrammarLanguage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_grammars(self, **kwargs) -> 'GrammarListing':
        """
        Get a pageable list of grammars, filtered by query parameters
        Multiple IDs can be specified, in which case all matching grammars will be returned, and no other parameters will be evaluated.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_grammars(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID
        :param str name: Name
        :param str description: Description
        :param str name_or_description: Name or description
        :param bool include_file_urls: Include grammar language file URLs
        :return: GrammarListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'description', 'name_or_description', 'include_file_urls']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_grammars" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/grammars'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'description' in params:
            query_params['description'] = params['description']
        if 'name_or_description' in params:
            query_params['nameOrDescription'] = params['name_or_description']
        if 'include_file_urls' in params:
            query_params['includeFileUrls'] = params['include_file_urls']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GrammarListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_ivr(self, ivr_id: str, **kwargs) -> 'IVR':
        """
        Get an IVR config.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_ivr(ivr_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str ivr_id: IVR id (required)
        :return: IVR
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ivr_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_ivr" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'ivr_id' is set
        if ('ivr_id' not in params) or (params['ivr_id'] is None):
            raise ValueError("Missing the required parameter `ivr_id` when calling `get_architect_ivr`")


        resource_path = '/api/v2/architect/ivrs/{ivrId}'.replace('{format}', 'json')
        path_params = {}
        if 'ivr_id' in params:
            path_params['ivrId'] = params['ivr_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IVR',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_ivr_identityresolution(self, ivr_id: str, **kwargs) -> 'IdentityResolutionConfig':
        """
        Get an IVR IdentityResolutionConfig.
        
	    get_architect_ivr_identityresolution is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_ivr_identityresolution(ivr_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str ivr_id: IVR id (required)
        :return: IdentityResolutionConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ivr_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_ivr_identityresolution" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'ivr_id' is set
        if ('ivr_id' not in params) or (params['ivr_id'] is None):
            raise ValueError("Missing the required parameter `ivr_id` when calling `get_architect_ivr_identityresolution`")


        resource_path = '/api/v2/architect/ivrs/{ivrId}/identityresolution'.replace('{format}', 'json')
        path_params = {}
        if 'ivr_id' in params:
            path_params['ivrId'] = params['ivr_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IdentityResolutionConfig',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_ivrs(self, **kwargs) -> 'IVREntityListing':
        """
        Get IVR configs.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_ivrs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str name: Name of the IVR to filter by.
        :param str dnis: The phone number of the IVR to filter by.
        :param str schedule_group: The Schedule Group of the IVR to filter by.
        :return: IVREntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'name', 'dnis', 'schedule_group']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_ivrs" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/ivrs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'dnis' in params:
            query_params['dnis'] = params['dnis']
        if 'schedule_group' in params:
            query_params['scheduleGroup'] = params['schedule_group']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IVREntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_ivrs_divisionviews(self, **kwargs) -> 'IVRDivisionViewEntityListing':
        """
        Get a pageable list of basic ivr configuration information objects filterable by query parameters.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_ivrs_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID of the IVR to filter by.
        :param str name: Name of the IVR to filter by.
        :param list[str] division_id: List of divisionIds on which to filter.
        :return: IVRDivisionViewEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_ivrs_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/ivrs/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IVRDivisionViewEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_prompt(self, prompt_id: str, **kwargs) -> 'Prompt':
        """
        Get specified user prompt
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_prompt(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param bool include_media_uris: Include the media URIs for each resource
        :param bool include_resources: Include the resources for each system prompt
        :param list[str] language: Filter the resources down to the provided languages
        :return: Prompt
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'include_media_uris', 'include_resources', 'language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_prompt" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_prompt`")


        resource_path = '/api/v2/architect/prompts/{promptId}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}
        if 'include_media_uris' in params:
            query_params['includeMediaUris'] = params['include_media_uris']
        if 'include_resources' in params:
            query_params['includeResources'] = params['include_resources']
        if 'language' in params:
            query_params['language'] = params['language']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Prompt',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_prompt_history_history_id(self, prompt_id: str, history_id: str, **kwargs) -> 'HistoryListing':
        """
        Get generated prompt history
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_prompt_history_history_id(prompt_id, history_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str history_id: History request ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_order: Sort order
        :param str sort_by: Sort by
        :param list[str] action: Flow actions to include (omit to include all)
        :return: HistoryListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'history_id', 'page_number', 'page_size', 'sort_order', 'sort_by', 'action']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_prompt_history_history_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_prompt_history_history_id`")
        # verify the required parameter 'history_id' is set
        if ('history_id' not in params) or (params['history_id'] is None):
            raise ValueError("Missing the required parameter `history_id` when calling `get_architect_prompt_history_history_id`")


        resource_path = '/api/v2/architect/prompts/{promptId}/history/{historyId}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'history_id' in params:
            path_params['historyId'] = params['history_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'action' in params:
            query_params['action'] = params['action']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='HistoryListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_prompt_resource(self, prompt_id: str, language_code: str, **kwargs) -> 'PromptAsset':
        """
        Get specified user prompt resource
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_prompt_resource(prompt_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :return: PromptAsset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_prompt_resource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_prompt_resource`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_architect_prompt_resource`")


        resource_path = '/api/v2/architect/prompts/{promptId}/resources/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PromptAsset',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_prompt_resources(self, prompt_id: str, **kwargs) -> 'PromptAssetEntityListing':
        """
        Get a pageable list of user prompt resources
        The returned list is pageable, and query parameters can be used for filtering.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_prompt_resources(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: PromptAssetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_prompt_resources" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_prompt_resources`")


        resource_path = '/api/v2/architect/prompts/{promptId}/resources'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PromptAssetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_prompts(self, **kwargs) -> 'PromptEntityListing':
        """
        Get a pageable list of user prompts
        The returned list is pageable, and query parameters can be used for filtering.  Multiple names can be specified, in which case all matching prompts will be returned, and no other filters will be evaluated.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_prompts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param list[str] name: Name
        :param str description: Description
        :param str name_or_description: Name or description
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param bool include_media_uris: Include the media URIs for each resource
        :param bool include_resources: Include the resources for each system prompt
        :param list[str] language: Filter the resources down to the provided languages
        :return: PromptEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'name', 'description', 'name_or_description', 'sort_by', 'sort_order', 'include_media_uris', 'include_resources', 'language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_prompts" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/prompts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'description' in params:
            query_params['description'] = params['description']
        if 'name_or_description' in params:
            query_params['nameOrDescription'] = params['name_or_description']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'include_media_uris' in params:
            query_params['includeMediaUris'] = params['include_media_uris']
        if 'include_resources' in params:
            query_params['includeResources'] = params['include_resources']
        if 'language' in params:
            query_params['language'] = params['language']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PromptEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_schedule(self, schedule_id: str, **kwargs) -> 'Schedule':
        """
        Get a schedule by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_schedule(schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schedule_id: Schedule ID (required)
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `get_architect_schedule`")


        resource_path = '/api/v2/architect/schedules/{scheduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Schedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_schedulegroup(self, schedule_group_id: str, **kwargs) -> 'ScheduleGroup':
        """
        Gets a schedule group by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_schedulegroup(schedule_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schedule_group_id: Schedule group ID (required)
        :return: ScheduleGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_schedulegroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schedule_group_id' is set
        if ('schedule_group_id' not in params) or (params['schedule_group_id'] is None):
            raise ValueError("Missing the required parameter `schedule_group_id` when calling `get_architect_schedulegroup`")


        resource_path = '/api/v2/architect/schedulegroups/{scheduleGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'schedule_group_id' in params:
            path_params['scheduleGroupId'] = params['schedule_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_schedulegroups(self, **kwargs) -> 'ScheduleGroupEntityListing':
        """
        Get a list of schedule groups.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_schedulegroups(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str name: Name of the Schedule Group to filter by.
        :param str schedule_ids: A comma-delimited list of Schedule IDs to filter by.
        :param list[str] division_id: List of divisionIds on which to filter.
        :return: ScheduleGroupEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'name', 'schedule_ids', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_schedulegroups" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/schedulegroups'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'schedule_ids' in params:
            query_params['scheduleIds'] = params['schedule_ids']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleGroupEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_schedulegroups_divisionviews(self, **kwargs) -> 'ScheduleGroupDivisionViewEntityListing':
        """
        Get a pageable list of basic schedule group configuration information objects filterable by query parameters.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_schedulegroups_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID of the schedule group to filter by.
        :param str name: Name of the schedule group to filter by.
        :param list[str] division_id: List of divisionIds on which to filter.
        :return: ScheduleGroupDivisionViewEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_schedulegroups_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/schedulegroups/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleGroupDivisionViewEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_schedules(self, **kwargs) -> 'ScheduleEntityListing':
        """
        Get a list of schedules.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_schedules(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str name: Name of the Schedule to filter by.
        :param list[str] division_id: List of divisionIds on which to filter.
        :return: ScheduleEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'name', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_schedules" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/schedules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_schedules_divisionviews(self, **kwargs) -> 'ScheduleDivisionViewEntityListing':
        """
        Get a pageable list of basic schedule configuration information objects filterable by query parameters.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_schedules_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID of the schedule group to filter by.
        :param str name: Name of the schedule group to filter by.
        :param list[str] division_id: List of divisionIds on which to filter.
        :return: ScheduleDivisionViewEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_schedules_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/schedules/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleDivisionViewEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_systemprompt(self, prompt_id: str, **kwargs) -> 'SystemPrompt':
        """
        Get a system prompt
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_systemprompt(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: promptId (required)
        :param bool include_media_uris: Include the media URIs for each resource
        :param bool include_resources: Include the resources for each system prompt
        :param list[str] language: Filter the resources down to the provided languages
        :return: SystemPrompt
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'include_media_uris', 'include_resources', 'language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_systemprompt" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_systemprompt`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}
        if 'include_media_uris' in params:
            query_params['includeMediaUris'] = params['include_media_uris']
        if 'include_resources' in params:
            query_params['includeResources'] = params['include_resources']
        if 'language' in params:
            query_params['language'] = params['language']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SystemPrompt',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_systemprompt_history_history_id(self, prompt_id: str, history_id: str, **kwargs) -> 'HistoryListing':
        """
        Get generated prompt history
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_systemprompt_history_history_id(prompt_id, history_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: promptId (required)
        :param str history_id: History request ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_order: Sort order
        :param str sort_by: Sort by
        :param list[str] action: Flow actions to include (omit to include all)
        :return: HistoryListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'history_id', 'page_number', 'page_size', 'sort_order', 'sort_by', 'action']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_systemprompt_history_history_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_systemprompt_history_history_id`")
        # verify the required parameter 'history_id' is set
        if ('history_id' not in params) or (params['history_id'] is None):
            raise ValueError("Missing the required parameter `history_id` when calling `get_architect_systemprompt_history_history_id`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/history/{historyId}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'history_id' in params:
            path_params['historyId'] = params['history_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'action' in params:
            query_params['action'] = params['action']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='HistoryListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_systemprompt_resource(self, prompt_id: str, language_code: str, **kwargs) -> 'SystemPromptAsset':
        """
        Get a system prompt resource.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_systemprompt_resource(prompt_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :return: SystemPromptAsset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_systemprompt_resource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_systemprompt_resource`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_architect_systemprompt_resource`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SystemPromptAsset',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_systemprompt_resources(self, prompt_id: str, **kwargs) -> 'SystemPromptAssetEntityListing':
        """
        Get system prompt resources.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_systemprompt_resources(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: SystemPromptAssetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'page_number', 'page_size', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_systemprompt_resources" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_systemprompt_resources`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/resources'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SystemPromptAssetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_systemprompts(self, **kwargs) -> 'SystemPromptEntityListing':
        """
        Get System Prompts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_systemprompts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str name: Name
        :param str description: Description
        :param str name_or_description: Name or description
        :param bool include_media_uris: Include the media URIs for each resource
        :param bool include_resources: Include the resources for each system prompt
        :param list[str] language: Filter the resources down to the provided languages
        :return: SystemPromptEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'name', 'description', 'name_or_description', 'include_media_uris', 'include_resources', 'language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_systemprompts" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/systemprompts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'description' in params:
            query_params['description'] = params['description']
        if 'name_or_description' in params:
            query_params['nameOrDescription'] = params['name_or_description']
        if 'include_media_uris' in params:
            query_params['includeMediaUris'] = params['include_media_uris']
        if 'include_resources' in params:
            query_params['includeResources'] = params['include_resources']
        if 'language' in params:
            query_params['language'] = params['language']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SystemPromptEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow(self, flow_id: str, **kwargs) -> 'Flow':
        """
        Get flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow(flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param bool deleted: Deleted flows
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'deleted']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow`")


        resource_path = '/api/v2/flows/{flowId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}
        if 'deleted' in params:
            query_params['deleted'] = params['deleted']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_history_history_id(self, flow_id: str, history_id: str, **kwargs) -> 'HistoryListing':
        """
        Get generated flow history
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_history_history_id(flow_id, history_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param str history_id: History request ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_order: Sort order
        :param str sort_by: Sort by
        :param list[str] action: Flow actions to include (omit to include all)
        :return: HistoryListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'history_id', 'page_number', 'page_size', 'sort_order', 'sort_by', 'action']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_history_history_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_history_history_id`")
        # verify the required parameter 'history_id' is set
        if ('history_id' not in params) or (params['history_id'] is None):
            raise ValueError("Missing the required parameter `history_id` when calling `get_flow_history_history_id`")


        resource_path = '/api/v2/flows/{flowId}/history/{historyId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']
        if 'history_id' in params:
            path_params['historyId'] = params['history_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'action' in params:
            query_params['action'] = params['action']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='HistoryListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_instances_settings_loglevels(self, flow_id: str, **kwargs) -> 'FlowSettingsResponse':
        """
        Retrieves the log level for a flow by flow id.
        Retrieves the log level for a flow by flow id.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_instances_settings_loglevels(flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: The flow id to get the loglevel for (required)
        :param list[str] expand: Expand instructions for the result
        :return: FlowSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_instances_settings_loglevels" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_instances_settings_loglevels`")


        resource_path = '/api/v2/flows/{flowId}/instances/settings/loglevels'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowSettingsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_latestconfiguration(self, flow_id: str, **kwargs) -> object:
        """
        Get the latest configuration for flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_latestconfiguration(flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param bool deleted: Deleted flows
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'deleted']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_latestconfiguration" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_latestconfiguration`")


        resource_path = '/api/v2/flows/{flowId}/latestconfiguration'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}
        if 'deleted' in params:
            query_params['deleted'] = params['deleted']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_version(self, flow_id: str, version_id: str, **kwargs) -> 'FlowVersion':
        """
        Get flow version
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_version(flow_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param str version_id: Version ID (required)
        :param str deleted: Deleted flows
        :return: FlowVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'version_id', 'deleted']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_flow_version`")


        resource_path = '/api/v2/flows/{flowId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}
        if 'deleted' in params:
            query_params['deleted'] = params['deleted']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_version_configuration(self, flow_id: str, version_id: str, **kwargs) -> object:
        """
        Get flow version configuration
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_version_configuration(flow_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param str version_id: Version ID (required)
        :param str deleted: Deleted flows
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'version_id', 'deleted']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_version_configuration" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_version_configuration`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_flow_version_configuration`")


        resource_path = '/api/v2/flows/{flowId}/versions/{versionId}/configuration'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}
        if 'deleted' in params:
            query_params['deleted'] = params['deleted']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_version_health(self, flow_id: str, version_id: str, **kwargs) -> 'FlowHealth':
        """
        Get overall health scores for all intents present in the NLU domain version associated with the bot flow version.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_version_health(flow_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID. (required)
        :param str version_id: Version ID. (required)
        :param str language: Language to filter for
        :return: FlowHealth
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'version_id', 'language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_version_health" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_version_health`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_flow_version_health`")


        resource_path = '/api/v2/flows/{flowId}/versions/{versionId}/health'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}
        if 'language' in params:
            query_params['language'] = params['language']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowHealth',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_version_intent_health(self, flow_id: str, version_id: str, intent_id: str, language: str, **kwargs) -> 'FlowHealthIntent':
        """
        Get health scores and other health metrics for a specific intent. This includes the health metrics for each utterance in an intent.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_version_intent_health(flow_id, version_id, intent_id, language, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID. (required)
        :param str version_id: Version ID. (required)
        :param str intent_id: Intent ID. (required)
        :param str language: Language to filter for (required)
        :return: FlowHealthIntent
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'version_id', 'intent_id', 'language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_version_intent_health" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_version_intent_health`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_flow_version_intent_health`")
        # verify the required parameter 'intent_id' is set
        if ('intent_id' not in params) or (params['intent_id'] is None):
            raise ValueError("Missing the required parameter `intent_id` when calling `get_flow_version_intent_health`")
        # verify the required parameter 'language' is set
        if ('language' not in params) or (params['language'] is None):
            raise ValueError("Missing the required parameter `language` when calling `get_flow_version_intent_health`")


        resource_path = '/api/v2/flows/{flowId}/versions/{versionId}/intents/{intentId}/health'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']
        if 'intent_id' in params:
            path_params['intentId'] = params['intent_id']

        query_params = {}
        if 'language' in params:
            query_params['language'] = params['language']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowHealthIntent',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_version_intent_utterance_health(self, flow_id: str, version_id: str, intent_id: str, utterance_id: str, language: str, **kwargs) -> 'FlowHealthUtterance':
        """
        Get health metrics associated with a specific utterance of an intent.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_version_intent_utterance_health(flow_id, version_id, intent_id, utterance_id, language, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID. (required)
        :param str version_id: Version ID. (required)
        :param str intent_id: Intent ID. (required)
        :param str utterance_id: Utterance ID. (required)
        :param str language: Language to filter for (required)
        :return: FlowHealthUtterance
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'version_id', 'intent_id', 'utterance_id', 'language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_version_intent_utterance_health" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_version_intent_utterance_health`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_flow_version_intent_utterance_health`")
        # verify the required parameter 'intent_id' is set
        if ('intent_id' not in params) or (params['intent_id'] is None):
            raise ValueError("Missing the required parameter `intent_id` when calling `get_flow_version_intent_utterance_health`")
        # verify the required parameter 'utterance_id' is set
        if ('utterance_id' not in params) or (params['utterance_id'] is None):
            raise ValueError("Missing the required parameter `utterance_id` when calling `get_flow_version_intent_utterance_health`")
        # verify the required parameter 'language' is set
        if ('language' not in params) or (params['language'] is None):
            raise ValueError("Missing the required parameter `language` when calling `get_flow_version_intent_utterance_health`")


        resource_path = '/api/v2/flows/{flowId}/versions/{versionId}/intents/{intentId}/utterances/{utteranceId}/health'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']
        if 'intent_id' in params:
            path_params['intentId'] = params['intent_id']
        if 'utterance_id' in params:
            path_params['utteranceId'] = params['utterance_id']

        query_params = {}
        if 'language' in params:
            query_params['language'] = params['language']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowHealthUtterance',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_versions(self, flow_id: str, **kwargs) -> 'FlowVersionEntityListing':
        """
        Get flow version list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_versions(flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param bool deleted: Include Deleted flows
        :return: FlowVersionEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'page_number', 'page_size', 'deleted']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_versions`")


        resource_path = '/api/v2/flows/{flowId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'deleted' in params:
            query_params['deleted'] = params['deleted']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowVersionEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows(self, **kwargs) -> 'FlowEntityListing':
        """
        Get a pageable list of flows, filtered by query parameters
        If one or more IDs are specified, the search will fetch flows that match the given ID(s) and not use any additional supplied query parameters in the search.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] type: Type
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID
        :param str name: Name
        :param str description: Description
        :param str name_or_description: Name or description
        :param str publish_version_id: Publish version ID
        :param str editable_by: Editable by
        :param str locked_by: Locked by
        :param str locked_by_client_id: Locked by client ID
        :param str secure: Secure
        :param bool deleted: Include deleted
        :param bool include_schemas: Include variable schemas
        :param str published_after: Published after
        :param str published_before: Published before
        :param list[str] division_id: division ID(s)
        :return: FlowEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'description', 'name_or_description', 'publish_version_id', 'editable_by', 'locked_by', 'locked_by_client_id', 'secure', 'deleted', 'include_schemas', 'published_after', 'published_before', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'type' in params:
            query_params['type'] = params['type']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'description' in params:
            query_params['description'] = params['description']
        if 'name_or_description' in params:
            query_params['nameOrDescription'] = params['name_or_description']
        if 'publish_version_id' in params:
            query_params['publishVersionId'] = params['publish_version_id']
        if 'editable_by' in params:
            query_params['editableBy'] = params['editable_by']
        if 'locked_by' in params:
            query_params['lockedBy'] = params['locked_by']
        if 'locked_by_client_id' in params:
            query_params['lockedByClientId'] = params['locked_by_client_id']
        if 'secure' in params:
            query_params['secure'] = params['secure']
        if 'deleted' in params:
            query_params['deleted'] = params['deleted']
        if 'include_schemas' in params:
            query_params['includeSchemas'] = params['include_schemas']
        if 'published_after' in params:
            query_params['publishedAfter'] = params['published_after']
        if 'published_before' in params:
            query_params['publishedBefore'] = params['published_before']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatable(self, datatable_id: str, **kwargs) -> 'DataTable':
        """
        Returns a specific datatable by id
        Given a datatableId returns the datatable object and schema associated with it.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatable(datatable_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str expand: Expand instructions for the result
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatable" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `get_flows_datatable`")


        resource_path = '/api/v2/flows/datatables/{datatableId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTable',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatable_export_job(self, datatable_id: str, export_job_id: str, **kwargs) -> 'DataTableExportJob':
        """
        Returns the state information about an export job
        Returns the state information about an export job.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatable_export_job(datatable_id, export_job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str export_job_id: id of export job (required)
        :return: DataTableExportJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'export_job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatable_export_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `get_flows_datatable_export_job`")
        # verify the required parameter 'export_job_id' is set
        if ('export_job_id' not in params) or (params['export_job_id'] is None):
            raise ValueError("Missing the required parameter `export_job_id` when calling `get_flows_datatable_export_job`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/export/jobs/{exportJobId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']
        if 'export_job_id' in params:
            path_params['exportJobId'] = params['export_job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTableExportJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatable_import_job(self, datatable_id: str, import_job_id: str, **kwargs) -> 'DataTableImportJob':
        """
        Returns the state information about an import job
        Returns the state information about an import job.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatable_import_job(datatable_id, import_job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str import_job_id: id of import job (required)
        :return: DataTableImportJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'import_job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatable_import_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `get_flows_datatable_import_job`")
        # verify the required parameter 'import_job_id' is set
        if ('import_job_id' not in params) or (params['import_job_id'] is None):
            raise ValueError("Missing the required parameter `import_job_id` when calling `get_flows_datatable_import_job`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/import/jobs/{importJobId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']
        if 'import_job_id' in params:
            path_params['importJobId'] = params['import_job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTableImportJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatable_import_jobs(self, datatable_id: str, **kwargs) -> 'DataTableImportEntityListing':
        """
        Get all recent import jobs
        Get all recent import jobs

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatable_import_jobs(datatable_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: DataTableImportEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatable_import_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `get_flows_datatable_import_jobs`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/import/jobs'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTableImportEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatable_row(self, datatable_id: str, row_id: str, **kwargs) -> Dict[str, object]:
        """
        Returns a specific row for the datatable
        Given a datatableId and a rowId (the value of the key field) this will return the full row contents for that rowId.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatable_row(datatable_id, row_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str row_id: The key for the row (required)
        :param bool showbrief: if true returns just the key field for the row
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'row_id', 'showbrief']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatable_row" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `get_flows_datatable_row`")
        # verify the required parameter 'row_id' is set
        if ('row_id' not in params) or (params['row_id'] is None):
            raise ValueError("Missing the required parameter `row_id` when calling `get_flows_datatable_row`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/rows/{rowId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']
        if 'row_id' in params:
            path_params['rowId'] = params['row_id']

        query_params = {}
        if 'showbrief' in params:
            query_params['showbrief'] = params['showbrief']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='dict(str, object)',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatable_rows(self, datatable_id: str, **kwargs) -> 'DataTableRowEntityListing':
        """
        Returns the rows for the datatable with the given id
        Returns all of the rows for the datatable with the given datatableId.  By default this will just be a truncated list returning the key for each row. Set showBrief to false to return all of the row contents.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatable_rows(datatable_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param bool showbrief: If true returns just the key value of the row
        :param str sort_order: Sort order
        :return: DataTableRowEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'page_number', 'page_size', 'showbrief', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatable_rows" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `get_flows_datatable_rows`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/rows'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'showbrief' in params:
            query_params['showbrief'] = params['showbrief']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTableRowEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatables(self, **kwargs) -> 'DataTablesDomainEntityListing':
        """
        Retrieve a list of datatables for the org
        Returns a metadata list of the datatables associated with this org, including datatableId, name and description.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatables(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str expand: Expand instructions for the result
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] division_id: division ID(s)
        :param str name: Filter by Name. The wildcard character * is supported within the filter. Matches are case-insensitive.
        :return: DataTablesDomainEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['expand', 'page_number', 'page_size', 'sort_by', 'sort_order', 'division_id', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatables" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/datatables'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTablesDomainEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatables_divisionview(self, datatable_id: str, **kwargs) -> 'DataTable':
        """
        Returns a specific datatable by id
        Given a datatableId returns the datatable object and schema associated with it.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatables_divisionview(datatable_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str expand: Expand instructions for the result
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatables_divisionview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `get_flows_datatables_divisionview`")


        resource_path = '/api/v2/flows/datatables/divisionviews/{datatableId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTable',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatables_divisionviews(self, **kwargs) -> 'DataTablesDomainEntityListing':
        """
        Retrieve a list of datatables for the org
        Returns a metadata list of the datatables associated with this org, including datatableId, name and description.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatables_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str expand: Expand instructions for the result
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] division_id: division ID(s)
        :param str name: Filter by Name. The wildcard character * is supported within the filter. Matches are case-insensitive.
        :return: DataTablesDomainEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['expand', 'page_number', 'page_size', 'sort_by', 'sort_order', 'division_id', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatables_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/datatables/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTablesDomainEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_divisionviews(self, **kwargs) -> 'FlowDivisionViewEntityListing':
        """
        Get a pageable list of basic flow information objects filterable by query parameters.
        This returns a simplified version of /flow consisting of name and type. If one or more IDs are specified, the search will fetch flows that match the given ID(s) and not use any additional supplied query parameters in the search.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] type: Type
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID
        :param str name: Name
        :param str publish_version_id: Publish version ID
        :param str published_after: Published after
        :param str published_before: Published before
        :param list[str] division_id: division ID(s)
        :param bool include_schemas: Include variable schemas
        :return: FlowDivisionViewEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'publish_version_id', 'published_after', 'published_before', 'division_id', 'include_schemas']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'type' in params:
            query_params['type'] = params['type']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'publish_version_id' in params:
            query_params['publishVersionId'] = params['publish_version_id']
        if 'published_after' in params:
            query_params['publishedAfter'] = params['published_after']
        if 'published_before' in params:
            query_params['publishedBefore'] = params['published_before']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']
        if 'include_schemas' in params:
            query_params['includeSchemas'] = params['include_schemas']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowDivisionViewEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_execution(self, flow_execution_id: str, **kwargs) -> 'FlowRuntimeExecution':
        """
        Get a flow execution's details. Flow execution details are available for several days after the flow is started.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_execution(flow_execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_execution_id: flow execution ID (required)
        :return: FlowRuntimeExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_execution_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_execution" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_execution_id' is set
        if ('flow_execution_id' not in params) or (params['flow_execution_id'] is None):
            raise ValueError("Missing the required parameter `flow_execution_id` when calling `get_flows_execution`")


        resource_path = '/api/v2/flows/executions/{flowExecutionId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_execution_id' in params:
            path_params['flowExecutionId'] = params['flow_execution_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowRuntimeExecution',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_export_job(self, job_id: str, **kwargs) -> 'ArchitectExportJobStateResponse':
        """
        Fetch Architect Export Job Status
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_export_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: Job ID (required)
        :param list[str] expand: Which fields, if any, to expand.
        :return: ArchitectExportJobStateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_export_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_flows_export_job`")


        resource_path = '/api/v2/flows/export/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ArchitectExportJobStateResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_instance(self, instance_id: str, **kwargs) -> 'GetFlowExecutionDataJobResult':
        """
        Start a process (job) to prepare a download of a singular flow execution data instance by Id
        Returns a JobResult object that contains an ID that can be used to check status and/or download links when the process (job) is complete.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_instance(instance_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str instance_id: Instance ID (required)
        :param str expand: Expand various details.
        :return: GetFlowExecutionDataJobResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_instance" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params) or (params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `get_flows_instance`")


        resource_path = '/api/v2/flows/instances/{instanceId}'.replace('{format}', 'json')
        path_params = {}
        if 'instance_id' in params:
            path_params['instanceId'] = params['instance_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GetFlowExecutionDataJobResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_instances_job(self, job_id: str, **kwargs) -> 'GetFlowExecutionDataJobResult':
        """
        Get the status and/or results of an asynchronous flow execution data retrieval job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_instances_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The asynchronous job ID (required)
        :return: GetFlowExecutionDataJobResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_instances_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_flows_instances_job`")


        resource_path = '/api/v2/flows/instances/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GetFlowExecutionDataJobResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_instances_querycapabilities(self, **kwargs) -> 'FlowsQueryCriteriaResponse':
        """
        Retrieve a list of capabilities that the org can use to query for execution data
        Returns the queryable parameters that can be used to build a query for execution data.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_instances_querycapabilities(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str expand: Expand various query types.
        :return: FlowsQueryCriteriaResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_instances_querycapabilities" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/instances/querycapabilities'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowsQueryCriteriaResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_instances_settings_executiondata(self, **kwargs) -> 'ExecutionDataFlowSettingsResponse':
        """
        Get the execution history enabled setting.
        Get the execution history enabled setting.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_instances_settings_executiondata(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ExecutionDataFlowSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_instances_settings_executiondata" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/instances/settings/executiondata'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExecutionDataFlowSettingsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_instances_settings_loglevels(self, **kwargs) -> 'FlowSettingsResponseEntityListing':
        """
        Retrieve a list of LogLevels for the organization.
        Returns a paged set of LogLevels per flow id

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_instances_settings_loglevels(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] expand: Expand instructions for the result
        :param int page_number: Page number
        :param int page_size: Number of entities to return. Maximum of 200.
        :return: FlowSettingsResponseEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['expand', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_instances_settings_loglevels" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/instances/settings/loglevels'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowSettingsResponseEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_instances_settings_loglevels_characteristics(self, **kwargs) -> 'FlowLogLevelCharacteristicsDefinitions':
        """
        Gets the available flow log level characteristics for this organization.
        Log levels can be customized and this returns the set of available characteristics that can be enabled/disabled.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_instances_settings_loglevels_characteristics(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: FlowLogLevelCharacteristicsDefinitions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_instances_settings_loglevels_characteristics" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/instances/settings/loglevels/characteristics'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowLogLevelCharacteristicsDefinitions',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_instances_settings_loglevels_default(self, **kwargs) -> 'FlowSettingsResponse':
        """
        Returns the flow default log level.
        Returns the flow default log level which will be used if no specific flow id log level is found.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_instances_settings_loglevels_default(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] expand: Expand instructions for the result
        :return: FlowSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_instances_settings_loglevels_default" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/instances/settings/loglevels/default'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowSettingsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_job(self, job_id: str, **kwargs) -> 'ArchitectJobStateResponse':
        """
        Fetch Architect Job Status
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: Job ID (required)
        :param list[str] expand: Which fields, if any, to expand.
        :return: ArchitectJobStateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_flows_job`")


        resource_path = '/api/v2/flows/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ArchitectJobStateResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_milestone(self, milestone_id: str, **kwargs) -> 'FlowMilestone':
        """
        Get a flow milestone
        Returns a specified flow milestone

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_milestone(milestone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str milestone_id: flow milestone ID (required)
        :return: FlowMilestone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['milestone_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_milestone" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'milestone_id' is set
        if ('milestone_id' not in params) or (params['milestone_id'] is None):
            raise ValueError("Missing the required parameter `milestone_id` when calling `get_flows_milestone`")


        resource_path = '/api/v2/flows/milestones/{milestoneId}'.replace('{format}', 'json')
        path_params = {}
        if 'milestone_id' in params:
            path_params['milestoneId'] = params['milestone_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowMilestone',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_milestones(self, **kwargs) -> 'FlowMilestoneListing':
        """
        Get a pageable list of flow milestones, filtered by query parameters
        Multiple IDs can be specified, in which case all matching flow milestones will be returned, and no other parameters will be evaluated.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_milestones(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID
        :param str name: Name
        :param str description: Description
        :param str name_or_description: Name or description
        :param list[str] division_id: division ID(s)
        :return: FlowMilestoneListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'description', 'name_or_description', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_milestones" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/milestones'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'description' in params:
            query_params['description'] = params['description']
        if 'name_or_description' in params:
            query_params['nameOrDescription'] = params['name_or_description']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowMilestoneListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_milestones_divisionviews(self, **kwargs) -> 'FlowMilestoneDivisionViewEntityListing':
        """
        Get a pageable list of basic flow milestone information objects filterable by query parameters.
        This returns flow milestones consisting of name and division. If one or more IDs are specified, the search will fetch flow milestones that match the given ID(s) and not use any additional supplied query parameters in the search.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_milestones_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID
        :param str name: Name
        :param list[str] division_id: division ID(s)
        :return: FlowMilestoneDivisionViewEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_milestones_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/milestones/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowMilestoneDivisionViewEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_outcome(self, flow_outcome_id: str, **kwargs) -> 'FlowOutcome':
        """
        Get a flow outcome
        Returns a specified flow outcome

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_outcome(flow_outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_outcome_id: flow outcome ID (required)
        :return: FlowOutcome
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_outcome_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_outcome" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_outcome_id' is set
        if ('flow_outcome_id' not in params) or (params['flow_outcome_id'] is None):
            raise ValueError("Missing the required parameter `flow_outcome_id` when calling `get_flows_outcome`")


        resource_path = '/api/v2/flows/outcomes/{flowOutcomeId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_outcome_id' in params:
            path_params['flowOutcomeId'] = params['flow_outcome_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowOutcome',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_outcomes(self, **kwargs) -> 'FlowOutcomeListing':
        """
        Get a pageable list of flow outcomes, filtered by query parameters
        Multiple IDs can be specified, in which case all matching flow outcomes will be returned, and no other parameters will be evaluated.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_outcomes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID
        :param str name: Name
        :param str description: Description
        :param str name_or_description: Name or description
        :param list[str] division_id: division ID(s)
        :return: FlowOutcomeListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'description', 'name_or_description', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_outcomes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/outcomes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'description' in params:
            query_params['description'] = params['description']
        if 'name_or_description' in params:
            query_params['nameOrDescription'] = params['name_or_description']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowOutcomeListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_outcomes_divisionviews(self, **kwargs) -> 'FlowOutcomeDivisionViewEntityListing':
        """
        Get a pageable list of basic flow outcome information objects filterable by query parameters.
        This returns flow outcomes consisting of name and division. If one or more IDs are specified, the search will fetch flow outcomes that match the given ID(s) and not use any additional supplied query parameters in the search.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_outcomes_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID
        :param str name: Name
        :param list[str] division_id: division ID(s)
        :return: FlowOutcomeDivisionViewEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_outcomes_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/outcomes/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowOutcomeDivisionViewEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_architect_grammar(self, grammar_id: str, **kwargs) -> 'Grammar':
        """
        Updates a grammar
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_architect_grammar(grammar_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str grammar_id: grammar ID (required)
        :param Grammar body: 
        :return: Grammar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grammar_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_architect_grammar" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'grammar_id' is set
        if ('grammar_id' not in params) or (params['grammar_id'] is None):
            raise ValueError("Missing the required parameter `grammar_id` when calling `patch_architect_grammar`")


        resource_path = '/api/v2/architect/grammars/{grammarId}'.replace('{format}', 'json')
        path_params = {}
        if 'grammar_id' in params:
            path_params['grammarId'] = params['grammar_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Grammar',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_architect_grammar_language(self, grammar_id: str, language_code: str, **kwargs) -> 'GrammarLanguage':
        """
        Updates a grammar language
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_architect_grammar_language(grammar_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str grammar_id: Grammar ID (required)
        :param str language_code: Language (required)
        :param GrammarLanguageUpdate body: 
        :return: GrammarLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grammar_id', 'language_code', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_architect_grammar_language" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'grammar_id' is set
        if ('grammar_id' not in params) or (params['grammar_id'] is None):
            raise ValueError("Missing the required parameter `grammar_id` when calling `patch_architect_grammar_language`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `patch_architect_grammar_language`")


        resource_path = '/api/v2/architect/grammars/{grammarId}/languages/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'grammar_id' in params:
            path_params['grammarId'] = params['grammar_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GrammarLanguage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_flows_instances_settings_executiondata(self, body: 'ExecutionDataSettingsRequest', **kwargs) -> 'ExecutionDataFlowSettingsResponse':
        """
        Edit the execution history enabled setting.
        Edit the execution history enabled setting.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_flows_instances_settings_executiondata(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExecutionDataSettingsRequest body: New Execution Data Setting (required)
        :return: ExecutionDataFlowSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_flows_instances_settings_executiondata" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_flows_instances_settings_executiondata`")


        resource_path = '/api/v2/flows/instances/settings/executiondata'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExecutionDataFlowSettingsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_dependencytracking_build(self, **kwargs) -> None:
        """
        Rebuild Dependency Tracking data for an organization
        Asynchronous.  Notification topic: v2.architect.dependencytracking.build

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_dependencytracking_build(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_dependencytracking_build" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/dependencytracking/build'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_emergencygroups(self, body: 'EmergencyGroup', **kwargs) -> 'EmergencyGroup':
        """
        Creates a new emergency group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_emergencygroups(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EmergencyGroup body:  (required)
        :return: EmergencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_emergencygroups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_emergencygroups`")


        resource_path = '/api/v2/architect/emergencygroups'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmergencyGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_grammar_language_files_dtmf(self, grammar_id: str, language_code: str, body: 'GrammarFileUploadRequest', **kwargs) -> 'UploadUrlResponse':
        """
        Creates a presigned URL for uploading a grammar DTMF mode file
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_grammar_language_files_dtmf(grammar_id, language_code, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str grammar_id: Grammar ID (required)
        :param str language_code: Language (required)
        :param GrammarFileUploadRequest body: query (required)
        :return: UploadUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grammar_id', 'language_code', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_grammar_language_files_dtmf" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'grammar_id' is set
        if ('grammar_id' not in params) or (params['grammar_id'] is None):
            raise ValueError("Missing the required parameter `grammar_id` when calling `post_architect_grammar_language_files_dtmf`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `post_architect_grammar_language_files_dtmf`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_grammar_language_files_dtmf`")


        resource_path = '/api/v2/architect/grammars/{grammarId}/languages/{languageCode}/files/dtmf'.replace('{format}', 'json')
        path_params = {}
        if 'grammar_id' in params:
            path_params['grammarId'] = params['grammar_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UploadUrlResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_grammar_language_files_voice(self, grammar_id: str, language_code: str, body: 'GrammarFileUploadRequest', **kwargs) -> 'UploadUrlResponse':
        """
        Creates a presigned URL for uploading a grammar voice mode file
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_grammar_language_files_voice(grammar_id, language_code, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str grammar_id: Grammar ID (required)
        :param str language_code: Language (required)
        :param GrammarFileUploadRequest body: query (required)
        :return: UploadUrlResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grammar_id', 'language_code', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_grammar_language_files_voice" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'grammar_id' is set
        if ('grammar_id' not in params) or (params['grammar_id'] is None):
            raise ValueError("Missing the required parameter `grammar_id` when calling `post_architect_grammar_language_files_voice`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `post_architect_grammar_language_files_voice`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_grammar_language_files_voice`")


        resource_path = '/api/v2/architect/grammars/{grammarId}/languages/{languageCode}/files/voice'.replace('{format}', 'json')
        path_params = {}
        if 'grammar_id' in params:
            path_params['grammarId'] = params['grammar_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UploadUrlResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_grammar_languages(self, grammar_id: str, body: 'GrammarLanguage', **kwargs) -> 'GrammarLanguage':
        """
        Create a new language for a given grammar
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_grammar_languages(grammar_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str grammar_id: Grammar ID (required)
        :param GrammarLanguage body:  (required)
        :return: GrammarLanguage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['grammar_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_grammar_languages" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'grammar_id' is set
        if ('grammar_id' not in params) or (params['grammar_id'] is None):
            raise ValueError("Missing the required parameter `grammar_id` when calling `post_architect_grammar_languages`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_grammar_languages`")


        resource_path = '/api/v2/architect/grammars/{grammarId}/languages'.replace('{format}', 'json')
        path_params = {}
        if 'grammar_id' in params:
            path_params['grammarId'] = params['grammar_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GrammarLanguage',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_grammars(self, body: 'Grammar', **kwargs) -> 'Grammar':
        """
        Create a new grammar
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_grammars(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Grammar body:  (required)
        :return: Grammar
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_grammars" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_grammars`")


        resource_path = '/api/v2/architect/grammars'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Grammar',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_ivrs(self, body: 'IVR', **kwargs) -> 'IVR':
        """
        Create IVR config.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_ivrs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param IVR body:  (required)
        :return: IVR
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_ivrs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_ivrs`")


        resource_path = '/api/v2/architect/ivrs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IVR',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_prompt_history(self, prompt_id: str, **kwargs) -> 'Operation':
        """
        Generate prompt history
        Asynchronous.  Notification topic: v2.architect.prompts.{promptId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_prompt_history(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_prompt_history" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `post_architect_prompt_history`")


        resource_path = '/api/v2/architect/prompts/{promptId}/history'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_prompt_resource_uploads(self, prompt_id: str, language_code: str, **kwargs) -> 'PromptAssetUpload':
        """
        Creates a presigned URL for uploading a user prompt file
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_prompt_resource_uploads(prompt_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :return: PromptAssetUpload
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_prompt_resource_uploads" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `post_architect_prompt_resource_uploads`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `post_architect_prompt_resource_uploads`")


        resource_path = '/api/v2/architect/prompts/{promptId}/resources/{languageCode}/uploads'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PromptAssetUpload',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_prompt_resources(self, prompt_id: str, body: 'PromptAssetCreate', **kwargs) -> 'PromptAsset':
        """
        Create a new user prompt resource
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_prompt_resources(prompt_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param PromptAssetCreate body:  (required)
        :return: PromptAsset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_prompt_resources" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `post_architect_prompt_resources`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_prompt_resources`")


        resource_path = '/api/v2/architect/prompts/{promptId}/resources'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PromptAsset',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_prompts(self, body: 'Prompt', **kwargs) -> 'Prompt':
        """
        Create a new user prompt
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_prompts(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Prompt body:  (required)
        :return: Prompt
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_prompts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_prompts`")


        resource_path = '/api/v2/architect/prompts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Prompt',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_schedulegroups(self, body: 'ScheduleGroup', **kwargs) -> 'ScheduleGroup':
        """
        Creates a new schedule group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_schedulegroups(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ScheduleGroup body:  (required)
        :return: ScheduleGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_schedulegroups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_schedulegroups`")


        resource_path = '/api/v2/architect/schedulegroups'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_schedules(self, body: 'Schedule', **kwargs) -> 'Schedule':
        """
        Create a new schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_schedules(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Schedule body:  (required)
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_schedules`")


        resource_path = '/api/v2/architect/schedules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Schedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_systemprompt_history(self, prompt_id: str, **kwargs) -> 'Operation':
        """
        Generate system prompt history
        Asynchronous.  Notification topic: v2.architect.systemprompts.{systemPromptId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_systemprompt_history(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: promptId (required)
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_systemprompt_history" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `post_architect_systemprompt_history`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/history'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_systemprompt_resource_uploads(self, prompt_id: str, language_code: str, **kwargs) -> 'PromptAssetUpload':
        """
        Creates a presigned URL for uploading a system prompt file
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_systemprompt_resource_uploads(prompt_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :return: PromptAssetUpload
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_systemprompt_resource_uploads" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `post_architect_systemprompt_resource_uploads`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `post_architect_systemprompt_resource_uploads`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}/uploads'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PromptAssetUpload',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_systemprompt_resources(self, prompt_id: str, body: 'SystemPromptAsset', **kwargs) -> 'SystemPromptAsset':
        """
        Create system prompt resource override.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_systemprompt_resources(prompt_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param SystemPromptAsset body:  (required)
        :return: SystemPromptAsset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_systemprompt_resources" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `post_architect_systemprompt_resources`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_systemprompt_resources`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/resources'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SystemPromptAsset',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flow_history(self, flow_id: str, **kwargs) -> 'Operation':
        """
        Generate flow history
        Asynchronous.  Notification topic: v2.flows.{flowId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flow_history(flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flow_history" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `post_flow_history`")


        resource_path = '/api/v2/flows/{flowId}/history'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flow_instances_settings_loglevels(self, flow_id: str, body: 'FlowLogLevelRequest', **kwargs) -> 'FlowSettingsResponse':
        """
        Set the logLevel for a particular flow id
        Assigns a new loglevel to a flow id

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flow_instances_settings_loglevels(flow_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: The flow id to set the loglevel for (required)
        :param FlowLogLevelRequest body: New LogLevel settings (required)
        :param list[str] expand: Expand instructions for the result
        :return: FlowSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flow_instances_settings_loglevels" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `post_flow_instances_settings_loglevels`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_flow_instances_settings_loglevels`")


        resource_path = '/api/v2/flows/{flowId}/instances/settings/loglevels'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowSettingsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flow_versions(self, flow_id: str, body: object, **kwargs) -> 'FlowVersion':
        """
        Create flow version
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flow_versions(flow_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param object body:  (required)
        :return: FlowVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flow_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `post_flow_versions`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_flow_versions`")


        resource_path = '/api/v2/flows/{flowId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows(self, body: 'Flow', **kwargs) -> 'Flow':
        """
        Create flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Flow body:  (required)
        :param str language: Language
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_flows`")


        resource_path = '/api/v2/flows'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'language' in params:
            query_params['language'] = params['language']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_actions_checkin(self, flow: str, **kwargs) -> 'Operation':
        """
        Check-in flow
        Asynchronous.  Notification topic: v2.flows.{flowId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_actions_checkin(flow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow: Flow ID (required)
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_actions_checkin" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow' is set
        if ('flow' not in params) or (params['flow'] is None):
            raise ValueError("Missing the required parameter `flow` when calling `post_flows_actions_checkin`")


        resource_path = '/api/v2/flows/actions/checkin'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'flow' in params:
            query_params['flow'] = params['flow']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_actions_checkout(self, flow: str, **kwargs) -> 'Flow':
        """
        Check-out flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_actions_checkout(flow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow: Flow ID (required)
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_actions_checkout" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow' is set
        if ('flow' not in params) or (params['flow'] is None):
            raise ValueError("Missing the required parameter `flow` when calling `post_flows_actions_checkout`")


        resource_path = '/api/v2/flows/actions/checkout'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'flow' in params:
            query_params['flow'] = params['flow']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_actions_deactivate(self, flow: str, **kwargs) -> 'Flow':
        """
        Deactivate flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_actions_deactivate(flow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow: Flow ID (required)
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_actions_deactivate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow' is set
        if ('flow' not in params) or (params['flow'] is None):
            raise ValueError("Missing the required parameter `flow` when calling `post_flows_actions_deactivate`")


        resource_path = '/api/v2/flows/actions/deactivate'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'flow' in params:
            query_params['flow'] = params['flow']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_actions_publish(self, flow: str, **kwargs) -> 'Operation':
        """
        Publish flow
        Asynchronous.  Notification topic: v2.flows.{flowId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_actions_publish(flow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow: Flow ID (required)
        :param str version: version
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow', 'version']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_actions_publish" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow' is set
        if ('flow' not in params) or (params['flow'] is None):
            raise ValueError("Missing the required parameter `flow` when calling `post_flows_actions_publish`")


        resource_path = '/api/v2/flows/actions/publish'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'flow' in params:
            query_params['flow'] = params['flow']
        if 'version' in params:
            query_params['version'] = params['version']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_actions_revert(self, flow: str, **kwargs) -> 'Flow':
        """
        Revert flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_actions_revert(flow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow: Flow ID (required)
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_actions_revert" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow' is set
        if ('flow' not in params) or (params['flow'] is None):
            raise ValueError("Missing the required parameter `flow` when calling `post_flows_actions_revert`")


        resource_path = '/api/v2/flows/actions/revert'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'flow' in params:
            query_params['flow'] = params['flow']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_actions_unlock(self, flow: str, **kwargs) -> 'Flow':
        """
        Unlock flow
        Allows for unlocking a flow in the case where there is no flow configuration available, and thus a check-in will not unlock the flow. The user must have Architect Admin permissions to perform this action.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_actions_unlock(flow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow: Flow ID (required)
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_actions_unlock" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow' is set
        if ('flow' not in params) or (params['flow'] is None):
            raise ValueError("Missing the required parameter `flow` when calling `post_flows_actions_unlock`")


        resource_path = '/api/v2/flows/actions/unlock'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'flow' in params:
            query_params['flow'] = params['flow']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_datatable_export_jobs(self, datatable_id: str, **kwargs) -> 'DataTableExportJob':
        """
        Begin an export process for exporting all rows from a datatable
        Create an export job for exporting rows. The caller can then poll for status of the export using the token returned in the response

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_datatable_export_jobs(datatable_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :return: DataTableExportJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_datatable_export_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `post_flows_datatable_export_jobs`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/export/jobs'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTableExportJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_datatable_import_jobs(self, datatable_id: str, body: 'DataTableImportJob', **kwargs) -> 'DataTableImportJob':
        """
        Begin an import process for importing rows into a datatable
        Create an import job for importing rows. The caller can then poll for status of the import using the token returned in the response

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_datatable_import_jobs(datatable_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param DataTableImportJob body: import job information (required)
        :return: DataTableImportJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_datatable_import_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `post_flows_datatable_import_jobs`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_flows_datatable_import_jobs`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/import/jobs'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTableImportJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_datatable_rows(self, datatable_id: str, data_table_row: object, **kwargs) -> Dict[str, object]:
        """
        Create a new row entry for the datatable.
        Will add the passed in row entry to the datatable with the given datatableId after verifying it against the schema.  When building the request body within API Explorer, Pro mode should be used. The DataTableRow should be a json-ized' stream of key -> value pairs {      \"Field1\": \"XYZZY\",      \"Field2\": false,      \"KEY\": \"27272\"  }

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_datatable_rows(datatable_id, data_table_row, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param object data_table_row:  (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'data_table_row']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_datatable_rows" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `post_flows_datatable_rows`")
        # verify the required parameter 'data_table_row' is set
        if ('data_table_row' not in params) or (params['data_table_row'] is None):
            raise ValueError("Missing the required parameter `data_table_row` when calling `post_flows_datatable_rows`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/rows'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data_table_row' in params:
            body_params = params['data_table_row']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='dict(str, object)',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_datatables(self, body: 'DataTable', **kwargs) -> 'DataTable':
        """
        Create a new datatable with the specified json-schema definition
        This will create a new datatable with fields that match the property definitions in the JSON schema.  The schema's title field will be overridden by the name field in the DataTable object.  See also http://json-schema.org/

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_datatables(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DataTable body: datatable json-schema (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_datatables" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_flows_datatables`")


        resource_path = '/api/v2/flows/datatables'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTable',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_executions(self, flow_launch_request: 'FlowExecutionLaunchRequest', **kwargs) -> 'FlowExecutionLaunchResponse':
        """
        Launch an instance of a flow definition, for flow types that support it such as the 'workflow' type.
        The launch is asynchronous, it returns as soon as the flow starts. You can use the returned ID to query its status if you need.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_executions(flow_launch_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FlowExecutionLaunchRequest flow_launch_request:  (required)
        :return: FlowExecutionLaunchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_launch_request']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_executions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_launch_request' is set
        if ('flow_launch_request' not in params) or (params['flow_launch_request'] is None):
            raise ValueError("Missing the required parameter `flow_launch_request` when calling `post_flows_executions`")


        resource_path = '/api/v2/flows/executions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'flow_launch_request' in params:
            body_params = params['flow_launch_request']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowExecutionLaunchResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_export_jobs(self, body: 'RegisterArchitectExportJob', **kwargs) -> 'RegisterArchitectExportJobResponse':
        """
        Register Architect Export Job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_export_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RegisterArchitectExportJob body:  (required)
        :return: RegisterArchitectExportJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_export_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_flows_export_jobs`")


        resource_path = '/api/v2/flows/export/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RegisterArchitectExportJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_instances_jobs(self, body: 'ExecutionDataRequest', **kwargs) -> 'GetFlowExecutionDataJobResult':
        """
        Start a process (job) that will prepare a list of execution data IDs for download.
        Returns a JobResult object that contains an ID that can be used to check status and/or download links when the process (job) is complete.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_instances_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ExecutionDataRequest body: Requested Flow Ids (required)
        :param str expand: Expand various query types.
        :return: GetFlowExecutionDataJobResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_instances_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_flows_instances_jobs`")


        resource_path = '/api/v2/flows/instances/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GetFlowExecutionDataJobResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_instances_query(self, body: 'CriteriaQuery', **kwargs) -> 'FlowResultEntityListing':
        """
        Query the database of existing flow histories to look for particular flow criteria
        Returns a list of matching flow histories up to 200 max.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_instances_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CriteriaQuery body: query (required)
        :param bool index_only: indexes only
        :param int page_size: number of results to return
        :return: FlowResultEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'index_only', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_instances_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_flows_instances_query`")


        resource_path = '/api/v2/flows/instances/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'index_only' in params:
            query_params['indexOnly'] = params['index_only']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowResultEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_jobs(self, **kwargs) -> 'RegisterArchitectJobResponse':
        """
        Register Architect Job. Returns a URL where a file, such as an Architect flow YAML file, can be PUT which will then initiate the job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_jobs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: RegisterArchitectJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_jobs" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RegisterArchitectJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_milestones(self, **kwargs) -> 'FlowMilestone':
        """
        Create a flow milestone
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_milestones(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FlowMilestone body: 
        :return: FlowMilestone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_milestones" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/milestones'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowMilestone',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_outcomes(self, **kwargs) -> 'FlowOutcome':
        """
        Create a flow outcome
        Asynchronous.  Notification topic: v2.flows.outcomes.{flowOutcomeId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_outcomes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FlowOutcome body: 
        :return: FlowOutcome
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_outcomes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/outcomes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowOutcome',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_emergencygroup(self, emergency_group_id: str, body: 'EmergencyGroup', **kwargs) -> 'EmergencyGroup':
        """
        Updates a emergency group by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_emergencygroup(emergency_group_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str emergency_group_id: Emergency group ID (required)
        :param EmergencyGroup body:  (required)
        :return: EmergencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['emergency_group_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_emergencygroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'emergency_group_id' is set
        if ('emergency_group_id' not in params) or (params['emergency_group_id'] is None):
            raise ValueError("Missing the required parameter `emergency_group_id` when calling `put_architect_emergencygroup`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_emergencygroup`")


        resource_path = '/api/v2/architect/emergencygroups/{emergencyGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'emergency_group_id' in params:
            path_params['emergencyGroupId'] = params['emergency_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmergencyGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_ivr(self, ivr_id: str, body: 'IVR', **kwargs) -> 'IVR':
        """
        Update an IVR Config.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_ivr(ivr_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str ivr_id: IVR id (required)
        :param IVR body:  (required)
        :return: IVR
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ivr_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_ivr" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'ivr_id' is set
        if ('ivr_id' not in params) or (params['ivr_id'] is None):
            raise ValueError("Missing the required parameter `ivr_id` when calling `put_architect_ivr`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_ivr`")


        resource_path = '/api/v2/architect/ivrs/{ivrId}'.replace('{format}', 'json')
        path_params = {}
        if 'ivr_id' in params:
            path_params['ivrId'] = params['ivr_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IVR',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_ivr_identityresolution(self, ivr_id: str, body: 'IdentityResolutionConfig', **kwargs) -> 'IdentityResolutionConfig':
        """
        Update an IVR IdentityResolutionConfig.
        
	    put_architect_ivr_identityresolution is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_ivr_identityresolution(ivr_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str ivr_id: IVR id (required)
        :param IdentityResolutionConfig body:  (required)
        :return: IdentityResolutionConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ivr_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_ivr_identityresolution" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'ivr_id' is set
        if ('ivr_id' not in params) or (params['ivr_id'] is None):
            raise ValueError("Missing the required parameter `ivr_id` when calling `put_architect_ivr_identityresolution`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_ivr_identityresolution`")


        resource_path = '/api/v2/architect/ivrs/{ivrId}/identityresolution'.replace('{format}', 'json')
        path_params = {}
        if 'ivr_id' in params:
            path_params['ivrId'] = params['ivr_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IdentityResolutionConfig',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_prompt(self, prompt_id: str, body: 'Prompt', **kwargs) -> 'Prompt':
        """
        Update specified user prompt
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_prompt(prompt_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param Prompt body:  (required)
        :return: Prompt
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_prompt" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `put_architect_prompt`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_prompt`")


        resource_path = '/api/v2/architect/prompts/{promptId}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Prompt',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_prompt_resource(self, prompt_id: str, language_code: str, body: 'PromptAsset', **kwargs) -> 'PromptAsset':
        """
        Update specified user prompt resource
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_prompt_resource(prompt_id, language_code, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :param PromptAsset body:  (required)
        :return: PromptAsset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_prompt_resource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `put_architect_prompt_resource`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `put_architect_prompt_resource`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_prompt_resource`")


        resource_path = '/api/v2/architect/prompts/{promptId}/resources/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PromptAsset',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_schedule(self, schedule_id: str, body: 'Schedule', **kwargs) -> 'Schedule':
        """
        Update schedule by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_schedule(schedule_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schedule_id: Schedule ID (required)
        :param Schedule body:  (required)
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `put_architect_schedule`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_schedule`")


        resource_path = '/api/v2/architect/schedules/{scheduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Schedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_schedulegroup(self, schedule_group_id: str, body: 'ScheduleGroup', **kwargs) -> 'ScheduleGroup':
        """
        Updates a schedule group by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_schedulegroup(schedule_group_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schedule_group_id: Schedule group ID (required)
        :param ScheduleGroup body:  (required)
        :return: ScheduleGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_group_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_schedulegroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schedule_group_id' is set
        if ('schedule_group_id' not in params) or (params['schedule_group_id'] is None):
            raise ValueError("Missing the required parameter `schedule_group_id` when calling `put_architect_schedulegroup`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_schedulegroup`")


        resource_path = '/api/v2/architect/schedulegroups/{scheduleGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'schedule_group_id' in params:
            path_params['scheduleGroupId'] = params['schedule_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_systemprompt_resource(self, prompt_id: str, language_code: str, body: 'SystemPromptAsset', **kwargs) -> 'SystemPromptAsset':
        """
        Updates a system prompt resource override.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_systemprompt_resource(prompt_id, language_code, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :param SystemPromptAsset body:  (required)
        :return: SystemPromptAsset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_systemprompt_resource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `put_architect_systemprompt_resource`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `put_architect_systemprompt_resource`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_systemprompt_resource`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SystemPromptAsset',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_flow(self, flow_id: str, body: 'Flow', **kwargs) -> 'Flow':
        """
        Update flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_flow(flow_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param Flow body:  (required)
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_flow" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `put_flow`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_flow`")


        resource_path = '/api/v2/flows/{flowId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_flow_instances_settings_loglevels(self, flow_id: str, body: 'FlowLogLevelRequest', **kwargs) -> 'FlowSettingsResponse':
        """
        Edit the logLevel for a particular flow id
        Updates the loglevel for a flow id

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_flow_instances_settings_loglevels(flow_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: The flow id to edit the loglevel for (required)
        :param FlowLogLevelRequest body: New LogLevel settings (required)
        :param list[str] expand: Expand instructions for the result
        :return: FlowSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_flow_instances_settings_loglevels" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `put_flow_instances_settings_loglevels`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_flow_instances_settings_loglevels`")


        resource_path = '/api/v2/flows/{flowId}/instances/settings/loglevels'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowSettingsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_flows_datatable(self, datatable_id: str, body: 'DataTable', **kwargs) -> 'DataTable':
        """
        Updates a specific datatable by id
        Updates a schema for a datatable with the given datatableId -updates allow only new fields to be added in the schema, no changes or removals of existing fields.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_flows_datatable(datatable_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param DataTable body: datatable json-schema (required)
        :param str expand: Expand instructions for the result
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_flows_datatable" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `put_flows_datatable`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_flows_datatable`")


        resource_path = '/api/v2/flows/datatables/{datatableId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTable',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_flows_datatable_row(self, datatable_id: str, row_id: str, **kwargs) -> Dict[str, object]:
        """
        Update a row entry
        Updates a row with the given rowId (the value of the key field) to the new values.  When building the request body within API Explorer, Pro mode should be used. The DataTableRow should be a json-ized' stream of key -> value pairs {     \"Field1\": \"XYZZY\",     \"Field2\": false,     \"KEY\": \"27272\" }

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_flows_datatable_row(datatable_id, row_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str row_id: the key for the row (required)
        :param object body: datatable row
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'row_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_flows_datatable_row" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `put_flows_datatable_row`")
        # verify the required parameter 'row_id' is set
        if ('row_id' not in params) or (params['row_id'] is None):
            raise ValueError("Missing the required parameter `row_id` when calling `put_flows_datatable_row`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/rows/{rowId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']
        if 'row_id' in params:
            path_params['rowId'] = params['row_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='dict(str, object)',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_flows_instances_settings_loglevels_default(self, body: 'FlowLogLevelRequest', **kwargs) -> 'FlowSettingsResponse':
        """
        Edit the flow default log level.
        Edit the flow default log level.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_flows_instances_settings_loglevels_default(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FlowLogLevelRequest body: New LogLevel settings (required)
        :param list[str] expand: Expand instructions for the result
        :return: FlowSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_flows_instances_settings_loglevels_default" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_flows_instances_settings_loglevels_default`")


        resource_path = '/api/v2/flows/instances/settings/loglevels/default'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowSettingsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_flows_milestone(self, milestone_id: str, **kwargs) -> 'FlowMilestone':
        """
        Updates a flow milestone
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_flows_milestone(milestone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str milestone_id: flow milestone ID (required)
        :param FlowMilestone body: 
        :return: FlowMilestone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['milestone_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_flows_milestone" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'milestone_id' is set
        if ('milestone_id' not in params) or (params['milestone_id'] is None):
            raise ValueError("Missing the required parameter `milestone_id` when calling `put_flows_milestone`")


        resource_path = '/api/v2/flows/milestones/{milestoneId}'.replace('{format}', 'json')
        path_params = {}
        if 'milestone_id' in params:
            path_params['milestoneId'] = params['milestone_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowMilestone',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_flows_outcome(self, flow_outcome_id: str, **kwargs) -> 'Operation':
        """
        Updates a flow outcome
        Updates a flow outcome.  Asynchronous.  Notification topic: v2.flowoutcomes.{flowoutcomeId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_flows_outcome(flow_outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_outcome_id: flow outcome ID (required)
        :param FlowOutcome body: 
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_outcome_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_flows_outcome" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_outcome_id' is set
        if ('flow_outcome_id' not in params) or (params['flow_outcome_id'] is None):
            raise ValueError("Missing the required parameter `flow_outcome_id` when calling `put_flows_outcome`")


        resource_path = '/api/v2/flows/outcomes/{flowOutcomeId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_outcome_id' in params:
            path_params['flowOutcomeId'] = params['flow_outcome_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
