# coding: utf-8

"""
AgentCopilotApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import Copilot
from ..models import ErrorBody

class AgentCopilotApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_assistant_copilot(self, assistant_id: str, **kwargs) -> 'Copilot':
        """
        Get copilot configuration of an assistant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_assistant_copilot(assistant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assistant_id: Assistant ID (required)
        :return: Copilot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assistant_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assistant_copilot" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assistant_id' is set
        if ('assistant_id' not in params) or (params['assistant_id'] is None):
            raise ValueError("Missing the required parameter `assistant_id` when calling `get_assistant_copilot`")


        resource_path = '/api/v2/assistants/{assistantId}/copilot'.replace('{format}', 'json')
        path_params = {}
        if 'assistant_id' in params:
            path_params['assistantId'] = params['assistant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Copilot',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_assistant_copilot(self, assistant_id: str, body: 'Copilot', **kwargs) -> 'Copilot':
        """
        Update agent copilot configuration
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_assistant_copilot(assistant_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assistant_id: Assistant ID (required)
        :param Copilot body:  (required)
        :return: Copilot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assistant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_assistant_copilot" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assistant_id' is set
        if ('assistant_id' not in params) or (params['assistant_id'] is None):
            raise ValueError("Missing the required parameter `assistant_id` when calling `put_assistant_copilot`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_assistant_copilot`")


        resource_path = '/api/v2/assistants/{assistantId}/copilot'.replace('{format}', 'json')
        path_params = {}
        if 'assistant_id' in params:
            path_params['assistantId'] = params['assistant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Copilot',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
