# coding: utf-8

"""
AgentAssistantsApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import Assistant
from ..models import AssistantListing
from ..models import AssistantQueue
from ..models import AssistantQueueListing
from ..models import ErrorBody

class AgentAssistantsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_assistant(self, assistant_id: str, **kwargs) -> None:
        """
        Delete an assistant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_assistant(assistant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assistant_id: Assistant ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assistant_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_assistant" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assistant_id' is set
        if ('assistant_id' not in params) or (params['assistant_id'] is None):
            raise ValueError("Missing the required parameter `assistant_id` when calling `delete_assistant`")


        resource_path = '/api/v2/assistants/{assistantId}'.replace('{format}', 'json')
        path_params = {}
        if 'assistant_id' in params:
            path_params['assistantId'] = params['assistant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_assistant_queue(self, assistant_id: str, queue_id: str, **kwargs) -> None:
        """
        Disassociate a queue from an assistant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_assistant_queue(assistant_id, queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assistant_id: Assistant ID (required)
        :param str queue_id: Queue ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assistant_id', 'queue_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_assistant_queue" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assistant_id' is set
        if ('assistant_id' not in params) or (params['assistant_id'] is None):
            raise ValueError("Missing the required parameter `assistant_id` when calling `delete_assistant_queue`")
        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `delete_assistant_queue`")


        resource_path = '/api/v2/assistants/{assistantId}/queues/{queueId}'.replace('{format}', 'json')
        path_params = {}
        if 'assistant_id' in params:
            path_params['assistantId'] = params['assistant_id']
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_assistant_queues(self, assistant_id: str, **kwargs) -> None:
        """
        Disassociate the queues from an assistant for the given assistant ID and queue IDs.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_assistant_queues(assistant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assistant_id: Assistant ID (required)
        :param str queue_ids: Comma-separated identifiers of the queues that need to be deleted.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assistant_id', 'queue_ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_assistant_queues" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assistant_id' is set
        if ('assistant_id' not in params) or (params['assistant_id'] is None):
            raise ValueError("Missing the required parameter `assistant_id` when calling `delete_assistant_queues`")


        resource_path = '/api/v2/assistants/{assistantId}/queues'.replace('{format}', 'json')
        path_params = {}
        if 'assistant_id' in params:
            path_params['assistantId'] = params['assistant_id']

        query_params = {}
        if 'queue_ids' in params:
            query_params['queueIds'] = params['queue_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_assistant(self, assistant_id: str, **kwargs) -> 'Assistant':
        """
        Get an assistant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_assistant(assistant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assistant_id: Assistant ID (required)
        :param str expand: Which fields, if any, to expand.
        :return: Assistant
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assistant_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assistant" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assistant_id' is set
        if ('assistant_id' not in params) or (params['assistant_id'] is None):
            raise ValueError("Missing the required parameter `assistant_id` when calling `get_assistant`")


        resource_path = '/api/v2/assistants/{assistantId}'.replace('{format}', 'json')
        path_params = {}
        if 'assistant_id' in params:
            path_params['assistantId'] = params['assistant_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Assistant',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_assistant_queue(self, assistant_id: str, queue_id: str, **kwargs) -> 'AssistantQueue':
        """
        Get queue Information for an assistant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_assistant_queue(assistant_id, queue_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assistant_id: Assistant ID (required)
        :param str queue_id: Queue ID (required)
        :param str expand: Which fields, if any, to expand.
        :return: AssistantQueue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assistant_id', 'queue_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assistant_queue" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assistant_id' is set
        if ('assistant_id' not in params) or (params['assistant_id'] is None):
            raise ValueError("Missing the required parameter `assistant_id` when calling `get_assistant_queue`")
        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `get_assistant_queue`")


        resource_path = '/api/v2/assistants/{assistantId}/queues/{queueId}'.replace('{format}', 'json')
        path_params = {}
        if 'assistant_id' in params:
            path_params['assistantId'] = params['assistant_id']
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssistantQueue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_assistant_queues(self, assistant_id: str, **kwargs) -> 'AssistantQueueListing':
        """
        Get all the queues associated with an assistant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_assistant_queues(assistant_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assistant_id: Assistant ID (required)
        :param str before: The cursor that points to the start of the set of entities that has been returned.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str page_size: Number of entities to return. Maximum of 200.
        :param str expand: Which fields, if any, to expand.
        :return: AssistantQueueListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assistant_id', 'before', 'after', 'page_size', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assistant_queues" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assistant_id' is set
        if ('assistant_id' not in params) or (params['assistant_id'] is None):
            raise ValueError("Missing the required parameter `assistant_id` when calling `get_assistant_queues`")


        resource_path = '/api/v2/assistants/{assistantId}/queues'.replace('{format}', 'json')
        path_params = {}
        if 'assistant_id' in params:
            path_params['assistantId'] = params['assistant_id']

        query_params = {}
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssistantQueueListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_assistants(self, **kwargs) -> 'AssistantListing':
        """
        Get all assistants.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_assistants(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str before: The cursor that points to the start of the set of entities that has been returned.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str limit: Number of entities to return. Maximum of 200. Deprecated in favour of pageSize
        :param str page_size: Number of entities to return. Maximum of 200.
        :param str name: Return the assistant by the given name.
        :return: AssistantListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['before', 'after', 'limit', 'page_size', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assistants" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/assistants'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssistantListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_assistants_queues(self, **kwargs) -> 'AssistantQueueListing':
        """
        Get all queues assigned to any assistant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_assistants_queues(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str before: The cursor that points to the start of the set of entities that has been returned.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str page_size: Number of entities to return. Maximum of 200.
        :param str queue_ids: Comma-separated identifiers of the queues that need to be retrieved.
        :param str expand: Which fields, if any, to expand.
        :return: AssistantQueueListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['before', 'after', 'page_size', 'queue_ids', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_assistants_queues" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/assistants/queues'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'queue_ids' in params:
            query_params['queueIds'] = params['queue_ids']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssistantQueueListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_assistant(self, assistant_id: str, body: 'Assistant', **kwargs) -> 'Assistant':
        """
        Update an assistant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_assistant(assistant_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assistant_id: Assistant ID (required)
        :param Assistant body:  (required)
        :return: Assistant
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assistant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_assistant" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assistant_id' is set
        if ('assistant_id' not in params) or (params['assistant_id'] is None):
            raise ValueError("Missing the required parameter `assistant_id` when calling `patch_assistant`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_assistant`")


        resource_path = '/api/v2/assistants/{assistantId}'.replace('{format}', 'json')
        path_params = {}
        if 'assistant_id' in params:
            path_params['assistantId'] = params['assistant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Assistant',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_assistant_queues(self, assistant_id: str, body: List['AssistantQueue'], **kwargs) -> 'AssistantQueueListing':
        """
        Update Queues for an Assistant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_assistant_queues(assistant_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assistant_id: Assistant ID (required)
        :param list[AssistantQueue] body:  (required)
        :return: AssistantQueueListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assistant_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_assistant_queues" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assistant_id' is set
        if ('assistant_id' not in params) or (params['assistant_id'] is None):
            raise ValueError("Missing the required parameter `assistant_id` when calling `patch_assistant_queues`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_assistant_queues`")


        resource_path = '/api/v2/assistants/{assistantId}/queues'.replace('{format}', 'json')
        path_params = {}
        if 'assistant_id' in params:
            path_params['assistantId'] = params['assistant_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssistantQueueListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_assistants(self, body: 'Assistant', **kwargs) -> 'Assistant':
        """
        Create an Assistant.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_assistants(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Assistant body:  (required)
        :return: Assistant
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_assistants" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_assistants`")


        resource_path = '/api/v2/assistants'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Assistant',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_assistant_queue(self, assistant_id: str, queue_id: str, body: 'AssistantQueue', **kwargs) -> 'AssistantQueue':
        """
        Create a queue assistant association.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_assistant_queue(assistant_id, queue_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str assistant_id: Assistant ID (required)
        :param str queue_id: Queue ID (required)
        :param AssistantQueue body:  (required)
        :return: AssistantQueue
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['assistant_id', 'queue_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_assistant_queue" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'assistant_id' is set
        if ('assistant_id' not in params) or (params['assistant_id'] is None):
            raise ValueError("Missing the required parameter `assistant_id` when calling `put_assistant_queue`")
        # verify the required parameter 'queue_id' is set
        if ('queue_id' not in params) or (params['queue_id'] is None):
            raise ValueError("Missing the required parameter `queue_id` when calling `put_assistant_queue`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_assistant_queue`")


        resource_path = '/api/v2/assistants/{assistantId}/queues/{queueId}'.replace('{format}', 'json')
        path_params = {}
        if 'assistant_id' in params:
            path_params['assistantId'] = params['assistant_id']
        if 'queue_id' in params:
            path_params['queueId'] = params['queue_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AssistantQueue',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
