#!/usr/bin/env python
#
# Autogenerated by Thrift Compiler (0.9.3)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py
#

import sys
import pprint
from urlparse import urlparse
from thrift.transport import TTransport
from thrift.transport import TSocket
from thrift.transport import TSSLSocket
from thrift.transport import THttpClient
from thrift.protocol import TBinaryProtocol

from hive_metastore import ThriftHiveMetastore
from hive_metastore.ttypes import *

if len(sys.argv) <= 1 or sys.argv[1] == '--help':
  print('')
  print('Usage: ' + sys.argv[0] + ' [-h host[:port]] [-u url] [-f[ramed]] [-s[sl]] function [arg1 [arg2...]]')
  print('')
  print('Functions:')
  print('  string getMetaConf(string key)')
  print('  void setMetaConf(string key, string value)')
  print('  void create_database(Database database)')
  print('  Database get_database(string name)')
  print('  void drop_database(string name, bool deleteData, bool cascade)')
  print('   get_databases(string pattern)')
  print('   get_all_databases()')
  print('  void alter_database(string dbname, Database db)')
  print('  Type get_type(string name)')
  print('  bool create_type(Type type)')
  print('  bool drop_type(string type)')
  print('   get_type_all(string name)')
  print('   get_fields(string db_name, string table_name)')
  print('   get_fields_with_environment_context(string db_name, string table_name, EnvironmentContext environment_context)')
  print('   get_schema(string db_name, string table_name)')
  print('   get_schema_with_environment_context(string db_name, string table_name, EnvironmentContext environment_context)')
  print('  void create_table(Table tbl)')
  print('  void create_table_with_environment_context(Table tbl, EnvironmentContext environment_context)')
  print('  void drop_table(string dbname, string name, bool deleteData)')
  print('  void drop_table_with_environment_context(string dbname, string name, bool deleteData, EnvironmentContext environment_context)')
  print('   get_tables(string db_name, string pattern)')
  print('   get_table_meta(string db_patterns, string tbl_patterns,  tbl_types)')
  print('   get_all_tables(string db_name)')
  print('  Table get_table(string dbname, string tbl_name)')
  print('   get_table_objects_by_name(string dbname,  tbl_names)')
  print('   get_table_names_by_filter(string dbname, string filter, i16 max_tables)')
  print('  void alter_table(string dbname, string tbl_name, Table new_tbl)')
  print('  void alter_table_with_environment_context(string dbname, string tbl_name, Table new_tbl, EnvironmentContext environment_context)')
  print('  void alter_table_with_cascade(string dbname, string tbl_name, Table new_tbl, bool cascade)')
  print('  Partition add_partition(Partition new_part)')
  print('  Partition add_partition_with_environment_context(Partition new_part, EnvironmentContext environment_context)')
  print('  i32 add_partitions( new_parts)')
  print('  i32 add_partitions_pspec( new_parts)')
  print('  Partition append_partition(string db_name, string tbl_name,  part_vals)')
  print('  AddPartitionsResult add_partitions_req(AddPartitionsRequest request)')
  print('  Partition append_partition_with_environment_context(string db_name, string tbl_name,  part_vals, EnvironmentContext environment_context)')
  print('  Partition append_partition_by_name(string db_name, string tbl_name, string part_name)')
  print('  Partition append_partition_by_name_with_environment_context(string db_name, string tbl_name, string part_name, EnvironmentContext environment_context)')
  print('  bool drop_partition(string db_name, string tbl_name,  part_vals, bool deleteData)')
  print('  bool drop_partition_with_environment_context(string db_name, string tbl_name,  part_vals, bool deleteData, EnvironmentContext environment_context)')
  print('  bool drop_partition_by_name(string db_name, string tbl_name, string part_name, bool deleteData)')
  print('  bool drop_partition_by_name_with_environment_context(string db_name, string tbl_name, string part_name, bool deleteData, EnvironmentContext environment_context)')
  print('  DropPartitionsResult drop_partitions_req(DropPartitionsRequest req)')
  print('  Partition get_partition(string db_name, string tbl_name,  part_vals)')
  print('  Partition exchange_partition( partitionSpecs, string source_db, string source_table_name, string dest_db, string dest_table_name)')
  print('   exchange_partitions( partitionSpecs, string source_db, string source_table_name, string dest_db, string dest_table_name)')
  print('  Partition get_partition_with_auth(string db_name, string tbl_name,  part_vals, string user_name,  group_names)')
  print('  Partition get_partition_by_name(string db_name, string tbl_name, string part_name)')
  print('   get_partitions(string db_name, string tbl_name, i16 max_parts)')
  print('   get_partitions_with_auth(string db_name, string tbl_name, i16 max_parts, string user_name,  group_names)')
  print('   get_partitions_pspec(string db_name, string tbl_name, i32 max_parts)')
  print('   get_partition_names(string db_name, string tbl_name, i16 max_parts)')
  print('   get_partitions_ps(string db_name, string tbl_name,  part_vals, i16 max_parts)')
  print('   get_partitions_ps_with_auth(string db_name, string tbl_name,  part_vals, i16 max_parts, string user_name,  group_names)')
  print('   get_partition_names_ps(string db_name, string tbl_name,  part_vals, i16 max_parts)')
  print('   get_partitions_by_filter(string db_name, string tbl_name, string filter, i16 max_parts)')
  print('   get_part_specs_by_filter(string db_name, string tbl_name, string filter, i32 max_parts)')
  print('  PartitionsByExprResult get_partitions_by_expr(PartitionsByExprRequest req)')
  print('   get_partitions_by_names(string db_name, string tbl_name,  names)')
  print('  void alter_partition(string db_name, string tbl_name, Partition new_part)')
  print('  void alter_partitions(string db_name, string tbl_name,  new_parts)')
  print('  void alter_partition_with_environment_context(string db_name, string tbl_name, Partition new_part, EnvironmentContext environment_context)')
  print('  void rename_partition(string db_name, string tbl_name,  part_vals, Partition new_part)')
  print('  bool partition_name_has_valid_characters( part_vals, bool throw_exception)')
  print('  string get_config_value(string name, string defaultValue)')
  print('   partition_name_to_vals(string part_name)')
  print('   partition_name_to_spec(string part_name)')
  print('  void markPartitionForEvent(string db_name, string tbl_name,  part_vals, PartitionEventType eventType)')
  print('  bool isPartitionMarkedForEvent(string db_name, string tbl_name,  part_vals, PartitionEventType eventType)')
  print('  Index add_index(Index new_index, Table index_table)')
  print('  void alter_index(string dbname, string base_tbl_name, string idx_name, Index new_idx)')
  print('  bool drop_index_by_name(string db_name, string tbl_name, string index_name, bool deleteData)')
  print('  Index get_index_by_name(string db_name, string tbl_name, string index_name)')
  print('   get_indexes(string db_name, string tbl_name, i16 max_indexes)')
  print('   get_index_names(string db_name, string tbl_name, i16 max_indexes)')
  print('  bool update_table_column_statistics(ColumnStatistics stats_obj)')
  print('  bool update_partition_column_statistics(ColumnStatistics stats_obj)')
  print('  ColumnStatistics get_table_column_statistics(string db_name, string tbl_name, string col_name)')
  print('  ColumnStatistics get_partition_column_statistics(string db_name, string tbl_name, string part_name, string col_name)')
  print('  TableStatsResult get_table_statistics_req(TableStatsRequest request)')
  print('  PartitionsStatsResult get_partitions_statistics_req(PartitionsStatsRequest request)')
  print('  AggrStats get_aggr_stats_for(PartitionsStatsRequest request)')
  print('  bool set_aggr_stats_for(SetPartitionsStatsRequest request)')
  print('  bool delete_partition_column_statistics(string db_name, string tbl_name, string part_name, string col_name)')
  print('  bool delete_table_column_statistics(string db_name, string tbl_name, string col_name)')
  print('  void create_function(Function func)')
  print('  void drop_function(string dbName, string funcName)')
  print('  void alter_function(string dbName, string funcName, Function newFunc)')
  print('   get_functions(string dbName, string pattern)')
  print('  Function get_function(string dbName, string funcName)')
  print('  GetAllFunctionsResponse get_all_functions()')
  print('  bool create_role(Role role)')
  print('  bool drop_role(string role_name)')
  print('   get_role_names()')
  print('  bool grant_role(string role_name, string principal_name, PrincipalType principal_type, string grantor, PrincipalType grantorType, bool grant_option)')
  print('  bool revoke_role(string role_name, string principal_name, PrincipalType principal_type)')
  print('   list_roles(string principal_name, PrincipalType principal_type)')
  print('  GrantRevokeRoleResponse grant_revoke_role(GrantRevokeRoleRequest request)')
  print('  GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest request)')
  print('  GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest request)')
  print('  PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, string user_name,  group_names)')
  print('   list_privileges(string principal_name, PrincipalType principal_type, HiveObjectRef hiveObject)')
  print('  bool grant_privileges(PrivilegeBag privileges)')
  print('  bool revoke_privileges(PrivilegeBag privileges)')
  print('  GrantRevokePrivilegeResponse grant_revoke_privileges(GrantRevokePrivilegeRequest request)')
  print('   set_ugi(string user_name,  group_names)')
  print('  string get_delegation_token(string token_owner, string renewer_kerberos_principal_name)')
  print('  i64 renew_delegation_token(string token_str_form)')
  print('  void cancel_delegation_token(string token_str_form)')
  print('  GetOpenTxnsResponse get_open_txns()')
  print('  GetOpenTxnsInfoResponse get_open_txns_info()')
  print('  OpenTxnsResponse open_txns(OpenTxnRequest rqst)')
  print('  void abort_txn(AbortTxnRequest rqst)')
  print('  void commit_txn(CommitTxnRequest rqst)')
  print('  LockResponse lock(LockRequest rqst)')
  print('  LockResponse check_lock(CheckLockRequest rqst)')
  print('  void unlock(UnlockRequest rqst)')
  print('  ShowLocksResponse show_locks(ShowLocksRequest rqst)')
  print('  void heartbeat(HeartbeatRequest ids)')
  print('  HeartbeatTxnRangeResponse heartbeat_txn_range(HeartbeatTxnRangeRequest txns)')
  print('  void compact(CompactionRequest rqst)')
  print('  ShowCompactResponse show_compact(ShowCompactRequest rqst)')
  print('  void add_dynamic_partitions(AddDynamicPartitions rqst)')
  print('  NotificationEventResponse get_next_notification(NotificationEventRequest rqst)')
  print('  CurrentNotificationEventId get_current_notificationEventId()')
  print('  FireEventResponse fire_listener_event(FireEventRequest rqst)')
  print('  void flushCache()')
  print('  GetFileMetadataByExprResult get_file_metadata_by_expr(GetFileMetadataByExprRequest req)')
  print('  GetFileMetadataResult get_file_metadata(GetFileMetadataRequest req)')
  print('  PutFileMetadataResult put_file_metadata(PutFileMetadataRequest req)')
  print('  ClearFileMetadataResult clear_file_metadata(ClearFileMetadataRequest req)')
  print('  string getName()')
  print('  string getVersion()')
  print('  fb_status getStatus()')
  print('  string getStatusDetails()')
  print('   getCounters()')
  print('  i64 getCounter(string key)')
  print('  void setOption(string key, string value)')
  print('  string getOption(string key)')
  print('   getOptions()')
  print('  string getCpuProfile(i32 profileDurationInSec)')
  print('  i64 aliveSince()')
  print('  void reinitialize()')
  print('  void shutdown()')
  print('')
  sys.exit(0)

pp = pprint.PrettyPrinter(indent = 2)
host = 'localhost'
port = 9090
uri = ''
framed = False
ssl = False
http = False
argi = 1

if sys.argv[argi] == '-h':
  parts = sys.argv[argi+1].split(':')
  host = parts[0]
  if len(parts) > 1:
    port = int(parts[1])
  argi += 2

if sys.argv[argi] == '-u':
  url = urlparse(sys.argv[argi+1])
  parts = url[1].split(':')
  host = parts[0]
  if len(parts) > 1:
    port = int(parts[1])
  else:
    port = 80
  uri = url[2]
  if url[4]:
    uri += '?%s' % url[4]
  http = True
  argi += 2

if sys.argv[argi] == '-f' or sys.argv[argi] == '-framed':
  framed = True
  argi += 1

if sys.argv[argi] == '-s' or sys.argv[argi] == '-ssl':
  ssl = True
  argi += 1

cmd = sys.argv[argi]
args = sys.argv[argi+1:]

if http:
  transport = THttpClient.THttpClient(host, port, uri)
else:
  socket = TSSLSocket.TSSLSocket(host, port, validate=False) if ssl else TSocket.TSocket(host, port)
  if framed:
    transport = TTransport.TFramedTransport(socket)
  else:
    transport = TTransport.TBufferedTransport(socket)
protocol = TBinaryProtocol.TBinaryProtocol(transport)
client = ThriftHiveMetastore.Client(protocol)
transport.open()

if cmd == 'getMetaConf':
  if len(args) != 1:
    print('getMetaConf requires 1 args')
    sys.exit(1)
  pp.pprint(client.getMetaConf(args[0],))

elif cmd == 'setMetaConf':
  if len(args) != 2:
    print('setMetaConf requires 2 args')
    sys.exit(1)
  pp.pprint(client.setMetaConf(args[0],args[1],))

elif cmd == 'create_database':
  if len(args) != 1:
    print('create_database requires 1 args')
    sys.exit(1)
  pp.pprint(client.create_database(eval(args[0]),))

elif cmd == 'get_database':
  if len(args) != 1:
    print('get_database requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_database(args[0],))

elif cmd == 'drop_database':
  if len(args) != 3:
    print('drop_database requires 3 args')
    sys.exit(1)
  pp.pprint(client.drop_database(args[0],eval(args[1]),eval(args[2]),))

elif cmd == 'get_databases':
  if len(args) != 1:
    print('get_databases requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_databases(args[0],))

elif cmd == 'get_all_databases':
  if len(args) != 0:
    print('get_all_databases requires 0 args')
    sys.exit(1)
  pp.pprint(client.get_all_databases())

elif cmd == 'alter_database':
  if len(args) != 2:
    print('alter_database requires 2 args')
    sys.exit(1)
  pp.pprint(client.alter_database(args[0],eval(args[1]),))

elif cmd == 'get_type':
  if len(args) != 1:
    print('get_type requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_type(args[0],))

elif cmd == 'create_type':
  if len(args) != 1:
    print('create_type requires 1 args')
    sys.exit(1)
  pp.pprint(client.create_type(eval(args[0]),))

elif cmd == 'drop_type':
  if len(args) != 1:
    print('drop_type requires 1 args')
    sys.exit(1)
  pp.pprint(client.drop_type(args[0],))

elif cmd == 'get_type_all':
  if len(args) != 1:
    print('get_type_all requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_type_all(args[0],))

elif cmd == 'get_fields':
  if len(args) != 2:
    print('get_fields requires 2 args')
    sys.exit(1)
  pp.pprint(client.get_fields(args[0],args[1],))

elif cmd == 'get_fields_with_environment_context':
  if len(args) != 3:
    print('get_fields_with_environment_context requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_fields_with_environment_context(args[0],args[1],eval(args[2]),))

elif cmd == 'get_schema':
  if len(args) != 2:
    print('get_schema requires 2 args')
    sys.exit(1)
  pp.pprint(client.get_schema(args[0],args[1],))

elif cmd == 'get_schema_with_environment_context':
  if len(args) != 3:
    print('get_schema_with_environment_context requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_schema_with_environment_context(args[0],args[1],eval(args[2]),))

elif cmd == 'create_table':
  if len(args) != 1:
    print('create_table requires 1 args')
    sys.exit(1)
  pp.pprint(client.create_table(eval(args[0]),))

elif cmd == 'create_table_with_environment_context':
  if len(args) != 2:
    print('create_table_with_environment_context requires 2 args')
    sys.exit(1)
  pp.pprint(client.create_table_with_environment_context(eval(args[0]),eval(args[1]),))

elif cmd == 'drop_table':
  if len(args) != 3:
    print('drop_table requires 3 args')
    sys.exit(1)
  pp.pprint(client.drop_table(args[0],args[1],eval(args[2]),))

elif cmd == 'drop_table_with_environment_context':
  if len(args) != 4:
    print('drop_table_with_environment_context requires 4 args')
    sys.exit(1)
  pp.pprint(client.drop_table_with_environment_context(args[0],args[1],eval(args[2]),eval(args[3]),))

elif cmd == 'get_tables':
  if len(args) != 2:
    print('get_tables requires 2 args')
    sys.exit(1)
  pp.pprint(client.get_tables(args[0],args[1],))

elif cmd == 'get_table_meta':
  if len(args) != 3:
    print('get_table_meta requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_table_meta(args[0],args[1],eval(args[2]),))

elif cmd == 'get_all_tables':
  if len(args) != 1:
    print('get_all_tables requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_all_tables(args[0],))

elif cmd == 'get_table':
  if len(args) != 2:
    print('get_table requires 2 args')
    sys.exit(1)
  pp.pprint(client.get_table(args[0],args[1],))

elif cmd == 'get_table_objects_by_name':
  if len(args) != 2:
    print('get_table_objects_by_name requires 2 args')
    sys.exit(1)
  pp.pprint(client.get_table_objects_by_name(args[0],eval(args[1]),))

elif cmd == 'get_table_names_by_filter':
  if len(args) != 3:
    print('get_table_names_by_filter requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_table_names_by_filter(args[0],args[1],eval(args[2]),))

elif cmd == 'alter_table':
  if len(args) != 3:
    print('alter_table requires 3 args')
    sys.exit(1)
  pp.pprint(client.alter_table(args[0],args[1],eval(args[2]),))

elif cmd == 'alter_table_with_environment_context':
  if len(args) != 4:
    print('alter_table_with_environment_context requires 4 args')
    sys.exit(1)
  pp.pprint(client.alter_table_with_environment_context(args[0],args[1],eval(args[2]),eval(args[3]),))

elif cmd == 'alter_table_with_cascade':
  if len(args) != 4:
    print('alter_table_with_cascade requires 4 args')
    sys.exit(1)
  pp.pprint(client.alter_table_with_cascade(args[0],args[1],eval(args[2]),eval(args[3]),))

elif cmd == 'add_partition':
  if len(args) != 1:
    print('add_partition requires 1 args')
    sys.exit(1)
  pp.pprint(client.add_partition(eval(args[0]),))

elif cmd == 'add_partition_with_environment_context':
  if len(args) != 2:
    print('add_partition_with_environment_context requires 2 args')
    sys.exit(1)
  pp.pprint(client.add_partition_with_environment_context(eval(args[0]),eval(args[1]),))

elif cmd == 'add_partitions':
  if len(args) != 1:
    print('add_partitions requires 1 args')
    sys.exit(1)
  pp.pprint(client.add_partitions(eval(args[0]),))

elif cmd == 'add_partitions_pspec':
  if len(args) != 1:
    print('add_partitions_pspec requires 1 args')
    sys.exit(1)
  pp.pprint(client.add_partitions_pspec(eval(args[0]),))

elif cmd == 'append_partition':
  if len(args) != 3:
    print('append_partition requires 3 args')
    sys.exit(1)
  pp.pprint(client.append_partition(args[0],args[1],eval(args[2]),))

elif cmd == 'add_partitions_req':
  if len(args) != 1:
    print('add_partitions_req requires 1 args')
    sys.exit(1)
  pp.pprint(client.add_partitions_req(eval(args[0]),))

elif cmd == 'append_partition_with_environment_context':
  if len(args) != 4:
    print('append_partition_with_environment_context requires 4 args')
    sys.exit(1)
  pp.pprint(client.append_partition_with_environment_context(args[0],args[1],eval(args[2]),eval(args[3]),))

elif cmd == 'append_partition_by_name':
  if len(args) != 3:
    print('append_partition_by_name requires 3 args')
    sys.exit(1)
  pp.pprint(client.append_partition_by_name(args[0],args[1],args[2],))

elif cmd == 'append_partition_by_name_with_environment_context':
  if len(args) != 4:
    print('append_partition_by_name_with_environment_context requires 4 args')
    sys.exit(1)
  pp.pprint(client.append_partition_by_name_with_environment_context(args[0],args[1],args[2],eval(args[3]),))

elif cmd == 'drop_partition':
  if len(args) != 4:
    print('drop_partition requires 4 args')
    sys.exit(1)
  pp.pprint(client.drop_partition(args[0],args[1],eval(args[2]),eval(args[3]),))

elif cmd == 'drop_partition_with_environment_context':
  if len(args) != 5:
    print('drop_partition_with_environment_context requires 5 args')
    sys.exit(1)
  pp.pprint(client.drop_partition_with_environment_context(args[0],args[1],eval(args[2]),eval(args[3]),eval(args[4]),))

elif cmd == 'drop_partition_by_name':
  if len(args) != 4:
    print('drop_partition_by_name requires 4 args')
    sys.exit(1)
  pp.pprint(client.drop_partition_by_name(args[0],args[1],args[2],eval(args[3]),))

elif cmd == 'drop_partition_by_name_with_environment_context':
  if len(args) != 5:
    print('drop_partition_by_name_with_environment_context requires 5 args')
    sys.exit(1)
  pp.pprint(client.drop_partition_by_name_with_environment_context(args[0],args[1],args[2],eval(args[3]),eval(args[4]),))

elif cmd == 'drop_partitions_req':
  if len(args) != 1:
    print('drop_partitions_req requires 1 args')
    sys.exit(1)
  pp.pprint(client.drop_partitions_req(eval(args[0]),))

elif cmd == 'get_partition':
  if len(args) != 3:
    print('get_partition requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_partition(args[0],args[1],eval(args[2]),))

elif cmd == 'exchange_partition':
  if len(args) != 5:
    print('exchange_partition requires 5 args')
    sys.exit(1)
  pp.pprint(client.exchange_partition(eval(args[0]),args[1],args[2],args[3],args[4],))

elif cmd == 'exchange_partitions':
  if len(args) != 5:
    print('exchange_partitions requires 5 args')
    sys.exit(1)
  pp.pprint(client.exchange_partitions(eval(args[0]),args[1],args[2],args[3],args[4],))

elif cmd == 'get_partition_with_auth':
  if len(args) != 5:
    print('get_partition_with_auth requires 5 args')
    sys.exit(1)
  pp.pprint(client.get_partition_with_auth(args[0],args[1],eval(args[2]),args[3],eval(args[4]),))

elif cmd == 'get_partition_by_name':
  if len(args) != 3:
    print('get_partition_by_name requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_partition_by_name(args[0],args[1],args[2],))

elif cmd == 'get_partitions':
  if len(args) != 3:
    print('get_partitions requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_partitions(args[0],args[1],eval(args[2]),))

elif cmd == 'get_partitions_with_auth':
  if len(args) != 5:
    print('get_partitions_with_auth requires 5 args')
    sys.exit(1)
  pp.pprint(client.get_partitions_with_auth(args[0],args[1],eval(args[2]),args[3],eval(args[4]),))

elif cmd == 'get_partitions_pspec':
  if len(args) != 3:
    print('get_partitions_pspec requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_partitions_pspec(args[0],args[1],eval(args[2]),))

elif cmd == 'get_partition_names':
  if len(args) != 3:
    print('get_partition_names requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_partition_names(args[0],args[1],eval(args[2]),))

elif cmd == 'get_partitions_ps':
  if len(args) != 4:
    print('get_partitions_ps requires 4 args')
    sys.exit(1)
  pp.pprint(client.get_partitions_ps(args[0],args[1],eval(args[2]),eval(args[3]),))

elif cmd == 'get_partitions_ps_with_auth':
  if len(args) != 6:
    print('get_partitions_ps_with_auth requires 6 args')
    sys.exit(1)
  pp.pprint(client.get_partitions_ps_with_auth(args[0],args[1],eval(args[2]),eval(args[3]),args[4],eval(args[5]),))

elif cmd == 'get_partition_names_ps':
  if len(args) != 4:
    print('get_partition_names_ps requires 4 args')
    sys.exit(1)
  pp.pprint(client.get_partition_names_ps(args[0],args[1],eval(args[2]),eval(args[3]),))

elif cmd == 'get_partitions_by_filter':
  if len(args) != 4:
    print('get_partitions_by_filter requires 4 args')
    sys.exit(1)
  pp.pprint(client.get_partitions_by_filter(args[0],args[1],args[2],eval(args[3]),))

elif cmd == 'get_part_specs_by_filter':
  if len(args) != 4:
    print('get_part_specs_by_filter requires 4 args')
    sys.exit(1)
  pp.pprint(client.get_part_specs_by_filter(args[0],args[1],args[2],eval(args[3]),))

elif cmd == 'get_partitions_by_expr':
  if len(args) != 1:
    print('get_partitions_by_expr requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_partitions_by_expr(eval(args[0]),))

elif cmd == 'get_partitions_by_names':
  if len(args) != 3:
    print('get_partitions_by_names requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_partitions_by_names(args[0],args[1],eval(args[2]),))

elif cmd == 'alter_partition':
  if len(args) != 3:
    print('alter_partition requires 3 args')
    sys.exit(1)
  pp.pprint(client.alter_partition(args[0],args[1],eval(args[2]),))

elif cmd == 'alter_partitions':
  if len(args) != 3:
    print('alter_partitions requires 3 args')
    sys.exit(1)
  pp.pprint(client.alter_partitions(args[0],args[1],eval(args[2]),))

elif cmd == 'alter_partition_with_environment_context':
  if len(args) != 4:
    print('alter_partition_with_environment_context requires 4 args')
    sys.exit(1)
  pp.pprint(client.alter_partition_with_environment_context(args[0],args[1],eval(args[2]),eval(args[3]),))

elif cmd == 'rename_partition':
  if len(args) != 4:
    print('rename_partition requires 4 args')
    sys.exit(1)
  pp.pprint(client.rename_partition(args[0],args[1],eval(args[2]),eval(args[3]),))

elif cmd == 'partition_name_has_valid_characters':
  if len(args) != 2:
    print('partition_name_has_valid_characters requires 2 args')
    sys.exit(1)
  pp.pprint(client.partition_name_has_valid_characters(eval(args[0]),eval(args[1]),))

elif cmd == 'get_config_value':
  if len(args) != 2:
    print('get_config_value requires 2 args')
    sys.exit(1)
  pp.pprint(client.get_config_value(args[0],args[1],))

elif cmd == 'partition_name_to_vals':
  if len(args) != 1:
    print('partition_name_to_vals requires 1 args')
    sys.exit(1)
  pp.pprint(client.partition_name_to_vals(args[0],))

elif cmd == 'partition_name_to_spec':
  if len(args) != 1:
    print('partition_name_to_spec requires 1 args')
    sys.exit(1)
  pp.pprint(client.partition_name_to_spec(args[0],))

elif cmd == 'markPartitionForEvent':
  if len(args) != 4:
    print('markPartitionForEvent requires 4 args')
    sys.exit(1)
  pp.pprint(client.markPartitionForEvent(args[0],args[1],eval(args[2]),eval(args[3]),))

elif cmd == 'isPartitionMarkedForEvent':
  if len(args) != 4:
    print('isPartitionMarkedForEvent requires 4 args')
    sys.exit(1)
  pp.pprint(client.isPartitionMarkedForEvent(args[0],args[1],eval(args[2]),eval(args[3]),))

elif cmd == 'add_index':
  if len(args) != 2:
    print('add_index requires 2 args')
    sys.exit(1)
  pp.pprint(client.add_index(eval(args[0]),eval(args[1]),))

elif cmd == 'alter_index':
  if len(args) != 4:
    print('alter_index requires 4 args')
    sys.exit(1)
  pp.pprint(client.alter_index(args[0],args[1],args[2],eval(args[3]),))

elif cmd == 'drop_index_by_name':
  if len(args) != 4:
    print('drop_index_by_name requires 4 args')
    sys.exit(1)
  pp.pprint(client.drop_index_by_name(args[0],args[1],args[2],eval(args[3]),))

elif cmd == 'get_index_by_name':
  if len(args) != 3:
    print('get_index_by_name requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_index_by_name(args[0],args[1],args[2],))

elif cmd == 'get_indexes':
  if len(args) != 3:
    print('get_indexes requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_indexes(args[0],args[1],eval(args[2]),))

elif cmd == 'get_index_names':
  if len(args) != 3:
    print('get_index_names requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_index_names(args[0],args[1],eval(args[2]),))

elif cmd == 'update_table_column_statistics':
  if len(args) != 1:
    print('update_table_column_statistics requires 1 args')
    sys.exit(1)
  pp.pprint(client.update_table_column_statistics(eval(args[0]),))

elif cmd == 'update_partition_column_statistics':
  if len(args) != 1:
    print('update_partition_column_statistics requires 1 args')
    sys.exit(1)
  pp.pprint(client.update_partition_column_statistics(eval(args[0]),))

elif cmd == 'get_table_column_statistics':
  if len(args) != 3:
    print('get_table_column_statistics requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_table_column_statistics(args[0],args[1],args[2],))

elif cmd == 'get_partition_column_statistics':
  if len(args) != 4:
    print('get_partition_column_statistics requires 4 args')
    sys.exit(1)
  pp.pprint(client.get_partition_column_statistics(args[0],args[1],args[2],args[3],))

elif cmd == 'get_table_statistics_req':
  if len(args) != 1:
    print('get_table_statistics_req requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_table_statistics_req(eval(args[0]),))

elif cmd == 'get_partitions_statistics_req':
  if len(args) != 1:
    print('get_partitions_statistics_req requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_partitions_statistics_req(eval(args[0]),))

elif cmd == 'get_aggr_stats_for':
  if len(args) != 1:
    print('get_aggr_stats_for requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_aggr_stats_for(eval(args[0]),))

elif cmd == 'set_aggr_stats_for':
  if len(args) != 1:
    print('set_aggr_stats_for requires 1 args')
    sys.exit(1)
  pp.pprint(client.set_aggr_stats_for(eval(args[0]),))

elif cmd == 'delete_partition_column_statistics':
  if len(args) != 4:
    print('delete_partition_column_statistics requires 4 args')
    sys.exit(1)
  pp.pprint(client.delete_partition_column_statistics(args[0],args[1],args[2],args[3],))

elif cmd == 'delete_table_column_statistics':
  if len(args) != 3:
    print('delete_table_column_statistics requires 3 args')
    sys.exit(1)
  pp.pprint(client.delete_table_column_statistics(args[0],args[1],args[2],))

elif cmd == 'create_function':
  if len(args) != 1:
    print('create_function requires 1 args')
    sys.exit(1)
  pp.pprint(client.create_function(eval(args[0]),))

elif cmd == 'drop_function':
  if len(args) != 2:
    print('drop_function requires 2 args')
    sys.exit(1)
  pp.pprint(client.drop_function(args[0],args[1],))

elif cmd == 'alter_function':
  if len(args) != 3:
    print('alter_function requires 3 args')
    sys.exit(1)
  pp.pprint(client.alter_function(args[0],args[1],eval(args[2]),))

elif cmd == 'get_functions':
  if len(args) != 2:
    print('get_functions requires 2 args')
    sys.exit(1)
  pp.pprint(client.get_functions(args[0],args[1],))

elif cmd == 'get_function':
  if len(args) != 2:
    print('get_function requires 2 args')
    sys.exit(1)
  pp.pprint(client.get_function(args[0],args[1],))

elif cmd == 'get_all_functions':
  if len(args) != 0:
    print('get_all_functions requires 0 args')
    sys.exit(1)
  pp.pprint(client.get_all_functions())

elif cmd == 'create_role':
  if len(args) != 1:
    print('create_role requires 1 args')
    sys.exit(1)
  pp.pprint(client.create_role(eval(args[0]),))

elif cmd == 'drop_role':
  if len(args) != 1:
    print('drop_role requires 1 args')
    sys.exit(1)
  pp.pprint(client.drop_role(args[0],))

elif cmd == 'get_role_names':
  if len(args) != 0:
    print('get_role_names requires 0 args')
    sys.exit(1)
  pp.pprint(client.get_role_names())

elif cmd == 'grant_role':
  if len(args) != 6:
    print('grant_role requires 6 args')
    sys.exit(1)
  pp.pprint(client.grant_role(args[0],args[1],eval(args[2]),args[3],eval(args[4]),eval(args[5]),))

elif cmd == 'revoke_role':
  if len(args) != 3:
    print('revoke_role requires 3 args')
    sys.exit(1)
  pp.pprint(client.revoke_role(args[0],args[1],eval(args[2]),))

elif cmd == 'list_roles':
  if len(args) != 2:
    print('list_roles requires 2 args')
    sys.exit(1)
  pp.pprint(client.list_roles(args[0],eval(args[1]),))

elif cmd == 'grant_revoke_role':
  if len(args) != 1:
    print('grant_revoke_role requires 1 args')
    sys.exit(1)
  pp.pprint(client.grant_revoke_role(eval(args[0]),))

elif cmd == 'get_principals_in_role':
  if len(args) != 1:
    print('get_principals_in_role requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_principals_in_role(eval(args[0]),))

elif cmd == 'get_role_grants_for_principal':
  if len(args) != 1:
    print('get_role_grants_for_principal requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_role_grants_for_principal(eval(args[0]),))

elif cmd == 'get_privilege_set':
  if len(args) != 3:
    print('get_privilege_set requires 3 args')
    sys.exit(1)
  pp.pprint(client.get_privilege_set(eval(args[0]),args[1],eval(args[2]),))

elif cmd == 'list_privileges':
  if len(args) != 3:
    print('list_privileges requires 3 args')
    sys.exit(1)
  pp.pprint(client.list_privileges(args[0],eval(args[1]),eval(args[2]),))

elif cmd == 'grant_privileges':
  if len(args) != 1:
    print('grant_privileges requires 1 args')
    sys.exit(1)
  pp.pprint(client.grant_privileges(eval(args[0]),))

elif cmd == 'revoke_privileges':
  if len(args) != 1:
    print('revoke_privileges requires 1 args')
    sys.exit(1)
  pp.pprint(client.revoke_privileges(eval(args[0]),))

elif cmd == 'grant_revoke_privileges':
  if len(args) != 1:
    print('grant_revoke_privileges requires 1 args')
    sys.exit(1)
  pp.pprint(client.grant_revoke_privileges(eval(args[0]),))

elif cmd == 'set_ugi':
  if len(args) != 2:
    print('set_ugi requires 2 args')
    sys.exit(1)
  pp.pprint(client.set_ugi(args[0],eval(args[1]),))

elif cmd == 'get_delegation_token':
  if len(args) != 2:
    print('get_delegation_token requires 2 args')
    sys.exit(1)
  pp.pprint(client.get_delegation_token(args[0],args[1],))

elif cmd == 'renew_delegation_token':
  if len(args) != 1:
    print('renew_delegation_token requires 1 args')
    sys.exit(1)
  pp.pprint(client.renew_delegation_token(args[0],))

elif cmd == 'cancel_delegation_token':
  if len(args) != 1:
    print('cancel_delegation_token requires 1 args')
    sys.exit(1)
  pp.pprint(client.cancel_delegation_token(args[0],))

elif cmd == 'get_open_txns':
  if len(args) != 0:
    print('get_open_txns requires 0 args')
    sys.exit(1)
  pp.pprint(client.get_open_txns())

elif cmd == 'get_open_txns_info':
  if len(args) != 0:
    print('get_open_txns_info requires 0 args')
    sys.exit(1)
  pp.pprint(client.get_open_txns_info())

elif cmd == 'open_txns':
  if len(args) != 1:
    print('open_txns requires 1 args')
    sys.exit(1)
  pp.pprint(client.open_txns(eval(args[0]),))

elif cmd == 'abort_txn':
  if len(args) != 1:
    print('abort_txn requires 1 args')
    sys.exit(1)
  pp.pprint(client.abort_txn(eval(args[0]),))

elif cmd == 'commit_txn':
  if len(args) != 1:
    print('commit_txn requires 1 args')
    sys.exit(1)
  pp.pprint(client.commit_txn(eval(args[0]),))

elif cmd == 'lock':
  if len(args) != 1:
    print('lock requires 1 args')
    sys.exit(1)
  pp.pprint(client.lock(eval(args[0]),))

elif cmd == 'check_lock':
  if len(args) != 1:
    print('check_lock requires 1 args')
    sys.exit(1)
  pp.pprint(client.check_lock(eval(args[0]),))

elif cmd == 'unlock':
  if len(args) != 1:
    print('unlock requires 1 args')
    sys.exit(1)
  pp.pprint(client.unlock(eval(args[0]),))

elif cmd == 'show_locks':
  if len(args) != 1:
    print('show_locks requires 1 args')
    sys.exit(1)
  pp.pprint(client.show_locks(eval(args[0]),))

elif cmd == 'heartbeat':
  if len(args) != 1:
    print('heartbeat requires 1 args')
    sys.exit(1)
  pp.pprint(client.heartbeat(eval(args[0]),))

elif cmd == 'heartbeat_txn_range':
  if len(args) != 1:
    print('heartbeat_txn_range requires 1 args')
    sys.exit(1)
  pp.pprint(client.heartbeat_txn_range(eval(args[0]),))

elif cmd == 'compact':
  if len(args) != 1:
    print('compact requires 1 args')
    sys.exit(1)
  pp.pprint(client.compact(eval(args[0]),))

elif cmd == 'show_compact':
  if len(args) != 1:
    print('show_compact requires 1 args')
    sys.exit(1)
  pp.pprint(client.show_compact(eval(args[0]),))

elif cmd == 'add_dynamic_partitions':
  if len(args) != 1:
    print('add_dynamic_partitions requires 1 args')
    sys.exit(1)
  pp.pprint(client.add_dynamic_partitions(eval(args[0]),))

elif cmd == 'get_next_notification':
  if len(args) != 1:
    print('get_next_notification requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_next_notification(eval(args[0]),))

elif cmd == 'get_current_notificationEventId':
  if len(args) != 0:
    print('get_current_notificationEventId requires 0 args')
    sys.exit(1)
  pp.pprint(client.get_current_notificationEventId())

elif cmd == 'fire_listener_event':
  if len(args) != 1:
    print('fire_listener_event requires 1 args')
    sys.exit(1)
  pp.pprint(client.fire_listener_event(eval(args[0]),))

elif cmd == 'flushCache':
  if len(args) != 0:
    print('flushCache requires 0 args')
    sys.exit(1)
  pp.pprint(client.flushCache())

elif cmd == 'get_file_metadata_by_expr':
  if len(args) != 1:
    print('get_file_metadata_by_expr requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_file_metadata_by_expr(eval(args[0]),))

elif cmd == 'get_file_metadata':
  if len(args) != 1:
    print('get_file_metadata requires 1 args')
    sys.exit(1)
  pp.pprint(client.get_file_metadata(eval(args[0]),))

elif cmd == 'put_file_metadata':
  if len(args) != 1:
    print('put_file_metadata requires 1 args')
    sys.exit(1)
  pp.pprint(client.put_file_metadata(eval(args[0]),))

elif cmd == 'clear_file_metadata':
  if len(args) != 1:
    print('clear_file_metadata requires 1 args')
    sys.exit(1)
  pp.pprint(client.clear_file_metadata(eval(args[0]),))

elif cmd == 'getName':
  if len(args) != 0:
    print('getName requires 0 args')
    sys.exit(1)
  pp.pprint(client.getName())

elif cmd == 'getVersion':
  if len(args) != 0:
    print('getVersion requires 0 args')
    sys.exit(1)
  pp.pprint(client.getVersion())

elif cmd == 'getStatus':
  if len(args) != 0:
    print('getStatus requires 0 args')
    sys.exit(1)
  pp.pprint(client.getStatus())

elif cmd == 'getStatusDetails':
  if len(args) != 0:
    print('getStatusDetails requires 0 args')
    sys.exit(1)
  pp.pprint(client.getStatusDetails())

elif cmd == 'getCounters':
  if len(args) != 0:
    print('getCounters requires 0 args')
    sys.exit(1)
  pp.pprint(client.getCounters())

elif cmd == 'getCounter':
  if len(args) != 1:
    print('getCounter requires 1 args')
    sys.exit(1)
  pp.pprint(client.getCounter(args[0],))

elif cmd == 'setOption':
  if len(args) != 2:
    print('setOption requires 2 args')
    sys.exit(1)
  pp.pprint(client.setOption(args[0],args[1],))

elif cmd == 'getOption':
  if len(args) != 1:
    print('getOption requires 1 args')
    sys.exit(1)
  pp.pprint(client.getOption(args[0],))

elif cmd == 'getOptions':
  if len(args) != 0:
    print('getOptions requires 0 args')
    sys.exit(1)
  pp.pprint(client.getOptions())

elif cmd == 'getCpuProfile':
  if len(args) != 1:
    print('getCpuProfile requires 1 args')
    sys.exit(1)
  pp.pprint(client.getCpuProfile(eval(args[0]),))

elif cmd == 'aliveSince':
  if len(args) != 0:
    print('aliveSince requires 0 args')
    sys.exit(1)
  pp.pprint(client.aliveSince())

elif cmd == 'reinitialize':
  if len(args) != 0:
    print('reinitialize requires 0 args')
    sys.exit(1)
  pp.pprint(client.reinitialize())

elif cmd == 'shutdown':
  if len(args) != 0:
    print('shutdown requires 0 args')
    sys.exit(1)
  pp.pprint(client.shutdown())

else:
  print('Unrecognized method %s' % cmd)
  sys.exit(1)

transport.close()
