#!/usr/bin/env python
#
# Autogenerated by Thrift Compiler (0.9.3)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py
#

import sys
import pprint
from urlparse import urlparse
from thrift.transport import TTransport
from thrift.transport import TSocket
from thrift.transport import TSSLSocket
from thrift.transport import THttpClient
from thrift.protocol import TBinaryProtocol

from fb303 import FacebookService
from fb303.ttypes import *

if len(sys.argv) <= 1 or sys.argv[1] == '--help':
  print('')
  print('Usage: ' + sys.argv[0] + ' [-h host[:port]] [-u url] [-f[ramed]] [-s[sl]] function [arg1 [arg2...]]')
  print('')
  print('Functions:')
  print('  string getName()')
  print('  string getVersion()')
  print('  fb_status getStatus()')
  print('  string getStatusDetails()')
  print('   getCounters()')
  print('  i64 getCounter(string key)')
  print('  void setOption(string key, string value)')
  print('  string getOption(string key)')
  print('   getOptions()')
  print('  string getCpuProfile(i32 profileDurationInSec)')
  print('  i64 aliveSince()')
  print('  void reinitialize()')
  print('  void shutdown()')
  print('')
  sys.exit(0)

pp = pprint.PrettyPrinter(indent = 2)
host = 'localhost'
port = 9090
uri = ''
framed = False
ssl = False
http = False
argi = 1

if sys.argv[argi] == '-h':
  parts = sys.argv[argi+1].split(':')
  host = parts[0]
  if len(parts) > 1:
    port = int(parts[1])
  argi += 2

if sys.argv[argi] == '-u':
  url = urlparse(sys.argv[argi+1])
  parts = url[1].split(':')
  host = parts[0]
  if len(parts) > 1:
    port = int(parts[1])
  else:
    port = 80
  uri = url[2]
  if url[4]:
    uri += '?%s' % url[4]
  http = True
  argi += 2

if sys.argv[argi] == '-f' or sys.argv[argi] == '-framed':
  framed = True
  argi += 1

if sys.argv[argi] == '-s' or sys.argv[argi] == '-ssl':
  ssl = True
  argi += 1

cmd = sys.argv[argi]
args = sys.argv[argi+1:]

if http:
  transport = THttpClient.THttpClient(host, port, uri)
else:
  socket = TSSLSocket.TSSLSocket(host, port, validate=False) if ssl else TSocket.TSocket(host, port)
  if framed:
    transport = TTransport.TFramedTransport(socket)
  else:
    transport = TTransport.TBufferedTransport(socket)
protocol = TBinaryProtocol.TBinaryProtocol(transport)
client = FacebookService.Client(protocol)
transport.open()

if cmd == 'getName':
  if len(args) != 0:
    print('getName requires 0 args')
    sys.exit(1)
  pp.pprint(client.getName())

elif cmd == 'getVersion':
  if len(args) != 0:
    print('getVersion requires 0 args')
    sys.exit(1)
  pp.pprint(client.getVersion())

elif cmd == 'getStatus':
  if len(args) != 0:
    print('getStatus requires 0 args')
    sys.exit(1)
  pp.pprint(client.getStatus())

elif cmd == 'getStatusDetails':
  if len(args) != 0:
    print('getStatusDetails requires 0 args')
    sys.exit(1)
  pp.pprint(client.getStatusDetails())

elif cmd == 'getCounters':
  if len(args) != 0:
    print('getCounters requires 0 args')
    sys.exit(1)
  pp.pprint(client.getCounters())

elif cmd == 'getCounter':
  if len(args) != 1:
    print('getCounter requires 1 args')
    sys.exit(1)
  pp.pprint(client.getCounter(args[0],))

elif cmd == 'setOption':
  if len(args) != 2:
    print('setOption requires 2 args')
    sys.exit(1)
  pp.pprint(client.setOption(args[0],args[1],))

elif cmd == 'getOption':
  if len(args) != 1:
    print('getOption requires 1 args')
    sys.exit(1)
  pp.pprint(client.getOption(args[0],))

elif cmd == 'getOptions':
  if len(args) != 0:
    print('getOptions requires 0 args')
    sys.exit(1)
  pp.pprint(client.getOptions())

elif cmd == 'getCpuProfile':
  if len(args) != 1:
    print('getCpuProfile requires 1 args')
    sys.exit(1)
  pp.pprint(client.getCpuProfile(eval(args[0]),))

elif cmd == 'aliveSince':
  if len(args) != 0:
    print('aliveSince requires 0 args')
    sys.exit(1)
  pp.pprint(client.aliveSince())

elif cmd == 'reinitialize':
  if len(args) != 0:
    print('reinitialize requires 0 args')
    sys.exit(1)
  pp.pprint(client.reinitialize())

elif cmd == 'shutdown':
  if len(args) != 0:
    print('shutdown requires 0 args')
    sys.exit(1)
  pp.pprint(client.shutdown())

else:
  print('Unrecognized method %s' % cmd)
  sys.exit(1)

transport.close()
