# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tracktime', 'tracktime.synchronisers']

package_data = \
{'': ['*']}

install_requires = \
['docutils>=0.16,<0.17',
 'pdfkit>=0.6.1,<0.7.0',
 'pyyaml>=5.3.1,<6.0.0',
 'requests>=2.24.0,<3.0.0',
 'tabulate>=0.8.7,<0.9.0']

entry_points = \
{'console_scripts': ['tt = tracktime.__main__:main']}

setup_kwargs = {
    'name': 'tracktime',
    'version': '0.9.18',
    'description': 'Time tracking library with command line interface.',
    'long_description': "tracktime\n=========\n\n.. image:: https://builds.sr.ht/~sumner.svg?search=~sumner/tracktime tags:build.yml\n   :alt: Build Status\n   :target: https://builds.sr.ht/~sumner?search=%7Esumner%2Ftracktime+tags%3Abuild.yml\n.. image:: https://img.shields.io/pypi/v/tracktime?color=4DC71F&logo=python&logoColor=fff\n   :alt: PyPi Version\n   :target: https://pypi.org/project/tracktime/\n.. image:: https://img.shields.io/aur/version/tracktime?logo=linux&logoColor=fff\n   :alt: AUR Version\n   :target: https://aur.archlinux.org/packages/tracktime/\n.. image:: https://img.shields.io/liberapay/receives/sumner.svg?logo=liberapay\n   :alt: LiberaPay Donation Status\n   :target: https://liberapay.com/sumner/donate\n\ntracktime is a filesystem-backed time tracking solution. It uses a sane\ndirectory structure to organize CSV files that store time tracking data for each\nday.\n\nFeatures\n--------\n\n- CLI\n- Start/stop/resume time entries\n- List/edit time entries for a given day\n- Generate rST, PDF, HTML reports for arbitrary date ranges (optionally\n  restricted to a particular customer or project)\n- Synchronise time spent to GitLab using the Time Tracking API\n- Synchronise time spent to Sourcehut via comments on issues\n\nInstallation\n------------\n\nUsing PyPi::\n\n    pip install --user tracktime\n\nOn Arch Linux, you can install the ``tracktime`` package from the AUR. For\nexample, if you use ``yay``::\n\n    yay -S tracktime\n\nDependencies\n^^^^^^^^^^^^\n\nReport functionality requires ``wkhtmltopdf`` to be installed. If you install\nusing the AUR package, this will be installed automatically. Otherwise, you can\ninstall it using your distribution's package manager or visit their `homepage`__\nfor installation instructions specific to your operating system.\n\nAdditionally, you will need to ensure that the ``wkhtmltopdf`` executable is in\nyour ``$PATH``.\n\n__ https://wkhtmltopdf.org/\n\nGuiding Principles\n------------------\n\n- Filesystem based (want to be able to use Git to keep track of my time entries)\n- Easy to edit manually (not a binary format)\n- Must be able to use offline\n\nConfiguration Options\n---------------------\n\nThere are a number of configuration options that can be set in\n``~/.config/tracktime/tracktimerc``. The ``tracktimerc`` file is in YAML format.\nHere is a link to an `example configuration`_. Below is a list of each of the\noptions and what they do.\n\n- ``fullname`` (``string``) - your full name. This is used for generating\n  reports.\n- ``sync_time`` (``boolean``, defaults to ``false``) - determines whether or not\n  to synchronise with external services.\n- ``editor`` (``string``) - specifies the editor to use when ``tt edit`` is run.\n  If this value is not present, the ``EDITOR`` and ``VISUAL`` environment\n  variables are used as fallback. If none are present, then ``vim`` (on\n  non-Windows OSes) or ``notepad`` (on Windows) is used.\n- ``editor_args`` (``string``) - a comma separated list of arguments that should\n  be passed to the ``editor`` when ``tt edit`` is run.\n- ``gitlab`` (``dictionary``) - configuration of GitLab parameters\n\n  - ``api_root`` (``string``, defaults to ``'https://gitlab.com/api/v4/'``) -\n    the GitLab API root to use.\n  - ``api_key`` (``string``) - can be either your GitLab API Key in plain text\n    or a shell command which returns the API key. This second option can be\n    useful if you want to store your API key in a password manager. To indicate\n    that it is a shell command, append a vertical bar (``|``) at the end of the\n    command.\n\n    .. note::\n\n      You can create an API key here:\n      https://gitlab.com/profile/personal_access_tokens. The API Key must be\n      created with full API access. Used to sync with GitLab.\n\n- ``tableformat`` (``string``, defaults to ``simple``) - the type of table to\n  generate when exporting a report to stdout. (See the `tabulate documentation`_\n  for details on what formats are supported.)\n- ``project_rates`` (``dictionary``) - a dictionary of project-rate pairs. Used\n  to calculate totals for the report export.\n- ``customer_aliases`` (``dictionary``) - a dictionary of alias-full name\n  pairs. Used to expand a name on the report export. Useful when a customer has\n  a really long name.\n- ``customer_addresses`` (``dictionary``) - a dictionary of name-address\n  pairs. Used in the report export.\n- ``external_synchroniser_files`` - a dictionary of\n  ``synchroniser name -> synchroniser Python file``. Allows users to import\n  third party synchronisers.\n- ``day_worked_min_threshold`` - the number of minutes which must be worked in a\n  day to consider it a work day. This is to avoid days where you work for a few\n  minutes from skewing statistical results.\n\n.. _example configuration: https://git.sr.ht/~sumner/tracktime/tree/master/examples/tracktimerc\n.. _tabulate documentation: https://bitbucket.org/astanin/python-tabulate#rst-header-table-format\n\nArchitecture\n------------\n\nDirectory Structure\n^^^^^^^^^^^^^^^^^^^\n\n::\n\n    /<root>\n    |-> 2017\n    |   |-> 01\n    |   |   |-> .synced\n    |   |   |-> 01\n    |   |   |-> 02\n    |   |   |-> ...\n    |   |-> 02\n    |   |-> ...\n    |-> 2018\n\nIn other words, the generic path is ``YEAR/MONTH/DAY`` where all three fields\nare the numeric, zero-padded.\n\nEach day with time tracked will have a corresponding file and have the file\nformat as described below.\n\nThe ``.synced`` file in each month's directory stores the amount of time that\nhas been reported to the external services.\n\nTime Tracking File Format\n^^^^^^^^^^^^^^^^^^^^^^^^^\n\nAll time tracking files will be CSVs with the following fields:\n\n- ``start`` - the start time for the time entry\n- ``stop`` - the stop time for the time entry\n- ``project`` - the project for the time entry\n- ``type`` - the type of entry (gitlab, github, or none)\n- ``taskid`` - the task ID (issue/PR/MR/story number)\n- ``customer`` - the customer the entry is for\n- ``notes`` - any notes about the time entry\n\nThe ``start`` and ``stop`` fields will be times, formatted in ``HH:MM`` where\n``HH`` is 24-hour time. All other fields are text fields that can hold arbitrary\ndata.\n\nSynced Time File Format\n^^^^^^^^^^^^^^^^^^^^^^^\n\nAll ``.synced`` files will be CSVs with the following fields:\n\n- ``type`` - the type of taskid (gitlab, github, or none)\n- ``project`` - the project that the taskid is associated with\n- ``taskid`` - the task ID (issue/PR/MR/story number)\n- ``synced`` - the amount of time that has been successfully pushed to the\n  external service for this taskid\n\nSynchronising to External Services\n----------------------------------\n\ntracktime can sync tracked time with external services. It does this by keeping\ntrack of how much time it has been reported to the external service using the\n``.synced`` file in each month's directory. Then, it pushes changes to the\nexternal service.\n\n**This is not a two-way sync! tracktime only pushes changes, it does not poll\nfor changes to the external services.**\n\nSupported External Services\n^^^^^^^^^^^^^^^^^^^^^^^^^^^\n\n- GitLab\n- Sourcehut\n\nContributing\n------------\n\nSee the CONTRIBUTING.md_ document for details on how to contribute to the\nproject.\n\n.. _CONTRIBUTING.md: https://git.sr.ht/~sumner/tracktime/tree/master/CONTRIBUTING.md\n\nUnsupported Edge Cases\n----------------------\n\n- Daylight savings time (if you are needing to track time at 02:00 in the\n  morning, I pitty you).\n- Time entries that span multiple days (if you are working that late, create two\n  entries).\n- Timezones (only switch timezones between days, if you have to switch, just\n  make sure that you keep the timezone consistent for a given day).\n",
    'author': 'Sumner Evans',
    'author_email': 'inquiries@sumnerevans.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://git.sr.ht/~sumner/tracktime',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
