from http import HTTPStatus
from typing import Any, Dict, Optional, Union, cast

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.body_delete_entries_by_file_exact_entries_by_file_delete import (
    BodyDeleteEntriesByFileExactEntriesByFileDelete,
)
from ...models.http_validation_error import HTTPValidationError
from ...types import UNSET, Response


def _get_kwargs(
    *,
    multipart_data: BodyDeleteEntriesByFileExactEntriesByFileDelete,
    collection_name: str,
) -> Dict[str, Any]:
    pass

    params: Dict[str, Any] = {}
    params["collection_name"] = collection_name

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    multipart_multipart_data = multipart_data.to_multipart()

    return {
        "method": "delete",
        "url": "/exact/entries/by-file",
        "files": multipart_multipart_data,
        "params": params,
    }


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Any, HTTPValidationError]]:
    if response.status_code == HTTPStatus.OK:
        response_200 = cast(Any, response.json())
        return response_200
    if response.status_code == HTTPStatus.NOT_FOUND:
        response_404 = cast(Any, None)
        return response_404
    if response.status_code == HTTPStatus.UNPROCESSABLE_ENTITY:
        response_422 = HTTPValidationError.from_dict(response.json())

        return response_422
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Any, HTTPValidationError]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient,
    multipart_data: BodyDeleteEntriesByFileExactEntriesByFileDelete,
    collection_name: str,
) -> Response[Union[Any, HTTPValidationError]]:
    """Delete Entries By File

     Delete entries in exact collections by rehashing files

    Args:
        collection_name (str):
        multipart_data (BodyDeleteEntriesByFileExactEntriesByFileDelete):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, HTTPValidationError]]
    """

    kwargs = _get_kwargs(
        multipart_data=multipart_data,
        collection_name=collection_name,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: AuthenticatedClient,
    multipart_data: BodyDeleteEntriesByFileExactEntriesByFileDelete,
    collection_name: str,
) -> Optional[Union[Any, HTTPValidationError]]:
    """Delete Entries By File

     Delete entries in exact collections by rehashing files

    Args:
        collection_name (str):
        multipart_data (BodyDeleteEntriesByFileExactEntriesByFileDelete):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, HTTPValidationError]
    """

    return sync_detailed(
        client=client,
        multipart_data=multipart_data,
        collection_name=collection_name,
    ).parsed


async def asyncio_detailed(
    *,
    client: AuthenticatedClient,
    multipart_data: BodyDeleteEntriesByFileExactEntriesByFileDelete,
    collection_name: str,
) -> Response[Union[Any, HTTPValidationError]]:
    """Delete Entries By File

     Delete entries in exact collections by rehashing files

    Args:
        collection_name (str):
        multipart_data (BodyDeleteEntriesByFileExactEntriesByFileDelete):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, HTTPValidationError]]
    """

    kwargs = _get_kwargs(
        multipart_data=multipart_data,
        collection_name=collection_name,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: AuthenticatedClient,
    multipart_data: BodyDeleteEntriesByFileExactEntriesByFileDelete,
    collection_name: str,
) -> Optional[Union[Any, HTTPValidationError]]:
    """Delete Entries By File

     Delete entries in exact collections by rehashing files

    Args:
        collection_name (str):
        multipart_data (BodyDeleteEntriesByFileExactEntriesByFileDelete):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, HTTPValidationError]
    """

    return (
        await asyncio_detailed(
            client=client,
            multipart_data=multipart_data,
            collection_name=collection_name,
        )
    ).parsed
