from http import HTTPStatus
from typing import Any, Dict, Optional, Union, cast

import httpx

from ... import errors
from ...client import AuthenticatedClient, Client
from ...models.collection import Collection
from ...models.http_validation_error import HTTPValidationError
from ...types import UNSET, Response, Unset


def _get_kwargs(
    name: str,
    *,
    is_exact: Union[Unset, None, bool] = False,
) -> Dict[str, Any]:
    pass

    params: Dict[str, Any] = {}
    params["is_exact"] = is_exact

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    return {
        "method": "get",
        "url": "/collection/get/{name}".format(
            name=name,
        ),
        "params": params,
    }


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[Any, Collection, HTTPValidationError]]:
    if response.status_code == HTTPStatus.OK:
        response_200 = Collection.from_dict(response.json())

        return response_200
    if response.status_code == HTTPStatus.NOT_FOUND:
        response_404 = cast(Any, None)
        return response_404
    if response.status_code == HTTPStatus.UNPROCESSABLE_ENTITY:
        response_422 = HTTPValidationError.from_dict(response.json())

        return response_422
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[Any, Collection, HTTPValidationError]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    name: str,
    *,
    client: AuthenticatedClient,
    is_exact: Union[Unset, None, bool] = False,
) -> Response[Union[Any, Collection, HTTPValidationError]]:
    """Get Collection

     Get a collection

    Args:
        name (str):
        is_exact (Union[Unset, None, bool]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, Collection, HTTPValidationError]]
    """

    kwargs = _get_kwargs(
        name=name,
        is_exact=is_exact,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    name: str,
    *,
    client: AuthenticatedClient,
    is_exact: Union[Unset, None, bool] = False,
) -> Optional[Union[Any, Collection, HTTPValidationError]]:
    """Get Collection

     Get a collection

    Args:
        name (str):
        is_exact (Union[Unset, None, bool]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, Collection, HTTPValidationError]
    """

    return sync_detailed(
        name=name,
        client=client,
        is_exact=is_exact,
    ).parsed


async def asyncio_detailed(
    name: str,
    *,
    client: AuthenticatedClient,
    is_exact: Union[Unset, None, bool] = False,
) -> Response[Union[Any, Collection, HTTPValidationError]]:
    """Get Collection

     Get a collection

    Args:
        name (str):
        is_exact (Union[Unset, None, bool]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[Any, Collection, HTTPValidationError]]
    """

    kwargs = _get_kwargs(
        name=name,
        is_exact=is_exact,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    name: str,
    *,
    client: AuthenticatedClient,
    is_exact: Union[Unset, None, bool] = False,
) -> Optional[Union[Any, Collection, HTTPValidationError]]:
    """Get Collection

     Get a collection

    Args:
        name (str):
        is_exact (Union[Unset, None, bool]):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[Any, Collection, HTTPValidationError]
    """

    return (
        await asyncio_detailed(
            name=name,
            client=client,
            is_exact=is_exact,
        )
    ).parsed
