import { __awaiter, __generator } from "tslib";
import { sleep } from "./utils/sleep";
import { WaiterState } from "./waiter";
var exponentialBackoffWithJitter = function (minDelay, maxDelay, attemptCeiling, attempt) {
    if (attempt > attemptCeiling)
        return maxDelay;
    var delay = minDelay * Math.pow(2, (attempt - 1));
    return randomInRange(minDelay, delay);
};
var randomInRange = function (min, max) { return min + Math.random() * (max - min); };
export var runPolling = function (_a, input, acceptorChecks) {
    var minDelay = _a.minDelay, maxDelay = _a.maxDelay, maxWaitTime = _a.maxWaitTime, abortController = _a.abortController, client = _a.client, abortSignal = _a.abortSignal;
    return __awaiter(void 0, void 0, void 0, function () {
        var state, currentAttempt, waitUntil, attemptCeiling, delay, state_1;
        var _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0: return [4, acceptorChecks(client, input)];
                case 1:
                    state = (_c.sent()).state;
                    if (state !== WaiterState.RETRY) {
                        return [2, { state: state }];
                    }
                    currentAttempt = 1;
                    waitUntil = Date.now() + maxWaitTime * 1000;
                    attemptCeiling = Math.log(maxDelay / minDelay) / Math.log(2) + 1;
                    _c.label = 2;
                case 2:
                    if (!true) return [3, 5];
                    if (((_b = abortController === null || abortController === void 0 ? void 0 : abortController.signal) === null || _b === void 0 ? void 0 : _b.aborted) || (abortSignal === null || abortSignal === void 0 ? void 0 : abortSignal.aborted)) {
                        return [2, { state: WaiterState.ABORTED }];
                    }
                    delay = exponentialBackoffWithJitter(minDelay, maxDelay, attemptCeiling, currentAttempt);
                    if (Date.now() + delay * 1000 > waitUntil) {
                        return [2, { state: WaiterState.TIMEOUT }];
                    }
                    return [4, sleep(delay)];
                case 3:
                    _c.sent();
                    return [4, acceptorChecks(client, input)];
                case 4:
                    state_1 = (_c.sent()).state;
                    if (state_1 !== WaiterState.RETRY) {
                        return [2, { state: state_1 }];
                    }
                    currentAttempt += 1;
                    return [3, 2];
                case 5: return [2];
            }
        });
    });
};
