import { __assign, __awaiter, __generator } from "tslib";
import { runPolling } from "./poller";
import { validateWaiterOptions } from "./utils";
import { waiterServiceDefaults, WaiterState } from "./waiter";
var abortTimeout = function (abortSignal) { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        return [2, new Promise(function (resolve) {
                abortSignal.onabort = function () { return resolve({ state: WaiterState.ABORTED }); };
            })];
    });
}); };
export var createWaiter = function (options, input, acceptorChecks) { return __awaiter(void 0, void 0, void 0, function () {
    var params, exitConditions;
    return __generator(this, function (_a) {
        params = __assign(__assign({}, waiterServiceDefaults), options);
        validateWaiterOptions(params);
        exitConditions = [runPolling(params, input, acceptorChecks)];
        if (options.abortController) {
            exitConditions.push(abortTimeout(options.abortController.signal));
        }
        if (options.abortSignal) {
            exitConditions.push(abortTimeout(options.abortSignal));
        }
        return [2, Promise.race(exitConditions)];
    });
}); };
