"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionSecretStack = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_secretsmanager_1 = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("../../constructs");
class ActionSecretStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const sourceSecret = aws_secretsmanager_1.Secret.fromSecretNameV2(this, 'secretToStoreInGitHub', 'cdk-github/test/structured');
        const githubTokenSecret = aws_secretsmanager_1.Secret.fromSecretNameV2(this, 'ghSecret', 'GITHUB_TOKEN');
        new constructs_1.ActionSecret(this, 'GitHubActionSecret', {
            githubTokenSecret,
            repositoryName: 'cdk-github',
            repositoryOwner: 'wtfjoke',
            repositorySecretName: 'A_RANDOM_GITHUB_SECRET',
            sourceSecret,
            sourceSecretJsonField: 'key',
        });
    }
}
exports.ActionSecretStack = ActionSecretStack;
//# sourceMappingURL=data:application/json;base64,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