/**
 * Supported values for matching routes based on the HTTP request method.
 *
 * @stability stable
 */
export declare enum HttpRouteMethod {
    /**
     * GET request.
     *
     * @stability stable
     */
    GET = "GET",
    /**
     * HEAD request.
     *
     * @stability stable
     */
    HEAD = "HEAD",
    /**
     * POST request.
     *
     * @stability stable
     */
    POST = "POST",
    /**
     * PUT request.
     *
     * @stability stable
     */
    PUT = "PUT",
    /**
     * DELETE request.
     *
     * @stability stable
     */
    DELETE = "DELETE",
    /**
     * CONNECT request.
     *
     * @stability stable
     */
    CONNECT = "CONNECT",
    /**
     * OPTIONS request.
     *
     * @stability stable
     */
    OPTIONS = "OPTIONS",
    /**
     * TRACE request.
     *
     * @stability stable
     */
    TRACE = "TRACE",
    /**
     * PATCH request.
     *
     * @stability stable
     */
    PATCH = "PATCH"
}
