"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayRoute = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const appmesh_generated_1 = require("./appmesh.generated");
const utils_1 = require("./private/utils");
const virtual_gateway_1 = require("./virtual-gateway");
/**
 * GatewayRoute represents a new or existing gateway route attached to a VirtualGateway and Mesh.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html
 * @stability stable
 */
class GatewayRoute extends cdk.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.gatewayRouteName || cdk.Lazy.stringValue({ produce: () => this.node.uniqueId }),
        });
        this.virtualGateway = props.virtualGateway;
        const routeSpecConfig = props.routeSpec.bind(this);
        const gatewayRoute = new appmesh_generated_1.CfnGatewayRoute(this, 'Resource', {
            gatewayRouteName: this.physicalName,
            meshName: props.virtualGateway.mesh.meshName,
            meshOwner: utils_1.renderMeshOwner(this.env.account, this.virtualGateway.mesh.env.account),
            spec: {
                httpRoute: routeSpecConfig.httpSpecConfig,
                http2Route: routeSpecConfig.http2SpecConfig,
                grpcRoute: routeSpecConfig.grpcSpecConfig,
            },
            virtualGatewayName: this.virtualGateway.virtualGatewayName,
        });
        this.gatewayRouteName = this.getResourceNameAttribute(gatewayRoute.attrGatewayRouteName);
        this.gatewayRouteArn = this.getResourceArnAttribute(gatewayRoute.ref, {
            service: 'appmesh',
            resource: `mesh/${props.virtualGateway.mesh.meshName}/virtualRouter/${this.virtualGateway.virtualGatewayName}/gatewayRoute`,
            resourceName: this.physicalName,
        });
    }
    /**
     * Import an existing GatewayRoute given an ARN.
     *
     * @stability stable
     */
    static fromGatewayRouteArn(scope, id, gatewayRouteArn) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.gatewayRouteArn = gatewayRouteArn;
                this.gatewayRouteName = cdk.Fn.select(4, cdk.Fn.split('/', cdk.Stack.of(scope).parseArn(gatewayRouteArn).resourceName));
                this.virtualGateway = virtual_gateway_1.VirtualGateway.fromVirtualGatewayArn(this, 'virtualGateway', gatewayRouteArn);
            }
        }(scope, id);
    }
    /**
     * Import an existing GatewayRoute given attributes.
     *
     * @stability stable
     */
    static fromGatewayRouteAttributes(scope, id, attrs) {
        return new class extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.gatewayRouteName = attrs.gatewayRouteName;
                this.gatewayRouteArn = cdk.Stack.of(scope).formatArn({
                    service: 'appmesh',
                    resource: `mesh/${attrs.virtualGateway.mesh.meshName}/virtualGateway/${attrs.virtualGateway.virtualGatewayName}/gatewayRoute`,
                    resourceName: this.gatewayRouteName,
                });
                this.virtualGateway = attrs.virtualGateway;
            }
        }(scope, id);
    }
}
exports.GatewayRoute = GatewayRoute;
_a = JSII_RTTI_SYMBOL_1;
GatewayRoute[_a] = { fqn: "@aws-cdk/aws-appmesh.GatewayRoute", version: "1.132.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2F0ZXdheS1yb3V0ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImdhdGV3YXktcm91dGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSxxQ0FBcUM7QUFFckMsMkRBQXNEO0FBRXRELDJDQUFrRDtBQUNsRCx1REFBb0U7Ozs7Ozs7QUE4QnBFLE1BQWEsWUFBYSxTQUFRLEdBQUcsQ0FBQyxRQUFROzs7O0lBZ0M1QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXdCO1FBQ2hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsWUFBWSxFQUFFLEtBQUssQ0FBQyxnQkFBZ0IsSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxFQUFFLE9BQU8sRUFBRSxHQUFHLEVBQUUsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDO1NBQ3BHLENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxjQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztRQUMzQyxNQUFNLGVBQWUsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUVuRCxNQUFNLFlBQVksR0FBRyxJQUFJLG1DQUFlLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUN6RCxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsWUFBWTtZQUNuQyxRQUFRLEVBQUUsS0FBSyxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsUUFBUTtZQUM1QyxTQUFTLEVBQUUsdUJBQWUsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsT0FBTyxDQUFDO1lBQ2xGLElBQUksRUFBRTtnQkFDSixTQUFTLEVBQUUsZUFBZSxDQUFDLGNBQWM7Z0JBQ3pDLFVBQVUsRUFBRSxlQUFlLENBQUMsZUFBZTtnQkFDM0MsU0FBUyxFQUFFLGVBQWUsQ0FBQyxjQUFjO2FBQzFDO1lBQ0Qsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxrQkFBa0I7U0FDM0QsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLGdCQUFnQixHQUFHLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyxZQUFZLENBQUMsb0JBQW9CLENBQUMsQ0FBQztRQUN6RixJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQyx1QkFBdUIsQ0FBQyxZQUFZLENBQUMsR0FBRyxFQUFFO1lBQ3BFLE9BQU8sRUFBRSxTQUFTO1lBQ2xCLFFBQVEsRUFBRSxRQUFRLEtBQUssQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLFFBQVEsa0JBQWtCLElBQUksQ0FBQyxjQUFjLENBQUMsa0JBQWtCLGVBQWU7WUFDM0gsWUFBWSxFQUFFLElBQUksQ0FBQyxZQUFZO1NBQ2hDLENBQUMsQ0FBQztJQUNMLENBQUM7Ozs7OztJQXhETSxNQUFNLENBQUMsbUJBQW1CLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUsZUFBdUI7UUFDckYsT0FBTyxJQUFJLEtBQU0sU0FBUSxHQUFHLENBQUMsUUFBUTtZQUExQjs7Z0JBQ0Esb0JBQWUsR0FBRyxlQUFlLENBQUM7Z0JBQ2xDLHFCQUFnQixHQUFHLEdBQUcsQ0FBQyxFQUFFLENBQUMsTUFBTSxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxHQUFHLEVBQUUsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLENBQUMsUUFBUSxDQUFDLGVBQWUsQ0FBQyxDQUFDLFlBQWEsQ0FBQyxDQUFDLENBQUM7Z0JBQ3BILG1CQUFjLEdBQUcsZ0NBQWMsQ0FBQyxxQkFBcUIsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUUsZUFBZSxDQUFDLENBQUM7WUFDMUcsQ0FBQztTQUFBLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0lBQ2YsQ0FBQzs7Ozs7O0lBR00sTUFBTSxDQUFDLDBCQUEwQixDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTZCO1FBQ2xHLE9BQU8sSUFBSSxLQUFNLFNBQVEsR0FBRyxDQUFDLFFBQVE7WUFBMUI7O2dCQUNBLHFCQUFnQixHQUFHLEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQztnQkFDMUMsb0JBQWUsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLEVBQUUsQ0FBQyxLQUFLLENBQUMsQ0FBQyxTQUFTLENBQUM7b0JBQ3ZELE9BQU8sRUFBRSxTQUFTO29CQUNsQixRQUFRLEVBQUUsUUFBUSxLQUFLLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxRQUFRLG1CQUFtQixLQUFLLENBQUMsY0FBYyxDQUFDLGtCQUFrQixlQUFlO29CQUM3SCxZQUFZLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtpQkFDcEMsQ0FBQyxDQUFDO2dCQUNNLG1CQUFjLEdBQUcsS0FBSyxDQUFDLGNBQWMsQ0FBQztZQUNqRCxDQUFDO1NBQUEsQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7SUFDZixDQUFDOztBQXJCSCxvQ0EyREMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjZGsgZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IENmbkdhdGV3YXlSb3V0ZSB9IGZyb20gJy4vYXBwbWVzaC5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgR2F0ZXdheVJvdXRlU3BlYyB9IGZyb20gJy4vZ2F0ZXdheS1yb3V0ZS1zcGVjJztcbmltcG9ydCB7IHJlbmRlck1lc2hPd25lciB9IGZyb20gJy4vcHJpdmF0ZS91dGlscyc7XG5pbXBvcnQgeyBJVmlydHVhbEdhdGV3YXksIFZpcnR1YWxHYXRld2F5IH0gZnJvbSAnLi92aXJ0dWFsLWdhdGV3YXknO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIElHYXRld2F5Um91dGUgZXh0ZW5kcyBjZGsuSVJlc291cmNlIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBnYXRld2F5Um91dGVOYW1lOiBzdHJpbmcsXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGdhdGV3YXlSb3V0ZUFybjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdmlydHVhbEdhdGV3YXk6IElWaXJ0dWFsR2F0ZXdheTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEdhdGV3YXlSb3V0ZUJhc2VQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBnYXRld2F5Um91dGVOYW1lPzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcm91dGVTcGVjOiBHYXRld2F5Um91dGVTcGVjO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBHYXRld2F5Um91dGVQcm9wcyBleHRlbmRzIEdhdGV3YXlSb3V0ZUJhc2VQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdmlydHVhbEdhdGV3YXk6IElWaXJ0dWFsR2F0ZXdheTtcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgR2F0ZXdheVJvdXRlIGV4dGVuZHMgY2RrLlJlc291cmNlIGltcGxlbWVudHMgSUdhdGV3YXlSb3V0ZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUdhdGV3YXlSb3V0ZUFybihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBnYXRld2F5Um91dGVBcm46IHN0cmluZyk6IElHYXRld2F5Um91dGUge1xuICAgIHJldHVybiBuZXcgY2xhc3MgZXh0ZW5kcyBjZGsuUmVzb3VyY2UgaW1wbGVtZW50cyBJR2F0ZXdheVJvdXRlIHtcbiAgICAgIHJlYWRvbmx5IGdhdGV3YXlSb3V0ZUFybiA9IGdhdGV3YXlSb3V0ZUFybjtcbiAgICAgIHJlYWRvbmx5IGdhdGV3YXlSb3V0ZU5hbWUgPSBjZGsuRm4uc2VsZWN0KDQsIGNkay5Gbi5zcGxpdCgnLycsIGNkay5TdGFjay5vZihzY29wZSkucGFyc2VBcm4oZ2F0ZXdheVJvdXRlQXJuKS5yZXNvdXJjZU5hbWUhKSk7XG4gICAgICByZWFkb25seSB2aXJ0dWFsR2F0ZXdheSA9IFZpcnR1YWxHYXRld2F5LmZyb21WaXJ0dWFsR2F0ZXdheUFybih0aGlzLCAndmlydHVhbEdhdGV3YXknLCBnYXRld2F5Um91dGVBcm4pO1xuICAgIH0oc2NvcGUsIGlkKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGZyb21HYXRld2F5Um91dGVBdHRyaWJ1dGVzKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIGF0dHJzOiBHYXRld2F5Um91dGVBdHRyaWJ1dGVzKTogSUdhdGV3YXlSb3V0ZSB7XG4gICAgcmV0dXJuIG5ldyBjbGFzcyBleHRlbmRzIGNkay5SZXNvdXJjZSBpbXBsZW1lbnRzIElHYXRld2F5Um91dGUge1xuICAgICAgcmVhZG9ubHkgZ2F0ZXdheVJvdXRlTmFtZSA9IGF0dHJzLmdhdGV3YXlSb3V0ZU5hbWU7XG4gICAgICByZWFkb25seSBnYXRld2F5Um91dGVBcm4gPSBjZGsuU3RhY2sub2Yoc2NvcGUpLmZvcm1hdEFybih7XG4gICAgICAgIHNlcnZpY2U6ICdhcHBtZXNoJyxcbiAgICAgICAgcmVzb3VyY2U6IGBtZXNoLyR7YXR0cnMudmlydHVhbEdhdGV3YXkubWVzaC5tZXNoTmFtZX0vdmlydHVhbEdhdGV3YXkvJHthdHRycy52aXJ0dWFsR2F0ZXdheS52aXJ0dWFsR2F0ZXdheU5hbWV9L2dhdGV3YXlSb3V0ZWAsXG4gICAgICAgIHJlc291cmNlTmFtZTogdGhpcy5nYXRld2F5Um91dGVOYW1lLFxuICAgICAgfSk7XG4gICAgICByZWFkb25seSB2aXJ0dWFsR2F0ZXdheSA9IGF0dHJzLnZpcnR1YWxHYXRld2F5O1xuICAgIH0oc2NvcGUsIGlkKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGdhdGV3YXlSb3V0ZU5hbWU6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IGdhdGV3YXlSb3V0ZUFybjogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHJlYWRvbmx5IHZpcnR1YWxHYXRld2F5OiBJVmlydHVhbEdhdGV3YXk7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEdhdGV3YXlSb3V0ZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBwaHlzaWNhbE5hbWU6IHByb3BzLmdhdGV3YXlSb3V0ZU5hbWUgfHwgY2RrLkxhenkuc3RyaW5nVmFsdWUoeyBwcm9kdWNlOiAoKSA9PiB0aGlzLm5vZGUudW5pcXVlSWQgfSksXG4gICAgfSk7XG5cbiAgICB0aGlzLnZpcnR1YWxHYXRld2F5ID0gcHJvcHMudmlydHVhbEdhdGV3YXk7XG4gICAgY29uc3Qgcm91dGVTcGVjQ29uZmlnID0gcHJvcHMucm91dGVTcGVjLmJpbmQodGhpcyk7XG5cbiAgICBjb25zdCBnYXRld2F5Um91dGUgPSBuZXcgQ2ZuR2F0ZXdheVJvdXRlKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIGdhdGV3YXlSb3V0ZU5hbWU6IHRoaXMucGh5c2ljYWxOYW1lLFxuICAgICAgbWVzaE5hbWU6IHByb3BzLnZpcnR1YWxHYXRld2F5Lm1lc2gubWVzaE5hbWUsXG4gICAgICBtZXNoT3duZXI6IHJlbmRlck1lc2hPd25lcih0aGlzLmVudi5hY2NvdW50LCB0aGlzLnZpcnR1YWxHYXRld2F5Lm1lc2guZW52LmFjY291bnQpLFxuICAgICAgc3BlYzoge1xuICAgICAgICBodHRwUm91dGU6IHJvdXRlU3BlY0NvbmZpZy5odHRwU3BlY0NvbmZpZyxcbiAgICAgICAgaHR0cDJSb3V0ZTogcm91dGVTcGVjQ29uZmlnLmh0dHAyU3BlY0NvbmZpZyxcbiAgICAgICAgZ3JwY1JvdXRlOiByb3V0ZVNwZWNDb25maWcuZ3JwY1NwZWNDb25maWcsXG4gICAgICB9LFxuICAgICAgdmlydHVhbEdhdGV3YXlOYW1lOiB0aGlzLnZpcnR1YWxHYXRld2F5LnZpcnR1YWxHYXRld2F5TmFtZSxcbiAgICB9KTtcblxuICAgIHRoaXMuZ2F0ZXdheVJvdXRlTmFtZSA9IHRoaXMuZ2V0UmVzb3VyY2VOYW1lQXR0cmlidXRlKGdhdGV3YXlSb3V0ZS5hdHRyR2F0ZXdheVJvdXRlTmFtZSk7XG4gICAgdGhpcy5nYXRld2F5Um91dGVBcm4gPSB0aGlzLmdldFJlc291cmNlQXJuQXR0cmlidXRlKGdhdGV3YXlSb3V0ZS5yZWYsIHtcbiAgICAgIHNlcnZpY2U6ICdhcHBtZXNoJyxcbiAgICAgIHJlc291cmNlOiBgbWVzaC8ke3Byb3BzLnZpcnR1YWxHYXRld2F5Lm1lc2gubWVzaE5hbWV9L3ZpcnR1YWxSb3V0ZXIvJHt0aGlzLnZpcnR1YWxHYXRld2F5LnZpcnR1YWxHYXRld2F5TmFtZX0vZ2F0ZXdheVJvdXRlYCxcbiAgICAgIHJlc291cmNlTmFtZTogdGhpcy5waHlzaWNhbE5hbWUsXG4gICAgfSk7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgR2F0ZXdheVJvdXRlQXR0cmlidXRlcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZ2F0ZXdheVJvdXRlTmFtZTogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZpcnR1YWxHYXRld2F5OiBJVmlydHVhbEdhdGV3YXk7XG59XG4iXX0=