import base64

from .annotation import Annotation
from .constants import BOX_ANNOTATION, POLYGON_ANNOTATION, LINE_ANNOTATION
from .datalakeinterface import DatalakeInterface
from .logger import get_debug_logger
from .model import Model

datalake_logger = get_debug_logger('DatalakeClient')


class DatalakeClient:
    """
    Python SDK of Datalake
    """

    def __init__(self, api_key: str, secret: str, dalalake_url: str) -> None:
        _string_key_secret = f'{api_key}:{secret}'
        _key_secret_bytes = _string_key_secret.encode("ascii")
        _encoded_key_secret_bytes = base64.b64encode(_key_secret_bytes)
        _encoded_key_secret = _encoded_key_secret_bytes.decode("ascii")

        self.datalake_interface = DatalakeInterface(_encoded_key_secret, dalalake_url)

    def upload_annotation_from_cocojson(self, file_path: str):
        datalake_logger.debug(f'file_name={file_path}')
        _annotation = Annotation(client=self)
        _annotation.upload_coco(file_path)

    def upload_modelrun_bbox_from_json(self, collection_name: str, model_id: str, file_path: str):
        datalake_logger.debug(f'file_name={file_path}')
        _model = Model(client=self)
        _model.upload_modelrun_json(collection_name, model_id, file_path, BOX_ANNOTATION)

    def upload_modelrun_polygon_from_json(self, collection_name: str, model_id: str, file_path: str):
        datalake_logger.debug(f'file_name={file_path}')
        _model = Model(client=self)
        _model.upload_modelrun_json(collection_name, model_id, file_path, POLYGON_ANNOTATION)

    def upload_modelrun_line_from_json(self, collection_name: str, model_id: str, file_path: str):
        datalake_logger.debug(f'file_name={file_path}')
        _model = Model(client=self)
        _model.upload_modelrun_json(collection_name, model_id, file_path, LINE_ANNOTATION)
