# PyLody
PyLody is a small package designed to create simple melodies.

## Usage
To create a melody you can use two methods: you can use notescript notation or add melody elements manually.
### The notescript notation
The notescript notation is a little-function programming language that allows you to write a melody using the melody elements: the letter notation of notes, pauses and repeating blocks.
- - -
The letter notation of notes and pauses must contains the duration at end of the declaration:
```[Note or pause] [Duration (in milliseconds)]```
The letter notation of notes must match this regex: ```\w\d#? [duration]``` (the duration regex is ```\d+```).
The pause declaration is ```- [duration]```.
- - -
The repeating block is a part of melody that can repeat any number of times. This is the structure of this block:
```
[Number of times to repeat] {
	...elements to repeat...
}
```
To create an infinite repeating loop just write an asterisk (*) as the number of times to repeat.
- - -
The notescript notation supports commentaries: ```/The text in the slashes will be ignored/```.
### Creating a melody
First of all, create a ```MelodyBuilder``` object. The constructor of this class takes one optional argument —— a notescript. To play the melody call the ```play``` method.
```
from pylody import MelodyBuilder

mb = MelodyBuilder(notescript)
mb.play()
```
You can create a melody without the notescript. Just add elements manually:
```
from pylody.elements import Pause, Note, Block

# The note declaration
mb.add(Note(note="A",
			octave=4,
			duration=250)) # A4 250

# The pause declaration
mb.add(Pause(duration=250)) # - 250

# The block declaration
block = Block(repeattimes=1)
...
block.add(element)
...
mb.add(block)
```
Or you can play elements separately:
```
note.play()
pause.play()
block.play()
```

## Example
```
from pylody import MelodyBuilder

mb = MelodyBuilder(r"""
	\ Example \
	* {
		2 {
			A4 250
			B4 250
		}
		3 {
			A4# 250
		}
		- 500
	}
""")
mb.play()
```
