# Generated by Django 2.2.12 on 2020-05-04 11:30

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import enumfields.fields
import jsonfield.fields
import security.enums


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='CeleryTaskLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('celery_task_id', models.CharField(db_index=True, max_length=250, verbose_name='celery ID')),
                ('name', models.CharField(max_length=250, verbose_name='task name')),
                ('queue_name', models.CharField(blank=True, max_length=250, null=True, verbose_name='queue name')),
                ('input', models.TextField(blank=True, editable=False, null=True, verbose_name='input')),
                ('task_args',
                 jsonfield.fields.JSONField(blank=True, editable=False, null=True, verbose_name='task args')),
                ('task_kwargs',
                 jsonfield.fields.JSONField(blank=True, editable=False, null=True, verbose_name='task kwargs')),
                ('estimated_time_of_first_arrival',
                 models.DateTimeField(verbose_name='estimated time of first arrival')),
                ('expires', models.DateTimeField(blank=True, null=True, verbose_name='time of expiration')),
                ('stale', models.DateTimeField(blank=True, null=True, verbose_name='stale task time')),
                ('is_set_as_stale', models.BooleanField(default=False, verbose_name='set as stale')),
            ],
            options={
                'verbose_name': 'celery task',
                'verbose_name_plural': 'celery tasks',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='CeleryTaskRunLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('celery_task_id', models.CharField(db_index=True, max_length=250, verbose_name='celery ID')),
                ('start', models.DateTimeField(blank=True, null=True, verbose_name='start')),
                ('stop', models.DateTimeField(blank=True, null=True, verbose_name='stop')),
                ('time', models.FloatField(blank=True, null=True, verbose_name='time')),
                ('state', enumfields.fields.NumEnumField(default=1, enum=security.enums.CeleryTaskRunLogState,
                                                         verbose_name='state')),
                ('name', models.CharField(max_length=250, verbose_name='task name')),
                ('task_args',
                 jsonfield.fields.JSONField(blank=True, editable=False, null=True, verbose_name='task args')),
                ('task_kwargs',
                 jsonfield.fields.JSONField(blank=True, editable=False, null=True, verbose_name='task kwargs')),
                ('result', jsonfield.fields.JSONField(blank=True, editable=False, null=True, verbose_name='result')),
                ('error_message', models.TextField(blank=True, null=True, verbose_name='error message')),
                ('output', models.TextField(blank=True, editable=False, null=True, verbose_name='output')),
                ('retries', models.PositiveSmallIntegerField(default=0, verbose_name='retries')),
                ('estimated_time_of_next_retry',
                 models.DateTimeField(blank=True, null=True, verbose_name='estimated time of arrival')),
            ],
            options={
                'verbose_name': 'celery task run',
                'verbose_name_plural': 'celery tasks run',
                'ordering': ('created_at',),
            },
        ),
        migrations.CreateModel(
            name='CommandLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('start', models.DateTimeField(editable=False, verbose_name='start')),
                ('stop', models.DateTimeField(blank=True, editable=False, null=True, verbose_name='stop')),
                ('time', models.FloatField(blank=True, null=True, verbose_name='time')),
                ('name', models.CharField(db_index=True, editable=False, max_length=250, verbose_name='name')),
                ('input', models.TextField(editable=False, verbose_name='input')),
                ('executed_from_command_line',
                 models.BooleanField(default=False, editable=False, verbose_name='executed from command line')),
                ('output', models.TextField(blank=True, editable=False, null=True, verbose_name='output')),
                ('is_successful',
                 models.BooleanField(default=False, editable=False, verbose_name='finished successfully')),
                (
                'error_message', models.TextField(blank=True, editable=False, null=True, verbose_name='error message')),
            ],
            options={
                'verbose_name': 'command log',
                'verbose_name_plural': 'command logs',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='InputLoggedRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('host', models.CharField(db_index=True, max_length=255, verbose_name='host')),
                ('method', models.SlugField(max_length=7, verbose_name='method')),
                ('path', models.CharField(blank=True, db_index=True, max_length=2000, verbose_name='URL path')),
                ('queries', jsonfield.fields.JSONField(blank=True, null=True, verbose_name='queries')),
                ('is_secure', models.BooleanField(default=False, verbose_name='HTTPS connection')),
                ('slug', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='slug')),
                ('request_timestamp', models.DateTimeField(db_index=True, verbose_name='request timestamp')),
                ('request_headers', jsonfield.fields.JSONField(blank=True, null=True, verbose_name='request headers')),
                ('request_body', models.TextField(blank=True, verbose_name='request body')),
                ('response_timestamp',
                 models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='response timestamp')),
                (
                'response_code', models.PositiveSmallIntegerField(blank=True, null=True, verbose_name='response code')),
                (
                'response_headers', jsonfield.fields.JSONField(blank=True, null=True, verbose_name='response headers')),
                ('response_body', models.TextField(blank=True, null=True, verbose_name='response body')),
                ('response_time', models.FloatField(blank=True, null=True, verbose_name='response time')),
                ('status', enumfields.fields.NumEnumField(default=0, enum=security.enums.LoggedRequestStatus,
                                                          verbose_name='status')),
                ('error_description', models.TextField(blank=True, null=True, verbose_name='error description')),
                ('exception_name',
                 models.CharField(blank=True, max_length=255, null=True, verbose_name='exception name')),
                ('ip', models.GenericIPAddressField(db_index=True, verbose_name='IP address')),
                ('type',
                 enumfields.fields.NumEnumField(db_index=True, default=1, enum=security.enums.InputLoggedRequestType,
                                                verbose_name='type')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                           to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'input logged request',
                'verbose_name_plural': 'input logged requests',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='OutputLoggedRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('host', models.CharField(db_index=True, max_length=255, verbose_name='host')),
                ('method', models.SlugField(max_length=7, verbose_name='method')),
                ('path', models.CharField(blank=True, db_index=True, max_length=2000, verbose_name='URL path')),
                ('queries', jsonfield.fields.JSONField(blank=True, null=True, verbose_name='queries')),
                ('is_secure', models.BooleanField(default=False, verbose_name='HTTPS connection')),
                ('slug', models.CharField(blank=True, db_index=True, max_length=255, null=True, verbose_name='slug')),
                ('request_timestamp', models.DateTimeField(db_index=True, verbose_name='request timestamp')),
                ('request_headers', jsonfield.fields.JSONField(blank=True, null=True, verbose_name='request headers')),
                ('request_body', models.TextField(blank=True, verbose_name='request body')),
                ('response_timestamp',
                 models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='response timestamp')),
                (
                'response_code', models.PositiveSmallIntegerField(blank=True, null=True, verbose_name='response code')),
                (
                'response_headers', jsonfield.fields.JSONField(blank=True, null=True, verbose_name='response headers')),
                ('response_body', models.TextField(blank=True, null=True, verbose_name='response body')),
                ('response_time', models.FloatField(blank=True, null=True, verbose_name='response time')),
                ('status', enumfields.fields.NumEnumField(default=0, enum=security.enums.LoggedRequestStatus,
                                                          verbose_name='status')),
                ('error_description', models.TextField(blank=True, null=True, verbose_name='error description')),
                ('exception_name',
                 models.CharField(blank=True, max_length=255, null=True, verbose_name='exception name')),
                ('celery_task_run_log',
                 models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                   related_name='output_logged_requests', to='security.CeleryTaskRunLog',
                                   verbose_name='celery task run log')),
                ('command_log', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                                  related_name='output_logged_requests', to='security.CommandLog',
                                                  verbose_name='command log')),
                ('input_logged_request',
                 models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL,
                                   related_name='output_logged_requests', to='security.InputLoggedRequest',
                                   verbose_name='input logged request')),
            ],
            options={
                'verbose_name': 'output logged request',
                'verbose_name_plural': 'output logged requests',
                'ordering': ('-created_at',),
            },
        ),
        migrations.CreateModel(
            name='OutputLoggedRequestGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
                ('object_ct',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType',
                                   verbose_name='content type of the related object')),
                ('output_logged_request',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security.OutputLoggedRequest')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('output_logged_request', 'object_ct', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='InputLoggedRequestGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
                ('input_logged_request',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security.InputLoggedRequest')),
                ('object_ct',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType',
                                   verbose_name='content type of the related object')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('input_logged_request', 'object_ct', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='CommandLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
                ('command_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security.CommandLog')),
                ('object_ct',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType',
                                   verbose_name='content type of the related object')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('command_log', 'object_ct', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='CeleryTaskRunLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
                ('celery_task_run_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security.CeleryTaskRunLog')),
                ('object_ct',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType',
                                   verbose_name='content type of the related object')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('celery_task_run_log', 'object_ct', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='CeleryTaskLogGenericManyToManyRelation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('changed_at', models.DateTimeField(auto_now=True, db_index=True, verbose_name='changed at')),
                ('object_id', models.TextField(db_index=True, verbose_name='ID of the related object')),
                ('celery_task_log',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='_related_objects',
                                   related_query_name='related_objects', to='security.CeleryTaskLog')),
                ('object_ct',
                 models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType',
                                   verbose_name='content type of the related object')),
            ],
            options={
                'db_tablespace': '',
                'unique_together': {('celery_task_log', 'object_ct', 'object_id')},
            },
        ),
    ]
