# AUTOGENERATED! DO NOT EDIT! File to edit: 16_inference_result.ipynb (unless otherwise specified).

__all__ = ['show_result']

# Cell
from tabulate import tabulate
import os
import yaml

# Cell
def show_result(result_folder):
    """

    This function will read results folder and output a table rearrange total experiment result.

    Args:

        result_folder: The all stored result yaml folder path.

    Return:

        result: Output a table to show total result.

    """

    metric = []

    files = os.listdir(result_folder)

    for file in files:
        with open(os.path.join(result_folder, file), "r") as f:
            data = yaml.load(f, Loader = yaml.SafeLoader)
        metric.append([file, data['success_rate'], data['fail_rate'], data["average_coillision"]])

    return tabulate(metric, headers=["method", "success_rate(%)", "timeout_rate(%)","average_coillision(times)"])