/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.xml.sax.SAXException;

public class HTTPFileArg
extends AbstractTestElement
implements Serializable {
    private static final long serialVersionUID = 240L;
    private static final String FILEPATH = "File.path";
    private static final String PARAMNAME = "File.paramname";
    private static final String MIMETYPE = "File.mimetype";
    private String header;
    private static Tika tika = HTTPFileArg.createTika();

    public HTTPFileArg() {
    }

    public HTTPFileArg(String path) {
        this(path, "", "");
    }

    public HTTPFileArg(String path, String paramname, String mimetype) {
        if (path == null || paramname == null || mimetype == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        this.setPath(path);
        this.setParamName(paramname);
        this.setMimeType(this.detectMimeType(path, mimetype));
    }

    private static Tika createTika() {
        try {
            return new Tika(new TikaConfig(HTTPFileArg.class.getClassLoader().getResourceAsStream("org/apache/jmeter/protocol/http/gui/action/tika-config.xml")));
        }
        catch (IOException | TikaException | SAXException e) {
            return new Tika();
        }
    }

    private String detectMimeType(String path, String mimetype) {
        if (StringUtils.isNotBlank((CharSequence)mimetype)) {
            return mimetype;
        }
        mimetype = StringUtils.defaultString((String)mimetype, (String)"");
        if (StringUtils.isBlank((CharSequence)path)) {
            return mimetype;
        }
        File file = new File(path);
        if (file.canRead()) {
            try {
                return tika.detect(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return tika.detect(path);
    }

    public HTTPFileArg(JMeterProperty path, JMeterProperty paramname, JMeterProperty mimetype) {
        if (path == null || paramname == null || mimetype == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        this.setProperty(FILEPATH, path);
        this.setProperty(MIMETYPE, mimetype);
        this.setProperty(PARAMNAME, paramname);
    }

    private void setProperty(String name, JMeterProperty prop) {
        JMeterProperty jmp = prop.clone();
        jmp.setName(name);
        this.setProperty(jmp);
    }

    public HTTPFileArg(HTTPFileArg file) {
        this(file.getPath(), file.getParamName(), file.getMimeType());
    }

    public void setParamName(String newParamName) {
        this.setProperty((JMeterProperty)new StringProperty(PARAMNAME, newParamName));
    }

    public String getParamName() {
        return this.getPropertyAsString(PARAMNAME);
    }

    public void setMimeType(String newMimeType) {
        this.setProperty((JMeterProperty)new StringProperty(MIMETYPE, newMimeType));
    }

    public String getMimeType() {
        return this.getPropertyAsString(MIMETYPE);
    }

    public void setPath(String newPath) {
        this.setMimeType(this.detectMimeType(newPath, this.getMimeType()));
        this.setProperty((JMeterProperty)new StringProperty(FILEPATH, newPath));
    }

    public String getPath() {
        return this.getPropertyAsString(FILEPATH);
    }

    public void setHeader(String newHeader) {
        this.header = newHeader;
    }

    public String getHeader() {
        return this.header;
    }

    public String toString() {
        return "path:'" + this.getPath() + "'|param:'" + this.getParamName() + "'|mimetype:'" + this.getMimeType() + "'";
    }

    public boolean isNotEmpty() {
        return this.getPath().length() > 0 || this.getParamName().length() > 0 || this.getMimeType().length() > 0;
    }
}

