/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.gui.action;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.KeystoreConfig;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.ReplaceableController;
import org.apache.jmeter.control.gui.TestPlanGui;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.plugin.MenuCreator;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.EscapeDialog;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.Authorization;
import org.apache.jmeter.protocol.http.control.Cookie;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.DNSCacheManager;
import org.apache.jmeter.protocol.http.control.Header;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.control.StaticHost;
import org.apache.jmeter.protocol.http.control.gui.HttpTestSampleGui;
import org.apache.jmeter.protocol.http.curl.ArgumentHolder;
import org.apache.jmeter.protocol.http.curl.BasicCurlParser;
import org.apache.jmeter.protocol.http.curl.FileArgumentHolder;
import org.apache.jmeter.protocol.http.gui.AuthPanel;
import org.apache.jmeter.protocol.http.gui.CookiePanel;
import org.apache.jmeter.protocol.http.gui.DNSCachePanel;
import org.apache.jmeter.protocol.http.gui.HeaderPanel;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerFactory;
import org.apache.jmeter.protocol.http.sampler.HTTPSamplerProxy;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.threads.gui.ThreadGroupGui;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ParseCurlCommandAction
extends AbstractAction
implements MenuCreator,
ActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseCurlCommandAction.class);
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final Set<String> commands = new HashSet<String>();
    public static final String IMPORT_CURL = "import_curl";
    private static final String CREATE_REQUEST = "CREATE_REQUEST";
    private static final String CERT = "cert";
    private FilePanel filePanel = null;
    private JSyntaxTextArea cURLCommandTA;
    private JLabel statusText;
    private JCheckBox uploadCookiesCheckBox;
    private final Tika tika = this.createTika();

    private Tika createTika() {
        try {
            return new Tika(new TikaConfig(this.getClass().getClassLoader().getResourceAsStream("org/apache/jmeter/protocol/http/gui/action/tika-config.xml")));
        }
        catch (IOException | TikaException | SAXException e) {
            return new Tika();
        }
    }

    public void doAction(ActionEvent e) {
        this.showInputDialog(e);
    }

    private void showInputDialog(ActionEvent event) {
        EscapeDialog messageDialog = new EscapeDialog((Frame)this.getParentFrame(event), JMeterUtils.getResString((String)"curl_import"), false);
        Container contentPane = messageDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.statusText = new JLabel("", 0);
        this.statusText.setForeground(UIManager.getColor("[jmeter]Label.errorForeground"));
        contentPane.add((Component)this.statusText, "North");
        this.cURLCommandTA = JSyntaxTextArea.getInstance((int)20, (int)80, (boolean)false);
        this.cURLCommandTA.setCaretPosition(0);
        contentPane.add((Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.cURLCommandTA), "Center");
        JPanel optionPanel = new JPanel(new BorderLayout(3, 1));
        this.filePanel = new FilePanel(JMeterUtils.getResString((String)"curl_import_from_file"));
        optionPanel.add((Component)this.filePanel, "Center");
        this.uploadCookiesCheckBox = new JCheckBox(JMeterUtils.getResString((String)"curl_add_cookie_header_to_cookiemanager"), false);
        optionPanel.add((Component)this.uploadCookiesCheckBox, "North");
        JButton button = new JButton(JMeterUtils.getResString((String)"curl_create_request"));
        button.setActionCommand(CREATE_REQUEST);
        button.addActionListener(this);
        button.setPreferredSize(new Dimension(50, 50));
        optionPanel.add((Component)button, "South");
        contentPane.add((Component)optionPanel, "South");
        messageDialog.pack();
        ComponentUtil.centerComponentInComponent((Component)GuiPackage.getInstance().getMainFrame(), (Component)messageDialog);
        SwingUtilities.invokeLater(() -> messageDialog.setVisible(true));
    }

    private JMeterTreeNode findFirstNodeOfType(Class<?> type) {
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        return treeModel.getNodesOfType(type).stream().filter(JMeterTreeNode::isEnabled).findFirst().orElse(null);
    }

    private DNSCacheManager findNodeOfTypeDnsCacheManagerByType(boolean isCustom) {
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        List res = treeModel.getNodesOfType(DNSCacheManager.class);
        for (JMeterTreeNode jm : res) {
            DNSCacheManager dnsCacheManager = (DNSCacheManager)jm.getTestElement();
            if (dnsCacheManager.isCustomResolver() != isCustom) continue;
            return dnsCacheManager;
        }
        return null;
    }

    private void createTestPlan(ActionEvent e, BasicCurlParser.Request request, String statusText) throws MalformedURLException, IllegalUserActionException {
        DNSCacheManager dnsCacheManager;
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "close"));
        GuiPackage guiPackage = GuiPackage.getInstance();
        guiPackage.clearTestPlan();
        FileServer.getFileServer().setScriptName(null);
        ThreadGroup threadGroup = new ThreadGroup();
        threadGroup.setProperty("TestElement.gui_class", ThreadGroupGui.class.getName());
        threadGroup.setProperty("TestElement.name", "Thread Group");
        threadGroup.setProperty("ThreadGroup.num_threads", "${__P(threads,10)}");
        threadGroup.setProperty("ThreadGroup.ramp_time", "${__P(rampup,30)}");
        threadGroup.setScheduler(true);
        threadGroup.setProperty("ThreadGroup.duration", "${__P(duration,3600)}");
        threadGroup.setDelay(5L);
        LoopController loopCtrl = new LoopController();
        loopCtrl.setProperty("LoopController.loops", "${__P(iterations,-1)}");
        loopCtrl.setContinueForever(false);
        threadGroup.setSamplerController(loopCtrl);
        TestPlan testPlan = new TestPlan();
        testPlan.setProperty("TestElement.name", "Test Plan");
        testPlan.setProperty("TestElement.gui_class", TestPlanGui.class.getName());
        testPlan.setComment("You can run me using: jmeter -Jthreads=<Number of threads> -Jrampup=<rampup in seconds> -Jduration=<duration in seconds> -Jiterations=<Number of iterations, -1 means infinite> -e -o <report output folder>");
        HashTree tree = new HashTree();
        HashTree testPlanHT = tree.add((Object)testPlan);
        HashTree threadGroupHT = testPlanHT.add((Object)threadGroup);
        this.createHttpRequest(request, threadGroupHT, statusText);
        if (!request.getAuthorization().getUser().isEmpty()) {
            AuthManager authManager = new AuthManager();
            this.createAuthManager(request, authManager);
            threadGroupHT.add((Object)authManager);
        }
        if (!request.getDnsServers().isEmpty()) {
            dnsCacheManager = new DNSCacheManager();
            this.createDnsServer(request, dnsCacheManager);
            threadGroupHT.add((Object)dnsCacheManager);
        }
        if (request.getDnsResolver() != null) {
            dnsCacheManager = new DNSCacheManager();
            this.createDnsResolver(request, dnsCacheManager);
            threadGroupHT.add((Object)dnsCacheManager);
        }
        CookieManager cookieManager = new CookieManager();
        this.createCookieManager(cookieManager, request);
        threadGroupHT.add((Object)cookieManager);
        ResultCollector resultCollector = new ResultCollector();
        resultCollector.setProperty("TestElement.name", "View Results Tree");
        resultCollector.setProperty("TestElement.gui_class", ViewResultsFullVisualizer.class.getName());
        tree.add(tree.getArray()[0], (Object)resultCollector);
        HashTree newTree = guiPackage.addSubTree(tree);
        guiPackage.updateCurrentGui();
        guiPackage.getMainFrame().getTree().setSelectionPath(new TreePath(((JMeterTreeNode)newTree.getArray()[0]).getPath()));
        HashTree subTree = guiPackage.getCurrentSubTree();
        ActionEvent actionEvent = new ActionEvent(subTree.get(subTree.getArray()[subTree.size() - 1]), e.getID(), "sub_tree_loaded");
        ActionRouter.getInstance().actionPerformed(actionEvent);
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "expand all"));
    }

    private HTTPSamplerProxy createHttpRequest(BasicCurlParser.Request request, HashTree parentHT, String commentText) throws MalformedURLException {
        HTTPSamplerProxy httpSampler = this.createSampler(request, commentText);
        HashTree samplerHT = parentHT.add((Object)httpSampler);
        samplerHT.add((Object)httpSampler.getHeaderManager());
        if (CERT.equals(request.getCaCert())) {
            samplerHT.add((Object)httpSampler.getKeystoreConfig());
        }
        return httpSampler;
    }

    private HTTPSamplerProxy createSampler(BasicCurlParser.Request request, String commentText) throws MalformedURLException {
        HTTPSamplerProxy httpSampler = (HTTPSamplerProxy)HTTPSamplerFactory.newInstance(HTTPSamplerFactory.DEFAULT_CLASSNAME);
        httpSampler.setProperty("TestElement.gui_class", HttpTestSampleGui.class.getName());
        httpSampler.setProperty("TestElement.name", "HTTP Request");
        if (!commentText.isEmpty()) {
            httpSampler.setProperty("TestPlan.comments", commentText);
        } else {
            httpSampler.setProperty("TestPlan.comments", ParseCurlCommandAction.getDefaultComment());
        }
        URL url = new URL(request.getUrl());
        httpSampler.setProtocol(url.getProtocol());
        if (url.getPort() != -1) {
            httpSampler.setPort(url.getPort());
        }
        String path = url.getPath();
        if (StringUtils.isNotEmpty((CharSequence)url.getQuery())) {
            path = path + "?" + url.getQuery();
        }
        httpSampler.setPath(path);
        httpSampler.setDomain(url.getHost());
        httpSampler.setUseKeepAlive(request.isKeepAlive());
        httpSampler.setFollowRedirects(true);
        httpSampler.setMethod(request.getMethod());
        HeaderManager headerManager = this.createHeaderManager(request);
        httpSampler.addTestElement((TestElement)headerManager);
        this.configureTimeout(request, httpSampler);
        this.createProxyServer(request, httpSampler);
        if (request.getInterfaceName() != null) {
            httpSampler.setIpSourceType(1);
            httpSampler.setIpSource(request.getInterfaceName());
        }
        if (!"GET".equals(request.getMethod()) && request.getPostData() != null) {
            Arguments arguments = new Arguments();
            httpSampler.setArguments(arguments);
            httpSampler.addNonEncodedArgument("", request.getPostData(), "");
        }
        if (!request.getFormData().isEmpty() || !request.getFormStringData().isEmpty()) {
            this.setFormData(request, httpSampler);
            httpSampler.setDoMultipart(true);
        }
        if (CERT.equals(request.getCaCert())) {
            KeystoreConfig keystoreConfig = this.createKeystoreConfiguration();
            httpSampler.addTestElement((TestElement)keystoreConfig);
        }
        return httpSampler;
    }

    private void configureTimeout(BasicCurlParser.Request request, HTTPSamplerProxy httpSampler) {
        double connectTimeout = request.getConnectTimeout();
        double maxTime = request.getMaxTime();
        if (connectTimeout >= 0.0) {
            httpSampler.setConnectTimeout(String.valueOf((int)request.getConnectTimeout()));
            if (maxTime >= 0.0) {
                maxTime -= connectTimeout;
            }
        }
        if (maxTime >= 0.0) {
            httpSampler.setResponseTimeout(String.valueOf((int)maxTime));
        }
    }

    private HeaderManager createHeaderManager(BasicCurlParser.Request request) {
        HeaderManager headerManager = new HeaderManager();
        headerManager.setProperty("TestElement.gui_class", HeaderPanel.class.getName());
        headerManager.setProperty("TestElement.name", "HTTP HeaderManager");
        headerManager.setProperty("TestPlan.comments", ParseCurlCommandAction.getDefaultComment());
        boolean hasAcceptEncoding = false;
        for (Pair<String, String> header : request.getHeaders()) {
            String key = (String)header.getKey();
            hasAcceptEncoding = hasAcceptEncoding || key.equalsIgnoreCase(ACCEPT_ENCODING);
            headerManager.getHeaders().addItem((Object)new Header(key, (String)header.getValue()));
        }
        if (!hasAcceptEncoding && request.isCompressed()) {
            headerManager.getHeaders().addItem((Object)new Header(ACCEPT_ENCODING, "gzip, deflate"));
        }
        return headerManager;
    }

    private void createCookieManager(CookieManager cookieManager, BasicCurlParser.Request request) {
        cookieManager.setProperty("TestElement.gui_class", CookiePanel.class.getName());
        cookieManager.setProperty("TestElement.name", "HTTP CookieManager");
        cookieManager.setProperty("TestPlan.comments", ParseCurlCommandAction.getDefaultComment());
        if (!request.getCookies(request.getUrl()).isEmpty()) {
            for (Cookie c : request.getCookies(request.getUrl())) {
                cookieManager.getCookies().addItem((Object)c);
            }
        }
        if (!request.getCookieInHeaders(request.getUrl()).isEmpty() && this.uploadCookiesCheckBox.isSelected()) {
            for (Cookie c : request.getCookieInHeaders(request.getUrl())) {
                cookieManager.getCookies().addItem((Object)c);
            }
        }
        if (!request.getFilepathCookie().isEmpty()) {
            String pathfileCookie = request.getFilepathCookie();
            File file = new File(pathfileCookie);
            if (file.isFile() && file.exists()) {
                try {
                    cookieManager.addFile(pathfileCookie);
                }
                catch (IOException e) {
                    LOGGER.error("Failed to read from File {}", (Object)pathfileCookie, (Object)e);
                    throw new IllegalArgumentException("Failed to read from File " + pathfileCookie);
                }
            } else {
                LOGGER.error("File {} doesn't exist", (Object)pathfileCookie);
                throw new IllegalArgumentException("File " + pathfileCookie + " doesn't exist");
            }
        }
    }

    private KeystoreConfig createKeystoreConfiguration() {
        KeystoreConfig keystoreConfig = new KeystoreConfig();
        keystoreConfig.setProperty("TestElement.gui_class", TestBeanGUI.class.getName());
        keystoreConfig.setProperty("TestElement.name", "Keystore Configuration");
        keystoreConfig.setProperty("TestPlan.comments", ParseCurlCommandAction.getDefaultComment());
        return keystoreConfig;
    }

    private void createAuthManager(BasicCurlParser.Request request, AuthManager authManager) {
        Authorization auth = request.getAuthorization();
        authManager.setProperty("TestElement.gui_class", AuthPanel.class.getName());
        authManager.setProperty("TestElement.name", "HTTP AuthorizationManager");
        authManager.setProperty("TestPlan.comments", ParseCurlCommandAction.getDefaultComment());
        authManager.getAuthObjects().addItem((Object)auth);
    }

    private boolean canAddAuthManagerInHttpRequest(BasicCurlParser.Request request, AuthManager authManager) {
        Authorization auth = request.getAuthorization();
        for (int i = 0; i < authManager.getAuthObjects().size(); ++i) {
            if (authManager.getAuthObjectAt(i).getUser().equals(auth.getUser()) && authManager.getAuthObjectAt(i).getPass().equals(auth.getPass()) && authManager.getAuthObjectAt(i).getMechanism() == auth.getMechanism()) continue;
            return true;
        }
        return false;
    }

    private boolean canUpdateAuthManagerInThreadGroup(BasicCurlParser.Request request, AuthManager authManager) {
        Authorization auth = request.getAuthorization();
        for (int i = 0; i < authManager.getAuthObjects().size(); ++i) {
            if (!auth.getURL().equals(authManager.getAuthObjectAt(i).getURL())) continue;
            return false;
        }
        return true;
    }

    private void createDnsServer(BasicCurlParser.Request request, DNSCacheManager dnsCacheManager) {
        Set<String> dnsServers = request.getDnsServers();
        dnsCacheManager.setProperty("TestElement.gui_class", DNSCachePanel.class.getName());
        dnsCacheManager.setProperty("TestElement.name", "DNS Cache Manager");
        dnsCacheManager.setProperty("TestPlan.comments", ParseCurlCommandAction.getDefaultComment());
        dnsCacheManager.getServers().clear();
        for (String dnsServer : dnsServers) {
            dnsCacheManager.addServer(dnsServer);
        }
    }

    private boolean canAddDnsServerInHttpRequest(BasicCurlParser.Request request, DNSCacheManager dnsCacheManager) {
        HashSet<String> currentDnsServers = new HashSet<String>();
        Set<String> newDnsServers = request.getDnsServers();
        for (int i = 0; i < dnsCacheManager.getServers().size(); ++i) {
            currentDnsServers.add(dnsCacheManager.getServers().get(i).getStringValue());
        }
        return newDnsServers.size() != currentDnsServers.size() || !newDnsServers.containsAll(currentDnsServers);
    }

    private void createDnsResolver(BasicCurlParser.Request request, DNSCacheManager dnsCacheManager) {
        dnsCacheManager.setProperty("TestElement.gui_class", DNSCachePanel.class.getName());
        dnsCacheManager.setProperty("TestElement.name", "DNS Cache Manager");
        dnsCacheManager.setCustomResolver(true);
        dnsCacheManager.getHosts().clear();
        String[] resolveParameters = request.getDnsResolver().split(":");
        String port = resolveParameters[1];
        if (!("443".equals(port) || "80".equals(port) || "*".equals(port))) {
            dnsCacheManager.setProperty("TestPlan.comments", "Custom DNS resolver doesn't support port " + port);
        } else {
            dnsCacheManager.setProperty("TestPlan.comments", ParseCurlCommandAction.getDefaultComment());
        }
        dnsCacheManager.addHost(resolveParameters[0], resolveParameters[2]);
    }

    private static String getDefaultComment() {
        return "Created from cURL on " + LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
    }

    private boolean canAddDnsResolverInHttpRequest(BasicCurlParser.Request request, DNSCacheManager dnsCacheManager) {
        if (dnsCacheManager.getHosts().size() != 1) {
            return true;
        }
        String[] resolveParameters = request.getDnsResolver().split(":");
        String host = resolveParameters[0];
        String address = resolveParameters[2];
        StaticHost statichost = (StaticHost)dnsCacheManager.getHosts().get(0).getObjectValue();
        return !statichost.getAddress().equals(address) || !statichost.getName().equals(host);
    }

    private void setFormData(BasicCurlParser.Request request, HTTPSamplerProxy httpSampler) {
        String formName;
        if (request.getPostData() != null) {
            throw new IllegalArgumentException("--form and --data can't appear in the same command");
        }
        ArrayList<HTTPFileArg> httpFileArgs = new ArrayList<HTTPFileArg>();
        for (Pair<String, String> pair : request.getFormStringData()) {
            formName = (String)pair.getKey();
            String formValue = (String)pair.getValue();
            httpSampler.addNonEncodedArgument(formName, formValue, "");
        }
        for (Pair pair : request.getFormData()) {
            formName = (String)pair.getKey();
            ArgumentHolder formValueObject = (ArgumentHolder)pair.getValue();
            String formValue = formValueObject.getName();
            if (formValueObject instanceof FileArgumentHolder) {
                String contentType;
                if (formValueObject.hasContenType()) {
                    contentType = formValueObject.getContentType();
                } else {
                    try {
                        File contentFile = new File(formValue);
                        if (contentFile.canRead()) {
                            contentType = this.tika.detect(contentFile);
                        } else {
                            LOGGER.info("Can not read file {}, so guessing contentType by extension.", (Object)formValue);
                            contentType = this.tika.detect(formValue);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.info("Could not detect contentType for file {} by content, so falling back to detection by filename", (Object)formValue);
                        contentType = this.tika.detect(formValue);
                    }
                }
                httpFileArgs.add(new HTTPFileArg(formValue, formName, contentType));
                continue;
            }
            if (formValueObject.hasContenType()) {
                httpSampler.addNonEncodedArgument(formName, formValue, "", formValueObject.getContentType());
                continue;
            }
            httpSampler.addNonEncodedArgument(formName, formValue, "");
        }
        if (!httpFileArgs.isEmpty()) {
            httpSampler.setHTTPFiles(httpFileArgs.toArray(new HTTPFileArg[httpFileArgs.size()]));
        }
    }

    private void createProxyServer(BasicCurlParser.Request request, HTTPSamplerProxy httpSampler) {
        Map<String, String> proxyServer = request.getProxyServer();
        for (Map.Entry<String, String> proxyPara : proxyServer.entrySet()) {
            String key;
            switch (key = proxyPara.getKey()) {
                case "servername": {
                    httpSampler.setProxyHost(proxyPara.getValue());
                    break;
                }
                case "port": {
                    httpSampler.setProxyPortInt(proxyPara.getValue());
                    break;
                }
                case "scheme": {
                    httpSampler.setProxyScheme(proxyPara.getValue());
                    break;
                }
                case "username": {
                    httpSampler.setProxyUser(proxyPara.getValue());
                    break;
                }
                case "password": {
                    httpSampler.setProxyPass(proxyPara.getValue());
                    break;
                }
            }
        }
    }

    public JMenuItem[] getMenuItemsAtLocation(MenuCreator.MENU_LOCATION location) {
        if (location == MenuCreator.MENU_LOCATION.TOOLS) {
            JMenuItem menuItemIC = new JMenuItem(JMeterUtils.getResString((String)IMPORT_CURL), 0);
            menuItemIC.setName(IMPORT_CURL);
            menuItemIC.setActionCommand(IMPORT_CURL);
            menuItemIC.setAccelerator(null);
            menuItemIC.addActionListener((ActionListener)ActionRouter.getInstance());
            return new JMenuItem[]{menuItemIC};
        }
        return new JMenuItem[0];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.statusText.setText("");
        this.statusText.setForeground(Color.GREEN);
        boolean isReadFromFile = false;
        if (e.getActionCommand().equals(CREATE_REQUEST)) {
            List<String> commandsList = null;
            try {
                if (!this.filePanel.getFilename().trim().isEmpty() && this.cURLCommandTA.getText().trim().isEmpty()) {
                    commandsList = this.readFromFile(this.filePanel.getFilename().trim());
                    isReadFromFile = true;
                } else if (this.filePanel.getFilename().trim().isEmpty() && !this.cURLCommandTA.getText().trim().isEmpty()) {
                    commandsList = this.readFromTextPanel(this.cURLCommandTA.getText().trim());
                } else {
                    throw new IllegalArgumentException("Error creating tast plan ,Please select one between reading file and directly fill in the panel");
                }
                List<BasicCurlParser.Request> requests = this.parseCommands(isReadFromFile, commandsList);
                for (int i = 0; i < requests.size(); ++i) {
                    BasicCurlParser.Request request = requests.get(i);
                    try {
                        String commentText = this.createCommentText(request);
                        GuiPackage guiPackage = GuiPackage.getInstance();
                        guiPackage.updateCurrentNode();
                        JMeterTreeNode treeNode = this.findFirstNodeOfType(AbstractThreadGroup.class);
                        if (treeNode == null) {
                            LOGGER.info("No AbstractThreadGroup found, potentially empty plan, creating a new plan");
                            this.createTestPlan(e, request, commentText);
                        } else {
                            JMeterTreeNode currentNode = guiPackage.getCurrentNode();
                            Object userObject = currentNode.getUserObject();
                            if (userObject instanceof Controller && !(userObject instanceof ReplaceableController)) {
                                LOGGER.info("Newly created element will be placed under current selected node {}", (Object)currentNode.getName());
                                this.addToTestPlan(currentNode, request, commentText);
                            } else {
                                LOGGER.info("Newly created element will be placed under first AbstractThreadGroup node {}", (Object)treeNode.getName());
                                this.addToTestPlan(treeNode, request, commentText);
                            }
                        }
                        this.statusText.setText(JMeterUtils.getResString((String)"curl_create_success"));
                        continue;
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error creating test plan from cURL command:{}, error:{}", new Object[]{commandsList.get(i), ex.getMessage(), ex});
                        this.statusText.setText(MessageFormat.format(JMeterUtils.getResString((String)"curl_create_failure"), ex.getMessage()));
                        this.statusText.setForeground(UIManager.getColor("[jmeter]Label.errorForeground"));
                        break;
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error creating test plan from cURL command list:{}", commandsList, (Object)ex);
                this.statusText.setText(MessageFormat.format(JMeterUtils.getResString((String)"curl_create_failure"), ex.getMessage()));
                this.statusText.setForeground(UIManager.getColor("[jmeter]Label.errorForeground"));
            }
        }
    }

    public List<BasicCurlParser.Request> parseCommands(boolean isReadFromFile, List<String> commandsList) {
        ArrayList<BasicCurlParser.Request> requests = new ArrayList<BasicCurlParser.Request>();
        BasicCurlParser basicCurlParser = new BasicCurlParser();
        for (int i = 0; i < commandsList.size(); ++i) {
            try {
                BasicCurlParser.Request q = basicCurlParser.parse(commandsList.get(i));
                requests.add(q);
                LOGGER.info("Parsed CURL command {} into {}", (Object)commandsList.get(i), (Object)q);
                continue;
            }
            catch (IllegalArgumentException ie) {
                if (isReadFromFile) {
                    int line = i + 1;
                    LOGGER.error("Error creating test plan from line {} of file, command:{}, error:{}", new Object[]{line, commandsList.get(i), ie.getMessage(), ie});
                    throw new IllegalArgumentException("Error creating tast plan from file in line " + line + ", see log file");
                }
                LOGGER.error("Error creating test plan from cURL command:{}, error:{}", new Object[]{commandsList.get(i), ie.getMessage(), ie});
                throw ie;
            }
        }
        return requests;
    }

    private void addToTestPlan(JMeterTreeNode currentNode, BasicCurlParser.Request request, String statusText) throws MalformedURLException {
        HTTPSamplerProxy sampler = this.createSampler(request, statusText);
        JMeterTreeModel treeModel = GuiPackage.getInstance().getTreeModel();
        JMeterUtils.runSafe((boolean)true, () -> {
            try {
                DNSCacheManager dnsCacheManager;
                DNSCacheManager dnsCacheManager2;
                boolean canAddAuthManagerInHttpRequest = false;
                boolean canAddDnsServer = false;
                boolean canAddDnsResolver = false;
                if (!request.getAuthorization().getUser().isEmpty()) {
                    AuthManager authManager;
                    JMeterTreeNode jMeterTreeNodeAuth = this.findFirstNodeOfType(AuthManager.class);
                    if (jMeterTreeNodeAuth == null) {
                        authManager = new AuthManager();
                        this.createAuthManager(request, authManager);
                        treeModel.addComponent((TestElement)authManager, currentNode);
                    } else {
                        authManager = (AuthManager)jMeterTreeNodeAuth.getTestElement();
                        if (this.canUpdateAuthManagerInThreadGroup(request, authManager)) {
                            this.createAuthManager(request, authManager);
                        } else {
                            canAddAuthManagerInHttpRequest = this.canAddAuthManagerInHttpRequest(request, authManager);
                        }
                    }
                }
                if (!request.getDnsServers().isEmpty()) {
                    dnsCacheManager2 = this.findNodeOfTypeDnsCacheManagerByType(false);
                    if (dnsCacheManager2 == null) {
                        dnsCacheManager2 = new DNSCacheManager();
                        this.createDnsServer(request, dnsCacheManager2);
                        treeModel.addComponent((TestElement)dnsCacheManager2, currentNode);
                    } else {
                        canAddDnsServer = this.canAddDnsServerInHttpRequest(request, dnsCacheManager2);
                    }
                }
                if (request.getDnsResolver() != null) {
                    dnsCacheManager2 = this.findNodeOfTypeDnsCacheManagerByType(true);
                    if (dnsCacheManager2 == null) {
                        dnsCacheManager2 = new DNSCacheManager();
                        this.createDnsResolver(request, dnsCacheManager2);
                        treeModel.addComponent((TestElement)dnsCacheManager2, currentNode);
                    } else {
                        canAddDnsResolver = this.canAddDnsResolverInHttpRequest(request, dnsCacheManager2);
                    }
                }
                if (!request.getCookies(request.getUrl()).isEmpty() || !request.getFilepathCookie().isEmpty() || !request.getCookieInHeaders(request.getUrl()).isEmpty() && this.uploadCookiesCheckBox.isSelected()) {
                    CookieManager cookieManager;
                    JMeterTreeNode jMeterTreeNodeCookie = this.findFirstNodeOfType(CookieManager.class);
                    if (jMeterTreeNodeCookie == null) {
                        cookieManager = new CookieManager();
                        this.createCookieManager(cookieManager, request);
                        treeModel.addComponent((TestElement)cookieManager, currentNode);
                    } else {
                        cookieManager = (CookieManager)jMeterTreeNodeCookie.getTestElement();
                        this.createCookieManager(cookieManager, request);
                    }
                }
                HeaderManager headerManager = sampler.getHeaderManager();
                KeystoreConfig keystoreConfig = sampler.getKeystoreConfig();
                JMeterTreeNode newNode = treeModel.addComponent((TestElement)sampler, currentNode);
                treeModel.addComponent((TestElement)headerManager, newNode);
                if (CERT.equals(request.getCaCert())) {
                    treeModel.addComponent((TestElement)keystoreConfig, newNode);
                }
                if (canAddAuthManagerInHttpRequest) {
                    AuthManager authManager = new AuthManager();
                    this.createAuthManager(request, authManager);
                    treeModel.addComponent((TestElement)authManager, newNode);
                }
                if (canAddDnsServer) {
                    dnsCacheManager = new DNSCacheManager();
                    this.createDnsServer(request, dnsCacheManager);
                    treeModel.addComponent((TestElement)dnsCacheManager, newNode);
                }
                if (canAddDnsResolver) {
                    dnsCacheManager = new DNSCacheManager();
                    this.createDnsResolver(request, dnsCacheManager);
                    treeModel.addComponent((TestElement)dnsCacheManager, newNode);
                }
            }
            catch (IllegalUserActionException ex) {
                LOGGER.error("Error placing sampler", (Throwable)ex);
                JMeterUtils.reportErrorToUser((String)ex.getMessage());
            }
        });
    }

    public Set<String> getActionNames() {
        return commands;
    }

    public JMenu[] getTopLevelMenus() {
        return new JMenu[0];
    }

    public boolean localeChanged(MenuElement menu) {
        return false;
    }

    public void localeChanged() {
    }

    public List<String> readFromFile(String pathname) throws IOException {
        String encoding = StandardCharsets.UTF_8.name();
        File file = new File(pathname);
        return FileUtils.readLines((File)file, (String)encoding);
    }

    public List<String> readFromTextPanel(String commands) {
        String[] cs = commands.split("curl");
        ArrayList<String> s = new ArrayList<String>();
        for (int i = 1; i < cs.length; ++i) {
            s.add("curl " + cs[i].trim());
        }
        return s;
    }

    public String createCommentText(BasicCurlParser.Request request) {
        StringBuilder commentText = new StringBuilder();
        if (!request.getOptionsIgnored().isEmpty()) {
            for (String s : request.getOptionsIgnored()) {
                commentText.append("--" + s + " ");
            }
            commentText.append("ignoring; ");
        }
        if (!request.getOptionsInProperties().isEmpty()) {
            for (String s : request.getOptionsInProperties()) {
                commentText.append(s + " ");
            }
            commentText.append("configure in jmeter.properties ");
        }
        if (request.getLimitRate() != 0) {
            commentText.append("Please configure the limit rate in 'httpclient.socket.http.cps' of 'jmeter.properties(374 line), the value is " + request.getLimitRate() + ";");
        }
        if (!request.getOptionsNoSupport().isEmpty()) {
            for (String s : request.getOptionsNoSupport()) {
                commentText.append("--" + s + " ");
            }
            commentText.append("not supported; ");
        }
        if (request.getNoproxy() != null) {
            commentText.append("Please configure noproxy list in terminal and restart JMeter. ");
            commentText.append("Look: https://jmeter.apache.org/usermanual/get-started.html#proxy_server");
        }
        if (!request.getCaCert().isEmpty()) {
            commentText.append("Please configure the SSL file with CA certificates in 'SSL configuration' of 'system.properties(49 line)'. ");
            commentText.append("Look: https://jmeter.apache.org/usermanual/properties_reference.html#ssl_config");
        }
        return commentText.toString();
    }

    static {
        commands.add(IMPORT_CURL);
    }
}

