/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.io.IOException;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONStyle;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.ResultRenderer;
import org.apache.jmeter.visualizers.SamplerResultTab;
import org.apache.jmeter.visualizers.ViewResultsFullVisualizer;

public class RenderAsJSON
extends SamplerResultTab
implements ResultRenderer {
    private static final String TAB_SEPARATOR = "    ";

    @Override
    public void renderResult(SampleResult sampleResult) {
        String response = ViewResultsFullVisualizer.getResponseAsString(sampleResult);
        this.showRenderJSONResponse(response);
    }

    private void showRenderJSONResponse(String response) {
        this.results.setContentType("text/plain");
        this.setTextOptimized(response == null ? "" : RenderAsJSON.prettyJSON(response));
        this.results.setCaretPosition(0);
        this.resultsScrollPane.setViewportView(this.results);
    }

    public static String prettyJSON(String json) {
        return RenderAsJSON.prettyJSON(json, TAB_SEPARATOR);
    }

    public static String prettyJSON(String json, String tabSeparator) {
        try {
            Object o = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(json);
            if (o instanceof JSONObject) {
                return ((JSONObject)o).toJSONString((JSONStyle)new PrettyJSONStyle(tabSeparator));
            }
            if (o instanceof JSONArray) {
                return ((JSONArray)o).toJSONString((JSONStyle)new PrettyJSONStyle(tabSeparator));
            }
        }
        catch (ParseException e) {
            return json;
        }
        return json;
    }

    @Override
    public String toString() {
        return JMeterUtils.getResString((String)"view_results_render_json");
    }

    private static class PrettyJSONStyle
    extends JSONStyle {
        private int level = 0;
        private String indentString = "    ";

        public PrettyJSONStyle(String indentString) {
            this.indentString = indentString;
        }

        private void indent(Appendable out) throws IOException {
            out.append('\n');
            out.append(StringUtils.repeat((String)this.indentString, (int)this.level));
        }

        public void objectStart(Appendable out) throws IOException {
            super.objectStart(out);
            ++this.level;
        }

        public void objectStop(Appendable out) throws IOException {
            --this.level;
            this.indent(out);
            super.objectStop(out);
        }

        public void objectNext(Appendable out) throws IOException {
            super.objectNext(out);
            this.indent(out);
        }

        public void objectEndOfKey(Appendable out) throws IOException {
            super.objectEndOfKey(out);
            out.append(' ');
        }

        public void objectFirstStart(Appendable out) throws IOException {
            this.indent(out);
            super.objectFirstStart(out);
        }

        public void arrayfirstObject(Appendable out) throws IOException {
            this.indent(out);
            super.arrayfirstObject(out);
        }

        public void arrayNextElm(Appendable out) throws IOException {
            super.arrayNextElm(out);
            this.indent(out);
        }

        public void arrayStart(Appendable out) throws IOException {
            super.arrayStart(out);
            ++this.level;
        }

        public void arrayStop(Appendable out) throws IOException {
            --this.level;
            this.indent(out);
            super.arrayStop(out);
        }
    }
}

