/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers;

import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.BSFTestElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BSFTimer
extends BSFTestElement
implements Cloneable,
Timer,
TestBean {
    private static final Logger log = LoggerFactory.getLogger(BSFTimer.class);
    private static final long serialVersionUID = 5L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long delay() {
        long delay = 0L;
        BSFManager mgr = null;
        try {
            mgr = this.getManager();
            Object o = this.evalFileOrScript(mgr);
            if (o == null) {
                log.warn("Script did not return a value");
                long l = 0L;
                return l;
            }
            delay = Long.parseLong(o.toString());
        }
        catch (NumberFormatException | BSFException e) {
            if (log.isWarnEnabled()) {
                log.warn("Problem in BSF script. {}", (Object)e.toString());
            }
        }
        finally {
            if (mgr != null) {
                mgr.terminate();
            }
        }
        return delay;
    }

    public Object clone() {
        return super.clone();
    }
}

