/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.ContinuousTransform;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.aes.AestheticsBuilder;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.PosProviderContext;
import jetbrains.datalore.plot.builder.assemble.GeomContextBuilder;
import jetbrains.datalore.plot.builder.assemble.ImmutableGeomContext;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u0002H\u00042\u0018\u0010\b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u0001H\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ,\u0010\f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J<\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J2\u0010\u0017\u001a\u001e\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0011J<\u0010\u001b\u001a\u001e\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J<\u0010\u001c\u001a\u001e\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J=\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2&\u0010\u001e\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\u001fH\u0000\u00a2\u0006\u0002\b J\u000e\u0010!\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\u001d\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b$Je\u0010%\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0016\u0010&\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0016\u0010'\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH\u0000\u00a2\u0006\u0002\b(J9\u0010)\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r2\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r2\n\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\u0006\u0010-\u001a\u00020.H\u0000\u00a2\u0006\u0002\b/J \u00100\u001a\u0002012\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u00020\n2\u0006\u00104\u001a\u000205H\u0002\u00a8\u00066"}, d2={"Ljetbrains/datalore/plot/builder/PlotUtil;", "", "()V", "asAesValue", "T", "aes", "Ljetbrains/datalore/plot/base/Aes;", "dataValue", "mapperOption", "Lkotlin/Function1;", "", "(Ljetbrains/datalore/plot/base/Aes;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "combineRanges", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "aesList", "", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "computeLayerDryRunRangeAfterSizeExpand", "locationAes", "sizeAes", "geomCtx", "Ljetbrains/datalore/plot/base/GeomContext;", "computeLayerDryRunXYRanges", "Lkotlin/Pair;", "layer", "Ljetbrains/datalore/plot/builder/GeomLayer;", "computeLayerDryRunXYRangesAfterPosAdjustment", "computeLayerDryRunXYRangesAfterSizeExpand", "createLayerAesthetics", "sharedMappers", "", "createLayerAesthetics$plot_builder_portable", "createLayerDryRunAesthetics", "createLayerPos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "createLayerPos$plot_builder_portable", "prepareLayerAestheticMappers", "xAesMapper", "yAesMapper", "prepareLayerAestheticMappers$plot_builder_portable", "rangeWithExpand", "range", "scale", "Ljetbrains/datalore/plot/base/Scale;", "includeZero", "", "rangeWithExpand$plot_builder_portable", "updateExpandedMinMax", "", "value", "expand", "expandedMinMax", "", "plot-builder-portable"})
public final class PlotUtil {
    @NotNull
    public static final PlotUtil INSTANCE = new PlotUtil();

    private PlotUtil() {
    }

    @NotNull
    public final PositionAdjustment createLayerPos$plot_builder_portable(@NotNull GeomLayer layer, @NotNull Aesthetics aes) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        return layer.createPos(new PosProviderContext(aes){
            @NotNull
            private final Lazy groupCount$delegate;
            final /* synthetic */ Aesthetics $aes;
            {
                this.$aes = $aes;
                this.groupCount$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this.$aes){
                    final /* synthetic */ Aesthetics $aes;
                    {
                        this.$aes = $aes;
                        super(0);
                    }

                    @NotNull
                    public final Integer invoke() {
                        Set set2 = CollectionsKt.toSet(this.$aes.groups());
                        return set2.size();
                    }
                }));
            }

            @NotNull
            public Aesthetics getAesthetics() {
                return this.$aes;
            }

            public int getGroupCount() {
                Lazy lazy = this.groupCount$delegate;
                Object var2_2 = null;
                boolean bl = false;
                return ((Number)lazy.getValue()).intValue();
            }
        });
    }

    @NotNull
    public final Pair<ClosedRange<Double>, ClosedRange<Double>> computeLayerDryRunXYRanges(@NotNull GeomLayer layer, @NotNull Aesthetics aes) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        ImmutableGeomContext geomCtx = new GeomContextBuilder().aesthetics(aes).build();
        Pair<ClosedRange<Double>, ClosedRange<Double>> rangesAfterPosAdjustment = this.computeLayerDryRunXYRangesAfterPosAdjustment(layer, aes, geomCtx);
        Pair<ClosedRange<Double>, ClosedRange<Double>> pair2 = this.computeLayerDryRunXYRangesAfterSizeExpand(layer, aes, geomCtx);
        ClosedRange xRangeAfterSizeExpand = (ClosedRange)pair2.component1();
        ClosedRange yRangeAfterSizeExpand = (ClosedRange)pair2.component2();
        ClosedRange rangeX = (ClosedRange)rangesAfterPosAdjustment.getFirst();
        if (rangeX == null) {
            rangeX = xRangeAfterSizeExpand;
        } else if (xRangeAfterSizeExpand != null) {
            rangeX = rangeX.span(xRangeAfterSizeExpand);
        }
        ClosedRange rangeY = (ClosedRange)rangesAfterPosAdjustment.getSecond();
        if (rangeY == null) {
            rangeY = yRangeAfterSizeExpand;
        } else if (yRangeAfterSizeExpand != null) {
            rangeY = rangeY.span(yRangeAfterSizeExpand);
        }
        return new Pair(rangeX, rangeY);
    }

    private final ClosedRange<Double> combineRanges(List<Aes<Double>> aesList, Aesthetics aesthetics) {
        ClosedRange<Double> result = null;
        for (Aes<Double> aes : aesList) {
            ClosedRange<Double> closedRange;
            ClosedRange<Double> range = aesthetics.range(aes);
            if (range == null) continue;
            ClosedRange<Double> closedRange2 = result;
            result = closedRange2 == null ? range : ((closedRange = closedRange2.span(range)) == null ? range : closedRange);
        }
        return result;
    }

    private final Pair<ClosedRange<Double>, ClosedRange<Double>> computeLayerDryRunXYRangesAfterPosAdjustment(GeomLayer layer, Aesthetics aes, GeomContext geomCtx) {
        List<Aes<Double>> posAesX = Aes.Companion.affectingScaleX((Iterable)layer.renderedAes());
        List<Aes<Double>> posAesY = Aes.Companion.affectingScaleY((Iterable)layer.renderedAes());
        PositionAdjustment pos = this.createLayerPos$plot_builder_portable(layer, aes);
        if (pos.isIdentity()) {
            ClosedRange<Double> rangeX = this.combineRanges(posAesX, aes);
            ClosedRange<Double> rangeY = this.combineRanges(posAesY, aes);
            return new Pair(rangeX, rangeY);
        }
        double adjustedMinX = 0.0;
        double adjustedMaxX = 0.0;
        double adjustedMinY = 0.0;
        double adjustedMaxY = 0.0;
        boolean rangesInited = false;
        int cardinality = posAesX.size() * posAesY.size();
        Double[] px = new Double[cardinality];
        Double[] py = new Double[cardinality];
        for (DataPointAesthetics p : aes.dataPoints()) {
            int i = -1;
            for (Aes<Double> aesX : posAesX) {
                Double valX = p.numeric(aesX);
                for (Aes<Double> aesY : posAesY) {
                    Double valY = p.numeric(aesY);
                    int n = i;
                    i = n + 1;
                    px[i] = valX;
                    py[i] = valY;
                }
            }
            while (i >= 0) {
                if (px[i] != null && py[i] != null) {
                    Double x2 = px[i];
                    Double y2 = py[i];
                    if (SeriesUtil.INSTANCE.isFinite(x2) && SeriesUtil.INSTANCE.isFinite(y2)) {
                        Double d = x2;
                        Intrinsics.checkNotNull((Object)d);
                        double d2 = d;
                        Double d3 = y2;
                        Intrinsics.checkNotNull((Object)d3);
                        DoubleVector newLoc = pos.translate(new DoubleVector(d2, d3), p, geomCtx);
                        double adjustedX = newLoc.getX();
                        double adjustedY = newLoc.getY();
                        if (rangesInited) {
                            boolean bl = false;
                            adjustedMinX = Math.min(adjustedX, adjustedMinX);
                            bl = false;
                            adjustedMaxX = Math.max(adjustedX, adjustedMaxX);
                            bl = false;
                            adjustedMinY = Math.min(adjustedY, adjustedMinY);
                            bl = false;
                            adjustedMaxY = Math.max(adjustedY, adjustedMaxY);
                        } else {
                            adjustedMinX = adjustedMaxX = adjustedX;
                            adjustedMinY = adjustedMaxY = adjustedY;
                            rangesInited = true;
                        }
                    }
                }
                int n = i;
                i = n + -1;
            }
        }
        ClosedRange<Comparable> xRange = rangesInited ? new ClosedRange<Comparable>(Double.valueOf(adjustedMinX), Double.valueOf(adjustedMaxX)) : null;
        ClosedRange<Comparable> yRange = rangesInited ? new ClosedRange<Comparable>(Double.valueOf(adjustedMinY), Double.valueOf(adjustedMaxY)) : null;
        return new Pair(xRange, (Object)yRange);
    }

    private final Pair<ClosedRange<Double>, ClosedRange<Double>> computeLayerDryRunXYRangesAfterSizeExpand(GeomLayer layer, Aesthetics aesthetics, GeomContext geomCtx) {
        List<Aes<?>> renderedAes = layer.renderedAes();
        boolean computeExpandX = renderedAes.contains(Aes.Companion.getWIDTH());
        boolean computeExpandY = renderedAes.contains(Aes.Companion.getHEIGHT());
        ClosedRange<Double> rangeX = computeExpandX ? this.computeLayerDryRunRangeAfterSizeExpand(Aes.Companion.getX(), Aes.Companion.getWIDTH(), aesthetics, geomCtx) : null;
        ClosedRange<Double> rangeY = computeExpandY ? this.computeLayerDryRunRangeAfterSizeExpand(Aes.Companion.getY(), Aes.Companion.getHEIGHT(), aesthetics, geomCtx) : null;
        return new Pair(rangeX, rangeY);
    }

    private final ClosedRange<Double> computeLayerDryRunRangeAfterSizeExpand(Aes<Double> locationAes, Aes<Double> sizeAes, Aesthetics aesthetics, GeomContext geomCtx) {
        Iterator<Double> locations = aesthetics.numericValues(locationAes).iterator();
        Iterator<Double> sizes = aesthetics.numericValues(sizeAes).iterator();
        double resolution = geomCtx.getResolution(locationAes);
        double[] dArray = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        double[] minMax = dArray;
        int n = 0;
        int n2 = aesthetics.dataPointCount();
        if (n < n2) {
            do {
                int i = n++;
                if (!locations.hasNext()) {
                    throw new IllegalStateException("Index is out of bounds: " + i + " for " + locationAes);
                }
                if (!sizes.hasNext()) {
                    throw new IllegalStateException("Index is out of bounds: " + i + " for " + sizeAes);
                }
                Double loc = locations.next();
                Double size2 = sizes.next();
                if (!SeriesUtil.INSTANCE.isFinite(loc) || !SeriesUtil.INSTANCE.isFinite(size2)) continue;
                Double d = size2;
                Intrinsics.checkNotNull((Object)d);
                double expand = resolution * (d / (double)2);
                Double d2 = loc;
                Intrinsics.checkNotNull((Object)d2);
                this.updateExpandedMinMax(d2, expand, minMax);
            } while (n < n2);
        }
        return minMax[0] <= minMax[1] ? new ClosedRange<Comparable>(Double.valueOf(minMax[0]), Double.valueOf(minMax[1])) : null;
    }

    private final void updateExpandedMinMax(double value, double expand, double[] expandedMinMax) {
        double d = value - expand;
        double d2 = expandedMinMax[0];
        boolean bl = false;
        expandedMinMax[0] = Math.min(d, d2);
        d = value + expand;
        d2 = expandedMinMax[1];
        bl = false;
        expandedMinMax[1] = Math.max(d, d2);
    }

    @NotNull
    public final Aesthetics createLayerDryRunAesthetics(@NotNull GeomLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Map<Aes<?>, Function1<Double, Object>> mappers = this.prepareLayerAestheticMappers$plot_builder_portable(layer, Mappers.INSTANCE.getIDENTITY(), Mappers.INSTANCE.getIDENTITY());
        return this.createLayerAesthetics$plot_builder_portable(layer, mappers);
    }

    @NotNull
    public final Map<Aes<?>, Function1<Double, Object>> prepareLayerAestheticMappers$plot_builder_portable(@NotNull GeomLayer layer, @NotNull Function1<? super Double, Double> xAesMapper, @NotNull Function1<? super Double, Double> yAesMapper) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter(xAesMapper, (String)"xAesMapper");
        Intrinsics.checkNotNullParameter(yAesMapper, (String)"yAesMapper");
        HashMap mappers = new HashMap();
        Aes[] aesArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()};
        List renderedAes = CollectionsKt.plus((Collection)layer.renderedAes(), (Iterable)CollectionsKt.listOf((Object[])aesArray));
        for (Aes aes : renderedAes) {
            Function1<? super Double, Double> mapper2;
            Object object;
            if (Intrinsics.areEqual((Object)aes, Aes.Companion.getSLOPE())) {
                Object object2 = yAesMapper.invoke((Object)1.0);
                Intrinsics.checkNotNull((Object)object2);
                double d = ((Number)object2).doubleValue();
                Object object3 = xAesMapper.invoke((Object)1.0);
                Intrinsics.checkNotNull((Object)object3);
                object = Mappers.INSTANCE.mul(d / ((Number)object3).doubleValue());
            } else {
                object = Aes.Companion.isPositionalX(aes) ? xAesMapper : (Aes.Companion.isPositionalY(aes) ? yAesMapper : (layer.hasBinding(aes) ? layer.getScaleMap().get(aes).getMapper() : null));
            }
            Function1<? super Double, Double> function1 = mapper2 = object;
            if (function1 == null) continue;
            Function1<? super Double, Double> function12 = function1;
            boolean bl = false;
            boolean bl2 = false;
            Function1<? super Double, Double> $this$prepareLayerAestheticMappers_u24lambda_u2d0 = function12;
            boolean bl3 = false;
            Map map2 = mappers;
            boolean bl4 = false;
            map2.put(aes, $this$prepareLayerAestheticMappers_u24lambda_u2d0);
        }
        return mappers;
    }

    @NotNull
    public final Aesthetics createLayerAesthetics$plot_builder_portable(@NotNull GeomLayer layer, @NotNull Map<Aes<?>, ? extends Function1<? super Double, ? extends Object>> sharedMappers) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter(sharedMappers, (String)"sharedMappers");
        AestheticsBuilder aesBuilder = new AestheticsBuilder(0, 1, null);
        aesBuilder.group(layer.getGroup());
        boolean hasPositionalConstants = false;
        for (Aes<?> aes : layer.renderedAes()) {
            if (!Aes.Companion.isPositional(aes) || !layer.hasConstant(aes)) continue;
            hasPositionalConstants = true;
            break;
        }
        DataFrame data = layer.getDataFrame();
        Integer dataPointCount = null;
        Iterator<Aes<?>> iterator2 = layer.renderedAes().iterator();
        while (iterator2.hasNext()) {
            Object v2;
            Aes<?> aes;
            Aes<?> aes2 = aes = iterator2.next();
            Function1<? super Double, ? extends Object> mapperOption = sharedMappers.get(aes2);
            if (layer.hasConstant(aes2)) {
                v2 = layer.getConstant(aes2);
                aesBuilder.constantAes(aes2, this.asAesValue(aes2, v2, mapperOption));
                continue;
            }
            if (layer.hasBinding(aes2)) {
                boolean v2 = mapperOption != null;
                boolean bl = false;
                int n = 0;
                if (!v2) {
                    boolean bl2 = false;
                    String string = Intrinsics.stringPlus((String)"No scale mapper defined for aesthetic ", aes2);
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                DataFrame.Variable transformVar = DataFrameUtil.INSTANCE.transformVarFor(aes2);
                bl = data.has(transformVar);
                n = 0;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Undefined var " + transformVar + " for aesthetic " + aes2;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                List<Double> numericValues2 = data.getNumeric(transformVar);
                if (dataPointCount == null) {
                    dataPointCount = numericValues2.size();
                } else {
                    n = numericValues2.size();
                    n = dataPointCount == n ? 1 : 0;
                    bl3 = false;
                    boolean bl5 = false;
                    if (n == 0) {
                        boolean bl6 = false;
                        String string = "" + aes2 + " expected data size=" + dataPointCount + " was size=" + numericValues2.size();
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
                n = 0;
                if (dataPointCount == 0 && hasPositionalConstants) {
                    aesBuilder.constantAes(aes2, layer.getAestheticsDefaults().defaultValue(aes2));
                    continue;
                }
                Function1<Integer, ? extends Object> integerFunction = AestheticsBuilder.Companion.listMapper(numericValues2, mapperOption);
                aesBuilder.aes(aes2, integerFunction);
                continue;
            }
            v2 = layer.getDefault(aes2);
            aesBuilder.constantAes(aes2, this.asAesValue(aes2, v2, mapperOption));
        }
        if (dataPointCount != null && ((Number)dataPointCount).intValue() > 0) {
            aesBuilder.dataPointCount(((Number)dataPointCount).intValue());
        } else if (hasPositionalConstants) {
            aesBuilder.dataPointCount(1);
        }
        return aesBuilder.build();
    }

    private final <T> T asAesValue(Aes<?> aes, T dataValue, Function1<? super Double, ? extends T> mapperOption) {
        Object object;
        if (aes.isNumeric() && mapperOption != null) {
            Object object2 = mapperOption.invoke((Object)(dataValue instanceof Double ? (Double)dataValue : null));
            if (object2 == null) {
                throw new IllegalArgumentException("Can't map " + dataValue + " to aesthetic " + aes);
            }
            object = object2;
        } else {
            object = dataValue;
        }
        return object;
    }

    @Nullable
    public final ClosedRange<Double> rangeWithExpand$plot_builder_portable(@Nullable ClosedRange<Double> range, @NotNull Scale<?> scale, boolean includeZero) {
        Double d;
        double transformed;
        Double d2;
        double transformed2;
        double upperExpand;
        double lowerExpand;
        double upperEndpoint;
        double lowerEndpoint;
        ContinuousTransform continuousTransform;
        block6: {
            block7: {
                Intrinsics.checkNotNullParameter(scale, (String)"scale");
                if (range == null) {
                    return null;
                }
                double mulExp = scale.getMultiplicativeExpand();
                double addExp = scale.getAdditiveExpand();
                ContinuousTransform continuousTransform2 = continuousTransform = scale.isContinuousDomain() ? (ContinuousTransform)scale.getTransform() : (ContinuousTransform)null;
                Double d3 = continuousTransform2 == null ? null : continuousTransform2.applyInverse(range.getLowerEnd());
                lowerEndpoint = d3 == null ? ((Number)range.getLowerEnd()).doubleValue() : d3.doubleValue();
                ContinuousTransform continuousTransform3 = continuousTransform;
                Double d4 = continuousTransform3 == null ? null : continuousTransform3.applyInverse(range.getUpperEnd());
                upperEndpoint = d4 == null ? ((Number)range.getUpperEnd()).doubleValue() : d4.doubleValue();
                double length = upperEndpoint - lowerEndpoint;
                upperExpand = lowerExpand = addExp + length * mulExp;
                if (!includeZero) break block6;
                if (lowerEndpoint == 0.0 || upperEndpoint == 0.0) break block7;
                boolean bl = false;
                bl = false;
                if (!(Math.signum(lowerEndpoint) == Math.signum(upperEndpoint))) break block6;
            }
            if (lowerEndpoint >= 0.0) {
                lowerExpand = 0.0;
            } else {
                upperExpand = 0.0;
            }
        }
        double d5 = lowerEndpoint - lowerExpand;
        boolean bl = false;
        boolean bl2 = false;
        double it = d5;
        boolean bl3 = false;
        ContinuousTransform continuousTransform4 = continuousTransform;
        double d6 = transformed2 = continuousTransform4 == null ? it : ((d2 = continuousTransform4.apply(it)) == null ? it : d2);
        boolean bl4 = false;
        double lowerEndWithExpand = Double.isNaN(d6) ? ((Number)range.getLowerEnd()).doubleValue() : transformed2;
        double d7 = upperEndpoint + upperExpand;
        boolean bl5 = false;
        boolean bl6 = false;
        double it2 = d7;
        boolean bl7 = false;
        ContinuousTransform continuousTransform5 = continuousTransform;
        double d8 = transformed = continuousTransform5 == null ? it2 : ((d = continuousTransform5.apply(it2)) == null ? it2 : d);
        boolean bl8 = false;
        double upperEndWithExpand = Double.isNaN(d8) ? ((Number)range.getUpperEnd()).doubleValue() : transformed;
        return new ClosedRange<Comparable>(Double.valueOf(lowerEndWithExpand), Double.valueOf(upperEndWithExpand));
    }
}

