/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AestheticsUtil;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.PointLegendKeyElementFactory;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.base.render.point.NamedShape;
import jetbrains.datalore.plot.base.render.point.PointShape;
import jetbrains.datalore.plot.base.render.point.PointShapeSvg;
import jetbrains.datalore.plot.base.render.point.TinyPointShape;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.vis.svg.slim.SvgSlimElements;
import jetbrains.datalore.vis.svg.slim.SvgSlimGroup;
import jetbrains.datalore.vis.svg.slim.SvgSlimObject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Ljetbrains/datalore/plot/base/geom/PointGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "animation", "", "getAnimation", "()Ljava/lang/Object;", "setAnimation", "(Ljava/lang/Object;)V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "sizeUnit", "", "getSizeUnit", "()Ljava/lang/String;", "setSizeUnit", "(Ljava/lang/String;)V", "buildIntern", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "getSizeUnitRatio", "", "Companion", "plot-base-portable"})
public class PointGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Object animation;
    @Nullable
    private String sizeUnit;
    public static final boolean HANDLES_GROUPS = false;

    @Nullable
    public final Object getAnimation() {
        return this.animation;
    }

    public final void setAnimation(@Nullable Object object) {
        this.animation = object;
    }

    @Nullable
    public final String getSizeUnit() {
        return this.sizeUnit;
    }

    public final void setSizeUnit(@Nullable String string) {
        this.sizeUnit = string;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new PointLegendKeyElementFactory(0.0, 1, null);
    }

    @Override
    public void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper helper = new GeomHelper(pos, coord, ctx2);
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx2);
        int count2 = aesthetics.dataPointCount();
        SvgSlimGroup slimGroup = SvgSlimElements.INSTANCE.g(count2);
        double sizeUnitRatio = this.getSizeUnitRatio(ctx2);
        int n = 0;
        if (n < count2) {
            do {
                PointShape shape;
                Double y2;
                int i;
                DataPointAesthetics p;
                Double x2;
                if (!SeriesUtil.INSTANCE.allFinite(x2 = (p = aesthetics.dataPointAt(i = n++)).x(), y2 = p.y())) continue;
                Double d = x2;
                Intrinsics.checkNotNull((Object)d);
                double d2 = d;
                Double d3 = y2;
                Intrinsics.checkNotNull((Object)d3);
                DoubleVector location = helper.toClient(new DoubleVector(d2, d3), p);
                Intrinsics.checkNotNull((Object)p.shape());
                GeomTargetCollector.DefaultImpls.addPoint$default(targetCollector, i, location, sizeUnitRatio * shape.size(p) / (double)2, Companion.tooltipParams(p), null, 16, null);
                SvgSlimObject o = PointShapeSvg.INSTANCE.create(shape, location, p, sizeUnitRatio);
                o.appendTo(slimGroup);
            } while (n < count2);
        }
        root.add(GeomBase.Companion.wrap(slimGroup));
    }

    private final double getSizeUnitRatio(GeomContext ctx2) {
        double d;
        if (this.sizeUnit != null) {
            String string = this.sizeUnit;
            Intrinsics.checkNotNull((Object)string);
            double unitRes = ctx2.getUnitResolution(GeomHelper.Companion.getSizeUnitAes(string));
            d = unitRes / 2.2;
        } else {
            d = 1.0;
        }
        return d;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/geom/PointGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "tooltipParams", "Ljetbrains/datalore/plot/base/interact/GeomTargetCollector$TooltipParams;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GeomTargetCollector.TooltipParams tooltipParams(@NotNull DataPointAesthetics p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Color color = Color.Companion.getTRANSPARENT();
            if (Intrinsics.areEqual((Object)p.shape(), (Object)TinyPointShape.INSTANCE)) {
                Color color2 = p.color();
                Intrinsics.checkNotNull((Object)color2);
                color = color2;
            } else if (p.shape() instanceof NamedShape) {
                PointShape pointShape = p.shape();
                if (pointShape == null) {
                    throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.base.render.point.NamedShape");
                }
                NamedShape shape = (NamedShape)pointShape;
                color = AestheticsUtil.INSTANCE.fill(shape.isFilled(), shape.isSolid(), p);
            }
            GeomTargetCollector.TooltipParams tooltipParams = GeomTargetCollector.TooltipParams.Companion.params();
            Double d = p.alpha();
            Intrinsics.checkNotNull((Object)d);
            return tooltipParams.setColor(HintColorUtil.INSTANCE.fromColorValue(color, d));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

