/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.datetime.tz;

import jetbrains.datalore.base.datetime.Date;
import jetbrains.datalore.base.datetime.DateTime;
import jetbrains.datalore.base.datetime.Duration;
import jetbrains.datalore.base.datetime.Instant;
import jetbrains.datalore.base.datetime.Time;
import jetbrains.datalore.base.datetime.tz.TimeZoneMoscow;
import jetbrains.datalore.base.datetime.tz.TimeZones;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0011\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H&J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000eH&J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/base/datetime/tz/TimeZone;", "", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "convertTimeAtDay", "Ljetbrains/datalore/base/datetime/Time;", "srcTime", "dstDate", "Ljetbrains/datalore/base/datetime/Date;", "dstTimeZone", "convertTo", "Ljetbrains/datalore/base/datetime/DateTime;", "toConvert", "to", "getTimeZoneShift", "Ljetbrains/datalore/base/datetime/Duration;", "instant", "Ljetbrains/datalore/base/datetime/Instant;", "toDateTime", "toInstant", "dateTime", "toString", "Companion", "base-portable"})
public abstract class TimeZone {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String id;
    @NotNull
    private static final TimeZone UTC = TimeZones.INSTANCE.utc();
    @NotNull
    private static final TimeZone BERLIN = TimeZones.INSTANCE.withEuSummerTime("Europe/Berlin", Duration.Companion.getHOUR().mul(1L));
    @NotNull
    private static final TimeZone MOSCOW = new TimeZoneMoscow();
    @NotNull
    private static final TimeZone NY = TimeZones.INSTANCE.withUsSummerTime("America/New_York", Duration.Companion.getHOUR().mul(-5L));

    protected TimeZone(@Nullable String id) {
        this.id = id;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    @NotNull
    public abstract DateTime toDateTime(@NotNull Instant var1);

    @NotNull
    public abstract Instant toInstant(@NotNull DateTime var1);

    @NotNull
    public final DateTime convertTo(@NotNull DateTime toConvert, @NotNull TimeZone to) {
        Intrinsics.checkNotNullParameter((Object)toConvert, (String)"toConvert");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return to == this ? toConvert : to.toDateTime(this.toInstant(toConvert));
    }

    @NotNull
    public final Time convertTimeAtDay(@NotNull Time srcTime, @NotNull Date dstDate, @NotNull TimeZone dstTimeZone) {
        Intrinsics.checkNotNullParameter((Object)srcTime, (String)"srcTime");
        Intrinsics.checkNotNullParameter((Object)dstDate, (String)"dstDate");
        Intrinsics.checkNotNullParameter((Object)dstTimeZone, (String)"dstTimeZone");
        DateTime src = new DateTime(dstDate, srcTime);
        DateTime dst = this.convertTo(src, dstTimeZone);
        int dayDiff = dstDate.compareTo(dst.getDate());
        if (dayDiff != 0) {
            Date correctedDay = dayDiff > 0 ? dstDate.nextDate() : dstDate.prevDate();
            src = new DateTime(correctedDay, srcTime);
            dst = this.convertTo(src, dstTimeZone);
        }
        return dst.getTime();
    }

    @NotNull
    public final Duration getTimeZoneShift(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        DateTime utcDateTime = this.toDateTime(instant);
        return instant.to(UTC.toInstant(utcDateTime));
    }

    @NotNull
    public String toString() {
        String string = this.id;
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/base/datetime/tz/TimeZone$Companion;", "", "()V", "BERLIN", "Ljetbrains/datalore/base/datetime/tz/TimeZone;", "getBERLIN", "()Ljetbrains/datalore/base/datetime/tz/TimeZone;", "MOSCOW", "getMOSCOW", "NY", "getNY", "UTC", "getUTC", "base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeZone getUTC() {
            return UTC;
        }

        @NotNull
        public final TimeZone getBERLIN() {
            return BERLIN;
        }

        @NotNull
        public final TimeZone getMOSCOW() {
            return MOSCOW;
        }

        @NotNull
        public final TimeZone getNY() {
            return NY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

