/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.openmodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.jmeter.threads.openmodel.DefaultThreadSchedule;
import org.apache.jmeter.threads.openmodel.ParserException;
import org.apache.jmeter.threads.openmodel.ThreadSchedule;
import org.apache.jmeter.threads.openmodel.ThreadScheduleStep;
import org.apache.jmeter.threads.openmodel.TimeUnitExtensionsKt;
import org.apache.jmeter.threads.openmodel.Tokenizer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0015\"\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0012\u001a\u0002H\u0017\"\n\b\u0000\u0010\u0017\u0018\u0001*\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0003H\u0082\b\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u000eH\u0002J\n\u0010$\u001a\u0004\u0018\u00010\u001dH\u0002J\b\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lorg/apache/jmeter/threads/openmodel/ScheduleParser;", "", "schedule", "", "(Ljava/lang/String;)V", "lastRate", "Lorg/apache/jmeter/threads/openmodel/ThreadScheduleStep$RateStep;", "pos", "", "token", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$Token;", "getToken", "()Lorg/apache/jmeter/threads/openmodel/Tokenizer$Token;", "tokens", "", "Lorg/apache/jmeter/threads/openmodel/Tokenizer$TokenPosition;", "getTokens", "()Ljava/util/List;", "consume", "", "expected", "", "([Lorg/apache/jmeter/threads/openmodel/Tokenizer$Token;)V", "T", "failMessage", "(Ljava/lang/String;)Lorg/apache/jmeter/threads/openmodel/Tokenizer$Token;", "parse", "Lorg/apache/jmeter/threads/openmodel/ThreadSchedule;", "parseArrivals", "Lorg/apache/jmeter/threads/openmodel/ThreadScheduleStep;", "functionName", "type", "Lorg/apache/jmeter/threads/openmodel/ThreadScheduleStep$ArrivalType;", "parseDuration", "", "parsePause", "parseRate", "parseTimeUnit", "Ljava/util/concurrent/TimeUnit;", "throwParseException", "", "message", "ApacheJMeter_core"})
public final class ScheduleParser {
    @NotNull
    private final String schedule;
    @NotNull
    private final List<Tokenizer.TokenPosition> tokens;
    private int pos;
    @NotNull
    private ThreadScheduleStep.RateStep lastRate;

    public ScheduleParser(@NotNull String schedule) {
        Intrinsics.checkNotNullParameter((Object)schedule, (String)"schedule");
        this.schedule = schedule;
        this.tokens = Tokenizer.INSTANCE.tokenize(this.schedule);
        this.lastRate = new ThreadScheduleStep.RateStep(0.0);
    }

    @NotNull
    public final List<Tokenizer.TokenPosition> getTokens() {
        return this.tokens;
    }

    private final Tokenizer.Token getToken() {
        return this.pos >= this.tokens.size() ? null : this.tokens.get(this.pos).getToken();
    }

    private final Void throwParseException(String message) {
        throw new ParserException(this.schedule, this.pos >= this.tokens.size() ? 0 : this.tokens.get(this.pos).getPos(), message);
    }

    @NotNull
    public final ThreadSchedule parse() {
        List steps = new ArrayList();
        while (this.pos < this.tokens.size()) {
            List<ThreadScheduleStep> pauseSteps = this.parsePause();
            if (pauseSteps != null) {
                CollectionsKt.addAll((Collection)steps, (Iterable)pauseSteps);
                continue;
            }
            ThreadScheduleStep threadScheduleStep = this.parseRate();
            if (threadScheduleStep == null && (threadScheduleStep = this.parseArrivals("random_arrivals", ThreadScheduleStep.ArrivalType.RANDOM)) == null && (threadScheduleStep = this.parseArrivals("even_arrivals", ThreadScheduleStep.ArrivalType.EVEN)) == null) {
                this.throwParseException("Unexpected input (expecting rate, random_arrivals, even_arrivals, or pause)");
                throw new KotlinNothingValueException();
            }
            ThreadScheduleStep step = threadScheduleStep;
            ((Collection)steps).add(step);
            if (!(step instanceof ThreadScheduleStep.RateStep)) continue;
            this.lastRate = (ThreadScheduleStep.RateStep)step;
        }
        return new DefaultThreadSchedule(steps);
    }

    private final void consume(Tokenizer.Token ... expected) {
        if (!ArraysKt.contains((Object[])expected, (Object)this.getToken())) {
            this.throwParseException("Unexpected input. Expected " + ArraysKt.joinToString$default((Object[])expected, null, null, null, (int)0, null, null, (int)63, null) + " got " + this.getToken());
            throw new KotlinNothingValueException();
        }
        ++this.pos;
    }

    private final /* synthetic */ <T extends Tokenizer.Token> T consume(String failMessage) {
        Tokenizer.Token token;
        boolean $i$f$consume = false;
        Tokenizer.Token token2 = this.getToken();
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        Tokenizer.Token it = token = token2;
        boolean bl = false;
        ++this.pos;
        Tokenizer.Token token3 = token;
        if (token3 == null) {
            this.throwParseException("Unexpected input. Expected " + failMessage + " got " + this.getToken());
            throw new KotlinNothingValueException();
        }
        return (T)token3;
    }

    /*
     * WARNING - void declaration
     */
    private final ThreadScheduleStep parseRate() {
        TimeUnit timeUnit;
        Tokenizer.Token[] tokenArray;
        void this_$iv;
        Tokenizer.Token token = this.getToken();
        if (!StringsKt.equals((String)(token != null ? token.getImage() : null), (String)"rate", (boolean)true)) {
            return null;
        }
        ++this.pos;
        Tokenizer.Token[] tokenArray2 = new Tokenizer.Token[]{Tokenizer.OpenParenthesisToken.INSTANCE};
        this.consume(tokenArray2);
        ScheduleParser scheduleParser = this;
        String failMessage$iv = "float number for rate";
        boolean $i$f$consume = false;
        Tokenizer.Token token2 = super.getToken();
        if (!(token2 instanceof Tokenizer.NumberToken)) {
            token2 = null;
        }
        Tokenizer.Token[] it$iv = tokenArray = (Tokenizer.Token[])((Tokenizer.NumberToken)token2);
        boolean bl = false;
        ++this_$iv.pos;
        if (tokenArray == null) {
            super.throwParseException("Unexpected input. Expected " + failMessage$iv + " got " + super.getToken());
            throw new KotlinNothingValueException();
        }
        Tokenizer.NumberToken rate = (Tokenizer.NumberToken)tokenArray;
        double rateValue = Double.parseDouble(rate.getImage());
        if (rateValue == 0.0 && Intrinsics.areEqual((Object)this.getToken(), (Object)Tokenizer.CloseParenthesisToken.INSTANCE)) {
            timeUnit = TimeUnit.SECONDS;
        } else {
            tokenArray = new Tokenizer.Token[]{Tokenizer.DivideToken.INSTANCE, new Tokenizer.IdentifierToken("per")};
            this.consume(tokenArray);
            timeUnit = this.parseTimeUnit();
        }
        TimeUnit timeUnit2 = timeUnit;
        tokenArray = new Tokenizer.Token[]{Tokenizer.CloseParenthesisToken.INSTANCE};
        this.consume(tokenArray);
        return new ThreadScheduleStep.RateStep(rateValue / TimeUnitExtensionsKt.getAsSeconds(timeUnit2));
    }

    private final ThreadScheduleStep parseArrivals(String functionName, ThreadScheduleStep.ArrivalType type) {
        Tokenizer.Token token = this.getToken();
        if (!StringsKt.equals((String)(token != null ? token.getImage() : null), (String)functionName, (boolean)true)) {
            return null;
        }
        ++this.pos;
        Tokenizer.Token[] tokenArray = new Tokenizer.Token[]{Tokenizer.OpenParenthesisToken.INSTANCE};
        this.consume(tokenArray);
        double duration = this.parseDuration();
        Tokenizer.Token[] tokenArray2 = new Tokenizer.Token[]{Tokenizer.CloseParenthesisToken.INSTANCE};
        this.consume(tokenArray2);
        return new ThreadScheduleStep.ArrivalsStep(type, duration);
    }

    private final List<ThreadScheduleStep> parsePause() {
        Tokenizer.Token token = this.getToken();
        if (!StringsKt.equals((String)(token != null ? token.getImage() : null), (String)"pause", (boolean)true)) {
            return null;
        }
        ++this.pos;
        Tokenizer.Token[] tokenArray = new Tokenizer.Token[]{Tokenizer.OpenParenthesisToken.INSTANCE};
        this.consume(tokenArray);
        double duration = this.parseDuration();
        Tokenizer.Token[] tokenArray2 = new Tokenizer.Token[]{Tokenizer.CloseParenthesisToken.INSTANCE};
        this.consume(tokenArray2);
        ThreadScheduleStep.ArrivalsStep arrivals = new ThreadScheduleStep.ArrivalsStep(ThreadScheduleStep.ArrivalType.EVEN, duration);
        if (this.lastRate.getRate() == 0.0) {
            Object[] objectArray = new ThreadScheduleStep[]{arrivals, this.lastRate};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        ThreadScheduleStep.RateStep zeroRate = new ThreadScheduleStep.RateStep(0.0);
        Object[] objectArray = new ThreadScheduleStep[]{this.lastRate, zeroRate, arrivals, zeroRate, this.lastRate};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final double parseDuration() {
        double res = 0.0;
        do {
            Tokenizer.Token token;
            void this_$iv;
            ScheduleParser scheduleParser = this;
            String failMessage$iv = "float number for duration";
            boolean $i$f$consume = false;
            Tokenizer.Token token2 = super.getToken();
            if (!(token2 instanceof Tokenizer.NumberToken)) {
                token2 = null;
            }
            Tokenizer.Token it$iv = token = (Tokenizer.Token)((Tokenizer.NumberToken)token2);
            boolean bl = false;
            ++this_$iv.pos;
            Tokenizer.Token token3 = token;
            if (token3 == null) {
                super.throwParseException("Unexpected input. Expected " + failMessage$iv + " got " + super.getToken());
                throw new KotlinNothingValueException();
            }
            Tokenizer.NumberToken duration = (Tokenizer.NumberToken)token3;
            double durationValue = Double.parseDouble(duration.getImage());
            if (durationValue == 0.0 && Intrinsics.areEqual((Object)this.getToken(), (Object)Tokenizer.CloseParenthesisToken.INSTANCE)) break;
            TimeUnit timeUnit = this.parseTimeUnit();
            res += durationValue * TimeUnitExtensionsKt.getAsSeconds(timeUnit);
        } while (this.getToken() instanceof Tokenizer.NumberToken);
        return res;
    }

    /*
     * WARNING - void declaration
     */
    private final TimeUnit parseTimeUnit() {
        TimeUnit timeUnit;
        Tokenizer.Token token;
        void this_$iv;
        ScheduleParser scheduleParser = this;
        String failMessage$iv = "unit for duration: sec, min, hour, day";
        boolean $i$f$consume = false;
        Tokenizer.Token token2 = super.getToken();
        if (!(token2 instanceof Tokenizer.IdentifierToken)) {
            token2 = null;
        }
        Tokenizer.Token it$iv = token = (Tokenizer.Token)((Tokenizer.IdentifierToken)token2);
        boolean bl = false;
        ++this_$iv.pos;
        Tokenizer.Token token3 = token;
        if (token3 == null) {
            super.throwParseException("Unexpected input. Expected " + failMessage$iv + " got " + super.getToken());
            throw new KotlinNothingValueException();
        }
        Tokenizer.IdentifierToken unit = (Tokenizer.IdentifierToken)token3;
        String image = unit.getImage();
        if (StringsKt.equals((String)image, (String)"ms", (boolean)true)) {
            timeUnit = TimeUnit.MILLISECONDS;
        } else if (StringsKt.equals((String)image, (String)"s", (boolean)true) || StringsKt.startsWith((String)image, (String)"sec", (boolean)true)) {
            timeUnit = TimeUnit.SECONDS;
        } else if (StringsKt.equals((String)image, (String)"m", (boolean)true) || StringsKt.startsWith((String)image, (String)"min", (boolean)true)) {
            timeUnit = TimeUnit.MINUTES;
        } else if (StringsKt.equals((String)image, (String)"h", (boolean)true) || StringsKt.startsWith((String)image, (String)"hour", (boolean)true)) {
            timeUnit = TimeUnit.HOURS;
        } else if (StringsKt.equals((String)image, (String)"d", (boolean)true) || StringsKt.startsWith((String)image, (String)"day", (boolean)true)) {
            timeUnit = TimeUnit.DAYS;
        } else {
            this.throwParseException("Unexpected time unit " + image);
            throw new KotlinNothingValueException();
        }
        TimeUnit timeUnit2 = timeUnit;
        return timeUnit2;
    }
}

