/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.io;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextFile
extends File {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggerFactory.getLogger(TextFile.class);
    private String encoding = null;

    public TextFile(File filename, String encoding) {
        super(filename.toString());
        this.setEncoding(encoding);
    }

    public TextFile(File filename) {
        super(filename.toString());
    }

    public TextFile(String filename) {
        super(filename);
    }

    public TextFile(String filename, String encoding) {
        super(filename);
        this.setEncoding(encoding);
    }

    public void setText(String body) {
        try {
            Files.write(this.toPath(), body.getBytes(this.getCharset()), new OpenOption[0]);
        }
        catch (IOException ioe) {
            log.error("", (Throwable)ioe);
        }
    }

    public String getText() {
        try {
            byte[] encoded = Files.readAllBytes(this.toPath());
            return new String(encoded, this.getCharset());
        }
        catch (IOException ioe) {
            log.error("Failed to getText", (Throwable)ioe);
            return "";
        }
    }

    private Charset getCharset() {
        return this.encoding != null ? Charset.forName(this.encoding) : Charset.defaultCharset();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.encoding == null ? 0 : this.encoding.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TextFile)) {
            return false;
        }
        TextFile other = (TextFile)obj;
        if (this.encoding == null) {
            return other.encoding == null;
        }
        return this.encoding.equals(other.encoding);
    }
}

