/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.Geom;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.builder.AxisUtil;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.LayerRendererUtil;
import jetbrains.datalore.plot.builder.SvgLayerRenderer;
import jetbrains.datalore.plot.builder.TileFrameOfReference;
import jetbrains.datalore.plot.builder.assemble.GeomContextBuilder;
import jetbrains.datalore.plot.builder.assemble.ImmutableGeomContext;
import jetbrains.datalore.plot.builder.guide.AxisComponent;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import jetbrains.datalore.plot.builder.theme.PanelGridTheme;
import jetbrains.datalore.plot.builder.theme.PanelTheme;
import jetbrains.datalore.plot.builder.theme.Theme;
import jetbrains.datalore.vis.svg.SvgNode;
import jetbrains.datalore.vis.svg.SvgRectElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(BA\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001bH\u0016J\u0010\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001bH\u0016J\u0018\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u0018H\u0002J\u0018\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\rH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Ljetbrains/datalore/plot/builder/SquareFrameOfReference;", "Ljetbrains/datalore/plot/builder/TileFrameOfReference;", "hScale", "Ljetbrains/datalore/plot/base/Scale;", "", "vScale", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "layoutInfo", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "theme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "flipAxis", "", "(Ljetbrains/datalore/plot/base/Scale;Ljetbrains/datalore/plot/base/Scale;Ljetbrains/datalore/plot/base/CoordinateSystem;Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;Ljetbrains/datalore/plot/builder/theme/Theme;Z)V", "geomCoord", "geomMapperX", "Lkotlin/Function1;", "geomMapperY", "isDebugDrawing", "()Z", "setDebugDrawing", "(Z)V", "applyClientLimits", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "clientBounds", "buildGeomComponent", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "layer", "Ljetbrains/datalore/plot/builder/GeomLayer;", "targetCollector", "Ljetbrains/datalore/plot/base/interact/GeomTargetCollector;", "drawAfterGeomLayer", "", "parent", "drawBeforeGeomLayer", "drawDebugShapes", "geomBounds", "drawPanelAndAxis", "beforeGeomLayer", "Companion", "plot-builder-portable"})
public final class SquareFrameOfReference
implements TileFrameOfReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Scale<Double> hScale;
    @NotNull
    private final Scale<Double> vScale;
    @NotNull
    private final CoordinateSystem coord;
    @NotNull
    private final TileLayoutInfo layoutInfo;
    @NotNull
    private final Theme theme;
    private final boolean flipAxis;
    private boolean isDebugDrawing;
    @NotNull
    private final Function1<Double, Double> geomMapperX;
    @NotNull
    private final Function1<Double, Double> geomMapperY;
    @NotNull
    private final CoordinateSystem geomCoord;

    public SquareFrameOfReference(@NotNull Scale<Double> hScale, @NotNull Scale<Double> vScale, @NotNull CoordinateSystem coord, @NotNull TileLayoutInfo layoutInfo, @NotNull Theme theme, boolean flipAxis) {
        Intrinsics.checkNotNullParameter(hScale, (String)"hScale");
        Intrinsics.checkNotNullParameter(vScale, (String)"vScale");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.hScale = hScale;
        this.vScale = vScale;
        this.coord = coord;
        this.layoutInfo = layoutInfo;
        this.theme = theme;
        this.flipAxis = flipAxis;
        if (this.flipAxis) {
            this.geomMapperX = this.vScale.getMapper();
            this.geomMapperY = this.hScale.getMapper();
            this.geomCoord = this.coord.flip();
        } else {
            this.geomMapperX = this.hScale.getMapper();
            this.geomMapperY = this.vScale.getMapper();
            this.geomCoord = this.coord;
        }
    }

    public final boolean isDebugDrawing() {
        return this.isDebugDrawing;
    }

    public final void setDebugDrawing(boolean bl) {
        this.isDebugDrawing = bl;
    }

    @Override
    public void drawBeforeGeomLayer(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.drawPanelAndAxis(parent, true);
    }

    @Override
    public void drawAfterGeomLayer(@NotNull SvgComponent parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.drawPanelAndAxis(parent, false);
    }

    private final void drawPanelAndAxis(SvgComponent parent, boolean beforeGeomLayer) {
        boolean drawVAxis;
        DoubleRectangle geomBounds = this.layoutInfo.getGeomBounds();
        PanelTheme panelTheme = this.theme.panel();
        AxisTheme hAxisTheme = this.theme.axisX(this.flipAxis);
        AxisTheme vAxisTheme = this.theme.axisY(this.flipAxis);
        PanelGridTheme hGridTheme = panelTheme.gridX(this.flipAxis);
        PanelGridTheme vGridTheme = panelTheme.gridY(this.flipAxis);
        boolean drawPanel = panelTheme.showRect() && beforeGeomLayer;
        boolean drawGridlines = beforeGeomLayer;
        boolean drawHAxis = beforeGeomLayer ? !hAxisTheme.isOntop() : hAxisTheme.isOntop();
        boolean bl = beforeGeomLayer ? !vAxisTheme.isOntop() : (drawVAxis = vAxisTheme.isOntop());
        if (drawPanel) {
            SvgRectElement panel = SquareFrameOfReference.Companion.buildPanelComponent(geomBounds, panelTheme);
            parent.add((SvgNode)panel);
        }
        if (drawHAxis || drawGridlines) {
            AxisLayoutInfo axisLayoutInfo = this.layoutInfo.getXAxisInfo();
            Intrinsics.checkNotNull((Object)axisLayoutInfo);
            AxisComponent hAxis = SquareFrameOfReference.Companion.buildAxis((Scale<Double>)this.hScale, axisLayoutInfo, !drawHAxis, !this.layoutInfo.getXAxisShown(), !drawGridlines, this.coord, hAxisTheme, hGridTheme, geomBounds.getHeight(), this.isDebugDrawing);
            hAxis.moveTo(new DoubleVector(geomBounds.getLeft(), geomBounds.getBottom()));
            parent.add((SvgComponent)hAxis);
        }
        if (drawVAxis || drawGridlines) {
            AxisLayoutInfo axisLayoutInfo = this.layoutInfo.getYAxisInfo();
            Intrinsics.checkNotNull((Object)axisLayoutInfo);
            AxisComponent vAxis = SquareFrameOfReference.Companion.buildAxis((Scale<Double>)this.vScale, axisLayoutInfo, !drawVAxis, !this.layoutInfo.getYAxisShown(), !drawGridlines, this.coord, vAxisTheme, vGridTheme, geomBounds.getWidth(), this.isDebugDrawing);
            vAxis.moveTo(geomBounds.getOrigin());
            parent.add((SvgComponent)vAxis);
        }
        if (this.isDebugDrawing && !beforeGeomLayer) {
            this.drawDebugShapes(parent, geomBounds);
        }
    }

    private final void drawDebugShapes(SvgComponent parent, DoubleRectangle geomBounds) {
        SquareFrameOfReference squareFrameOfReference = this;
        boolean bl = false;
        boolean bl2 = false;
        SquareFrameOfReference $this$drawDebugShapes_u24lambda_u2d0 = squareFrameOfReference;
        boolean bl3 = false;
        DoubleRectangle tileBounds = $this$drawDebugShapes_u24lambda_u2d0.layoutInfo.getBounds();
        SvgRectElement rect2 = new SvgRectElement(tileBounds);
        rect2.fillColor().set((Object)Color.Companion.getBLACK());
        rect2.strokeWidth().set((Object)0.0);
        rect2.fillOpacity().set((Object)0.1);
        parent.add((SvgNode)rect2);
        squareFrameOfReference = this;
        bl = false;
        bl2 = false;
        SquareFrameOfReference $this$drawDebugShapes_u24lambda_u2d1 = squareFrameOfReference;
        boolean bl4 = false;
        SvgRectElement rect3 = new SvgRectElement(geomBounds);
        rect3.fillColor().set((Object)Color.Companion.getPINK());
        rect3.strokeWidth().set((Object)1.0);
        rect3.fillOpacity().set((Object)0.5);
        parent.add((SvgNode)rect3);
    }

    @Override
    @NotNull
    public SvgComponent buildGeomComponent(@NotNull GeomLayer layer, @NotNull GeomTargetCollector targetCollector) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)targetCollector, (String)"targetCollector");
        Function1 hAxisMapper = this.hScale.getMapper();
        Function1 vAxisMapper = this.vScale.getMapper();
        AxisLayoutInfo axisLayoutInfo = this.layoutInfo.getXAxisInfo();
        Intrinsics.checkNotNull((Object)axisLayoutInfo);
        ClosedRange<Double> hAxisDomain = axisLayoutInfo.getAxisDomain();
        AxisLayoutInfo axisLayoutInfo2 = this.layoutInfo.getYAxisInfo();
        Intrinsics.checkNotNull((Object)axisLayoutInfo2);
        ClosedRange<Double> vAxisDomain = axisLayoutInfo2.getAxisDomain();
        Object object = hAxisMapper.invoke((Object)hAxisDomain.getLowerEnd());
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
        }
        Comparable comparable = (Double)object;
        object = hAxisMapper.invoke((Object)hAxisDomain.getUpperEnd());
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
        }
        ClosedRange closedRange = new ClosedRange(comparable, (Comparable)((Double)object));
        object = vAxisMapper.invoke((Object)vAxisDomain.getLowerEnd());
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
        }
        Comparable comparable2 = (Double)object;
        object = vAxisMapper.invoke((Object)vAxisDomain.getUpperEnd());
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
        }
        DoubleRectangle aesBounds = new DoubleRectangle(closedRange, new ClosedRange(comparable2, (Comparable)((Double)object)));
        return SquareFrameOfReference.Companion.buildGeom(layer, (Function1<? super Double, Double>)this.geomMapperX, (Function1<? super Double, Double>)this.geomMapperY, aesBounds, this.geomCoord, this.flipAxis, targetCollector);
    }

    @Override
    @NotNull
    public DoubleRectangle applyClientLimits(@NotNull DoubleRectangle clientBounds) {
        Intrinsics.checkNotNullParameter((Object)clientBounds, (String)"clientBounds");
        return this.geomCoord.applyClientLimits(clientBounds);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J^\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J`\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0016\u0010\u001a\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001b2\u0016\u0010\u001c\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002\u00a8\u0006'"}, d2={"Ljetbrains/datalore/plot/builder/SquareFrameOfReference$Companion;", "", "()V", "buildAxis", "Ljetbrains/datalore/plot/builder/guide/AxisComponent;", "scale", "Ljetbrains/datalore/plot/base/Scale;", "", "info", "Ljetbrains/datalore/plot/builder/layout/AxisLayoutInfo;", "hideAxis", "", "hideAxisBreaks", "hideGridlines", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "axisTheme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "gridTheme", "Ljetbrains/datalore/plot/builder/theme/PanelGridTheme;", "gridLineLength", "isDebugDrawing", "buildGeom", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "layer", "Ljetbrains/datalore/plot/builder/GeomLayer;", "xAesMapper", "Lkotlin/Function1;", "yAesMapper", "xyAesBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "flippedAxis", "targetCollector", "Ljetbrains/datalore/plot/base/interact/GeomTargetCollector;", "buildPanelComponent", "Ljetbrains/datalore/vis/svg/SvgRectElement;", "bounds", "theme", "Ljetbrains/datalore/plot/builder/theme/PanelTheme;", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final AxisComponent buildAxis(Scale<Double> scale, AxisLayoutInfo info, boolean hideAxis, boolean hideAxisBreaks, boolean hideGridlines, CoordinateSystem coord, AxisTheme axisTheme, PanelGridTheme gridTheme, double gridLineLength, boolean isDebugDrawing) {
            boolean bl = !hideAxis || !hideGridlines;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Trying to build an empty axis componenmt";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Orientation orientation = info.getOrientation();
            AxisComponent.TickLabelAdjustments labelAdjustments = new AxisComponent.TickLabelAdjustments(orientation, info.getTickLabelHorizontalAnchor(), info.getTickLabelVerticalAnchor(), info.getTickLabelRotationAngle(), info.getTickLabelAdditionalOffsets());
            AxisComponent axis = new AxisComponent(info.getAxisLength(), orientation, AxisUtil.INSTANCE.breaksData(scale, coord, orientation.isHorizontal()), labelAdjustments, gridLineLength, axisTheme, gridTheme, info.getTickLabelSmallFont(), hideAxis, hideAxisBreaks, hideGridlines);
            if (isDebugDrawing && info.getTickLabelsBounds() != null) {
                SvgRectElement rect2 = new SvgRectElement(info.getTickLabelsBounds());
                rect2.strokeColor().set((Object)Color.Companion.getGREEN());
                rect2.strokeWidth().set((Object)1.0);
                rect2.fillOpacity().set((Object)0.0);
                axis.add((SvgNode)rect2);
            }
            return axis;
        }

        private final SvgRectElement buildPanelComponent(DoubleRectangle bounds, PanelTheme theme) {
            SvgRectElement svgRectElement = new SvgRectElement(bounds);
            boolean bl = false;
            boolean bl2 = false;
            SvgRectElement $this$buildPanelComponent_u24lambda_u2d1 = svgRectElement;
            boolean bl3 = false;
            $this$buildPanelComponent_u24lambda_u2d1.strokeColor().set((Object)theme.rectColor());
            $this$buildPanelComponent_u24lambda_u2d1.strokeWidth().set((Object)theme.rectStrokeWidth());
            $this$buildPanelComponent_u24lambda_u2d1.fillColor().set((Object)theme.rectFill());
            return svgRectElement;
        }

        private final SvgComponent buildGeom(GeomLayer layer, Function1<? super Double, Double> xAesMapper, Function1<? super Double, Double> yAesMapper, DoubleRectangle xyAesBounds, CoordinateSystem coord, boolean flippedAxis, GeomTargetCollector targetCollector) {
            LayerRendererUtil.LayerRendererData rendererData = LayerRendererUtil.INSTANCE.createLayerRendererData(layer, xAesMapper, yAesMapper);
            Map<Aes<?>, Function1<Double, Object>> aestheticMappers = rendererData.getAestheticMappers();
            Aesthetics aesthetics = rendererData.getAesthetics();
            ImmutableGeomContext ctx = new GeomContextBuilder().flipped(flippedAxis).aesthetics(aesthetics).aestheticMappers(aestheticMappers).aesBounds(xyAesBounds).geomTargetCollector(flippedAxis ? targetCollector.flip() : targetCollector).build();
            PositionAdjustment pos = rendererData.getPos();
            Geom geom = layer.getGeom();
            return new SvgLayerRenderer(aesthetics, geom, pos, coord, ctx);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

