/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter;

import com.blazemeter.jmeter.RandomCSVDataSetConfig;
import com.blazemeter.jmeter.RandomCSVDataSetConfigGui;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextArea;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterStopThreadException;
import org.apache.log.Logger;

public class TestRandomCSVAction
implements ActionListener {
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    private static final int PREVIEW_MAX_SIZE = 20;
    private final RandomCSVDataSetConfigGui randomCSVConfigGui;

    public TestRandomCSVAction(RandomCSVDataSetConfigGui randomCSVConfigGui) {
        this.randomCSVConfigGui = randomCSVConfigGui;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        RandomCSVDataSetConfig config = (RandomCSVDataSetConfig)this.randomCSVConfigGui.createTestElement();
        config.setRewindOnTheEndOfList(false);
        config.setIndependentListPerThread(false);
        JTextArea checkArea = this.randomCSVConfigGui.getCheckArea();
        try {
            config.setFilename(this.compoundValue(config.getFilename()));
            config.setVariableNames(this.compoundValue(config.getVariableNames()));
            config.setFileEncoding(this.compoundValue(config.getFileEncoding()));
            config.setDelimiter(this.compoundValue(config.getDelimiter()));
            JMeterVariables jMeterVariables = new JMeterVariables();
            JMeterContextService.getContext().setVariables(jMeterVariables);
            ArrayList result = new ArrayList();
            config.trySetFinalFilename();
            config.testStarted();
            String[] destinationVariableKeys = config.getDestinationVariableKeys();
            try {
                for (int i = 0; i < 20; ++i) {
                    config.iterationStart(null);
                    HashMap<String, String> record = new HashMap<String, String>();
                    for (String var : destinationVariableKeys) {
                        record.put(var, jMeterVariables.get(var));
                    }
                    result.add(record);
                }
            }
            catch (JMeterStopThreadException i) {
                // empty catch block
            }
            config.testEnded();
            StringBuilder builder = new StringBuilder();
            builder.append("Reading CSV successfully finished, ").append(result.size()).append(" records found:\r\n");
            for (Map map : result) {
                for (String key : map.keySet()) {
                    builder.append("${").append(key).append("} = ");
                    builder.append((String)map.get(key));
                    builder.append("\r\n");
                }
                builder.append("------------\r\n");
            }
            checkArea.setText(builder.toString());
            checkArea.setCaretPosition(0);
        }
        catch (RuntimeException | InvalidVariableException ex) {
            checkArea.setText(ex.getMessage());
            LOGGER.warn("Failed to test CSV Reading ", ex);
        }
    }

    private String compoundValue(String val) throws InvalidVariableException {
        CompoundVariable compoundVariable = new CompoundVariable();
        compoundVariable.setParameters(val);
        return compoundVariable.execute();
    }
}

