import os

from cryptography.exceptions import InvalidKey

from .exceptions import (
    InvalidTokenException,
    NoPrivateKeyException,
    BadlyFormattedTokenException,
    TokenExpiredException,
    PathMismatchException,
    MethodMismatchException,
)
from .token import RocketToken

# set some variable to use as keys when operating in dev mode
os.environ[
    "RT_DEV_PRIVATE"
] = "-----BEGIN PRIVATE KEY-----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\nYLMsmPtXtrMMthdhJ/3/5OViAlp54A==\n-----END PRIVATE KEY-----\n"
os.environ[
    "RT_DEV_PUBLIC"
] = "-----BEGIN PUBLIC KEY-----\nMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEA27G8c38qWBcv2NXc0fzt\nLSJXwiYROjIZSp0cVsyX5EIECuh0Cr6BLnOL5TJ3eq3r9Us3o2LgBPmKHZWQ1/SL\nlSHDux8OOEHXeovfmj93sE3mjzbu5iZyj+J+GHF0GA3Q4P7vocnD1+rdKdwjcV+e\n6jw41Lrb/7tOezasUDBV8UlYzazj6hSQQd18gcKBGj6xls+tNIKQD4/Y97MxBRr4\n35DCgQUbmupj4PmgXJ7RyPiSbikuoCKR862yF5VwoQNdzg9Zir2glezDjfXz9n8v\nS+4xZTe2jmLoSEHuffQNi8QvVeDWU6WB12uPf9HJLf7xmJbDttnDRHUHc0ljc99S\ncusXiof0BAR94G+ltxGtizYO5Ycxr3U3RGNxqAAxPcd61M3qFlqXGsktcHsiNdKA\n2tMNN6s2w/0b7jICPrGBdi1Fh8pDueYrinnAzUQoDeJ0QIBzl7cDa5+qbeRg0278\nqvOSvn+KDD8FXeVS/02EqwbK3M1pC1iPa4V2FLaZqVONJ88DOp9zA8NNl3zCT2Zm\nrgnBsIhiUkjOGPJl6h2ku4VJxq82b34fFbwRuH2Ud8HVVhW6rHOU9PiI8zmTX0pv\ndhjv4PR+p3C+kTJrbgtcR/t4GKXtggslPhfKUBn+xwQA2E8ktDt0pSv0rSeFIGP3\n/yYEX5GkMIw1magjqtNm/X8CAwEAAQ==\n-----END PUBLIC KEY-----\n"

__all__ = [
    RocketToken,
    InvalidTokenException,
    NoPrivateKeyException,
    InvalidKey,
    BadlyFormattedTokenException,
    TokenExpiredException,
    PathMismatchException,
    MethodMismatchException,
]
