# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: meta.proto
# plugin: python-betterproto
from dataclasses import dataclass
from datetime import datetime, timedelta
from typing import Dict, List

import betterproto
from betterproto.grpc.grpclib_server import ServiceBase


@dataclass(eq=False, repr=False)
class ChainMeta(betterproto.Message):
    """Metadata associated with an MCMC chain."""

    # Unique identifier of the MCMC run this chain belongs to.
    rid: str = betterproto.string_field(1)
    # Number of the chain inside the MCMC run.
    chain_number: int = betterproto.int32_field(2)


@dataclass(eq=False, repr=False)
class Variable(betterproto.Message):
    """Description of a model variable."""

    # Name of the variable.
    name: str = betterproto.string_field(1)
    # Data type (lowercase).
    dtype: str = betterproto.string_field(2)
    # The shape tuple. May contain 0es for dynamically sized dimensions. The
    # default value, an empty sequence, corresponds to scalar shape. Note that
    # for variables of dynamic dimensionality, ``undefined_ndim=True`` can be set
    # to render ``shape`` and ``dims`` meaningless.
    shape: List[int] = betterproto.uint64_field(3)
    # Names of the variable's dimensions. The default value, an empty sequence,
    # corresponds to undefined dimension names and applies to scalar variables,
    # and variables where ``undefined_ndim=True``.
    dims: List[str] = betterproto.string_field(4)
    # Could this variable be computed deterministically from other variables?
    is_deterministic: bool = betterproto.bool_field(5)
    # Set to ``True`` when the dimensionality of this variable is undefined,
    # rendering ``shape`` meaningless.
    undefined_ndim: bool = betterproto.bool_field(6)


@dataclass(eq=False, repr=False)
class Coordinate(betterproto.Message):
    """A named array that labels a dimension."""

    # Name of the dimension these labels belong to.
    name: str = betterproto.string_field(1)
    # Coordinate values.
    values: "npproto.Ndarray" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class DataVariable(betterproto.Message):
    """Constant or observed data in the model."""

    # Name of the data variable.
    name: str = betterproto.string_field(1)
    # The array containing the data.
    value: "npproto.Ndarray" = betterproto.message_field(2)
    # Names of the dimensions.
    dims: List[str] = betterproto.string_field(3)
    # Is the posterior conditional on this data?
    is_observed: bool = betterproto.bool_field(4)


@dataclass(eq=False, repr=False)
class ExtendedValue(betterproto.Message):
    """Like google.protobuf.Value, but with support for additional types."""

    # Represents a null value.
    null_value: "betterproto_lib_google_protobuf.NullValue" = betterproto.enum_field(
        1, group="kind"
    )
    # Represents a double value.
    number_value: float = betterproto.double_field(2, group="kind")
    # Represents a string value.
    string_value: str = betterproto.string_field(3, group="kind")
    # Represents a boolean value.
    bool_value: bool = betterproto.bool_field(4, group="kind")
    # Represents a structured value.
    struct_value: "betterproto_lib_google_protobuf.Struct" = betterproto.message_field(
        5, group="kind"
    )
    # Represents a repeated `Value`.
    list_value: "betterproto_lib_google_protobuf.ListValue" = betterproto.message_field(
        6, group="kind"
    )
    # Represents a timestamp value.
    timestamp_value: datetime = betterproto.message_field(7, group="kind")
    # Represents a duration value.
    duration_value: timedelta = betterproto.message_field(8, group="kind")
    # Represents a NumPy array value.
    ndarray_value: "npproto.Ndarray" = betterproto.message_field(9, group="kind")


@dataclass(eq=False, repr=False)
class RunMeta(betterproto.Message):
    """Metadata associated with an MCMC run."""

    # Unique identifier of the MCMC run.
    rid: str = betterproto.string_field(1)
    # Metadata of model variables.
    variables: List["Variable"] = betterproto.message_field(3)
    # Named arrays to label dimensions.
    coordinates: List["Coordinate"] = betterproto.message_field(4)
    # Arbitrary metadata
    attributes: Dict[str, "ExtendedValue"] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    # Diagnostic variables produced by MCMC sampling algorithms.
    sample_stats: List["Variable"] = betterproto.message_field(6)
    # Constant or observed data in the model.
    data: List["DataVariable"] = betterproto.message_field(7)


import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf

from . import npproto
