# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class FormProperty(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'type': 'str',
        'value': 'str',
        'writable': 'bool',
        'required': 'bool',
        'enum_values': 'list[DropdownValue]',
        'check_buttons': 'list[OptionValue]',
        'radio_buttons': 'list[OptionValue]',
        'default_dropdown_values': 'list[DropdownValue]',
        'proposed_dropdown_values': 'list[DropdownValue]',
        'date_time_type': 'str',
        'multi_value': 'bool',
        'proposed_fixed': 'bool',
        'default_from_resource': 'bool',
        'multi_default_dropdown_values': 'dict(str, list[DropdownValue])',
        'multi_proposed_dropdown_values': 'dict(str, list[DropdownValue])',
        'asset_type': 'ResourceReference',
        'community_ids': 'list[str]',
        'domain_ids': 'list[str]',
        'status_ids': 'list[str]'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'type': 'type',
        'value': 'value',
        'writable': 'writable',
        'required': 'required',
        'enum_values': 'enumValues',
        'check_buttons': 'checkButtons',
        'radio_buttons': 'radioButtons',
        'default_dropdown_values': 'defaultDropdownValues',
        'proposed_dropdown_values': 'proposedDropdownValues',
        'date_time_type': 'dateTimeType',
        'multi_value': 'multiValue',
        'proposed_fixed': 'proposedFixed',
        'default_from_resource': 'defaultFromResource',
        'multi_default_dropdown_values': 'multiDefaultDropdownValues',
        'multi_proposed_dropdown_values': 'multiProposedDropdownValues',
        'asset_type': 'assetType',
        'community_ids': 'communityIds',
        'domain_ids': 'domainIds',
        'status_ids': 'statusIds'
    }

    def __init__(self, id=None, name=None, type=None, value=None, writable=None, required=None, enum_values=None, check_buttons=None, radio_buttons=None, default_dropdown_values=None, proposed_dropdown_values=None, date_time_type=None, multi_value=None, proposed_fixed=None, default_from_resource=None, multi_default_dropdown_values=None, multi_proposed_dropdown_values=None, asset_type=None, community_ids=None, domain_ids=None, status_ids=None, local_vars_configuration=None):  # noqa: E501
        """FormProperty - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._type = None
        self._value = None
        self._writable = None
        self._required = None
        self._enum_values = None
        self._check_buttons = None
        self._radio_buttons = None
        self._default_dropdown_values = None
        self._proposed_dropdown_values = None
        self._date_time_type = None
        self._multi_value = None
        self._proposed_fixed = None
        self._default_from_resource = None
        self._multi_default_dropdown_values = None
        self._multi_proposed_dropdown_values = None
        self._asset_type = None
        self._community_ids = None
        self._domain_ids = None
        self._status_ids = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if type is not None:
            self.type = type
        if value is not None:
            self.value = value
        if writable is not None:
            self.writable = writable
        if required is not None:
            self.required = required
        if enum_values is not None:
            self.enum_values = enum_values
        if check_buttons is not None:
            self.check_buttons = check_buttons
        if radio_buttons is not None:
            self.radio_buttons = radio_buttons
        if default_dropdown_values is not None:
            self.default_dropdown_values = default_dropdown_values
        if proposed_dropdown_values is not None:
            self.proposed_dropdown_values = proposed_dropdown_values
        if date_time_type is not None:
            self.date_time_type = date_time_type
        if multi_value is not None:
            self.multi_value = multi_value
        if proposed_fixed is not None:
            self.proposed_fixed = proposed_fixed
        if default_from_resource is not None:
            self.default_from_resource = default_from_resource
        if multi_default_dropdown_values is not None:
            self.multi_default_dropdown_values = multi_default_dropdown_values
        if multi_proposed_dropdown_values is not None:
            self.multi_proposed_dropdown_values = multi_proposed_dropdown_values
        if asset_type is not None:
            self.asset_type = asset_type
        if community_ids is not None:
            self.community_ids = community_ids
        if domain_ids is not None:
            self.domain_ids = domain_ids
        if status_ids is not None:
            self.status_ids = status_ids

    @property
    def id(self):
        """Gets the id of this FormProperty.  # noqa: E501

        The id of the property.  # noqa: E501

        :return: The id of this FormProperty.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this FormProperty.

        The id of the property.  # noqa: E501

        :param id: The id of this FormProperty.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this FormProperty.  # noqa: E501

        The name of the property.  # noqa: E501

        :return: The name of this FormProperty.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this FormProperty.

        The name of the property.  # noqa: E501

        :param name: The name of this FormProperty.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def type(self):
        """Gets the type of this FormProperty.  # noqa: E501

        The property type.  # noqa: E501

        :return: The type of this FormProperty.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this FormProperty.

        The property type.  # noqa: E501

        :param type: The type of this FormProperty.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def value(self):
        """Gets the value of this FormProperty.  # noqa: E501

        The property (default) value.  # noqa: E501

        :return: The value of this FormProperty.  # noqa: E501
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """Sets the value of this FormProperty.

        The property (default) value.  # noqa: E501

        :param value: The value of this FormProperty.  # noqa: E501
        :type: str
        """

        self._value = value

    @property
    def writable(self):
        """Gets the writable of this FormProperty.  # noqa: E501

        Whether the property is writable.  # noqa: E501

        :return: The writable of this FormProperty.  # noqa: E501
        :rtype: bool
        """
        return self._writable

    @writable.setter
    def writable(self, writable):
        """Sets the writable of this FormProperty.

        Whether the property is writable.  # noqa: E501

        :param writable: The writable of this FormProperty.  # noqa: E501
        :type: bool
        """

        self._writable = writable

    @property
    def required(self):
        """Gets the required of this FormProperty.  # noqa: E501

        Whether the property is required.  # noqa: E501

        :return: The required of this FormProperty.  # noqa: E501
        :rtype: bool
        """
        return self._required

    @required.setter
    def required(self, required):
        """Sets the required of this FormProperty.

        Whether the property is required.  # noqa: E501

        :param required: The required of this FormProperty.  # noqa: E501
        :type: bool
        """

        self._required = required

    @property
    def enum_values(self):
        """Gets the enum_values of this FormProperty.  # noqa: E501

        The property's enum values.  # noqa: E501

        :return: The enum_values of this FormProperty.  # noqa: E501
        :rtype: list[DropdownValue]
        """
        return self._enum_values

    @enum_values.setter
    def enum_values(self, enum_values):
        """Sets the enum_values of this FormProperty.

        The property's enum values.  # noqa: E501

        :param enum_values: The enum_values of this FormProperty.  # noqa: E501
        :type: list[DropdownValue]
        """

        self._enum_values = enum_values

    @property
    def check_buttons(self):
        """Gets the check_buttons of this FormProperty.  # noqa: E501

        The property's checkbox buttons.  # noqa: E501

        :return: The check_buttons of this FormProperty.  # noqa: E501
        :rtype: list[OptionValue]
        """
        return self._check_buttons

    @check_buttons.setter
    def check_buttons(self, check_buttons):
        """Sets the check_buttons of this FormProperty.

        The property's checkbox buttons.  # noqa: E501

        :param check_buttons: The check_buttons of this FormProperty.  # noqa: E501
        :type: list[OptionValue]
        """

        self._check_buttons = check_buttons

    @property
    def radio_buttons(self):
        """Gets the radio_buttons of this FormProperty.  # noqa: E501

        The property's radio buttons.  # noqa: E501

        :return: The radio_buttons of this FormProperty.  # noqa: E501
        :rtype: list[OptionValue]
        """
        return self._radio_buttons

    @radio_buttons.setter
    def radio_buttons(self, radio_buttons):
        """Sets the radio_buttons of this FormProperty.

        The property's radio buttons.  # noqa: E501

        :param radio_buttons: The radio_buttons of this FormProperty.  # noqa: E501
        :type: list[OptionValue]
        """

        self._radio_buttons = radio_buttons

    @property
    def default_dropdown_values(self):
        """Gets the default_dropdown_values of this FormProperty.  # noqa: E501

        The property's default dropdown values.  # noqa: E501

        :return: The default_dropdown_values of this FormProperty.  # noqa: E501
        :rtype: list[DropdownValue]
        """
        return self._default_dropdown_values

    @default_dropdown_values.setter
    def default_dropdown_values(self, default_dropdown_values):
        """Sets the default_dropdown_values of this FormProperty.

        The property's default dropdown values.  # noqa: E501

        :param default_dropdown_values: The default_dropdown_values of this FormProperty.  # noqa: E501
        :type: list[DropdownValue]
        """

        self._default_dropdown_values = default_dropdown_values

    @property
    def proposed_dropdown_values(self):
        """Gets the proposed_dropdown_values of this FormProperty.  # noqa: E501

        The property's proposed dropdown values.  # noqa: E501

        :return: The proposed_dropdown_values of this FormProperty.  # noqa: E501
        :rtype: list[DropdownValue]
        """
        return self._proposed_dropdown_values

    @proposed_dropdown_values.setter
    def proposed_dropdown_values(self, proposed_dropdown_values):
        """Sets the proposed_dropdown_values of this FormProperty.

        The property's proposed dropdown values.  # noqa: E501

        :param proposed_dropdown_values: The proposed_dropdown_values of this FormProperty.  # noqa: E501
        :type: list[DropdownValue]
        """

        self._proposed_dropdown_values = proposed_dropdown_values

    @property
    def date_time_type(self):
        """Gets the date_time_type of this FormProperty.  # noqa: E501

        The datetime type in case the property is of type datetime.  # noqa: E501

        :return: The date_time_type of this FormProperty.  # noqa: E501
        :rtype: str
        """
        return self._date_time_type

    @date_time_type.setter
    def date_time_type(self, date_time_type):
        """Sets the date_time_type of this FormProperty.

        The datetime type in case the property is of type datetime.  # noqa: E501

        :param date_time_type: The date_time_type of this FormProperty.  # noqa: E501
        :type: str
        """

        self._date_time_type = date_time_type

    @property
    def multi_value(self):
        """Gets the multi_value of this FormProperty.  # noqa: E501

        Whether the property allows multiple values.  # noqa: E501

        :return: The multi_value of this FormProperty.  # noqa: E501
        :rtype: bool
        """
        return self._multi_value

    @multi_value.setter
    def multi_value(self, multi_value):
        """Sets the multi_value of this FormProperty.

        Whether the property allows multiple values.  # noqa: E501

        :param multi_value: The multi_value of this FormProperty.  # noqa: E501
        :type: bool
        """

        self._multi_value = multi_value

    @property
    def proposed_fixed(self):
        """Gets the proposed_fixed of this FormProperty.  # noqa: E501

        Whether the property's proposed values are the only set of allowed values to select.  # noqa: E501

        :return: The proposed_fixed of this FormProperty.  # noqa: E501
        :rtype: bool
        """
        return self._proposed_fixed

    @proposed_fixed.setter
    def proposed_fixed(self, proposed_fixed):
        """Sets the proposed_fixed of this FormProperty.

        Whether the property's proposed values are the only set of allowed values to select.  # noqa: E501

        :param proposed_fixed: The proposed_fixed of this FormProperty.  # noqa: E501
        :type: bool
        """

        self._proposed_fixed = proposed_fixed

    @property
    def default_from_resource(self):
        """Gets the default_from_resource of this FormProperty.  # noqa: E501

        Whether the property's default value is the current resource.  # noqa: E501

        :return: The default_from_resource of this FormProperty.  # noqa: E501
        :rtype: bool
        """
        return self._default_from_resource

    @default_from_resource.setter
    def default_from_resource(self, default_from_resource):
        """Sets the default_from_resource of this FormProperty.

        Whether the property's default value is the current resource.  # noqa: E501

        :param default_from_resource: The default_from_resource of this FormProperty.  # noqa: E501
        :type: bool
        """

        self._default_from_resource = default_from_resource

    @property
    def multi_default_dropdown_values(self):
        """Gets the multi_default_dropdown_values of this FormProperty.  # noqa: E501

        The multi default dropdown values.  # noqa: E501

        :return: The multi_default_dropdown_values of this FormProperty.  # noqa: E501
        :rtype: dict(str, list[DropdownValue])
        """
        return self._multi_default_dropdown_values

    @multi_default_dropdown_values.setter
    def multi_default_dropdown_values(self, multi_default_dropdown_values):
        """Sets the multi_default_dropdown_values of this FormProperty.

        The multi default dropdown values.  # noqa: E501

        :param multi_default_dropdown_values: The multi_default_dropdown_values of this FormProperty.  # noqa: E501
        :type: dict(str, list[DropdownValue])
        """

        self._multi_default_dropdown_values = multi_default_dropdown_values

    @property
    def multi_proposed_dropdown_values(self):
        """Gets the multi_proposed_dropdown_values of this FormProperty.  # noqa: E501

        The multi proposed dropdown values.  # noqa: E501

        :return: The multi_proposed_dropdown_values of this FormProperty.  # noqa: E501
        :rtype: dict(str, list[DropdownValue])
        """
        return self._multi_proposed_dropdown_values

    @multi_proposed_dropdown_values.setter
    def multi_proposed_dropdown_values(self, multi_proposed_dropdown_values):
        """Sets the multi_proposed_dropdown_values of this FormProperty.

        The multi proposed dropdown values.  # noqa: E501

        :param multi_proposed_dropdown_values: The multi_proposed_dropdown_values of this FormProperty.  # noqa: E501
        :type: dict(str, list[DropdownValue])
        """

        self._multi_proposed_dropdown_values = multi_proposed_dropdown_values

    @property
    def asset_type(self):
        """Gets the asset_type of this FormProperty.  # noqa: E501


        :return: The asset_type of this FormProperty.  # noqa: E501
        :rtype: ResourceReference
        """
        return self._asset_type

    @asset_type.setter
    def asset_type(self, asset_type):
        """Sets the asset_type of this FormProperty.


        :param asset_type: The asset_type of this FormProperty.  # noqa: E501
        :type: ResourceReference
        """

        self._asset_type = asset_type

    @property
    def community_ids(self):
        """Gets the community_ids of this FormProperty.  # noqa: E501

        Community ids.  # noqa: E501

        :return: The community_ids of this FormProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._community_ids

    @community_ids.setter
    def community_ids(self, community_ids):
        """Sets the community_ids of this FormProperty.

        Community ids.  # noqa: E501

        :param community_ids: The community_ids of this FormProperty.  # noqa: E501
        :type: list[str]
        """

        self._community_ids = community_ids

    @property
    def domain_ids(self):
        """Gets the domain_ids of this FormProperty.  # noqa: E501

        Domain ids.  # noqa: E501

        :return: The domain_ids of this FormProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._domain_ids

    @domain_ids.setter
    def domain_ids(self, domain_ids):
        """Sets the domain_ids of this FormProperty.

        Domain ids.  # noqa: E501

        :param domain_ids: The domain_ids of this FormProperty.  # noqa: E501
        :type: list[str]
        """

        self._domain_ids = domain_ids

    @property
    def status_ids(self):
        """Gets the status_ids of this FormProperty.  # noqa: E501

        Status ids.  # noqa: E501

        :return: The status_ids of this FormProperty.  # noqa: E501
        :rtype: list[str]
        """
        return self._status_ids

    @status_ids.setter
    def status_ids(self, status_ids):
        """Sets the status_ids of this FormProperty.

        Status ids.  # noqa: E501

        :param status_ids: The status_ids of this FormProperty.  # noqa: E501
        :type: list[str]
        """

        self._status_ids = status_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, FormProperty):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, FormProperty):
            return True

        return self.to_dict() != other.to_dict()
