# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class ComplexRelationLegTypeRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'min': 'int',
        'max': 'int',
        'role': 'str',
        'co_role': 'str',
        'asset_type_id': 'str',
        'id': 'str',
        'relation_type_id': 'str'
    }

    attribute_map = {
        'min': 'min',
        'max': 'max',
        'role': 'role',
        'co_role': 'coRole',
        'asset_type_id': 'assetTypeId',
        'id': 'id',
        'relation_type_id': 'relationTypeId'
    }

    def __init__(self, min=None, max=None, role=None, co_role=None, asset_type_id=None, id=None, relation_type_id=None, local_vars_configuration=None):  # noqa: E501
        """ComplexRelationLegTypeRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._min = None
        self._max = None
        self._role = None
        self._co_role = None
        self._asset_type_id = None
        self._id = None
        self._relation_type_id = None
        self.discriminator = None

        if min is not None:
            self.min = min
        if max is not None:
            self.max = max
        self.role = role
        if co_role is not None:
            self.co_role = co_role
        self.asset_type_id = asset_type_id
        if id is not None:
            self.id = id
        if relation_type_id is not None:
            self.relation_type_id = relation_type_id

    @property
    def min(self):
        """Gets the min of this ComplexRelationLegTypeRequest.  # noqa: E501

        The minimum number of Leg Type occurrences.  # noqa: E501

        :return: The min of this ComplexRelationLegTypeRequest.  # noqa: E501
        :rtype: int
        """
        return self._min

    @min.setter
    def min(self, min):
        """Sets the min of this ComplexRelationLegTypeRequest.

        The minimum number of Leg Type occurrences.  # noqa: E501

        :param min: The min of this ComplexRelationLegTypeRequest.  # noqa: E501
        :type: int
        """

        self._min = min

    @property
    def max(self):
        """Gets the max of this ComplexRelationLegTypeRequest.  # noqa: E501

        The maximum number of Leg Type occurrences.  # noqa: E501

        :return: The max of this ComplexRelationLegTypeRequest.  # noqa: E501
        :rtype: int
        """
        return self._max

    @max.setter
    def max(self, max):
        """Sets the max of this ComplexRelationLegTypeRequest.

        The maximum number of Leg Type occurrences.  # noqa: E501

        :param max: The max of this ComplexRelationLegTypeRequest.  # noqa: E501
        :type: int
        """

        self._max = max

    @property
    def role(self):
        """Gets the role of this ComplexRelationLegTypeRequest.  # noqa: E501

        The name of the role that the source plays.  # noqa: E501

        :return: The role of this ComplexRelationLegTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this ComplexRelationLegTypeRequest.

        The name of the role that the source plays.  # noqa: E501

        :param role: The role of this ComplexRelationLegTypeRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and role is None:  # noqa: E501
            raise ValueError("Invalid value for `role`, must not be `None`")  # noqa: E501

        self._role = role

    @property
    def co_role(self):
        """Gets the co_role of this ComplexRelationLegTypeRequest.  # noqa: E501

        The name of the role that the target plays.  # noqa: E501

        :return: The co_role of this ComplexRelationLegTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._co_role

    @co_role.setter
    def co_role(self, co_role):
        """Sets the co_role of this ComplexRelationLegTypeRequest.

        The name of the role that the target plays.  # noqa: E501

        :param co_role: The co_role of this ComplexRelationLegTypeRequest.  # noqa: E501
        :type: str
        """

        self._co_role = co_role

    @property
    def asset_type_id(self):
        """Gets the asset_type_id of this ComplexRelationLegTypeRequest.  # noqa: E501

        The ID of the Asset Type of the Relation.<br/>In the next major release, this parameter will only be valid when adding a new leg to the ComplexRelationType. Changing the Asset Type of an existing leg won't be allowed and will result in an error.  # noqa: E501

        :return: The asset_type_id of this ComplexRelationLegTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._asset_type_id

    @asset_type_id.setter
    def asset_type_id(self, asset_type_id):
        """Sets the asset_type_id of this ComplexRelationLegTypeRequest.

        The ID of the Asset Type of the Relation.<br/>In the next major release, this parameter will only be valid when adding a new leg to the ComplexRelationType. Changing the Asset Type of an existing leg won't be allowed and will result in an error.  # noqa: E501

        :param asset_type_id: The asset_type_id of this ComplexRelationLegTypeRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and asset_type_id is None:  # noqa: E501
            raise ValueError("Invalid value for `asset_type_id`, must not be `None`")  # noqa: E501

        self._asset_type_id = asset_type_id

    @property
    def id(self):
        """Gets the id of this ComplexRelationLegTypeRequest.  # noqa: E501

        The id of the Complex Relation Leg Type. The Leg Type will be created with this id or updated.<br/>If left empty on update the Leg Type will be recreated.  # noqa: E501

        :return: The id of this ComplexRelationLegTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ComplexRelationLegTypeRequest.

        The id of the Complex Relation Leg Type. The Leg Type will be created with this id or updated.<br/>If left empty on update the Leg Type will be recreated.  # noqa: E501

        :param id: The id of this ComplexRelationLegTypeRequest.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def relation_type_id(self):
        """Gets the relation_type_id of this ComplexRelationLegTypeRequest.  # noqa: E501

        The id of Relation Type of the Leg Type.  # noqa: E501

        :return: The relation_type_id of this ComplexRelationLegTypeRequest.  # noqa: E501
        :rtype: str
        """
        return self._relation_type_id

    @relation_type_id.setter
    def relation_type_id(self, relation_type_id):
        """Sets the relation_type_id of this ComplexRelationLegTypeRequest.

        The id of Relation Type of the Leg Type.  # noqa: E501

        :param relation_type_id: The relation_type_id of this ComplexRelationLegTypeRequest.  # noqa: E501
        :type: str
        """

        self._relation_type_id = relation_type_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ComplexRelationLegTypeRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ComplexRelationLegTypeRequest):
            return True

        return self.to_dict() != other.to_dict()
