# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class ChangeCommunityRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'parent_id': 'str',
        'name': 'str',
        'description': 'str',
        'remove_scope_overlap_on_move': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'parent_id': 'parentId',
        'name': 'name',
        'description': 'description',
        'remove_scope_overlap_on_move': 'removeScopeOverlapOnMove'
    }

    def __init__(self, id=None, parent_id=None, name=None, description=None, remove_scope_overlap_on_move=None, local_vars_configuration=None):  # noqa: E501
        """ChangeCommunityRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._parent_id = None
        self._name = None
        self._description = None
        self._remove_scope_overlap_on_move = None
        self.discriminator = None

        self.id = id
        if parent_id is not None:
            self.parent_id = parent_id
        if name is not None:
            self.name = name
        if description is not None:
            self.description = description
        if remove_scope_overlap_on_move is not None:
            self.remove_scope_overlap_on_move = remove_scope_overlap_on_move

    @property
    def id(self):
        """Gets the id of this ChangeCommunityRequest.  # noqa: E501

        The ID of the community to be changed. Silently ignored if the ID is provided as path parameter of the request.  # noqa: E501

        :return: The id of this ChangeCommunityRequest.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ChangeCommunityRequest.

        The ID of the community to be changed. Silently ignored if the ID is provided as path parameter of the request.  # noqa: E501

        :param id: The id of this ChangeCommunityRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def parent_id(self):
        """Gets the parent_id of this ChangeCommunityRequest.  # noqa: E501

        The ID of the new parent community for the community.  # noqa: E501

        :return: The parent_id of this ChangeCommunityRequest.  # noqa: E501
        :rtype: str
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """Sets the parent_id of this ChangeCommunityRequest.

        The ID of the new parent community for the community.  # noqa: E501

        :param parent_id: The parent_id of this ChangeCommunityRequest.  # noqa: E501
        :type: str
        """

        self._parent_id = parent_id

    @property
    def name(self):
        """Gets the name of this ChangeCommunityRequest.  # noqa: E501

        The new name for the community.  # noqa: E501

        :return: The name of this ChangeCommunityRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ChangeCommunityRequest.

        The new name for the community.  # noqa: E501

        :param name: The name of this ChangeCommunityRequest.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 255):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this ChangeCommunityRequest.  # noqa: E501

        The new description for the community.  # noqa: E501

        :return: The description of this ChangeCommunityRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ChangeCommunityRequest.

        The new description for the community.  # noqa: E501

        :param description: The description of this ChangeCommunityRequest.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def remove_scope_overlap_on_move(self):
        """Gets the remove_scope_overlap_on_move of this ChangeCommunityRequest.  # noqa: E501

        Whether scopes assigned to domain community and its children should be removed on move if there are any inherited scopes in new parent community  # noqa: E501

        :return: The remove_scope_overlap_on_move of this ChangeCommunityRequest.  # noqa: E501
        :rtype: bool
        """
        return self._remove_scope_overlap_on_move

    @remove_scope_overlap_on_move.setter
    def remove_scope_overlap_on_move(self, remove_scope_overlap_on_move):
        """Sets the remove_scope_overlap_on_move of this ChangeCommunityRequest.

        Whether scopes assigned to domain community and its children should be removed on move if there are any inherited scopes in new parent community  # noqa: E501

        :param remove_scope_overlap_on_move: The remove_scope_overlap_on_move of this ChangeCommunityRequest.  # noqa: E501
        :type: bool
        """

        self._remove_scope_overlap_on_move = remove_scope_overlap_on_move

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ChangeCommunityRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ChangeCommunityRequest):
            return True

        return self.to_dict() != other.to_dict()
