# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class AssignmentImpl(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'created_by': 'str',
        'created_on': 'int',
        'last_modified_by': 'str',
        'last_modified_on': 'int',
        'system': 'bool',
        'resource_type': 'str',
        'asset_type': 'NamedResourceReferenceImpl',
        'statuses': 'list[NamedDescribedResourceReference]',
        'default_status_id': 'str',
        'characteristic_types': 'list[AssignedCharacteristicType]',
        'articulation_rules': 'list[ArticulationRuleImpl]',
        'validation_rules': 'list[NamedResourceReferenceImpl]',
        'data_quality_rules': 'list[NamedDescribedResourceReference]',
        'domain_types': 'list[NamedDescribedResourceReference]',
        'scope': 'ScopeImpl'
    }

    attribute_map = {
        'id': 'id',
        'created_by': 'createdBy',
        'created_on': 'createdOn',
        'last_modified_by': 'lastModifiedBy',
        'last_modified_on': 'lastModifiedOn',
        'system': 'system',
        'resource_type': 'resourceType',
        'asset_type': 'assetType',
        'statuses': 'statuses',
        'default_status_id': 'defaultStatusId',
        'characteristic_types': 'characteristicTypes',
        'articulation_rules': 'articulationRules',
        'validation_rules': 'validationRules',
        'data_quality_rules': 'dataQualityRules',
        'domain_types': 'domainTypes',
        'scope': 'scope'
    }

    def __init__(self, id=None, created_by=None, created_on=None, last_modified_by=None, last_modified_on=None, system=None, resource_type=None, asset_type=None, statuses=None, default_status_id=None, characteristic_types=None, articulation_rules=None, validation_rules=None, data_quality_rules=None, domain_types=None, scope=None, local_vars_configuration=None):  # noqa: E501
        """AssignmentImpl - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._created_by = None
        self._created_on = None
        self._last_modified_by = None
        self._last_modified_on = None
        self._system = None
        self._resource_type = None
        self._asset_type = None
        self._statuses = None
        self._default_status_id = None
        self._characteristic_types = None
        self._articulation_rules = None
        self._validation_rules = None
        self._data_quality_rules = None
        self._domain_types = None
        self._scope = None
        self.discriminator = None

        self.id = id
        if created_by is not None:
            self.created_by = created_by
        if created_on is not None:
            self.created_on = created_on
        if last_modified_by is not None:
            self.last_modified_by = last_modified_by
        if last_modified_on is not None:
            self.last_modified_on = last_modified_on
        if system is not None:
            self.system = system
        self.resource_type = resource_type
        if asset_type is not None:
            self.asset_type = asset_type
        if statuses is not None:
            self.statuses = statuses
        if default_status_id is not None:
            self.default_status_id = default_status_id
        if characteristic_types is not None:
            self.characteristic_types = characteristic_types
        if articulation_rules is not None:
            self.articulation_rules = articulation_rules
        if validation_rules is not None:
            self.validation_rules = validation_rules
        if data_quality_rules is not None:
            self.data_quality_rules = data_quality_rules
        if domain_types is not None:
            self.domain_types = domain_types
        if scope is not None:
            self.scope = scope

    @property
    def id(self):
        """Gets the id of this AssignmentImpl.  # noqa: E501

        The id of the represented object (entity).  # noqa: E501

        :return: The id of this AssignmentImpl.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AssignmentImpl.

        The id of the represented object (entity).  # noqa: E501

        :param id: The id of this AssignmentImpl.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def created_by(self):
        """Gets the created_by of this AssignmentImpl.  # noqa: E501

        The id of the user that created this resource.  # noqa: E501

        :return: The created_by of this AssignmentImpl.  # noqa: E501
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """Sets the created_by of this AssignmentImpl.

        The id of the user that created this resource.  # noqa: E501

        :param created_by: The created_by of this AssignmentImpl.  # noqa: E501
        :type: str
        """

        self._created_by = created_by

    @property
    def created_on(self):
        """Gets the created_on of this AssignmentImpl.  # noqa: E501

        The timestamp (in UTC time standard) of the creation of this resource.  # noqa: E501

        :return: The created_on of this AssignmentImpl.  # noqa: E501
        :rtype: int
        """
        return self._created_on

    @created_on.setter
    def created_on(self, created_on):
        """Sets the created_on of this AssignmentImpl.

        The timestamp (in UTC time standard) of the creation of this resource.  # noqa: E501

        :param created_on: The created_on of this AssignmentImpl.  # noqa: E501
        :type: int
        """

        self._created_on = created_on

    @property
    def last_modified_by(self):
        """Gets the last_modified_by of this AssignmentImpl.  # noqa: E501

        The id of the user who modified this resource the last time.  # noqa: E501

        :return: The last_modified_by of this AssignmentImpl.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_by

    @last_modified_by.setter
    def last_modified_by(self, last_modified_by):
        """Sets the last_modified_by of this AssignmentImpl.

        The id of the user who modified this resource the last time.  # noqa: E501

        :param last_modified_by: The last_modified_by of this AssignmentImpl.  # noqa: E501
        :type: str
        """

        self._last_modified_by = last_modified_by

    @property
    def last_modified_on(self):
        """Gets the last_modified_on of this AssignmentImpl.  # noqa: E501

        The timestamp (in UTC time standard) of the last modification of this resource.  # noqa: E501

        :return: The last_modified_on of this AssignmentImpl.  # noqa: E501
        :rtype: int
        """
        return self._last_modified_on

    @last_modified_on.setter
    def last_modified_on(self, last_modified_on):
        """Sets the last_modified_on of this AssignmentImpl.

        The timestamp (in UTC time standard) of the last modification of this resource.  # noqa: E501

        :param last_modified_on: The last_modified_on of this AssignmentImpl.  # noqa: E501
        :type: int
        """

        self._last_modified_on = last_modified_on

    @property
    def system(self):
        """Gets the system of this AssignmentImpl.  # noqa: E501

        Whether this is a system resource or not.  # noqa: E501

        :return: The system of this AssignmentImpl.  # noqa: E501
        :rtype: bool
        """
        return self._system

    @system.setter
    def system(self, system):
        """Sets the system of this AssignmentImpl.

        Whether this is a system resource or not.  # noqa: E501

        :param system: The system of this AssignmentImpl.  # noqa: E501
        :type: bool
        """

        self._system = system

    @property
    def resource_type(self):
        """Gets the resource_type of this AssignmentImpl.  # noqa: E501

        The type of this resource, i.e. [Community, Asset, Domain, Attribute, Relation, WorkflowInstance].  # noqa: E501

        :return: The resource_type of this AssignmentImpl.  # noqa: E501
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """Sets the resource_type of this AssignmentImpl.

        The type of this resource, i.e. [Community, Asset, Domain, Attribute, Relation, WorkflowInstance].  # noqa: E501

        :param resource_type: The resource_type of this AssignmentImpl.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and resource_type is None:  # noqa: E501
            raise ValueError("Invalid value for `resource_type`, must not be `None`")  # noqa: E501
        allowed_values = ["View", "Asset", "Community", "Domain", "AssetType", "DomainType", "Status", "User", "ClassificationMatch", "UserGroup", "Attribute", "StringAttribute", "ScriptAttribute", "BooleanAttribute", "DateAttribute", "NumericAttribute", "SingleValueListAttribute", "MultiValueListAttribute", "Comment", "Attachment", "Responsibility", "Workflow", "Job", "Relation", "RelationType", "ComplexRelation", "ComplexRelationType", "ArticulationRule", "Assignment", "Scope", "RelationTrace", "ValidationRule", "DataQualityRule", "DataQualityMetric", "Address", "InstantMessagingAccount", "Email", "PhoneNumber", "Website", "Activity", "FormProperty", "WorkflowTask", "ActivityChange", "WorkflowInstance", "Role", "AttributeType", "BooleanAttributeType", "DateAttributeType", "DateTimeAttributeType", "MultiValueListAttributeType", "NumericAttributeType", "ScriptAttributeType", "SingleValueListAttributeType", "StringAttributeType", "ViewSharingRule", "ViewAssignmentRule", "JdbcDriverFile", "JdbcDriver", "JdbcIngestionProperties", "CsvIngestionProperties", "ExcelIngestionProperties", "ConnectionStringParameter", "AssignedCharacteristicType", "Notification", "Tag", "ComplexRelationLegType", "ComplexRelationAttributeType", "ComplexRelationLeg", "BaseDataType", "AdvancedDataType", "DiagramPicture", "DiagramPictureSharingRule", "DiagramPictureAssignmentRule", "Rating", "Classification", "PhysicalDataConnector", "Context"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and resource_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `resource_type` ({0}), must be one of {1}"  # noqa: E501
                .format(resource_type, allowed_values)
            )

        self._resource_type = resource_type

    @property
    def asset_type(self):
        """Gets the asset_type of this AssignmentImpl.  # noqa: E501


        :return: The asset_type of this AssignmentImpl.  # noqa: E501
        :rtype: NamedResourceReferenceImpl
        """
        return self._asset_type

    @asset_type.setter
    def asset_type(self, asset_type):
        """Sets the asset_type of this AssignmentImpl.


        :param asset_type: The asset_type of this AssignmentImpl.  # noqa: E501
        :type: NamedResourceReferenceImpl
        """

        self._asset_type = asset_type

    @property
    def statuses(self):
        """Gets the statuses of this AssignmentImpl.  # noqa: E501

        The list of references to the statuses.  # noqa: E501

        :return: The statuses of this AssignmentImpl.  # noqa: E501
        :rtype: list[NamedDescribedResourceReference]
        """
        return self._statuses

    @statuses.setter
    def statuses(self, statuses):
        """Sets the statuses of this AssignmentImpl.

        The list of references to the statuses.  # noqa: E501

        :param statuses: The statuses of this AssignmentImpl.  # noqa: E501
        :type: list[NamedDescribedResourceReference]
        """

        self._statuses = statuses

    @property
    def default_status_id(self):
        """Gets the default_status_id of this AssignmentImpl.  # noqa: E501

        The ID of the default status.  # noqa: E501

        :return: The default_status_id of this AssignmentImpl.  # noqa: E501
        :rtype: str
        """
        return self._default_status_id

    @default_status_id.setter
    def default_status_id(self, default_status_id):
        """Sets the default_status_id of this AssignmentImpl.

        The ID of the default status.  # noqa: E501

        :param default_status_id: The default_status_id of this AssignmentImpl.  # noqa: E501
        :type: str
        """

        self._default_status_id = default_status_id

    @property
    def characteristic_types(self):
        """Gets the characteristic_types of this AssignmentImpl.  # noqa: E501

        The list of assigned characteristic types such as attribute types, relation types and complex relation types. Depending on the actual type, a characteristic type may contain additional properties. For additional details, refer to the schemas of AssignedAttributeType, AssignedComplexRelationType and AssignedRelationType.  # noqa: E501

        :return: The characteristic_types of this AssignmentImpl.  # noqa: E501
        :rtype: list[AssignedCharacteristicType]
        """
        return self._characteristic_types

    @characteristic_types.setter
    def characteristic_types(self, characteristic_types):
        """Sets the characteristic_types of this AssignmentImpl.

        The list of assigned characteristic types such as attribute types, relation types and complex relation types. Depending on the actual type, a characteristic type may contain additional properties. For additional details, refer to the schemas of AssignedAttributeType, AssignedComplexRelationType and AssignedRelationType.  # noqa: E501

        :param characteristic_types: The characteristic_types of this AssignmentImpl.  # noqa: E501
        :type: list[AssignedCharacteristicType]
        """

        self._characteristic_types = characteristic_types

    @property
    def articulation_rules(self):
        """Gets the articulation_rules of this AssignmentImpl.  # noqa: E501

        The list of articulation rules applying with the assignment.  # noqa: E501

        :return: The articulation_rules of this AssignmentImpl.  # noqa: E501
        :rtype: list[ArticulationRuleImpl]
        """
        return self._articulation_rules

    @articulation_rules.setter
    def articulation_rules(self, articulation_rules):
        """Sets the articulation_rules of this AssignmentImpl.

        The list of articulation rules applying with the assignment.  # noqa: E501

        :param articulation_rules: The articulation_rules of this AssignmentImpl.  # noqa: E501
        :type: list[ArticulationRuleImpl]
        """

        self._articulation_rules = articulation_rules

    @property
    def validation_rules(self):
        """Gets the validation_rules of this AssignmentImpl.  # noqa: E501

        The list of references to validation rules applying with the assignment.  # noqa: E501

        :return: The validation_rules of this AssignmentImpl.  # noqa: E501
        :rtype: list[NamedResourceReferenceImpl]
        """
        return self._validation_rules

    @validation_rules.setter
    def validation_rules(self, validation_rules):
        """Sets the validation_rules of this AssignmentImpl.

        The list of references to validation rules applying with the assignment.  # noqa: E501

        :param validation_rules: The validation_rules of this AssignmentImpl.  # noqa: E501
        :type: list[NamedResourceReferenceImpl]
        """

        self._validation_rules = validation_rules

    @property
    def data_quality_rules(self):
        """Gets the data_quality_rules of this AssignmentImpl.  # noqa: E501

        The list of references to data quality rules applying with the assignment.  # noqa: E501

        :return: The data_quality_rules of this AssignmentImpl.  # noqa: E501
        :rtype: list[NamedDescribedResourceReference]
        """
        return self._data_quality_rules

    @data_quality_rules.setter
    def data_quality_rules(self, data_quality_rules):
        """Sets the data_quality_rules of this AssignmentImpl.

        The list of references to data quality rules applying with the assignment.  # noqa: E501

        :param data_quality_rules: The data_quality_rules of this AssignmentImpl.  # noqa: E501
        :type: list[NamedDescribedResourceReference]
        """

        self._data_quality_rules = data_quality_rules

    @property
    def domain_types(self):
        """Gets the domain_types of this AssignmentImpl.  # noqa: E501

        The list of references to domain types which the assignment refers to.  # noqa: E501

        :return: The domain_types of this AssignmentImpl.  # noqa: E501
        :rtype: list[NamedDescribedResourceReference]
        """
        return self._domain_types

    @domain_types.setter
    def domain_types(self, domain_types):
        """Sets the domain_types of this AssignmentImpl.

        The list of references to domain types which the assignment refers to.  # noqa: E501

        :param domain_types: The domain_types of this AssignmentImpl.  # noqa: E501
        :type: list[NamedDescribedResourceReference]
        """

        self._domain_types = domain_types

    @property
    def scope(self):
        """Gets the scope of this AssignmentImpl.  # noqa: E501


        :return: The scope of this AssignmentImpl.  # noqa: E501
        :rtype: ScopeImpl
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """Sets the scope of this AssignmentImpl.


        :param scope: The scope of this AssignmentImpl.  # noqa: E501
        :type: ScopeImpl
        """

        self._scope = scope

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AssignmentImpl):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AssignmentImpl):
            return True

        return self.to_dict() != other.to_dict()
