# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class AddRelationRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'source_id': 'str',
        'target_id': 'str',
        'type_id': 'str',
        'starting_date': 'int',
        'ending_date': 'int'
    }

    attribute_map = {
        'source_id': 'sourceId',
        'target_id': 'targetId',
        'type_id': 'typeId',
        'starting_date': 'startingDate',
        'ending_date': 'endingDate'
    }

    def __init__(self, source_id=None, target_id=None, type_id=None, starting_date=None, ending_date=None, local_vars_configuration=None):  # noqa: E501
        """AddRelationRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._source_id = None
        self._target_id = None
        self._type_id = None
        self._starting_date = None
        self._ending_date = None
        self.discriminator = None

        self.source_id = source_id
        self.target_id = target_id
        self.type_id = type_id
        if starting_date is not None:
            self.starting_date = starting_date
        if ending_date is not None:
            self.ending_date = ending_date

    @property
    def source_id(self):
        """Gets the source_id of this AddRelationRequest.  # noqa: E501

        The ID of the source of the relation.  # noqa: E501

        :return: The source_id of this AddRelationRequest.  # noqa: E501
        :rtype: str
        """
        return self._source_id

    @source_id.setter
    def source_id(self, source_id):
        """Sets the source_id of this AddRelationRequest.

        The ID of the source of the relation.  # noqa: E501

        :param source_id: The source_id of this AddRelationRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and source_id is None:  # noqa: E501
            raise ValueError("Invalid value for `source_id`, must not be `None`")  # noqa: E501

        self._source_id = source_id

    @property
    def target_id(self):
        """Gets the target_id of this AddRelationRequest.  # noqa: E501

        The ID of the target of the relation.  # noqa: E501

        :return: The target_id of this AddRelationRequest.  # noqa: E501
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """Sets the target_id of this AddRelationRequest.

        The ID of the target of the relation.  # noqa: E501

        :param target_id: The target_id of this AddRelationRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and target_id is None:  # noqa: E501
            raise ValueError("Invalid value for `target_id`, must not be `None`")  # noqa: E501

        self._target_id = target_id

    @property
    def type_id(self):
        """Gets the type_id of this AddRelationRequest.  # noqa: E501

        The ID of the type of the relation.  # noqa: E501

        :return: The type_id of this AddRelationRequest.  # noqa: E501
        :rtype: str
        """
        return self._type_id

    @type_id.setter
    def type_id(self, type_id):
        """Sets the type_id of this AddRelationRequest.

        The ID of the type of the relation.  # noqa: E501

        :param type_id: The type_id of this AddRelationRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and type_id is None:  # noqa: E501
            raise ValueError("Invalid value for `type_id`, must not be `None`")  # noqa: E501

        self._type_id = type_id

    @property
    def starting_date(self):
        """Gets the starting_date of this AddRelationRequest.  # noqa: E501

        The starting date of the relation.  # noqa: E501

        :return: The starting_date of this AddRelationRequest.  # noqa: E501
        :rtype: int
        """
        return self._starting_date

    @starting_date.setter
    def starting_date(self, starting_date):
        """Sets the starting_date of this AddRelationRequest.

        The starting date of the relation.  # noqa: E501

        :param starting_date: The starting_date of this AddRelationRequest.  # noqa: E501
        :type: int
        """

        self._starting_date = starting_date

    @property
    def ending_date(self):
        """Gets the ending_date of this AddRelationRequest.  # noqa: E501

        The ending date of the relation.  # noqa: E501

        :return: The ending_date of this AddRelationRequest.  # noqa: E501
        :rtype: int
        """
        return self._ending_date

    @ending_date.setter
    def ending_date(self, ending_date):
        """Sets the ending_date of this AddRelationRequest.

        The ending date of the relation.  # noqa: E501

        :param ending_date: The ending_date of this AddRelationRequest.  # noqa: E501
        :type: int
        """

        self._ending_date = ending_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddRelationRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddRelationRequest):
            return True

        return self.to_dict() != other.to_dict()
