# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class AddIssueRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'responsible_community_id': 'str',
        'name': 'str',
        'type_id': 'str',
        'description': 'str',
        'priority': 'str',
        'requester_id': 'str',
        'related_assets': 'list[RelatedAssetReference]',
        'category_ids': 'list[str]'
    }

    attribute_map = {
        'responsible_community_id': 'responsibleCommunityId',
        'name': 'name',
        'type_id': 'typeId',
        'description': 'description',
        'priority': 'priority',
        'requester_id': 'requesterId',
        'related_assets': 'relatedAssets',
        'category_ids': 'categoryIds'
    }

    def __init__(self, responsible_community_id=None, name=None, type_id=None, description=None, priority=None, requester_id=None, related_assets=None, category_ids=None, local_vars_configuration=None):  # noqa: E501
        """AddIssueRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._responsible_community_id = None
        self._name = None
        self._type_id = None
        self._description = None
        self._priority = None
        self._requester_id = None
        self._related_assets = None
        self._category_ids = None
        self.discriminator = None

        if responsible_community_id is not None:
            self.responsible_community_id = responsible_community_id
        self.name = name
        self.type_id = type_id
        self.description = description
        if priority is not None:
            self.priority = priority
        if requester_id is not None:
            self.requester_id = requester_id
        if related_assets is not None:
            self.related_assets = related_assets
        if category_ids is not None:
            self.category_ids = category_ids

    @property
    def responsible_community_id(self):
        """Gets the responsible_community_id of this AddIssueRequest.  # noqa: E501

        The ID of the community responsible for handling the issue.  # noqa: E501

        :return: The responsible_community_id of this AddIssueRequest.  # noqa: E501
        :rtype: str
        """
        return self._responsible_community_id

    @responsible_community_id.setter
    def responsible_community_id(self, responsible_community_id):
        """Sets the responsible_community_id of this AddIssueRequest.

        The ID of the community responsible for handling the issue.  # noqa: E501

        :param responsible_community_id: The responsible_community_id of this AddIssueRequest.  # noqa: E501
        :type: str
        """

        self._responsible_community_id = responsible_community_id

    @property
    def name(self):
        """Gets the name of this AddIssueRequest.  # noqa: E501

        The name of the subject for which the issue is being created.  # noqa: E501

        :return: The name of this AddIssueRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AddIssueRequest.

        The name of the subject for which the issue is being created.  # noqa: E501

        :param name: The name of this AddIssueRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def type_id(self):
        """Gets the type_id of this AddIssueRequest.  # noqa: E501

        The type ID of the issue to be created.  # noqa: E501

        :return: The type_id of this AddIssueRequest.  # noqa: E501
        :rtype: str
        """
        return self._type_id

    @type_id.setter
    def type_id(self, type_id):
        """Sets the type_id of this AddIssueRequest.

        The type ID of the issue to be created.  # noqa: E501

        :param type_id: The type_id of this AddIssueRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and type_id is None:  # noqa: E501
            raise ValueError("Invalid value for `type_id`, must not be `None`")  # noqa: E501

        self._type_id = type_id

    @property
    def description(self):
        """Gets the description of this AddIssueRequest.  # noqa: E501

        The description for the issue.  # noqa: E501

        :return: The description of this AddIssueRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AddIssueRequest.

        The description for the issue.  # noqa: E501

        :param description: The description of this AddIssueRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def priority(self):
        """Gets the priority of this AddIssueRequest.  # noqa: E501

        The priority for the issue.  # noqa: E501

        :return: The priority of this AddIssueRequest.  # noqa: E501
        :rtype: str
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this AddIssueRequest.

        The priority for the issue.  # noqa: E501

        :param priority: The priority of this AddIssueRequest.  # noqa: E501
        :type: str
        """

        self._priority = priority

    @property
    def requester_id(self):
        """Gets the requester_id of this AddIssueRequest.  # noqa: E501

        The requester of the issue.  # noqa: E501

        :return: The requester_id of this AddIssueRequest.  # noqa: E501
        :rtype: str
        """
        return self._requester_id

    @requester_id.setter
    def requester_id(self, requester_id):
        """Sets the requester_id of this AddIssueRequest.

        The requester of the issue.  # noqa: E501

        :param requester_id: The requester_id of this AddIssueRequest.  # noqa: E501
        :type: str
        """

        self._requester_id = requester_id

    @property
    def related_assets(self):
        """Gets the related_assets of this AddIssueRequest.  # noqa: E501

        The list of assets which the issue is related to.  # noqa: E501

        :return: The related_assets of this AddIssueRequest.  # noqa: E501
        :rtype: list[RelatedAssetReference]
        """
        return self._related_assets

    @related_assets.setter
    def related_assets(self, related_assets):
        """Sets the related_assets of this AddIssueRequest.

        The list of assets which the issue is related to.  # noqa: E501

        :param related_assets: The related_assets of this AddIssueRequest.  # noqa: E501
        :type: list[RelatedAssetReference]
        """

        self._related_assets = related_assets

    @property
    def category_ids(self):
        """Gets the category_ids of this AddIssueRequest.  # noqa: E501

        The list of IDs of assets which represent categories for this issue. Each asset in this list should be of type Issue Category.  # noqa: E501

        :return: The category_ids of this AddIssueRequest.  # noqa: E501
        :rtype: list[str]
        """
        return self._category_ids

    @category_ids.setter
    def category_ids(self, category_ids):
        """Sets the category_ids of this AddIssueRequest.

        The list of IDs of assets which represent categories for this issue. Each asset in this list should be of type Issue Category.  # noqa: E501

        :param category_ids: The category_ids of this AddIssueRequest.  # noqa: E501
        :type: list[str]
        """

        self._category_ids = category_ids

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddIssueRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddIssueRequest):
            return True

        return self.to_dict() != other.to_dict()
