# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class AddDataQualityRuleRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'categorization_relation_type_id': 'str',
        'data_quality_metrics': 'list[DataQualityMetricRequest]',
        'relation_trace_entries': 'list[RelationTraceEntryRequest]'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'categorization_relation_type_id': 'categorizationRelationTypeId',
        'data_quality_metrics': 'dataQualityMetrics',
        'relation_trace_entries': 'relationTraceEntries'
    }

    def __init__(self, id=None, name=None, description=None, categorization_relation_type_id=None, data_quality_metrics=None, relation_trace_entries=None, local_vars_configuration=None):  # noqa: E501
        """AddDataQualityRuleRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._description = None
        self._categorization_relation_type_id = None
        self._data_quality_metrics = None
        self._relation_trace_entries = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.name = name
        if description is not None:
            self.description = description
        self.categorization_relation_type_id = categorization_relation_type_id
        if data_quality_metrics is not None:
            self.data_quality_metrics = data_quality_metrics
        self.relation_trace_entries = relation_trace_entries

    @property
    def id(self):
        """Gets the id of this AddDataQualityRuleRequest.  # noqa: E501

        The ID of the new Data Quality Rule. Should be unique within all data quality rules.<br/>It should have a format of universally unique identifier (UUID) and should not start with<br/><code>00000000-0000-0000-</code> which is a reserved prefix.  # noqa: E501

        :return: The id of this AddDataQualityRuleRequest.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AddDataQualityRuleRequest.

        The ID of the new Data Quality Rule. Should be unique within all data quality rules.<br/>It should have a format of universally unique identifier (UUID) and should not start with<br/><code>00000000-0000-0000-</code> which is a reserved prefix.  # noqa: E501

        :param id: The id of this AddDataQualityRuleRequest.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this AddDataQualityRuleRequest.  # noqa: E501

        The name of the new data quality rule. Should be unique within all data quality rules.  # noqa: E501

        :return: The name of this AddDataQualityRuleRequest.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this AddDataQualityRuleRequest.

        The name of the new data quality rule. Should be unique within all data quality rules.  # noqa: E501

        :param name: The name of this AddDataQualityRuleRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 255):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this AddDataQualityRuleRequest.  # noqa: E501

        The description of the new data quality rule.  # noqa: E501

        :return: The description of this AddDataQualityRuleRequest.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this AddDataQualityRuleRequest.

        The description of the new data quality rule.  # noqa: E501

        :param description: The description of this AddDataQualityRuleRequest.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) > 255):
            raise ValueError("Invalid value for `description`, length must be less than or equal to `255`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                description is not None and len(description) < 0):
            raise ValueError("Invalid value for `description`, length must be greater than or equal to `0`")  # noqa: E501

        self._description = description

    @property
    def categorization_relation_type_id(self):
        """Gets the categorization_relation_type_id of this AddDataQualityRuleRequest.  # noqa: E501

        The ID of the categorization relation type.  # noqa: E501

        :return: The categorization_relation_type_id of this AddDataQualityRuleRequest.  # noqa: E501
        :rtype: str
        """
        return self._categorization_relation_type_id

    @categorization_relation_type_id.setter
    def categorization_relation_type_id(self, categorization_relation_type_id):
        """Sets the categorization_relation_type_id of this AddDataQualityRuleRequest.

        The ID of the categorization relation type.  # noqa: E501

        :param categorization_relation_type_id: The categorization_relation_type_id of this AddDataQualityRuleRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and categorization_relation_type_id is None:  # noqa: E501
            raise ValueError("Invalid value for `categorization_relation_type_id`, must not be `None`")  # noqa: E501

        self._categorization_relation_type_id = categorization_relation_type_id

    @property
    def data_quality_metrics(self):
        """Gets the data_quality_metrics of this AddDataQualityRuleRequest.  # noqa: E501

        The Data Quality Metrics that should be assigned to the rule that is going to be created.  # noqa: E501

        :return: The data_quality_metrics of this AddDataQualityRuleRequest.  # noqa: E501
        :rtype: list[DataQualityMetricRequest]
        """
        return self._data_quality_metrics

    @data_quality_metrics.setter
    def data_quality_metrics(self, data_quality_metrics):
        """Sets the data_quality_metrics of this AddDataQualityRuleRequest.

        The Data Quality Metrics that should be assigned to the rule that is going to be created.  # noqa: E501

        :param data_quality_metrics: The data_quality_metrics of this AddDataQualityRuleRequest.  # noqa: E501
        :type: list[DataQualityMetricRequest]
        """

        self._data_quality_metrics = data_quality_metrics

    @property
    def relation_trace_entries(self):
        """Gets the relation_trace_entries of this AddDataQualityRuleRequest.  # noqa: E501

        The list of entries that describes relations along which the data quality result is calculated.  # noqa: E501

        :return: The relation_trace_entries of this AddDataQualityRuleRequest.  # noqa: E501
        :rtype: list[RelationTraceEntryRequest]
        """
        return self._relation_trace_entries

    @relation_trace_entries.setter
    def relation_trace_entries(self, relation_trace_entries):
        """Sets the relation_trace_entries of this AddDataQualityRuleRequest.

        The list of entries that describes relations along which the data quality result is calculated.  # noqa: E501

        :param relation_trace_entries: The relation_trace_entries of this AddDataQualityRuleRequest.  # noqa: E501
        :type: list[RelationTraceEntryRequest]
        """
        if self.local_vars_configuration.client_side_validation and relation_trace_entries is None:  # noqa: E501
            raise ValueError("Invalid value for `relation_trace_entries`, must not be `None`")  # noqa: E501

        self._relation_trace_entries = relation_trace_entries

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddDataQualityRuleRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddDataQualityRuleRequest):
            return True

        return self.to_dict() != other.to_dict()
