# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class AddComplexRelationRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'complex_relation_type_id': 'str',
        'legs': 'list[ComplexRelationLegRequest]',
        'attributes': 'dict(str, list[AttributeValue])'
    }

    attribute_map = {
        'id': 'id',
        'complex_relation_type_id': 'complexRelationTypeId',
        'legs': 'legs',
        'attributes': 'attributes'
    }

    def __init__(self, id=None, complex_relation_type_id=None, legs=None, attributes=None, local_vars_configuration=None):  # noqa: E501
        """AddComplexRelationRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._complex_relation_type_id = None
        self._legs = None
        self._attributes = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.complex_relation_type_id = complex_relation_type_id
        if legs is not None:
            self.legs = legs
        if attributes is not None:
            self.attributes = attributes

    @property
    def id(self):
        """Gets the id of this AddComplexRelationRequest.  # noqa: E501

        The ID of the new complex relation. Should be unique within all complex relations and assets.<br/>It should have a format of universally unique identifier (UUID) and should not start with <code>00000000-0000-0000-</code> which is a reserved prefix.  # noqa: E501

        :return: The id of this AddComplexRelationRequest.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this AddComplexRelationRequest.

        The ID of the new complex relation. Should be unique within all complex relations and assets.<br/>It should have a format of universally unique identifier (UUID) and should not start with <code>00000000-0000-0000-</code> which is a reserved prefix.  # noqa: E501

        :param id: The id of this AddComplexRelationRequest.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def complex_relation_type_id(self):
        """Gets the complex_relation_type_id of this AddComplexRelationRequest.  # noqa: E501

        The ID of the type of the complex relation.  # noqa: E501

        :return: The complex_relation_type_id of this AddComplexRelationRequest.  # noqa: E501
        :rtype: str
        """
        return self._complex_relation_type_id

    @complex_relation_type_id.setter
    def complex_relation_type_id(self, complex_relation_type_id):
        """Sets the complex_relation_type_id of this AddComplexRelationRequest.

        The ID of the type of the complex relation.  # noqa: E501

        :param complex_relation_type_id: The complex_relation_type_id of this AddComplexRelationRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and complex_relation_type_id is None:  # noqa: E501
            raise ValueError("Invalid value for `complex_relation_type_id`, must not be `None`")  # noqa: E501

        self._complex_relation_type_id = complex_relation_type_id

    @property
    def legs(self):
        """Gets the legs of this AddComplexRelationRequest.  # noqa: E501

         The list of legs that the new complex relation should contain.  # noqa: E501

        :return: The legs of this AddComplexRelationRequest.  # noqa: E501
        :rtype: list[ComplexRelationLegRequest]
        """
        return self._legs

    @legs.setter
    def legs(self, legs):
        """Sets the legs of this AddComplexRelationRequest.

         The list of legs that the new complex relation should contain.  # noqa: E501

        :param legs: The legs of this AddComplexRelationRequest.  # noqa: E501
        :type: list[ComplexRelationLegRequest]
        """

        self._legs = legs

    @property
    def attributes(self):
        """Gets the attributes of this AddComplexRelationRequest.  # noqa: E501

        The attributes that the new complex relation should contain.<br/><u>Example:</u><br/>attributes : {<br/>&emsp;\"00000000-0000-0000-0000-000000003114\": [<br/>&emsp;&emsp;{<br/>&emsp;&emsp;&emsp;\"value\": \"string1\"<br/>&emsp;&emsp;}<br/>&emsp;]<br/>&emsp;\"00000000-0000-0000-0000-000000003115\": [<br/>&emsp;&emsp;{<br/>&emsp;&emsp;&emsp;\"values\": [<br/>&emsp;&emsp;&emsp;&emsp;\"string2\",<br/>&emsp;&emsp;&emsp;&emsp;\"string3\"<br/>&emsp;&emsp;&emsp;]<br/>&emsp;&emsp;}<br/>&emsp;]<br/>}  # noqa: E501

        :return: The attributes of this AddComplexRelationRequest.  # noqa: E501
        :rtype: dict(str, list[AttributeValue])
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """Sets the attributes of this AddComplexRelationRequest.

        The attributes that the new complex relation should contain.<br/><u>Example:</u><br/>attributes : {<br/>&emsp;\"00000000-0000-0000-0000-000000003114\": [<br/>&emsp;&emsp;{<br/>&emsp;&emsp;&emsp;\"value\": \"string1\"<br/>&emsp;&emsp;}<br/>&emsp;]<br/>&emsp;\"00000000-0000-0000-0000-000000003115\": [<br/>&emsp;&emsp;{<br/>&emsp;&emsp;&emsp;\"values\": [<br/>&emsp;&emsp;&emsp;&emsp;\"string2\",<br/>&emsp;&emsp;&emsp;&emsp;\"string3\"<br/>&emsp;&emsp;&emsp;]<br/>&emsp;&emsp;}<br/>&emsp;]<br/>}  # noqa: E501

        :param attributes: The attributes of this AddComplexRelationRequest.  # noqa: E501
        :type: dict(str, list[AttributeValue])
        """

        self._attributes = attributes

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddComplexRelationRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddComplexRelationRequest):
            return True

        return self.to_dict() != other.to_dict()
