# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from collibra_core.configuration import Configuration


class AddCommentRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'content': 'str',
        'base_resource': 'ResourceReference',
        'parent_id': 'str',
        'base_resource_id': 'str',
        'base_resource_type': 'str'
    }

    attribute_map = {
        'content': 'content',
        'base_resource': 'baseResource',
        'parent_id': 'parentId',
        'base_resource_id': 'baseResourceId',
        'base_resource_type': 'baseResourceType'
    }

    def __init__(self, content=None, base_resource=None, parent_id=None, base_resource_id=None, base_resource_type=None, local_vars_configuration=None):  # noqa: E501
        """AddCommentRequest - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._content = None
        self._base_resource = None
        self._parent_id = None
        self._base_resource_id = None
        self._base_resource_type = None
        self.discriminator = None

        self.content = content
        self.base_resource = base_resource
        if parent_id is not None:
            self.parent_id = parent_id
        if base_resource_id is not None:
            self.base_resource_id = base_resource_id
        if base_resource_type is not None:
            self.base_resource_type = base_resource_type

    @property
    def content(self):
        """Gets the content of this AddCommentRequest.  # noqa: E501

        The actual HTML content of the comment to be added. Can contain user mentions using syntax [@User:$userId] where $userId is the ID of mentioned user.For example: [@User:00000000-0000-0000-0000-000000900002].  # noqa: E501

        :return: The content of this AddCommentRequest.  # noqa: E501
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """Sets the content of this AddCommentRequest.

        The actual HTML content of the comment to be added. Can contain user mentions using syntax [@User:$userId] where $userId is the ID of mentioned user.For example: [@User:00000000-0000-0000-0000-000000900002].  # noqa: E501

        :param content: The content of this AddCommentRequest.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and content is None:  # noqa: E501
            raise ValueError("Invalid value for `content`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                content is not None and len(content) > 2147483647):
            raise ValueError("Invalid value for `content`, length must be less than or equal to `2147483647`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                content is not None and len(content) < 1):
            raise ValueError("Invalid value for `content`, length must be greater than or equal to `1`")  # noqa: E501

        self._content = content

    @property
    def base_resource(self):
        """Gets the base_resource of this AddCommentRequest.  # noqa: E501


        :return: The base_resource of this AddCommentRequest.  # noqa: E501
        :rtype: ResourceReference
        """
        return self._base_resource

    @base_resource.setter
    def base_resource(self, base_resource):
        """Sets the base_resource of this AddCommentRequest.


        :param base_resource: The base_resource of this AddCommentRequest.  # noqa: E501
        :type: ResourceReference
        """
        if self.local_vars_configuration.client_side_validation and base_resource is None:  # noqa: E501
            raise ValueError("Invalid value for `base_resource`, must not be `None`")  # noqa: E501

        self._base_resource = base_resource

    @property
    def parent_id(self):
        """Gets the parent_id of this AddCommentRequest.  # noqa: E501

        The ID of the parent comment. If not null - the comment is the reply for the parent comment.  # noqa: E501

        :return: The parent_id of this AddCommentRequest.  # noqa: E501
        :rtype: str
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """Sets the parent_id of this AddCommentRequest.

        The ID of the parent comment. If not null - the comment is the reply for the parent comment.  # noqa: E501

        :param parent_id: The parent_id of this AddCommentRequest.  # noqa: E501
        :type: str
        """

        self._parent_id = parent_id

    @property
    def base_resource_id(self):
        """Gets the base_resource_id of this AddCommentRequest.  # noqa: E501


        :return: The base_resource_id of this AddCommentRequest.  # noqa: E501
        :rtype: str
        """
        return self._base_resource_id

    @base_resource_id.setter
    def base_resource_id(self, base_resource_id):
        """Sets the base_resource_id of this AddCommentRequest.


        :param base_resource_id: The base_resource_id of this AddCommentRequest.  # noqa: E501
        :type: str
        """

        self._base_resource_id = base_resource_id

    @property
    def base_resource_type(self):
        """Gets the base_resource_type of this AddCommentRequest.  # noqa: E501


        :return: The base_resource_type of this AddCommentRequest.  # noqa: E501
        :rtype: str
        """
        return self._base_resource_type

    @base_resource_type.setter
    def base_resource_type(self, base_resource_type):
        """Sets the base_resource_type of this AddCommentRequest.


        :param base_resource_type: The base_resource_type of this AddCommentRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["View", "Asset", "Community", "Domain", "AssetType", "DomainType", "Status", "User", "ClassificationMatch", "UserGroup", "Attribute", "StringAttribute", "ScriptAttribute", "BooleanAttribute", "DateAttribute", "NumericAttribute", "SingleValueListAttribute", "MultiValueListAttribute", "Comment", "Attachment", "Responsibility", "Workflow", "Job", "Relation", "RelationType", "ComplexRelation", "ComplexRelationType", "ArticulationRule", "Assignment", "Scope", "RelationTrace", "ValidationRule", "DataQualityRule", "DataQualityMetric", "Address", "InstantMessagingAccount", "Email", "PhoneNumber", "Website", "Activity", "FormProperty", "WorkflowTask", "ActivityChange", "WorkflowInstance", "Role", "AttributeType", "BooleanAttributeType", "DateAttributeType", "DateTimeAttributeType", "MultiValueListAttributeType", "NumericAttributeType", "ScriptAttributeType", "SingleValueListAttributeType", "StringAttributeType", "ViewSharingRule", "ViewAssignmentRule", "JdbcDriverFile", "JdbcDriver", "JdbcIngestionProperties", "CsvIngestionProperties", "ExcelIngestionProperties", "ConnectionStringParameter", "AssignedCharacteristicType", "Notification", "Tag", "ComplexRelationLegType", "ComplexRelationAttributeType", "ComplexRelationLeg", "BaseDataType", "AdvancedDataType", "DiagramPicture", "DiagramPictureSharingRule", "DiagramPictureAssignmentRule", "Rating", "Classification", "PhysicalDataConnector", "Context"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and base_resource_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `base_resource_type` ({0}), must be one of {1}"  # noqa: E501
                .format(base_resource_type, allowed_values)
            )

        self._base_resource_type = base_resource_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AddCommentRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AddCommentRequest):
            return True

        return self.to_dict() != other.to_dict()
