# coding: utf-8

"""
    Collibra Data Governance Center Core API

    <p>The Core REST API allows you to create your own integrations with Collibra Data Governance Center.</p><p><i>Create custom applications to help users get access to the right data.</i></p>  # noqa: E501

    The version of the OpenAPI document: 2.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from collibra_core.api_client import ApiClient
from collibra_core.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WorkflowTasksApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cancel_workflow_task(self, workflow_task_id, **kwargs):  # noqa: E501
        """Cancel workflow task.  # noqa: E501

        Cancels the workflow task with the specified ID with a reason. If the given workflow is a subprocess, this method makes sure everything is cancelled from the root process instance. If the given task is not found, this method will assume it already was cancelled without throwing any error.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_workflow_task(workflow_task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_task_id: The ID of the workflow task. (required)
        :param str body: The reason for the cancellation of the workflow task.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.cancel_workflow_task_with_http_info(workflow_task_id, **kwargs)  # noqa: E501

    def cancel_workflow_task_with_http_info(self, workflow_task_id, **kwargs):  # noqa: E501
        """Cancel workflow task.  # noqa: E501

        Cancels the workflow task with the specified ID with a reason. If the given workflow is a subprocess, this method makes sure everything is cancelled from the root process instance. If the given task is not found, this method will assume it already was cancelled without throwing any error.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cancel_workflow_task_with_http_info(workflow_task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_task_id: The ID of the workflow task. (required)
        :param str body: The reason for the cancellation of the workflow task.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_task_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_workflow_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_task_id' is set
        if self.api_client.client_side_validation and ('workflow_task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_task_id` when calling `cancel_workflow_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_task_id' in local_var_params:
            path_params['workflowTaskId'] = local_var_params['workflow_task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowTasks/{workflowTaskId}/canceled', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def complete_workflow_tasks(self, **kwargs):  # noqa: E501
        """Complete workflow tasks.  # noqa: E501

        Completes tasks based on the provided request and returns the following tasks, if the same user is assigned to them.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_workflow_tasks(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CompleteWorkflowTasksRequest complete_workflow_tasks_request: Request to complete the workflow tasks.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[WorkflowTask]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.complete_workflow_tasks_with_http_info(**kwargs)  # noqa: E501

    def complete_workflow_tasks_with_http_info(self, **kwargs):  # noqa: E501
        """Complete workflow tasks.  # noqa: E501

        Completes tasks based on the provided request and returns the following tasks, if the same user is assigned to them.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.complete_workflow_tasks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CompleteWorkflowTasksRequest complete_workflow_tasks_request: Request to complete the workflow tasks.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[WorkflowTask], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'complete_workflow_tasks_request'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method complete_workflow_tasks" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'complete_workflow_tasks_request' in local_var_params:
            body_params = local_var_params['complete_workflow_tasks_request']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowTasks/completed', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[WorkflowTask]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def find_workflow_tasks(self, **kwargs):  # noqa: E501
        """Find workflow tasks.  # noqa: E501

        Returns the workflow tasks matching given search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_workflow_tasks(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int offset: The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.
        :param int limit: The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.
        :param int count_limit: Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped
        :param str business_item_id: The ID of the business item
        :param str business_item_type: The type of the business item
        :param str workflow_task_user_relation: The type of relation between user and searched tasks. This could be either set to search for all the tasks the user is permitted to view or just those assigned to the user.
        :param str business_item_name: The part of the name of the business item.
        :param str description: The part of the task description.
        :param str user_id: The ID of the user for which the tasks need to be returned. If empty, the current logged in user will be used
        :param int create_date: The creation date of the task. It is the timestamp (in UTC time standard)
        :param int due_date: The due date of the task. It is the timestamp (in UTC time standard)
        :param str title: The title/name of the task.
        :param str type: The task type.
        :param str sort_field: The field on which the results are sorted. On due date by default.
        :param str sort_order: The sorting order.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowTaskPagedResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.find_workflow_tasks_with_http_info(**kwargs)  # noqa: E501

    def find_workflow_tasks_with_http_info(self, **kwargs):  # noqa: E501
        """Find workflow tasks.  # noqa: E501

        Returns the workflow tasks matching given search criteria.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_workflow_tasks_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int offset: The first result to retrieve. If not set (offset = <code>0</code>), results will be retrieved starting from row <code>0</code>.
        :param int limit: The maximum number of results to retrieve. If not set (limit = <code>0</code>), the default limit will be used.
        :param int count_limit: Allows to limit the number of elements that will be counted. -1 will count everything and 0 will cause the count to be skipped
        :param str business_item_id: The ID of the business item
        :param str business_item_type: The type of the business item
        :param str workflow_task_user_relation: The type of relation between user and searched tasks. This could be either set to search for all the tasks the user is permitted to view or just those assigned to the user.
        :param str business_item_name: The part of the name of the business item.
        :param str description: The part of the task description.
        :param str user_id: The ID of the user for which the tasks need to be returned. If empty, the current logged in user will be used
        :param int create_date: The creation date of the task. It is the timestamp (in UTC time standard)
        :param int due_date: The due date of the task. It is the timestamp (in UTC time standard)
        :param str title: The title/name of the task.
        :param str type: The task type.
        :param str sort_field: The field on which the results are sorted. On due date by default.
        :param str sort_order: The sorting order.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowTaskPagedResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'offset',
            'limit',
            'count_limit',
            'business_item_id',
            'business_item_type',
            'workflow_task_user_relation',
            'business_item_name',
            'description',
            'user_id',
            'create_date',
            'due_date',
            'title',
            'type',
            'sort_field',
            'sort_order'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_workflow_tasks" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'count_limit' in local_var_params and local_var_params['count_limit'] is not None:  # noqa: E501
            query_params.append(('countLimit', local_var_params['count_limit']))  # noqa: E501
        if 'business_item_id' in local_var_params and local_var_params['business_item_id'] is not None:  # noqa: E501
            query_params.append(('businessItemId', local_var_params['business_item_id']))  # noqa: E501
        if 'business_item_type' in local_var_params and local_var_params['business_item_type'] is not None:  # noqa: E501
            query_params.append(('businessItemType', local_var_params['business_item_type']))  # noqa: E501
        if 'workflow_task_user_relation' in local_var_params and local_var_params['workflow_task_user_relation'] is not None:  # noqa: E501
            query_params.append(('workflowTaskUserRelation', local_var_params['workflow_task_user_relation']))  # noqa: E501
        if 'business_item_name' in local_var_params and local_var_params['business_item_name'] is not None:  # noqa: E501
            query_params.append(('businessItemName', local_var_params['business_item_name']))  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('userId', local_var_params['user_id']))  # noqa: E501
        if 'create_date' in local_var_params and local_var_params['create_date'] is not None:  # noqa: E501
            query_params.append(('createDate', local_var_params['create_date']))  # noqa: E501
        if 'due_date' in local_var_params and local_var_params['due_date'] is not None:  # noqa: E501
            query_params.append(('dueDate', local_var_params['due_date']))  # noqa: E501
        if 'title' in local_var_params and local_var_params['title'] is not None:  # noqa: E501
            query_params.append(('title', local_var_params['title']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'sort_field' in local_var_params and local_var_params['sort_field'] is not None:  # noqa: E501
            query_params.append(('sortField', local_var_params['sort_field']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowTasks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowTaskPagedResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_task_form_data(self, workflow_task_id, **kwargs):  # noqa: E501
        """Get task form data.  # noqa: E501

        Returns the task form data of the workflow task with the specified ID and form property type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_form_data(workflow_task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_task_id: Workflow task ID. (required)
        :param str form_property_type: Form property type.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TaskFormData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_task_form_data_with_http_info(workflow_task_id, **kwargs)  # noqa: E501

    def get_task_form_data_with_http_info(self, workflow_task_id, **kwargs):  # noqa: E501
        """Get task form data.  # noqa: E501

        Returns the task form data of the workflow task with the specified ID and form property type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_task_form_data_with_http_info(workflow_task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_task_id: Workflow task ID. (required)
        :param str form_property_type: Form property type.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TaskFormData, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_task_id',
            'form_property_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_task_form_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_task_id' is set
        if self.api_client.client_side_validation and ('workflow_task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_task_id` when calling `get_task_form_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_task_id' in local_var_params:
            path_params['workflowTaskId'] = local_var_params['workflow_task_id']  # noqa: E501

        query_params = []
        if 'form_property_type' in local_var_params and local_var_params['form_property_type'] is not None:  # noqa: E501
            query_params.append(('formPropertyType', local_var_params['form_property_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowTasks/{workflowTaskId}/taskFormData', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TaskFormData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_task(self, workflow_task_id, **kwargs):  # noqa: E501
        """Get workflow task.  # noqa: E501

        Returns the workflow task with the specified ID. A task will only be returned when the user has the correct permission to view it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_task(workflow_task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_task_id: The ID of the workflow task to return. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowTask
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_workflow_task_with_http_info(workflow_task_id, **kwargs)  # noqa: E501

    def get_workflow_task_with_http_info(self, workflow_task_id, **kwargs):  # noqa: E501
        """Get workflow task.  # noqa: E501

        Returns the workflow task with the specified ID. A task will only be returned when the user has the correct permission to view it.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_task_with_http_info(workflow_task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_task_id: The ID of the workflow task to return. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowTask, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_task_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_task_id' is set
        if self.api_client.client_side_validation and ('workflow_task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_task_id` when calling `get_workflow_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_task_id' in local_var_params:
            path_params['workflowTaskId'] = local_var_params['workflow_task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowTasks/{workflowTaskId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowTask',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reassign_task(self, workflow_task_id, **kwargs):  # noqa: E501
        """Reassign task.  # noqa: E501

        Reassigns the task with the specified ID to one or more users, groups or roles. Caller needs to provide at least one of the value list for users, groups or roles. If roles are provided then the same number of communities needs to be provided also.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reassign_task(workflow_task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_task_id: The ID of the workflow task. (required)
        :param list[str] users: The user IDs to reassign to.
        :param list[str] groups: The group IDs to reassign to.
        :param list[str] roles: The role IDs to reassign to.
        :param list[str] communities: The Community IDs of the specified roles to reassign to.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.reassign_task_with_http_info(workflow_task_id, **kwargs)  # noqa: E501

    def reassign_task_with_http_info(self, workflow_task_id, **kwargs):  # noqa: E501
        """Reassign task.  # noqa: E501

        Reassigns the task with the specified ID to one or more users, groups or roles. Caller needs to provide at least one of the value list for users, groups or roles. If roles are provided then the same number of communities needs to be provided also.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reassign_task_with_http_info(workflow_task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str workflow_task_id: The ID of the workflow task. (required)
        :param list[str] users: The user IDs to reassign to.
        :param list[str] groups: The group IDs to reassign to.
        :param list[str] roles: The role IDs to reassign to.
        :param list[str] communities: The Community IDs of the specified roles to reassign to.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow_task_id',
            'users',
            'groups',
            'roles',
            'communities'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reassign_task" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow_task_id' is set
        if self.api_client.client_side_validation and ('workflow_task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow_task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow_task_id` when calling `reassign_task`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_task_id' in local_var_params:
            path_params['workflowTaskId'] = local_var_params['workflow_task_id']  # noqa: E501

        query_params = []
        if 'users' in local_var_params and local_var_params['users'] is not None:  # noqa: E501
            query_params.append(('users', local_var_params['users']))  # noqa: E501
            collection_formats['users'] = 'multi'  # noqa: E501
        if 'groups' in local_var_params and local_var_params['groups'] is not None:  # noqa: E501
            query_params.append(('groups', local_var_params['groups']))  # noqa: E501
            collection_formats['groups'] = 'multi'  # noqa: E501
        if 'roles' in local_var_params and local_var_params['roles'] is not None:  # noqa: E501
            query_params.append(('roles', local_var_params['roles']))  # noqa: E501
            collection_formats['roles'] = 'multi'  # noqa: E501
        if 'communities' in local_var_params and local_var_params['communities'] is not None:  # noqa: E501
            query_params.append(('communities', local_var_params['communities']))  # noqa: E501
            collection_formats['communities'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'bearerAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflowTasks/{workflowTaskId}/reassign', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
